<?php

/**
 * JLayer
 *
 * Wrapper for JohnCMS 5.0.1
 * Base Configuration file.
 * This file use ENGINE_DIR constant, which contains path to ~/incfiles directory of engine
 *
 * @return array
 *
 * @package JohnCMS
 * @subpackage JLayer
 * @author Screamer
 * @copyright 2013
 */

/** Get access to johncms */
define('_IN_JOHNCMS', true);

// Data for return
$return = array(
	'network'           => array(
		'ip'            => 0,                     // IP Address
		'ip_via_proxy'  => 0,                     // IP Address via PROXY
		'user_agent'    => 'Not Recognised',      // User-Agent
		'is_mobile'     => false,                 // Is browser mobile?
	),
	'system_settings'   => array(),               // CMS settings
	'user'              => array(
		'data'          => array(),               // Data of user
		'settings'      => array(),               // Settings of user
		'infringements' => array(),               // Infringements
		'table_name'    => 'users',               // Name of table, which contains users data
	),
	'language'          => '',                    // Defined system language
	'db'                => array(                 // MySQL connection
		'host'          => '',                    // Host
		'user'          => '',                    // User
		'password'      => '',                    // Password
		'name'          => '',                    // Name of database
	),
	'output'            => array(                 // Data for output
		'head'          => '',                    // Header
		'end'           => '',                    // Footer
	),
);

// Check engine files for exists
$johncms = array('engine' => 'core', 'head' => 'head', 'end' => 'end', 'db_config' => 'db',);
foreach ($johncms as $key => $item) {
	$item = realpath(ENGINE_DIR . $item . '.php');
	if ($item !== false) {
		$johncms[$key] = $item;
	} else {
		throw new \Exception('File "' . ENGINE_DIR . $item . '.php" is not exists');
	}
}

// Get data for return
require $johncms['engine'];
ob_end_clean();
if (isset($kmess)) {
	core::$user_set['kmess'] = $kmess; // Items per page
}
// Network
$return['network']['ip'] = core::$ip;
$return['network']['ip_via_proxy'] = core::$ip_via_proxy;
$return['network']['user_agent'] = core::$user_agent;
$return['network']['is_mobile'] = core::$is_mobile;
// CMS settings
$return['system_settings'] = core::$system_set;
// User data
$return['user']['data'] = core::$user_data;
$return['user']['settings'] = core::$user_set;
$return['user']['infringements'] = core::$user_ban;
// Language
$return['language'] = core::$lng_iso;
// MySQL Connection
require $johncms['db_config'];
$return['db']['host'] = $db_host;
$return['db']['user'] = $db_user;
$return['db']['password'] = $db_pass;
$return['db']['name'] = $db_name;
// Header
ob_start();
require $johncms['head'];
$header = ob_get_contents();
ob_end_clean();
$return['output']['head'] = $header;
// Footer
ob_start();
require $johncms['end'];
$footer = ob_get_contents();
ob_end_clean();
$return['output']['end'] = $footer;

return $return;