<?php
namespace jl {

	use \jl\exception\InvalidArgumentException;

	/**
	 * JLayer
	 *
	 * Plugins parent
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */
	class Plugin {

		/**
		 * @var Db Object of Db
		 */
		protected $db;

		/**
		 * @var Template Templates handler
		 */
		protected $tpl;

		/**
		 * @var JLayer JLayer
		 */
		protected $jl;

		/**
		 * @var Language Languages handler
		 */
		protected $lng;

		/**
		 * Constructor
		 *
		 * @param Db            $db  Object of Db
		 * @param Template|null $tpl Templates handler
		 * @param JLayer        $jl  JLayer
		 * @param Language|null $lng Languages handler
		 *
		 * @throws exception\InvalidArgumentException
		 * @return Plugin
		 */
		public function __construct(Db $db, $tpl, JLayer $jl, $lng) {
			if (!is_null($tpl) && !($tpl instanceof Template)) {
				throw new InvalidArgumentException('tpl', 'Template, null');
			}
			if (!is_null($lng) && !($lng instanceof Language)) {
				throw new InvalidArgumentException('lng', 'Language, null');
			}

			$this->db  = $db;
			$this->tpl = $tpl;
			$this->jl  = $jl;
			$this->lng = $lng;
		}

	}
}