<?php
namespace jl\exception {

	/**
	 * Class InvalidArgumentException
	 * @package jl\exception
	 */
	class InvalidArgumentException extends \LogicException {

		/**
		 * Constructor
		 *
		 * @param string     $argument Name of argument
		 * @param int        $types    Allowed types of argument
		 * @param int        $code
		 * @param \Exception $previous
		 *
		 * @return \jl\exception\InvalidArgumentException
		 */
		public function __construct($argument, $types, $code = 0, \Exception $previous = null) {
			$message = 'Invalid type of argument "' . $argument . '". "' . $types . '" expect.';
			parent::__construct($message, $code, $previous);
		}
	}
}