<?php
namespace jl {

	/**
	 * JLayer
	 *
	 * Controllers parent
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */
	abstract class Controller {

		/**
		 * @var \jl\Jlayer Layer Object
		 */
		protected $jl;

		/**
		 * @var \jl\Language Language phrases
		 */
		protected $lng;

		/**
		 * @var \jl\Template Templates handler
		 */
		protected $tpl;

		/**
		 * Constructor
		 *
		 * @param JLayer    $jl  Layer object
		 * @param Language $lng Language phrases
		 * @param Template  $tpl Templates handler
		 *
		 * @return \jl\Controller
		 */
		public function  __construct(JLayer $jl, Language $lng, Template $tpl) {
			$this->jl = $jl;
			$this->lng = $lng;
			$this->tpl = $tpl;
		}

		/**
		 * Default action
		 *
		 * @return mixed
		 */
		public abstract function action_index();

	}
}