<?php

/**
 * JLayer
 * DB wrappers parent
 * @package JohnCMS
 * @subpackage JLayer
 * @author Screamer
 * @copyright 2013
 */

abstract class JL_Db {

	/**
	 * @var Occured SQL errors
	 */
	protected $jl_errors = array();

	/**
	 * Save SQL errors to log
	 * @return (void)
	 */
	public function __destruct() {
		if (!empty($this->jl_errors)) {
			$log = JL_LOGS . date('d-m-Y') . '.log';
			if (is_file($log)) {
				$data = file_get_contents($log);
			} else {
				$data = '';
			}
			$errors = '';
			foreach ($this->jl_errors as $item) {
				$errors .= PHP_EOL .'Time: ' . date('H:i:s', time()) . PHP_EOL
					. 'Error Code: ' . $item[0] . PHP_EOL
					. 'Error Messsage: ' . $item[1] . PHP_EOL
					. 'Statement: ' . $item[2] . PHP_EOL
					. str_repeat('-', 11);
			}
			file_put_contents($log, ($errors . $data));
		}
	}

	/**
	 * Returns the numerical value of the error message from previous MySQL operation
	 * @return (int)
	 */
	public abstract function errno();

	/**
	 * Returns the text of the error message from previous MySQL operation
	 * @return (string)
	 */
	public abstract function error();

	/**
	 * Escapes special characters in a string for use in an SQL statement
	 * @param (string) $string The string that is to be escaped.
	 * @return (string)
	 */
	public abstract function escape_string($string);

	/**
	 * Fetch a result row as an associative array
	 * @param (mixed) $result The result resource that is being evaluated. This result comes from a call to mysql_query().
	 * @return (array)
	 */
	public abstract function fetch_assoc($result);

	/**
	 * Get the ID generated in the last query
	 * @return (int)
	 */
	public abstract function insert_id();

	/**
	 * Send a MySQL query
	 * @param (string) $statement An SQL query. The query string should not end with a semicolon. Data inside the query should be properly escaped.
	 * @return (mixed)
	 */
	public abstract function query($statement);

	/**
	 * Get result data
	 * @param (string) $statement An SQL query.
	 * @return (int)
	 */
	public abstract function result($statement);

}