<?php

/**
 * Conference for JohnCMS
 * Settings handler
 * @author Screamer
 * @copyright 2013
 */

class Model_Settings extends JL_Model {

	/**
	 * @var Module Settings
	 */
	private $settings;

	/**
	 * Get settings
	 * @return (array)
	 */
	public function get() {
		if (is_null($this->settings)) {
			$result = $this->db->query("SELECT * FROM `" . $this->table_prefix . "_settings`");
			$this->settings = array();
			while ($item = $this->db->fetch_assoc($result)) {
				$this->settings[$item['key']] = $item['val'];
			}
			if (!array_key_exists('cpu', $this->settings)) {
				$this->settings['cpu'] = 1;
			}
			if (!array_key_exists('autoclean', $this->settings)) {
				$this->settings['autoclean'] = 96;
			}
		}
		return $this->settings;
	}

	/**
	 * Save settings
	 * @param (array) $data Settings
	 * @return (void)
	 */
	public function save(array $data) {
		foreach ($data as $k => $v) {
			$this->db->query(
				"INSERT INTO `" . $this->table_prefix . "_settings` "
				. "SET `key` = '" . $k . "', `val` = '" . $this->db->escape_string($v) . "' "
				. "ON DUPLICATE KEY UPDATE `val` = '" . $this->db->escape_string($v) . "'"
			);
		}
		$this->settings = $data;
	}

}