if (/http:\/\/johncms.com(.+?)/.test(document.location.href)) {
	// Redirect from answer form at forum
	say_loc = /forum\/(.*)\?act=say&id=([\d]+)/.exec(document.location.href);
	if (say_loc != null) {
		document.location.href = 'http://johncms.com/forum/?id=' + say_loc[2];
	}
	window.onload = function () {
		// Remove logo
		var tables = document.getElementsByTagName('table');
		if (tables.length > 0) {
			document.body.removeChild(tables[0]);
		}
		// Remove advert
		var adv = document.getElementsByClassName('gmenu');
		for (var a = 0; a < adv.length; a++) {
			if (/http:\/\/johncms.com\/go.php\?id=[\d]+/.test(adv[a].innerHTML)) {
				adv[a].style.display = 'none';
			}
		}
		// Remove counters
		var divs = document.getElementsByTagName('div');
		dtotal = divs.length - 2;
		divs[dtotal].parentNode.removeChild(divs[dtotal]);
		// Edit header
		var get_tmn = document.getElementsByClassName('tmn');
		var get_header = document.getElementsByClassName('header');
		if (get_tmn.length > 0 && get_header.length > 0) {
			get_header[0].innerHTML = get_tmn[0].innerHTML;
			get_tmn[0].parentNode.removeChild(get_tmn[0]);
		}
		// Remove css style
		var get_style = document.getElementsByTagName('link');
		if (get_style.length > 0) {
			for (var s = 0; s < get_style.length; s++) {
				if (get_style[s].rel == 'stylesheet') {
					get_style[s].parentNode.removeChild(get_style[s]);
				}
			}
		}
		// Add new css style
		var style = document.createElement('style');
		style.innerHTML = stylesheet();
		document.head.appendChild(style);
		// Forum handler
		if (/http:\/\/johncms.com\/forum(.+?)\?id=[\d]+/.test(document.location.href)) {
			forum_handler(tables);
		}
	}
}

function forum_handler(posts)
{
	if (posts.length > 0) {
		for (var i = 0; i < posts.length; i++) {
			if (posts[i].childNodes.length == 1) {
				var p = posts[i].childNodes[0].childNodes[1].childNodes;
				// 2 - profile, 4 - is online?; 6 - answer; 8 - quote; 10 - time; 12 - status
				var profile = p[2];
				var post = p[6];
				var answer = p[8];
				var quote = p[10];
				var time = p[12];
				if (answer.nodeName != 'a') {
					nickname = profile.innerHTML;
					time = answer;
					quote = false;
					answer = false;
				} else {
					nickname = false;
				}
				// Get nickname
				if (!nickname) {
					nickname = />(.+?)</.exec(profile.innerHTML);
					if (nickname == null) {
						continue;
					}
					nickname = nickname[1];
				}
				// Remove quote and answer links
				if (quote) {
					quote.parentNode.removeChild(quote);
				}
				if (answer) {
					answer.parentNode.removeChild(answer);	
				}
				// Set link to post
				post_id = /id=([\d]+)/.exec(post.href);
				posts[i].id = 'p_' + post_id[1];
				// For Insert link to post into form
				var ins_pl = document.createElement('a');
				ins_pl.href= "javascript:insert('[url=" + post.href + "]', 'Пост #" + post_id[1] + "[/url]', '')";
				ins_pl.innerHTML = '&#160;#';
				post.parentNode.insertBefore(ins_pl, post);
				// Change title for link to post 
				post.innerHTML = post_id[1] + '&#160;';
				// Add answer link, insert link to post, link to post
				time.innerHTML += ' <a href="javascript:insert(\'' + nickname + ', \', \'answer\', \'' + posts[i].id + '\')">&gt;&gt;</a>';
				// Handle thumbs
				var total = posts[i].parentNode.childNodes.length - 1;
				if (posts[i].parentNode.childNodes[total].nodeName == 'span') {
					thumb = posts[i].parentNode.childNodes[total].getElementsByTagName('img');
					if (thumb.length > 0) {
						thumb = thumb[0];
						var get_name = /file=(.*)/.exec(thumb.src);
						if (get_name) {
							im_name = get_name[1];
							switch_image = document.createElement('a');
							switch_image.innerHTML = '[+/-]';
							switch_image.href = "javascript:popup('" + im_name + "')";
							var container = document.createElement('div');
							container.id = im_name;
							container.className = 'popup';
							container.style.display = 'none';
							var sub_container = document.createElement('div');
							var full_image = document.createElement('img');
							full_image.src = 'http://johncms.com/files/forum/attach/' + im_name;
							full_image.alt = '';
							sub_container.appendChild(full_image);
							container.appendChild(sub_container);
							var close_button = document.createElement('a');
							close_button.href = "javascript:popup('" + im_name + "')";
							close_button.innerHTML = 'x';
							close_button.className = 'close_button';
							container.appendChild(close_button);
							var google = document.createElement('a');
							google.href = "http://google.com/searchbyimage?image_url=http://johncms.com/files/forum/attach/" + im_name;
							google.target = "_blank";
							google.innerHTML = '[G]';
							thumb.parentNode.appendChild(document.createElement('br'));
							thumb.parentNode.appendChild(switch_image);
							thumb.parentNode.appendChild(google);
							thumb.parentNode.appendChild(container);
						}

					}
				}
			}
		}
		var forms = document.getElementsByTagName('form');
		if (forms.length > 0) {
			for (var f = 0; f < forms.length; f++) {
				if (/act=say/.test(forms[f].action)) {
					els = forms[f].childNodes[0].childNodes;
					els[0].parentNode.removeChild(els[0]); // Remove style for bb panel
					els[2].parentNode.removeChild(els[2]); // Remove function for insert bb tags
					var panel = document.createElement('div');
					panel.className = 'bb_panel';
					for (var p = 2; p < els.length; p++) {
						if (els[p].nodeName == 'textarea') {
							els[p].id = 'message_form';
							break;
						}
						if (els[p]) {
							panel.appendChild(els[p]);
						}
					}
					p_style = document.createElement('style');
					p_style.innerHTML = '.bb_panel {margin: 2px; padding: 0px 10px 2px 2px;} '
						+ '.bb_panel a {background: whitesmoke;font-variant: small-caps;display:inline-block;padding: 4px 7px;margin: 1px 2px;box-shadow: 0 0 5px 1px #050505; text-decoration: none;border:0;font-weight:normal;}'
						+ '.bb_panel a:hover{box-shadow: 0 0 2px 1px #090909}'
						+ '.color_table {position: absolute; background: white; margin: 4px; box-shadow: 0 0 3px 1px black;}'
						+ '.color_table a {float:left;  width:10px; height:10px; margin:2px; padding: 0px; border: 1px solid black;box-shadow: 0 0 2px 0px #070707}'
						+ '.smls_panel {position: absolute; overflow: auto; max-width: 400px; max-height: 150px;box-shadow: 0 0 2px 0px #070707; margin-top: 2px;}'
						+ '.smls_panel a, .smls_panel a:hover {box-shadow: none;}';
					forms[f].childNodes[0].appendChild(p_style);
					forms[f].childNodes[0].appendChild(panel);
					panel.childNodes[0].innerHTML = 'b';
					panel.childNodes[1].innerHTML = 'i';
					panel.childNodes[2].innerHTML = 'u';
					panel.childNodes[3].innerHTML = 's';
					panel.childNodes[4].innerHTML = '*';
					panel.childNodes[5].innerHTML = '&gt;';
					panel.childNodes[5].href = "javascript:insert('[c]', '[/c]')";
					panel.childNodes[6].innerHTML = '#';
					panel.childNodes[7].innerHTML = 'url';
					// Foreground color panel
					fg_color = panel.childNodes[8];
					// Switch Button
					fg_button = document.createElement('a');
					fg_button.innerHTML = 'fgc';
					fg_button.href = "javascript:spoiler('fg_color')";
					fg_color.replaceChild(fg_button, fg_color.childNodes[1]);
					// Table of colors
					fg_color.childNodes[3].id = 'fg_color';
					fg_color.childNodes[3].className = 'color_table';
					fg_color.childNodes[3].style.display = 'none';
					// Background color panel
					bg_color = panel.childNodes[9];
					// Switch button
					bg_button = document.createElement('a');
					bg_button.innerHTML = 'bgc';
					bg_button.href = 'javascript:spoiler(\'bg_color\')';
					bg_color.replaceChild(bg_button, bg_color.childNodes[1]);
					// Table width colors
					bg_color.childNodes[3].id = 'bg_color';
					bg_color.childNodes[3].className = 'color_table';
					bg_color.childNodes[3].style.display = 'none';
					// Smileys
					smls = panel.childNodes[10];
					sm_button = document.createElement('a');
					sm_button.innerHTML = ')))';
					sm_button.href = 'javascript:spoiler(\'smls_panel\')';
					smls.replaceChild(sm_button, smls.childNodes[0]);
					smls.childNodes[2].id = 'smls_panel';
					smls.childNodes[2].className = 'smls_panel';
					smls.childNodes[2].style.display = 'none';
					// Big small rgb tags
					var big = document.createElement('a');
					var small = document.createElement('a');
					var red = document.createElement('a');
					var green = document.createElement('a');
					var blue = document.createElement('a');
					big.innerHTML = 'big';
					small.innerHTML = 'small';
					red.innerHTML = 'r';
					green.innerHTML = 'g';
					blue.innerHTML = 'b';
					big.href = 'javascript:insert(\'[big]\', \'[/big]\', \'\')';
					small.href = 'javascript:insert(\'[small]\', \'[/small]\', \'\')';
					red.href = 'javascript:insert(\'[red]\', \'[/red]\', \'\')';
					green.href = 'javascript:insert(\'[green]\', \'[/green]\', \'\')';
					blue.href = 'javascript:insert(\'[blue]\', \'[/blue]\', \'\')';
					panel.appendChild(big);
					panel.appendChild(small);
					panel.appendChild(red);
					panel.appendChild(green);
					panel.appendChild(blue);
					break;
				}
			}
		}
	}
}

function spoiler(element_id)
{
	var element = document.getElementById(element_id);
	element.style.display = element.style.display == 'none' ? '' : 'none';
}

function popup(id){
	var element = document.getElementById(id);
	if (element.style.display == 'none') {
		element.style.display = '';
		center(id);
	} else {
		element.style.display = 'none';
	}
}

function center(id)
{
	var element = document.getElementById(id);
	wresolution=screen.width;
	hresolution=screen.height;
	if(wresolution>=1024 && hresolution>=768){
		if(window.getComputedStyle){
			var h=document.documentElement.clientHeight;
			var w=document.documentElement.clientWidth;
			var element_A = window.getComputedStyle(element, '');
			var element_A_width=parseInt(element_A.getPropertyValue('width'));
			var element_A_height=parseInt(element_A.getPropertyValue('height'));
			element.style.left=(w-element_A_width)/2+'px';
			element.style.top=(h-element_A_height)/2+'px';
		} else{
			var h2=document.documentElement.clientHeight;
			var w2=document.documentElement.clientWidth;
			var element_A_width=parseInt(element.currentStyle.width);
			var element_A_height=parseInt(element.currentStyle.height);
			element.style.left=(w2-element_A_width)/2+'px';
			element.style.top=(h2-element_A_height)/2+'px';
		}
	}
}

function insert(tag_open, tag_close, post_id)
{
	var e_field = document.getElementById('message_form');
	if (tag_close == 'answer') {
		// Set field to post
		tag_close = '';
		var post_el = document.getElementById(post_id);
		if (post_el) {
			post_el.parentNode.appendChild(e_field.parentNode.parentNode.parentNode);
		}
	}
	if (tag_open == '[c]') { // Insert selected text
		if (window.getSelection) {
			tag_open += window.getSelection().toString() + "\n";
		} else if (document.getSelection) {
			tag_open += document.getSelection() + "\n";
		} else if (document.selection) {
			tag_open += document.selection.createRange().text + "\n";
		}
	}
	if (e_field.selectionStart != undefined) {
		// Work with selected text
		e_field.focus();
        var string = e_field.value;
        var start_selection = e_field.selectionStart;
        var end_selection = e_field.selectionEnd - start_selection;
        e_field.value = string.substr(0, start_selection)
    	             + tag_open
    	             + string.substr(start_selection, end_selection)
    	             + tag_close
    	             + string.substr(start_selection + end_selection);
	} else {
		// Add tags to end of text
		e_field.value += tag_open+tag_close;
	}
}

function stylesheet()
{
	return 'body {'
		    + 'background-color: #ffffff;'
		    + 'padding: 0px;'
		    + 'margin: 0px auto;'
		    + 'font-size: small;'
		    + 'font-family: Arial, Tahoma;'
		    + 'color: #1b1b1b;'
		    + 'max-width: 900px;'
		+ '}'
		+ 'a {'
		    + 'color: #ab5200;'
			+ 'text-decoration: none;'
		+ '}'
		+ 'a:hover {'
		    + 'color: #7b2200;'
		+ '}'
		+ 'h1, h2, h3, h4, h5, h6 {'
			+ 'font-variant: small-caps;'
			+ 'font-weight: 700;'
			+ 'padding: 0px;'
			+ 'margin: 0px;'
		+ '}'
		+ 'h1 {font-size: 14pt;} h2 {font-size: 12pt;} h3 {font-size: 10pt;} h4 {font-size: 9pt;} h5 {font-size: 8pt;} h6 {font-size: 8pt;}'
		+ 'p {'
			+ 'padding: 0px;'
			+ 'margin: 10px 0px 0px 0px;'
		+ '}'
		+ 'textarea {'
			+ 'width: 98%;'
			+ 'margin: 0px auto;'
			+ 'height: 200px;'
		+ '}'
		+ '.header, .footer {'
			+ 'background-color: #1b1b1b;'
		    + 'padding: 5px;'
		    + 'margin: 6px auto;'
		    + 'color: #ab5200;'
		    + 'max-width: 60%;'
		    + 'box-shadow: 0 0 3px 1px #888888;'
		    + 'text-align: center;'
		+ '}'
		+ '.quote {'
			+ 'background-color: #ffffff;'
			+ 'box-shadow: 0 0 2px 0px #777777;'
			+ 'max-width: 50%;'
			+ 'margin: 3px;'
			+ 'padding: 5px;'
			+ 'text-align: left;'
			+ 'color: gray;'
			+ 'font-style: italic;'
		+ '}'
		+ '.phpcode {'
			+ 'background-color: #ffffff;'
			+ 'box-shadow: 0 0 2px 0px #777777;'
			+ 'margin: 3px;'
			+ 'padding: 5px;'
			+ 'overflow: auto;'
			+ 'white-space: nowrap;'
		+ '}'
		+ '.maintxt {'
			+ 'padding: 7px;'
			+ 'margin: 5px;'
			+ 'box-shadow: 0 0 3px 1px black;'
		+ '}'
		+ '.phdr {'
			+ 'margin: 4px auto;'
			+ 'padding: 7px;'
			+ 'box-shadow: 0 0 3px 1px black;'
			+ 'max-width: 60%;'
		+ '}'
		+ '.phdr h3 {'
			+ 'text-align: center;'
		+ '}'
		+ '.menu, .fmenu, .gmenu, .bmenu, .topmenu, .user, .news {'
			+ 'padding: 5px 10px;'
			+ 'margin: 5px;'
			+ 'background: #ebebeb;'
			+ 'box-shadow: 0 0 3px 1px #cecece;'
		+ '}'
		+ '.menu:hover, .fmenu:hover, .gmenu:hover, .bmenu:hover, .topmenu:hover, .user:hover, .news:hover{'
			+ 'background: #dfdfdf;'
		+ '}'
		+ '.rmenu, .alarm {'
			+ 'background: #dfa0a0;'
			+ 'padding: 5px 10px;'
			+ 'margin: 5px;'
			+ 'box-shadow: 0 0 3px 1px #cecece;'
		+ '}'
		+ '.list1, .list2 {'
			+ 'padding: 5px;'
			+ 'margin: 3px 0px;'
			+ 'border-top: 1px solid #dfdfdf;'
		+ '}'
		+ '.sub {'
			+ 'color: #6e6e6e;'
			+ 'border-top: 1px dashed #dfdfdf;'
			+ 'margin: 4px 0px;'
		+ '}'
		+ '.green {color: green;} .red {color: red;} .gray{color: gray;}'
		+ '.bblist {'
		    + 'color: #4a5663;'
		    + 'background: transparent url(../../images/dot.gif) no-repeat left;'
		    + 'padding: 2px 0px 2px 10px;'
		+ '}'
		+ '.greply, .reply {'
			+ 'padding: 5px;margin: 3px;'
			+ 'max-width: 70%;'
			+ 'box-shadow: 0 0 3px 1px #dfa0a0;'
		+ '}'
		+ '.sitemap {display:none;}'
		+ '.currentpage {'
		   + 'background-color: #edebeb;'
		   + 'border: 1px solid #cccccc;'
		   + 'padding: 0px 5px 0px 5px;'
		+ '}'
		+ 'a.pagenav {'
			+ 'border: 1px solid #dfa0a0;'
		    + 'padding: 0px 3px 0px 3px;'
		    + 'text-decoration: none;'
		+ '}'
		+ 'a.pagenav:hover {'
			+ 'background-color: #f7f7f7;'
			+ 'border: 1px solid #efb0b0;'
		+ '}'
		// User-Script
		+ '.popup {'
			+ 'position: fixed;'
			+ 'top: 0; left: 0;'
			+ 'text-align: center;'
		+ '}'
		+ '.popup div {'
			+ 'margin: 10px;'
			+ 'max-width: 800px;'
			+ 'max-height: 500px;'
			+ 'overflow:auto;'
			+ 'box-shadow: 0 0 3px 1px #000000;'
		+ '}'
		+ '.close_button {'
			+ 'box-shadow: 0 0 3px 2px black;'
			+ 'padding: 5px 7px;'
			+ 'font-variant: small-caps;'
			+ 'font-size: 12pt;'
			+ 'float: right;'
		+ '}'
		+ '';
}