<?php
session_start();

class puzzle {
var $picname = 'pic';
var $sesdir = 'ses';
var $dircrush = 'crush';
var $dir = 'img';
var $recfile = 'rec.txt';
var $sidepart;
var $parts;
var $sesfile;
var $dirname;
var $picx;
var $picy;

function __construct($imgfile, $sidepart = 4) {
$this->imgfile = $imgfile;
$this->sidepart = $sidepart;
$this->time = time();    
$this->parts = pow($this->sidepart, 2);
$this->dirname = mb_substr($this->imgfile, 0, -4);
$this->sesfile = isset($_SESSION['ses']) ? $_SESSION['ses'] : $_SESSION['ses'] = $this->sesdir . DIRECTORY_SEPARATOR . $this->dirname . '_puzzle-' . $this->time . '.txt';
$this->dircreate();

$img = imagecreatefromjpeg($this->dir . DIRECTORY_SEPARATOR . $imgfile);    
$x = imagesx($img);
$y = imagesy($img);
$newx = (intval($x/$this->sidepart))*$this->sidepart;
$newy = (intval($y/$this->sidepart))*$this->sidepart;
$newimg = imagecreatetruecolor($newx, $newy);
imagefill($newimg, 0, 0, 0x000000);
imagecopyresampled($newimg, $img, 0, 0, 0, 0, $x, $y, $newx, $newy);
$picx = $newx/$this->sidepart;
$picy = $newy/$this->sidepart;

$this->picx = $picx;
$this->picy = $picy;
 
for ($i=0, $gorizontal=0; $i<$this->parts-1; $i++) {
$newpic = imagecreatetruecolor($picx, $picy);
imagefill($newpic, 0, 0, 0x000000);         
if ((($i%$this->sidepart)==0) && ($i!=0))
$gorizontal++;    
$vertical = ($i!=0) ? ($i%$this->sidepart) : $i;
imagecopyresampled($newpic, $newimg, 0, 0, ($vertical*$picx), ($gorizontal*$picy), $picx, $picy, $picx, $picy);    
imagejpeg($newpic, $this->dir . DIRECTORY_SEPARATOR . $this->dircrush . DIRECTORY_SEPARATOR . $this->dirname . DIRECTORY_SEPARATOR . $this->parts . DIRECTORY_SEPARATOR . $this->picname . ($i+1) . '.jpg', 25);
imagedestroy($newpic);
}
$this->plusimg();
$this->origarr();
$this->sesfile();
}

function plusimg() {
$res = imagecreatetruecolor($this->picx, $this->picy);
$color = imagecolorallocate($res, 255, 255, 255);
imagefilledrectangle($res, 0, 0, $this->picx, $this->picy, $color); 
$plus = imagecreatetruecolor($this->picx-$this->sidepart, $this->picy-$this->sidepart);
$color2 = imagecolorallocate($plus, 64, 200, 128);
imagefilledrectangle($plus, $this->sidepart/2, $this->sidepart/2, $this->picx-$this->sidepart, $this->picy-$this->sidepart, $color2);
imagecopymerge($res, $plus, $this->sidepart/2, $this->sidepart/2, 0, 0, $this->picx, $this->picy, 100);
imagejpeg($res, $this->dir . DIRECTORY_SEPARATOR . $this->dircrush . DIRECTORY_SEPARATOR . $this->dirname . DIRECTORY_SEPARATOR . $this->parts . DIRECTORY_SEPARATOR . $this->picname . $this->parts . '.jpg', 25);
imagedestroy($res);    
}

function dircreate() {
if (!is_dir($this->dir))
mkdir($this->dir, 0777, true);
if (!file_exists($this->dir . DIRECTORY_SEPARATOR . $this->dircrush . DIRECTORY_SEPARATOR . $this->dirname . DIRECTORY_SEPARATOR . $this->parts . DIRECTORY_SEPARATOR . $this->picname . $this->parts . '.jpg')) 
if (!is_dir($this->dir . DIRECTORY_SEPARATOR . $this->dircrush . DIRECTORY_SEPARATOR . $this->dirname . DIRECTORY_SEPARATOR . $this->parts)) 
mkdir($this->dir . DIRECTORY_SEPARATOR . $this->dircrush . DIRECTORY_SEPARATOR . $this->dirname . DIRECTORY_SEPARATOR . $this->parts, 0777, true);    
}

function sides() {
for ($i=0; $i<$this->sidepart; $i++) 
$this->noup[] = $i;    
for ($i=$this->parts-$this->sidepart; $i<$this->parts; $i++)
$this->nodown[] = $i;     
for ($i=0; $i<$this->parts; $i+=$this->sidepart)
$this->noleft[] = $i;    
for ($i=$this->sidepart-1; $i<$this->parts; $i+=$this->sidepart)
$this->noright[] = $i;    
return array('up' => $this->noup, 'down' => $this->nodown, 'left' => $this->noleft, 'right' => $this->noright);
}

function get_plus() {
foreach ($this->imgarr() as $id => $key)
foreach ($key as $k => $v)    
if ($k=='pos' . $this->parts)
return $id;    
}

function get_act() {
$arr = $this->sides();    
$this->sosl = !in_array($this->get_plus(), $arr['left']) ? $this->get_plus()-1 : '-1';
$this->sosr = !in_array($this->get_plus(), $arr['right']) ? $this->get_plus()+1 : '-1';
$this->sosu = !in_array($this->get_plus(), $arr['up']) ? $this->get_plus()-$this->sidepart : '-1';
$this->sosd = !in_array($this->get_plus(), $arr['down']) ? $this->get_plus()+$this->sidepart : '-1';
return array('left' => $this->sosl, 'right' => $this->sosr, 'up' => $this->sosu, 'down' => $this->sosd);
}

function origarr() {
for ($i=0;$i<$this->parts;$i++)
$arr[$i] = array('pos' . ($i+1) => $this->picname . ($i+1) . '.jpg');
return $arr;
}

function sesfile() {
if (!is_file($this->sesfile)) {    
$arr = $this->origarr();    
shuffle($arr);
$file = new SplFileObject($this->sesfile, 'w');
$file->fwrite(serialize($arr));
}    
}

function resavesesfile($arr) {
$file = new SplFileObject($this->sesfile, 'w');
$file->fwrite(serialize($arr));    
}

function imgarr() {
$file = new SplFileObject($this->sesfile);
while (!$file->eof())
$val .= $file->fgets();
return unserialize($val);
}

function view($file) {
if (file_exists($this->dir . DIRECTORY_SEPARATOR . $file))
return '<img src="data:image/jpeg;base64,' . chunk_split(base64_encode(file_get_contents($this->dir . DIRECTORY_SEPARATOR . $file))) . '" alt="preview" />';
}

function turn($num) {
$num = intval($num);
if (!in_array($num, $sides = $this->get_act()))
return false;    
$arr = $this->imgarr(); 
for ($i=0; $i<$this->parts; $i++)
foreach ($arr[$i] as $k => $v)
if ($i==$num)
$rep[$this->get_plus()] = array($k => $v);
elseif ($i==$this->get_plus())
$rep[$num] = array($k => $v);
else 
$rep[$i] = array($k => $v);
$this->resavesesfile($rep);
header('Location: ?');
}

function scale($percent) {
if ($percent == 0 || $percent > 0 && $percent<101) {
$percent = intval($percent);
if ($percent==0) $percent++;    
} else {
#die('ПНХ');    
}
$img_one = imagecreatetruecolor(100, 20);
$color_one = imagecolorallocate($img_one, 0, 0, 66);
imagefilledrectangle ($img_one, 0, 0, 100, 20, $color_one);
$img_two = imagecreatetruecolor($percent, 20);
$color_two = imagecolorallocate($img_two, 255, 255, 255);
imagefilledrectangle ($img_two, 0, 0, $percent, 20, $color_two);
imagecopymerge($img_one, $img_two, 0, 0, 0, 0, 100, 20, 25);
$print_percent = imagecreatetruecolor(100, 20);
$white = imagecolorallocate($print_percent, 0, 0, 0);
$red = imagecolorallocate($print_percent, 255, 0, 0);
imagecolortransparent($print_percent, $white);       
imagestring($print_percent, 12, 36, 2, $percent . '%', $red);  
imagecopymerge($img_one, $print_percent, 0, 0, 0, 0, 100, 20, 100);
imagejpeg($img_one, 'tmp.jpg', 100);
$fil = file_get_contents('tmp.jpg');
unlink('tmp.jpg');
imagedestroy($img_one);
imagedestroy($img_two);
imagedestroy($print_percent);
return '<img  width="100" height="20" src="data:image/jpeg;base64,' . chunk_split(base64_encode($fil)) . '" alt="koescale" />';
}

function recresult() {
$res = time()-substr(end(explode(DIRECTORY_SEPARATOR, $this->sesfile)), 9, -4);
$d = intval($res/(3600*24));
$h = intval(($res%(3600*24))/3600);
$m = intval((($res%(3600*24))%3600)/60);
$s = (($res%(3600*24))%3600)%60;
$result = '[ ' . date('d-m-Y H:i:s') . ' ] ' . $d . ' day ' . $h . ' hor ' . $m . ' min ' . $s . ' sec';
file_put_contents($this->recfile, $result . PHP_EOL, FILE_APPEND | LOCK_EX);
unlink($this->sesfile);
echo $result;
session_destroy();
$this->__destruct();
}

function finish() {
$orig = $this->origarr();
$imgarr = $this->imgarr();
$diff = 0;
for ($i=0; $i<$this->parts; $i++)
if ($orig[$i] == $imgarr[$i])
$diff++;
$this->scale = '<div>Головоломка собрана на  ' . $this->scale($diff/$this->parts*100) . ' </div>';
return ($diff==$this->parts) ? true : false;
}

function result($url) {
$arr = $this->imgarr();
$arract = $this->get_act();
echo '<style type="text/css">.act {border: 3px solid green;}</style>' . PHP_EOL;
echo $this->scale;
echo '<table><tr>' . PHP_EOL;
for ($i=0;$i<$this->parts;$i++) {
echo '<td>' . PHP_EOL; 
foreach ($arr[$i] as $k => $v) 
if ($i==$arract['left'] || $i==$arract['up'] || $i==$arract['right'] || $i==$arract['down']) 
echo '<a href="' . $url . '&amp;num=' . $i . '"><img class="act" src="' . $this->dir . DIRECTORY_SEPARATOR . $this->dircrush . DIRECTORY_SEPARATOR . $this->dirname . DIRECTORY_SEPARATOR . $this->parts . DIRECTORY_SEPARATOR . $v . '" alt="' . substr($v, 3, -4) . '" /></a>' . PHP_EOL;    
else 
echo '<img src="' . $this->dir . DIRECTORY_SEPARATOR . $this->dircrush . DIRECTORY_SEPARATOR . $this->dirname . DIRECTORY_SEPARATOR . $this->parts . DIRECTORY_SEPARATOR . $v . '" alt="' . substr($v, 3, -4) . '" />' . PHP_EOL;
echo '</td>' . PHP_EOL;
if ((($i+1)%$this->sidepart)==0 && $i!=0) 
echo '</tr><tr>' . PHP_EOL;    
}
echo '</tr></table>' . PHP_EOL;
}

function __destruct() {
foreach ($this as $key => $value)  
unset($this->$key); 
}
}

$class = new puzzle('1.jpg', 4);

if ($class->finish()) {
$class->recresult();
echo '<div><a href="">В меню</a></div>';
exit;    
} else {
if (isset($_GET['num'])) {
$class->turn(intval($_GET['num']));    
}
$class->result('?');
}
?>