<?php

//Сервер
define('SHOP_SITE', 'http://scades.ru');
define('SHOP_SERVER', 'http://scades.ru/api/myshop.php');

class MyShopScades {

    //ID магазина
    private $id = 0;
    //Товаров на странице
    private $on_page = 10;
    private $page = 1;

    function __construct($id) {
        $this->id = (int) $id;
        error_reporting(E_COMPILE_ERROR);
    }

    //Id магазина
    function id() {
        return $this->id;
    }

    //товаров на страницу
    function set_on_page($onpage) {
        $this->on_page = (int) $onpage;
    }

    //Устанавливаем текущую страницу
    function set_page($page) {
        $this->page = $page;
    }

    //Получаем каталог
    function get($mother) {
        $mother = (int) $mother;
        //echo SHOP_SERVER . '?id=' . $this->id . '&m=' . $mother . '&chain&kats&tovars&onpage=' . $this->on_page . '&page=' . $this->page;
        $content = self::http(SHOP_SERVER . '?id=' . $this->id . '&m=' . $mother . '&chain&kats&tovars&onpage=' . $this->on_page . '&page=' . $this->page);
        if (!$arr = unserialize($content)) {
            return Array();
        }
        return $arr;
    }

    //Получаем товар
    function tovar($id, $mother = 0) {
        $id = (int) $id;
        //echo SHOP_SERVER . '?m='.$mother.'&id=' . $this->id . '&tovar=' . $id . '&chain';
        $content = self::http(SHOP_SERVER . '?m=' . $mother . '&id=' . $this->id . '&tovar=' . $id . '&chain');
        if (!$arr = unserialize($content)) {
            return Array();
        }
        return $arr;
    }

    //Подготовка к покупке
    function prepareBuy($id, $email, $ref) {
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return false;
        }

		//echo SHOP_SITE . '/buy.php?id=' . $id . '&email=' . $email . '&shop=' . $this->id . '&serialize&ref=' . $ref;
        $content = self::http(SHOP_SITE . '/buy.php?id=' . $id . '&email=' . $email . '&shop=' . $this->id . '&serialize&ref=' . $ref);

        if (!$arr = unserialize($content)) {
            return Array();
        }
        return $arr;
    }

    /*
      $kolvo - число записей
      $on_page- записей на страницу
      $page - номер текущей страницы

      $arr['page'] -  текущая страница
      $arr['start'] - начальная запись для sql запроса в LIMIT $arr['start'],$on_page
      $arr['max_page'] - максимальная страница
     */

    static function pages_arr($kolvo, $on_page, $page) {
        $max_page = ceil($kolvo / $on_page);
        if ($max_page < 1) {
            $max_page = 1;
        }

        if ($page == 'end') {
            $page = $max_page;
        } else {
            $page = (int) $page;
            if ($page < 1) {
                $page = 1;
            } elseif ($page > $max_page) {
                $page = $max_page;
            }
        }

        $start = ($page - 1) * $on_page;
        $arr = Array();
        $arr['start'] = $start;
        $arr['max_page'] = $max_page;
        $arr['page'] = $page;
        return $arr;
    }

//Формируем html строку страниц
//page - текущая страница
//max - кол-во страниц
//shablon - http://site.ru/big_text.php?p={page}
//size - Количество отображаемых элементов в  строке страниц
//----------------------------------------------
    static function pages($page, $max, $shablon, $size = 5) {
        $page_str = '';
        $page = (int) $page;
        $max = (int) $max;
        $size = (int) $size;

        if ($max < 2) {
            return $page_str;
        }

        if ($page > 1) {
            $page_str.='<a href="' . str_replace('{page}', 1, $shablon) . '"><span>&lt;&lt;</span></a><a href="' . str_replace('{page}', $page - 1, $shablon) . '"><span>&lt;</span></a>';
        }

        for ($i = 1; $i <= $max; $i++) {
            if ($i < $page - $size OR $i > $page + $size) {
                continue;
            }
            if ($page == $i) {
                $page_str.='<span class="courrent">' . $i . '</span>';
            } else {
                $page_str.='<a href="' . str_replace('{page}', $i, $shablon) . '"><span>' . $i . '</span></a>';
            }
        }
        if ($page < $max) {
            $page_str.='<a href="' . str_replace('{page}', $page + 1, $shablon) . '"><span>&gt;</span></a><a href="' . str_replace('{page}', $max, $shablon) . '"><span>&gt;&gt;</span></a>';
        }
        return '<div class="pages">' . $page_str . '</div>';
    }

    //Запрос по http
    static function http($url, $headers = Array(), $post_array = Array()) {
        if (!function_exists('curl_init')) {
            return file_get_contents($url);
        }

        $head = Array();
        if (is_array($headers)) {
            foreach ($headers AS $key => $val) {
                $head[] = $key . ': ' . $val;
            }
        }

        $post = '';
        if ($post_array) {
            $c = count($post_array);
            $i = 0;
            foreach ($post_array AS $key => $val) {
                $i++;
                $post.= $key . '=' . $val;
                if ($i <> $c) {
                    $post .= '&';
                }
            }
        }


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_PROGRESSFUNCTION, 'curl_shop_callback');      //Функция для ограничения трафика по размеру
        curl_setopt($ch, CURLOPT_NOPROGRESS, false);

        if ($post) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)');

        if ($head) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $head);  //Заголовки
        }




//curl_setopt($ch, CURLOPT_HEADER,         true);         // для включения заголовков в вывод.
        //curl_setopt($ch, CURLOPT_NOBODY,         true);         // для исключения тела ответа из вывода. Метод запроса устанавливается в HEAD. 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);           //Количество секунд ожидания при попытке соединения    
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);           //Максимально позволенное количество секунд для выполнения cURL-функций.
        //curl_setopt($ch, CURLINFO_HEADER_OUT,        true);

        $result = curl_exec($ch);

        //print_r(curl_getinfo ($ch ,CURLINFO_HEADER_OUT));
        //Возвращаем false, устанавливаем сообщение об ошибке----
        $err = curl_error($ch);
        if ($err) {
            $result = Array();
            $result['error'] = $err;
            return serialize($result);
        }
        //-------------------------------------------------------

        curl_close($ch);

        return $result;
    }

}

//call back функция для curl, ограничивает размер скачиваемого файла
function curl_shop_callback($download_size, $downloaded, $upload_size, $uploaded) {
    global $ch;
    static $summ;
    if (!isset($summ)) {
        $summ = 0;
    }
    $summ+=$downloaded;
    if ($summ > 500 * 1024) {
        throw new Exception('Too long content');
    }
    return false;
}

//----------------------------------------------------------------
?>
