<?php
/***************************************************************************
 *      Разработка и оптимизация под WAP: Гутник Игорь ( чел ).
 *          2009 год
 ***************************************************************************/

define('IN_PHPBB', true);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['General']['Управление стилями'] = $filename;
	return;
}

$phpbb_root_path = '../';
require($phpbb_root_path . 'extension.inc');
require('pagestart.' . $phpEx);

$confirm = ( isset($HTTP_POST_VARS['confirm']) ) ? TRUE : FALSE;

if( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : $HTTP_POST_VARS['mode'];
	$mode = htmlspecialchars($mode);
}
else 
{
	$mode = "";
}

switch( $mode )
{
	case "delete":
		$style_id = ( isset($HTTP_GET_VARS['style_id']) ) ? intval($HTTP_GET_VARS['style_id']) : intval($HTTP_POST_VARS['style_id']);

		if( !$style_id )
		{
				message_die(GENERAL_MESSAGE, "Не выбран ни один стиль");
		}
		
		if( !$confirm )
		{
			if($style_id == $board_config['default_style'])
			{
				message_die(GENERAL_MESSAGE, $lang['Cannot_remove_style']);
			}
			
			$hidden_fields = '<input type="hidden" name="mode" value="'.$mode.'" /><input type="hidden" name="style_id" value="'.$style_id.'" />';

			$template->set_filenames(array(
				"confirm" => "admin/confirm_body.tpl")
			);

			$template->assign_vars(array(
				"MESSAGE_TITLE" => $lang['Confirm'],
				"MESSAGE_TEXT" => $lang['Confirm_delete_style'],

				"L_YES" => $lang['Yes'],
				"L_NO" => $lang['No'],

				"S_CONFIRM_ACTION" => append_sid("admin_style_edit.$phpEx"),
				"S_HIDDEN_FIELDS" => $hidden_fields)
			);

			$template->pparse("confirm");

		}
		else
		{
			$sql = "DELETE FROM " . STYLES_CSS . " 
				WHERE style_id = $style_id";
			if(!$result = $db->sql_query($sql, BEGIN_TRANSACTION))
			{
				message_die(GENERAL_ERROR, "Could not remove style data!", "", __LINE__, __FILE__, $sql);
			}
			
			$message = $lang['Style_removed'] . "<br /><br />" . sprintf($lang['Click_return_styleadmin'], "<a href=\"" . append_sid("admin_style_edit.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

			message_die(GENERAL_MESSAGE, $message);
		}
	break;
	case "edit":
		$style_id = ( isset($HTTP_GET_VARS['style_id']) ) ? intval($HTTP_GET_VARS['style_id']) : intval($HTTP_POST_VARS['style_id']);

		if( !$confirm )
		{
			$sql = "SELECT * 
				FROM " . STYLES_CSS . " 
				WHERE style_id = $style_id";
			if(!$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, "Could not get data from styles table", "", __LINE__, __FILE__, $sql);
			}
			$row = $db->sql_fetchrow($result);

			$hidden_fields = '<input type="hidden" name="mode" value="'.$mode.'" /><input type="hidden" name="style_id" value="'.$style_id.'" /><input type="hidden" name="confirm" value="yes" />';

			$template->set_filenames(array(
				"body" => "admin/style_edit.tpl")
			);

			$template->assign_vars(array(
				"S_PROFILE_ACTION" => append_sid('admin_style_edit.'.$phpEx),
				"STYLE_NAME" => $row['style_name'],
				"STYLE_TEXT" => $row['style_text'],
				"L_SUBMIT" => $lang['Submit'],
				"S_HIDDEN_FIELDS" => $hidden_fields)
			);

			$template->pparse("body");
			include('./page_footer_admin.'.$phpEx);

		}
		else
		{

			if ( empty($HTTP_POST_VARS['style_text']) || empty($HTTP_POST_VARS['style_name']) )
			{
			$message = "Заполните все поля!<br /><br /><a href=\"" . append_sid("admin_style_edit.$phpEx?mode=edit&amp;style_id=$style_id") . "\">Попробовать ещё</a>";
			message_die(GENERAL_ERROR, $message);
			}
			$style_text = htmlspecialchars(trim($HTTP_POST_VARS['style_text']));
			$style_name = htmlspecialchars(trim($HTTP_POST_VARS['style_name']));

			$sql = "UPDATE " . STYLES_CSS . " 
				SET style_name = '" . str_replace("\'", "''", $style_name) . "', style_text = '" . str_replace("\'", "''", $style_text) . "' 
				WHERE style_id = $style_id";
			if(!$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, "Could not update style information", "", __LINE__, __FILE__, $sql);
			}

			$message = "Стиль изменён.<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=left") . "\">", "</a>");
			message_die(GENERAL_MESSAGE, $message);

		}
	break;
	case "setup":
		if( !$confirm )
		{
			message_die(GENERAL_MESSAGE, "Ошибка! Не введены данные стиля!");
		}
		else
		{

			if ( empty($HTTP_POST_VARS['style_text']) || empty($HTTP_POST_VARS['style_name']) )
			{
			$message = "Заполните все поля!<br /><br /><a href=\"" . append_sid("admin_style_edit.$phpEx") . "\">Попробовать ещё</a>";
			message_die(GENERAL_ERROR, $message);
			}

			$style_text = htmlspecialchars(trim($HTTP_POST_VARS['style_text']));
			$style_name = htmlspecialchars(trim($HTTP_POST_VARS['style_name']));

			$sql = "INSERT INTO " . STYLES_CSS . " (style_name, style_text)
				VALUES ('" . str_replace("\'", "''", $style_name) . "', '" . str_replace("\'", "''", $style_text) . "')";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not insert data into styles table', '', __LINE__, __FILE__, $sql);
			}
			$message = "Стиль \"".$style_name."\" успешно добавлен.<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=left") . "\">", "</a>");
			message_die(GENERAL_MESSAGE, $message);

		}
	break;
	default:
		$sql = "SELECT style_id, style_name 
			FROM " . STYLES_CSS . " ORDER BY style_id ASC";
		if(!$result = $db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, "Could not get style information!", "", __LINE__, __FILE__, $sql);
		}
		$style_rowset = $db->sql_fetchrowset($result);
		
		$template->set_filenames(array(
			"body" => "admin/styles_list_body.tpl")
		);

		$hidden_fields = '<input type="hidden" name="mode" value="setup" /><input type="hidden" name="confirm" value="yes" />';

		$template->assign_vars(array(
			"S_PROFILE_ACTION" => append_sid('admin_style_edit.'.$phpEx),
			"L_SUBMIT" => $lang['Submit'], 
			"S_HIDDEN_FIELDS" => $hidden_fields)
		);

		for($i = 0; $i < count($style_rowset); $i++)
		{
			$row_class = ( !($i % 2) ) ? 'row_easy' : 'row_hard';
			$s_id = $i+1;

			$template->assign_block_vars("styles", array(
				"ROW_CLASS" => $row_class,
				"STYLE_NAME" => $style_rowset[$i]['style_name'],
				"STYLE_ID" => $s_id,
				"U_STYLE_EDIT" => append_sid("admin_style_edit.$phpEx?mode=edit&amp;style_id=" . $style_rowset[$i]['style_id']),
				"U_STYLE_DELETE" => append_sid("admin_style_edit.$phpEx?mode=delete&amp;style_id=" . $style_rowset[$i]['style_id']))
			);
		}
		
		$template->pparse("body");
		include('./page_footer_admin.'.$phpEx);

}

?>