#!/usr/bin/env python
# -*- coding: utf-8 -*-
__author__ = 'SlyDeath'

import os, sys
if not os.geteuid() == 0:
    sys.exit(u'Script must be run as root!!!')

print u'##################################################################################'
print u'##### Введите полный путь к папке сайта, например /home/user/projects/mysite #####'
print u'##################################################################################'
DocumentRoot = raw_input(u'DocumentRoot: ')

if ( os.path.exists( DocumentRoot ) and  os.path.isdir( DocumentRoot ) ) :
    print u'Папка существует, всё окей'
else :
    try:
        os.makedirs( DocumentRoot )
    except OSError:
        raise

print u'##############################################################################'
print u'##### Введите адрес по которому будет доступен сайт, например mysite.loc #####'
print u'##############################################################################'
ServerName = raw_input(u'ServerName: ')
print u'############################################################################'
print u'##### Введите почтовый адрес администратора, например admin@mysite.loc #####'
print u'############################################################################'
ServerAdmin = raw_input(u'ServerAdmin: ')

defaultConfig = '''
<VirtualHost *:80>
    DocumentRoot ''' + DocumentRoot + '''
    ServerName ''' + ServerName + '''
    ServerAdmin ''' + ServerAdmin + '''
    <Directory ''' + DocumentRoot + '''>
        Options +FollowSymLinks
        AllowOverride All
        Order allow,deny
        Allow from all
    </Directory>
</VirtualHost>'''

with open ( u'/etc/apache2/sites-available/' + ServerName, 'w+' ) as configFile :
    if ( os.path.exists( u'/etc/apache2/sites-available/' + ServerName ) and  os.path.isfile( u'/etc/apache2/sites-available/' + ServerName ) ) :
        configFile.write(defaultConfig)
        print u'#####################################'
        print u'##### Виртуальный хост сохранён #####'
        print u'##### Save config done ##############'
        print u'#####################################'
    else :
        print u'###############################################################################'
        print u'##### Файл /etc/apache2/sites-available/' + ServerName + ' не существует ######'
        print u'##### File /etc/apache2/sites-available/' + ServerName + ' does not exist #####'
        print u'###############################################################################'

print u'############################################################'
print u'##### Делаю бэкап файла /etc/hosts в /etc/hosts.backup #####'
print u'##### Back-up /etc/hosts to /etc/hosts.backup ##############'
print u'############################################################'
os.system( 'cp /etc/hosts /etc/hosts.backup' )

with open ( u'/etc/hosts', 'a' ) as hostsFile :
    if ( os.path.exists ( u'/etc/hosts' ) and  os.path.isfile ( u'/etc/hosts' ) ) :
        hostsFile.write ( '127.0.0.1        ' + ServerName + '\n' )
    else :
        print u'##########################################'
        print u'##### Файл /etc/hosts не существует ######'
        print u'##### File /etc/hosts does not exist #####'
        print u'##########################################'

print u'###########################'
print u'##### Активируем сайт #####'
print u'##### Site enable #########'
print u'###########################'
os.system( 'a2ensite ' + ServerName )

print u'###########################'
print u'##### Перезапускаем Апач ##'
print u'##### Reload Apache #######'
print u'###########################'
os.system( 'service apache2 restart' )

print u'#######################################'
print u'##### Ставим права на катол сайта #####'
print u'##### Change Сhmod on site path #######'
print u'#######################################'
os.system( 'chmod 777 -R ' + DocumentRoot )

print u'#########################'
print u'##### Всё готово!!! :) ##'
print u'##### All done!!! :) ####'
print u'#########################'
