<?php # Created by Up

/*
Файл с которым работаете, должен существовать на сервере с правами доступа позволяющими запись в файл 0666

тип данных может быть двух видов, это:
value - значение переменной и
kom - коментарий переменной

$обьект=new config_file('адрес к файлу');
$обьект->new_key('$переменная','значение','тип данных'); // Создание переменных с данными
$обьект->read_key('$переменная','тип данных'); // чтение переменных с данными
$обьект->updata_key('$переменная','значение','тип данных'); // Обновление переменных с данными
$обьект->unset_key('$переменная'); // удаление переменных с данными
$обьект->config_saved(); // сохранение изменений в файле

все функции возврощают
true - при успешном выполнении и
false - если не удалось выполнить действие
так же можно посмотреть по какой причине не удалось выполнить действие
вызвав $обьект->error

Небольшой пример использования
$config =new config_file('config.php') or die($config->error); // Начинаем работу с файлом, если работа невозможна, выводим ошибку
$config->updata_key('$admin_icq','560-55-75','value') or die($config->error); // Обновляем переменную $admin_icq которая должна быть в файле, если обновление не произошло, выводим ошибку
$config->new_key('$admin_name','Up','value') or die($config->error); // Создаем переменную $admin_name в файле, если переменная не создана, выводим ошибку
$copy=$config->read_key('$copy','value'); // Читаем значение переменной
if($copy!==false) // если прочитанно
	print $copy; // Выводим значение
	 else // Если значение не прочитанно
		die($config->error); Выводим ошибку
$config->config_saved() or die($config->error); // Сохраняем изменения в файле, если не сохранилось, выводим ошибку
unset($config); // Озвобождаем занятые ресурсы
*/

class config_file
 {
	var $file=false; // Файл
	var $error=false; // Ошибки
	var $header="<?php # Created by Up\r\n"; // Шапка (если файл новый или нету по какой то причине своей)
	var $content=array(); // Контент файлa (ключь переменная в файле чтобы вытащить значение переменной добавляем ключь value чтобы вытащить коментарий переменной, добавляем ключ kom)
	var $foot="\r\n?>"; // Завершение файла

	function _config_001($file)
	 {
		$this->file=$file;
		$file=is_file($file)?file_get_contents($file):false;
		if($file!==false)
		 {
			$file=explode("\n\$",trim(preg_replace("/[\r\n]+\$/","\n\$",preg_replace("/\?>$/",'',trim($file)))));
			$this->header=strstr($file[0],'<\?')?$file[0]."\r\n":$this->header;
			unset($file[0]);
			$file=$this->_config_002($file);
		 }
		return $file;
	 }

	function _config_002($file)
	 {
		foreach($file as $arr)
		 {
			if(!empty($arr))
			 {
				$arr=explode('=',$arr);
				$key='$'.trim($arr[0]);
				unset($arr[0]);
				$arr=explode("~\r-\n-\t-conf-\t-\n-\r~",preg_replace("/('|\")?;( +)?(\/\*|\/\/|\#)/","~\r-\n-\t-conf-\t-\n-\r~",implode($arr,'=')));
				$this->content[$key]['value']=trim(str_replace("'","\\'",str_replace("\\'","'",str_replace('\\"','"',preg_replace("/^['\"]/",'',trim($arr[0]))))));
				unset($arr[0]);
				$this->content[$key]['kom']=trim(preg_replace("#\*/$#",'',preg_replace("/^\$/",'',trim(implode($arr,'\'; #')))));
			 }
		 }
		return true;
	 }

	function config_file($file)
	 {
		if($this->_config_001($file)===false)
		 {
			$this->error='Файл: '.htmlspecialchars($file).' не найден!';
			return false;
		 }
		 else
			return true;
	 }

	function unset_key($key)
	 {
		$key=trim($key);
		if(isset($this->content[$key]))
		 {
			unset($this->content[$key]);
			return true;
		 }
		 else
			 {
				$this->error='Переменная: '.htmlspecialchars($key).' не существует!';
				return false;
			 }
	 }

	function read_key($key,$parametr='value')
	 {
		$key=trim($key);
		if(isset($this->content[$key][$parametr]))
			return $this->content[$key][$parametr];
		 else
			 {
				$this->error='Переменная: '.htmlspecialchars($key).' с параметром '.htmlspecialchars($parametr).' не найдена!';
				return false;
			 }
	 }

	function updata_key($key,$value,$parametr='value')
	 {
		$key=trim($key);
		if(isset($this->content[$key][$parametr]))
			$this->content[$key][$parametr]=str_replace("'","\\'",$value);
		 else
			 {
				$this->error='Переменная: '.htmlspecialchars($key).' с параметром '.htmlspecialchars($parametr).' не найдена!';
				return false;
			 }
		return true;
	 }

	function new_key($key,$value,$parametr='value')
	 {
		$key=trim($key);
		if(isset($this->content[$key][$parametr]))
		 {
			$this->error='Переменная: '.htmlspecialchars($key).' с параметром '.htmlspecialchars($parametr).' уже существует!';
			return false;
		 }
			else
				$this->content[$key][$parametr]=str_replace("'","\\'",$value);
		return true;
	 }

	function config_saved()
	 {
		$content=$this->header."\r\n";
		foreach($this->content as $key=>$arr)
			$content.=$key.'=\''.$arr['value'].'\'; /*'.$arr['kom'].'*/'.("\r\n");
		$content.=$this->foot;
		if($fp=fopen($this->file,'w'))
		 {
			flock($fp,LOCK_EX);
			fputs($fp,$content);
			fflush($fp);
			flock($fp,LOCK_UN);
			fclose($fp);
			return true;
		 }
		 else
			 {
				$this->error='Ошибка записи в файл: '.htmlspecialchars($this->file);
				return false;
			 }
	 }
 }
?>