<?php
/*
 * @Author:      Papezhuk M. V.
 * @Web-Site:    http://nurd-cms.ru
 * @CopyRight:   NURD ENGINE 2 2012-2013
 * @Authorised:  api.Class
 */

class API {
	// Имя сервера
	private $server = 'nurd-cms.ru';

	// Тип подключения
	private $connectionType = 'http';

	// Файл
	private $page = "index.php";


	// Инициализация подключения
	public function __construct ($ServerURL = 'nurd-cms.ru', $isHTTPS = false) {
		$this->connectionType = $isHTTPS ? 'https' : 'http';
		$this->server = $ServerURL;
	}

	// Получение ответа на GET-запрос
	public function get ($paramsArray = array(), $ReqJSON = false) {
		$paramsArray['host'] = $_SERVER['HTTP_HOST'];
		$URLParams = array();
		foreach ($paramsArray as $var => $val)
			$URLParams[] = $var . '=' . $val;
		$queryString = implode('&', $URLParams);
		$request = @file_get_contents($this->connectionType . '://' . $this->server . '/' . $this->page . '?' . $queryString);
		return $ReqJSON ? json_decode($request, 1) : $request;
	}

	// Получение ответа на POST-запрос
	public function post ($paramsArray = array(), $ReqJSON = false) {
		$paramsArray['host'] = '';
		$URLParams = array();
		foreach ($paramsArray as $var => $val)
			$URLParams[] = $var . '=' . $val;
		$queryString = implode('&', $URLParams);
		$queryString = stream_context_create(array(
			$this->connectionType => array(
				'method' => 'POST',
				'header' => 'Content-Type: application/x-www-form-urlencoded' . PHP_EOL,
				'content' => $queryString,
			),));
		$request = @file_get_contents($this->connectionType . '://' . $this->server . '/' . $this->page, false, $queryString);
		return $ReqJSON ? json_decode($request, 1) : $request;
	}

	// Установить путь к файлу
	public function to ($FilePath = 'index.php') {
		return $this->page = $FilePath;
	}
}
?>