<?php
/*
 * @Author:      Papezhuk M. V.
 * @Web-Site:    http://nurd-cms.ru
 * @CopyRight:   NURD ENGINE 2 2012-2013
 * @Authorised:  cache.Class.php
 */

/*
 * Cache-Class
 * позволяет кешировать все
 */
class cache {
    /*
     * Кешируем содержимое переменной
     * В качестве переменной могут быть данные
     */
    static function create($cache_data, $name, $recache_time_out = 300) {
        $recache = 0;
        if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/cache_' . $name . '.php'))
            include $_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/cache_' . $name . '.php';

        //Не кеширум если время не истекло
        if ($recache > time()) return false;

        //Кешируем
        if ($recache < time()) {
            $recache = time()+$recache_time_out;
            $recache = strtolower($recache_time_out) == 'one' ? '"one"' : '"' . $recache . '"';
            $cache_data = var_export($cache_data, true);
            $data = "<?php\r\n";
            $data .= "\$recache\t=\t$recache;\r\n";
            $data .= "\$content\t=\t$cache_data;\r\n";
            $data .= "?>";

            if (file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/cache_' . $name . '.php', $data))
                return true;
        }
    }

    /*
     * Получаем содержимое файла кеша
     * ! Если время жизни кеш файла истекло, вернется false
     */
    static function get($name) {
        $content = false;
		$recache = 0;
        if (!file_exists($_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/cache_' . $name . '.php')) return false;
        include $_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/cache_' . $name . '.php';
        if ($recache > time() || $recache == 'one')
            return is_string($content) ? str_ireplace("\\'", "'", $content) : $content;
        else
            return false;
    }

    /*
     * Путь к файлу
     */
    static function get_path ($name) {
        if(file_exists($_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/cache_' . $name . '.php'))
            return 'unichat/cache/cache_' . $name . '.php';
        else
            return false;
    }

    /*
     * Чистка кеша
     */
    static function clear($name = false) {
        if ($name) {
            @unlink($_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/cache_' . $name . '.php');
            return true;
        }

        foreach ($_SERVER['DOCUMENT_ROOT'] . '/unichat/cache/*.php' as $file)
            @unlink($file);
        return true;
    }

}