<?php
function koecrushimage($imgfile, $sidepart=4) {

$root = realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
    
$dir = 'img';

$crushdir = 'crush';

if (!is_dir($root . $dir))
mkdir($root . $dir, 0777, true);

if (!is_dir($root . $dir . DIRECTORY_SEPARATOR . $crushdir))
mkdir($root . $dir . DIRECTORY_SEPARATOR . $crushdir, 0777, true);

$parts = pow($sidepart, 2);

if (!is_dir($root . $dir . DIRECTORY_SEPARATOR . $crushdir . DIRECTORY_SEPARATOR . substr($imgfile, 0, -4) . DIRECTORY_SEPARATOR . $parts))
mkdir($root . $dir . DIRECTORY_SEPARATOR . $crushdir . DIRECTORY_SEPARATOR . substr($imgfile, 0, -4) . DIRECTORY_SEPARATOR . $parts, 0777, true);

$img = imagecreatefromjpeg($root . $dir . DIRECTORY_SEPARATOR . $imgfile); 
$x = imagesx($img);
$y = imagesy($img);
$newx = (intval($x/$sidepart))*$sidepart;
$newy = (intval($y/$sidepart))*$sidepart;
$newimg = imagecreatetruecolor($newx, $newy);
imagefill($newimg, 0, 0, 0x000000);
imagecopyresampled($newimg, $img, 0, 0, 0, 0, $x, $y, $newx, $newy);
$picx = $newx/$sidepart;
$picy = $newy/$sidepart;
 
for ($i=0, $gorizontal=0; $i<$parts; $i++) {
$newpic = imagecreatetruecolor($picx, $picy);
imagefill($newpic, 0, 0, 0x000000); 
if ((($i%$sidepart)==0) && ($i!=0)) {
$gorizontal++; 
}
$vertical = ($i!=0) ? ($i%$sidepart) : $i;
imagecopyresampled($newpic, $newimg, 0, 0, ($vertical*$picx), ($gorizontal*$picy), $picx, $picy, $picx, $picy); 
imagejpeg($newpic, $root . $dir . DIRECTORY_SEPARATOR . $crushdir . DIRECTORY_SEPARATOR . substr($imgfile, 0, -4) . DIRECTORY_SEPARATOR . $parts . DIRECTORY_SEPARATOR . 'pic' . ($i+1) . '.jpg', 25);
imagedestroy($newpic);
}
screen($parts, $dir . DIRECTORY_SEPARATOR . $crushdir . DIRECTORY_SEPARATOR . substr($imgfile, 0, -4) . DIRECTORY_SEPARATOR . $parts);
}

function screen($parts, $dir) {
echo '<table><tr>' . PHP_EOL;
for ($i=1;$i<=$parts;$i++) {
echo '<td>' . PHP_EOL; 
echo '<img src="' . $dir . DIRECTORY_SEPARATOR . 'pic' . $i . '.jpg" alt="' . $i . '" />' . PHP_EOL;
echo '</td>' . PHP_EOL;
if (($i%(sqrt($parts))==0) && ($i!=0)){
echo '</tr><tr>' . PHP_EOL; 
} 
}
echo '</tr></table>' . PHP_EOL;
}

koecrushimage('test.jpg', 10);

?>
