<?php

class loger {

private static $user;    
private static $dir;    
private static $logdir = 'logs';
private static $archdir = 'archive';

public function __construct($user) {
if (!is_dir(self::$logdir . DIRECTORY_SEPARATOR . date('Y-m-d'))) {
if (!mkdir(self::$logdir . DIRECTORY_SEPARATOR . date('Y-m-d'), 0777, true)) {
#throw new Exception('WTF, log dir not created');     
} 
}
if (!is_dir(self::$archdir)) {
if (!mkdir(self::$archdir, 0777, true)) {
#throw new Exception('WTF, archive dir not created');     
} 
}
self::$dir = self::$logdir . DIRECTORY_SEPARATOR . date('Y-m-d');
self::$user = $user;
}
    
public static function writelog($text) {
if (self::$dir === null) {
#throw new Exception('WTF, dir not initialiting');
} else {
$file = self::$dir . DIRECTORY_SEPARATOR . self::$user . '.txt';
file_put_contents($file, $text . PHP_EOL, FILE_APPEND | LOCK_EX); 
}
self::logrotate();     
}

public static function logrotate() {
$sda = array_diff(scandir(self::$logdir), array('.', '..'));
if (sizeof($sda)>0) {
foreach ($sda as $dir) {
if ($dir != date('Y-m-d')) {
$zip = new ZipArchive;
if ($zip->open(self::$archdir . DIRECTORY_SEPARATOR . $dir . '.zip', ZipArchive::CREATE) === TRUE) {
$zip->addEmptyDir($dir);
$sdf = array_diff(scandir(self::$logdir . DIRECTORY_SEPARATOR . $dir), array('.', '..'));     
foreach ($sdf as $file) {
$zip->addFile(self::$logdir . DIRECTORY_SEPARATOR . $dir . DIRECTORY_SEPARATOR . $file, $dir . DIRECTORY_SEPARATOR . $file);    
}
$zip->close();
} else {
#throw new Exception('WTF, archive not created'); 
}
if (is_file(self::$archdir . DIRECTORY_SEPARATOR . $dir . '.zip')) {
self::deldir(self::$logdir . DIRECTORY_SEPARATOR . $dir);    
}
}
}
}
}

public static function deldir($dir) {
$dirarr = array_diff(scandir($dir), array('.', '..'));
if (sizeof($dirarr)>0) {    
foreach ($dirarr as $file) { 
unlink($dir . DIRECTORY_SEPARATOR . $file);
}
}
rmdir($dir);
}

}

?>