<?php
/*
 * Max's Page Navigation 4
 * Постраничная навигация MPPN4
 * Автор: Максим Папежук
 * Сайт: nurd-cms.ru
 * 
 * E-mail: invisliver@gmail.com
 * (пишите по поводу вакансий)
 *
 * Дата релиза: 9 мая 2012
 * Статья на: dcms.su, johncms.com.
 *
 ! Копирайты указанные в данном комментарие - единственные
 ! Прошу их не трогать
 ! Кто может пожертвуйте молодому (17 лет)
 ! разработчику на мороженное
 $ R171726141843   Z214584525928   U206669991180
 */

class PageNav {
    /*
     * Технические настройки навигации
     */
    //Записей на страницу
    var $per_page = 10;

    //Сколько записей должно быть
    //для показа минимизированной
    //навигации
    var $on_optimal = 10;

    //Условная переменная для
    //Парсера SQL-Запросов
    var $pars_var = '#LIMIT';
    
    //Переменная заголовка, в которой
    //будет передаваться номер текущей
    //страницы
    var $var = 'page';

    /*
    * Настройки дизайна
    *
    * Присваиваем классы, для будущей
    * настройки дизайна по выборке
    * batton[class=*]
    */
    //Класс* (css) кнопки страниц
    var $buttons_class = 'nav';

    //Класс* (css) кнопки текущей страницы
    //Возможно для выделения кнопки страницы
    //на которой находится пользователь
    var $button_class = 'nav_this';

    /*
     * Переменные необходимые для
     * работы класса
     */
    //Количество записей, выводимых
    //В навигации целиком
    var $rows = 0;

    //Текущая страница
    //По умолчанию равна 1
    var $page = 1;

    /*
     * Настройка
     *
     * В случае если настройки нужно изменить
     * из скрипта, существует данная функция
     */
    function SetParam ( $param, $value) {
        //Если параметра не существует,
        //Останавливаем функцию
        if ( empty( $this->$param ) )
            return false;
        //Если параметр существует
        //функция не остановится и
        //запишет параметр
        $this->$param = $value;
        return;
    }

    /*
     * Парсер SQL-Запросов
     *
     * Автоматически заменяет условную
     * переменную, на LIMIT в SQL
     * соответствующий номеру страницы
     */
    function Query ( $query) {
        //Подсчитываем количество записей
        //Записываем результат в переменную
        $this->rows = mysql_num_rows( str_ireplace( $this->pars_var, '', $query) );
        //Текущая страница
        $page = $_REQUEST[$this->var] ? trim($_REQUEST[$this->var]) : 1;
        //Если указана последняя страница
        //Или пытаются поковырять чего-то
        //Записываем результат в переменную
        if ( $page == 'last')
            $page = $this->rows;
        elseif ( is_string( $page ) )
            $page = 1;
        //Узнаем LIMIT mysql
        $start = ($page*$this->per_page)-$this->per_page;
        $limit = " LIMIT $start,$this->per_page";
        //Возвращаем результат
        return mysql_query( str_ireplace( $this->pars_var, $limit, $query) );
    }
    
    /*
     * Вывод навигации
     * 
     * Количество страниц будет зависеть
     * от $per_page и $rows
     *
     * $this->rows - запишется при выполнении
     * SQL-запросв
     * Также можно ввести вручную (если навигация
     * не касается SQL-запросов)
     *
     * $this->per_page - статичная переменная.
     */
    function Show ( $rows = NULL) {
        //Количество записей
        $rows = !$rows ? $this->rows : (int) ceil ( $rows );
        //Количество страниц
        $pages = ceil ( $rows / $this->per_page );
        //Текущая страница
        $page = $_REQUEST[$this->var] ? trim($_REQUEST[$this->var]) : 1;
        //если парсер SQL не был вызван,
        //значит в параметре page может быть
        //end или last
        if ( $page == 'last')
            $page = $pages;
        elseif ( is_string( $page ) )
            $page = 1;
        //Создаем форму которой будет передаваться
        //наш номер страницы
        echo "<form method='POST'>";
        //Определяем вид навигации
        if ( $pages > $this->on_optimal ) {
            /*Оптимальный вид навигации (Минимум генерации PHP)*/
            //Первая
            if ( $page > 2 ) echo "<input class='". $this->buttons_class ."' type='submit' name='" . $this->var . "' value='1' /> ... \n";
            //На 1 меньше чем текущая
            if ( $page > 1 ) echo "<input class='". $this->buttons_class ."' type='submit' name='" . $this->var . "' value='" . ($page - 1) . "' />\n";
                //Текущая
                echo "<input class='". $this->button_class ."' type='submit' name='" . $this->var . "' value='" . $page . "' />\n";
            //На 1 больше чем текущая
            if ( ($page + 1) <= $pages ) echo "<input class='". $this->buttons_class ."' type='submit' name='" . $this->var . "' value='" . ($page + 1) . "' />\n";
            //Последняя
            if ( ($page + 2) <= $pages ) echo " ... <input class='". $this->buttons_class ."' type='submit' name='" . $this->var . "' value='" . $pages . "' />\n";

        } else {
            /*Вывод стандартной версии*/
            for ( $n=1; $n <= $pages; $n++ ) {
                if ( $page == $n )
                    //Текущая
                    echo "<input class='". $this->button_class ."' type='submit' name='" . $this->var . "' value='" . $n . "' />\n";
                else
                    //Любая другая
                    echo "<input class='". $this->buttons_class ."' type='submit' name='" . $this->var . "' value='" . $n . "' />\n";
            }
        }
        //Закрываем форму
        echo "</form>";
        return;
    }
}
?>