<?php

/*
////////////////////////////////////////////////////////////////////////////////
// JohnCMS                Mobile Content Management System                    //
// Project site:          http://johncms.com                                  //
// Support site:          http://gazenwagen.com                               //
////////////////////////////////////////////////////////////////////////////////
// Lead Developer:        Oleg Kasyanov   (AlkatraZ)  alkatraz@gazenwagen.com //
// Development Team:      Eugene Ryabinin (john77)    john77@gazenwagen.com   //
//                        Dmitry Liseenko (FlySelf)   flyself@johncms.com     //
////////////////////////////////////////////////////////////////////////////////
*/

defined('_IN_JOHNCMS') or die('Error: restricted access');
$textl = 'Поиск пользователей';
$headmod = 'usersearch';
require('../incfiles/head.php');

/*
-----------------------------------------------------------------
Принимаем данные, выводим форму поиска
-----------------------------------------------------------------
*/
$search = isset($_POST['search']) ? trim($_POST['search']) : '';
$search = $search ? $search : rawurldecode(trim($_GET['search']));
echo '<div class="phdr"><a href="index.php"><b>Актив сайта</b></a> | Поиск пользователей</div>' .
    '<form action="index.php?act=search" method="post">' .
    '<div class="gmenu"><p>' .
    '<input type="text" name="search" value="' . functions::checkout($search) . '" />' .
    '<input type="submit" value="Найти" name="submit" />' .
    '</p></div></form>';

/*
-----------------------------------------------------------------
Проверям на ошибки
-----------------------------------------------------------------
*/
$error = array();
if (!empty($search) && (mb_strlen($search) < 2 || mb_strlen($search) > 20))
    $error[] = 'Ник: Минимальная длина Ника - 2, максимальная 20 символов';
if (preg_match("/[^1-9a-z\-\@\*\(\)\?\!\~\_\=\[\]]+/", functions::rus_lat(mb_strtolower($search))))
    $error[] = 'Ник: Недопустимые символы в Нике';
if ($search && !$error) {
    /*
    -----------------------------------------------------------------
    Выводим результаты поиска
    -----------------------------------------------------------------
    */
    echo '<div class="phdr">Результаты запроса</div>';
    $search_db = functions::rus_lat(mb_strtolower($search));
    $search_db = strtr($search_db, array (
        '_' => '\\_',
        '%' => '\\%',
        '*' => '%'
    ));
    $search_db = '%' . $search_db . '%';
    $req = mysql_query("SELECT COUNT(*) FROM `users` WHERE `name_lat` LIKE '" . mysql_real_escape_string($search_db) . "'");
    $total = mysql_result($req, 0);
    if ($total > 0) {
        $req = mysql_query("SELECT * FROM `users` WHERE `name_lat` LIKE '" . mysql_real_escape_string($search_db) . "' ORDER BY `name` ASC LIMIT $start, $kmess");
        while ($res = mysql_fetch_array($req)) {
            echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
            echo functions::display_user($res);
            echo '</div>';
            ++$i;
        }
    } else {
        echo '<div class="menu"><p>По вашему запросу ничего не найдено</p></div>';
    }
    echo '<div class="phdr">Всего: ' . $total . '</div>';
    if ($total > $kmess) {
        // Навигация по страницам
        echo '<p>' . functions::display_pagination('index.php?act=search&amp;' . ($search_t ? 't=1&amp;' : '') . 'search=' . rawurlencode($search) . '&amp;', $start, $total, $kmess) . '</p>' .
            '<p><form action="index.php?act=search" method="post">' .
            '<input type="hidden" name="search" value="' . functions::checkout($search) . '" />' .
            '<input type="text" name="page" size="2"/>' .
            '<input type="submit" value="К странице &gt;&gt;"/>' .
            '</form></p>';
    }
} else {
    /*
    -----------------------------------------------------------------
    Выводим сообщение об ошибке
    -----------------------------------------------------------------
    */
    if ($error)
        echo functions::display_error($error);

    /*
    -----------------------------------------------------------------
    Показываем инструкцию для поиска
    -----------------------------------------------------------------
    */
    echo '<div class="phdr"><small>Поиск идет по Нику пользователя (NickName) и нечувствителен к регистру букв. То есть, <b>UsEr</b> и <b>user</b> для поиска равноценны.<br />Запрос на поиск транслитерируется, то есть, чтоб найти, к примеру, ник ДИМА, Вы можете в запросе написать dima, результат будет один и тот же.</small></div>';
}
echo '<p>' . ($search && !$error ? '<a href="index.php?act=search">Новый поиск</a><br />' : '') . '<a href="index.php">Назад</a></p>';
?>