<?php
	/*
	Copyright (C) 2002-2004 Edwin van Wijk, www.v-wijk.net

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	*/

	include('config.inc.php'); //load configuration

	// Report simple running errors
	error_reporting(E_ERROR | E_WARNING | E_PARSE);

	//Procedure for emptying the tmp directory
	if($clearTemp==true)
	{
		if ($handle = opendir($downloadDir)) {
			while (false !== ($delFile = readdir($handle))) { 
				if($delFile!="." and $delFile!="..") {
					unlink($downloadDir . $delFile);
				}
			}
			closedir($handle); 
		}
	}

	function del_recursive($currentDir,$connection,$file){
		if ($lista = @ftp_nlist($connection, "$file")){
			for ($x=0;$x<count($lista);$x++){
				if (!@ftp_delete($connection, "$lista[$x]"))
				  del_recursive($currentDir,$connection,$lista[$x]);
			}
			@ftp_rmdir($connection, "$file");
		 }
	}

	include("include/functions.inc.php");

	session_start();

	$HPV = $HTTP_POST_VARS;

	// Get the POST, GET and SESSION variables (if register_globals=off (PHP4.2.1+))
	// It's a bit of a dirty hack but variables are sometimes GET and sometimes POST variables
	$mode=(isset($HPV['mode']))?$HPV['mode']:$HTTP_GET_VARS['mode'];
	$actionType=(isset($HPV['actionType']))?$HPV['actionType']:$HTTP_GET_VARS['actionType'];
	$currentDir=(isset($HPV['currentDir']))?$HPV['currentDir']:$HTTP_GET_VARS['currentDir'];
	$file=(isset($HPV['file']))?$HPV['file']:$HTTP_GET_VARS['file'];
	$file2=(isset($HPV['file2']))?$HPV['file2']:$HTTP_GET_VARS['file2'];
	$permissions=(isset($HPV['permissions']))?$HPV['permissions']:$HTTP_GET_VARS['permissions'];
	$directory=(isset($HPV['directory']))?$HPV['directory']:$HTTP_GET_VARS['directory'];	$MAX_FILE_SIZE=(isset($HPV['MAX_FILE_SIZE']))?$HPV['MAX_FILE_SIZE']:$HTTP_GET_VARS['MAX_FILE_SIZE'];
	$logoff=(isset($HPV['logoff']))?$HPV['logoff']:$HTTP_GET_VARS['logoff'];

	if(isset($HTTP_SESSION_VARS['server'])) {
		$server=$HTTP_SESSION_VARS['server'];
		$user=$HTTP_SESSION_VARS['user'];
		$password=$HTTP_SESSION_VARS['password'];
		$language=$HTTP_SESSION_VARS['language'];
		$port=$HTTP_SESSION_VARS['port'];
	} else {
		$server=$HTTP_POST_VARS['server'];
		$user=$HTTP_POST_VARS['user'];
		$password=$HTTP_POST_VARS['password'];
		$language=$HTTP_POST_VARS['language'];
		$port=$HTTP_POST_VARS['port'];
	}


	if (isset($logoff))
	{
		session_unregister('server');
		session_unregister('user');
		session_unregister('password');
		session_unregister('port');
		unset($server);
		unset($user);
		unset($password);
		unset($port);
		session_destroy();
	}
	
	// If language is not yet set, try to get the language from your browser.
	if($language==""){
     	$browser_lang = getenv("http_accept_language");
		$tmplang = $languages[$browser_lang];
		if(file_exists("include/language/" . $tmplang . ".lang.php")) {
			$language = $tmplang;
		} else {
			$language = "english";
		}
	}
	
	//Include Language file
	include("include/language/" . $language . ".lang.php");   // Selected language

	if ($server!="")
	{
		session_register('server', $server);
		session_register('user', $user);
		session_register('password', $password);
		session_register('language', $language);
		session_register('port', $port);

		$connection = @ftp_connect($server, $port);
		$loggedOn = @ftp_login($connection, $user, $password);
		$systype = @ftp_systype($connection);
		if($goPassive) {
			$passiveMode = @ftp_pasv($connection, true);
		}

		if(!isset($mode))
		{
			$mode=1; //(FTP_ASCII = 0; FTP_BINARY=1)
		}
		if ($loggedOn)
		{
			if (isset($currentDir))
			{
				ftp_chdir($connection, $currentDir);
			}
			$currentDir = ftp_pwd($connection);
			$msg = currentDirectory($currentDir);

			// what to do now ???
			if(isset($actionType)) {
				switch ($actionType) {
					case "chmod":	// Change permissions
						if(@ftp_site($connection, "chmod $permissions $file"))
						{
							$msg= $lblFilePermissionChanged;
						} else
						{
							$msg= $lblCouldNotChangePermissions;
						}
						break;
					case "cd":			// Change directory
						 //First try : normal directory
						 if ($file=="..")
						 { 
							@ftp_cdup($connection);
							$currentDir = @ftp_pwd($connection);
							$msg = 	$lblIndexOf . " " . currentDirectory($currentDir);
						 }
						 else
                         {
						 if(@ftp_chdir($connection, $currentDir . $file))
						 {
							$currentDir = @ftp_pwd($connection);
							$msg = $lblIndexOf . " " . currentDirectory($currentDir);
						 }
						 elseif(@ftp_chdir($connection, $file)) // Symbolic link directory
						 {
							$currentDir = @ftp_pwd($connection);
							$msg = $lblIndexOf . " " . currentDirectory($currentDir);
						 }
						 else // link to a file so let's retrieve this...
						 {
							header("Content-disposition: attachment; filename=\"$file\"");
							header("Content-type: application/octetstream");
							header("Pragma: ");
							header("Cache-Control: cache");
							header("Expires: 0");

							//Determine original filename
							$filearray = explode("/",$file);
							$file = $filearray[sizeof($filearray)-1];
							$msg = $file;

							$fp = fopen($downloadDir . $file, "w");
							if(!@ftp_fget($connection,$fp,"$file",$mode))
							{
								fclose($fp);
								exit;
							}
							fclose($fp);
							$data = readfile($downloadDir . $file);
							$i=0;
							while ($data[$i] != "")
							{
								echo $data[$i];
								$i++;
							}
							unlink($downloadDir . $file);
							exit;

                                                 }
						}
						break;
					case "get":			// Download file
						header("Content-disposition: attachment; filename=\"$file\"");
						header("Content-type: application/octetstream");
						header("Pragma: ");
						header("Cache-Control: cache");
						header("Expires: 0");

						$fp = fopen($downloadDir . $file, "w");
						ftp_fget($connection,$fp,"$file",$mode) OR DIE($lblErrorDownloadingFile);
						fclose($fp);
						$data = readfile($downloadDir . $file);
						$i=0;
						while ($data[$i] != "")
						{
							echo $data[$i];
							$i++;
						}
						unlink($downloadDir . $file);
						exit;
						break;
					case "put":			// Upload file
						if($file_size > $MAX_FILE_SIZE)
						{
							$msg = "<B>" . $lblFileSizeTooBig . "</B> (max. " . $MAX_FILE_SIZE . "bytes)<P>";
						}
						else
						{
							if(file_exists($HTTP_POST_FILES['file']['tmp_name']))
							{
								if ($mode==1)
								{
									ftp_put($connection, $currentDir . "/" . $HTTP_POST_FILES['file']['name'], $HTTP_POST_FILES['file']['tmp_name'], 1);
								}
								else
								{
									ftp_put($connection, $currentDir . "/" . $HTTP_POST_FILES['file']['name'], $HTTP_POST_FILES['file']['tmp_name'], 0);
								}
								unlink($HTTP_POST_FILES['file']['tmp_name']);
							}
							else
							{
								$msg = $lblFileCouldNotBeUploaded;
							}
						}
						break;
					case "deldir";		// Delete directory
						if(@ftp_rmdir($connection, "$file"))
						{
								$msg = "$file " . $lblDeleted;
						}
						else
						{
							//Verify if has files inside and if so, call recursive del
							if ($lista = @ftp_nlist($connection, "$currentDir/$file")){
								del_recursive($currentDir,$connection,$file);
								$msg = "$file " . $lblDeleted;
							}
							else $msg = $lblCouldNotDelete . " " . $file;
						}
						break;
					case "delfile";		// Delete file
						if(@ftp_delete($connection, "$file"))
						{
							$msg = "$file " . $lblDeleted;
						}
						else
						{
							$msg = $lblCouldNotDelete . " " . $file;
						}
						break;
					case "rename";		// Rename file
						if(@ftp_rename($connection, "$file", "$file2"))
						{
							$msg = $file . " " . $lblRenamedTo . " " . $file2;
						}
						else
						{
							$msg = $lblCouldNotRename . " " . $file . " " . $lblTo . " " . $file2;
						}
						break;
					case "createdir":  // Create a new directory
						if(@ftp_mkdir($connection, "$file"))
						{
							$msg = $file . " " . $lblCreated;
						}
						else
						{
							$msg = $lblCouldNotCreate . " " . $file;
						}
						break;
				}
			}
?>
<HTML>
<HEAD>
	<TITLE>WebFTP 2.4 By Edwin van Wijk</TITLE>
	<LINK REL=StyleSheet HREF="style/cm.css" TITLE=Contemporary TYPE="text/css">
	<SCRIPT LANGUAGE="JavaScript" SRC="include/script.js"></SCRIPT>
</HEAD>
<BODY>
<TABLE CELLPADDING=0 CELLSPACING=0 HEIGHT="100%">
<TR><TD>
	<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 WIDTH='100%'>
		<TR>
			<TD CLASS=titlebar COLSPAN=3>
				<B>WebFTP <?=$lblVersion;?> 2.3</B>
			</TD>
		</TR>
		<TR>
			<TD CLASS=menu>
			<?php
			$newMode=($mode==1)?0:1;
			?>
				<?php if($loggedOn) { ?>
				<TABLE CELLPADDING=0 CELLSPACING=0><TR>
				
				<TD VALIGN=CENTER>&nbsp;<A HREF='javascript:submitForm("cd","..")'><IMG SRC="img/parent.gif" HEIGHT=24 WIDTH=24 ALIGN=TOP BORDER=0></A></TD>
				<TD VALIGN=CENTER><nobr><A HREF='javascript:submitForm("cd","..")'>&nbsp;<?=$lblUp;?></A> </nobr></TD>

				<TD VALIGN=CENTER>&nbsp;<A CLASS=menu HREF="javascript:changeMode('<?=$newMode;?>')"><IMG SRC="img/mode.gif" HEIGHT=24 BORDER=0 ALIGN=CENTER></A></TD>
				<TD VALIGN=CENTER><nobr><A CLASS=menu HREF="javascript:changeMode('<?=$newMode;?>')">&nbsp;<?=$lblChangeMode;?></A> </nobr></TD>

				<TD VALIGN=CENTER>&nbsp;<A CLASS=menu HREF="<?=$PHP_SELF;?>?logoff=true"><IMG SRC="img/logoff.gif" HEIGHT=24 BORDER=0 ALIGN=CENTER></A></TD>
				<TD VALIGN=CENTER><nobr><A CLASS=menu HREF="<?=$PHP_SELF;?>?logoff=true">&nbsp;<?=$lblLogOff;?></A> </nobr></TD>

				<TD COLSPAN=6 VALIGN=TOP class=statusbar width="100%" VALIGN=CENTER ALIGN=RIGHT>
					<?=directoryPath($currentDir, $server);?>
				</TD>
				</TR>
</TABLE>
				<?php } else { ?>
				<TABLE CELLPADDING=0 CELLSPACING=0><TR>
				<TD VALIGN=CENTER>&nbsp;<A CLASS=menu HREF="<?=$PHP_SELF;?>?logoff=true"><IMG SRC="img/logoff.gif" HEIGHT=24 BORDER=0 ALIGN=CENTER></A> </TD>
				<TD VALIGN=CENTER>&nbsp;<A CLASS=menu HREF="<?=$PHP_SELF;?>?logoff=true"><?=$lblRetry;?></A> </TD>
				</TR></TABLE>

				<?php } ?>
			</TD>
			</FORM>
		</TR>
	</TABLE>
</TD></TR>
<TR><TD HEIGHT="100%">
	<FORM NAME="actionform" METHOD=POST ACTION='<?=$PHP_SELF;?>'>
		<INPUT TYPE='hidden' NAME='actionType' VALUE=''>
		<INPUT TYPE='hidden' NAME='currentDir' VALUE='<?=$currentDir;?>'>
		<INPUT TYPE='hidden' NAME='file' VALUE=''>
		<INPUT TYPE='hidden' NAME='file2' VALUE=''>
		<INPUT TYPE='hidden' NAME='extension' VALUE=''>
		<INPUT TYPE='hidden' NAME='permissions' VALUE=''>
		<INPUT TYPE='hidden' NAME='mode' VALUE='<?=$mode;?>' STYLE='border: none; background-color: #EFEFEF;'>
	</FORM>
	<HR>

	<TABLE HEIGHT="100%">
		<TR>
		<TD class=leftmenu VALIGN=TOP width=210>
			<DIV ALIGN=CENTER>
				<BR>
				<!-- File and folder -->
				<TABLE CELLPADDING=0 CELLSPACING=0 class=item>
					<TR>
						<TD VALIGN=TOP class=itemhead>
							<B><?=$lblFileTasks;?></B>
						</TD>
						</FORM>
					</TR>
					<TR>
						<TD VALIGN=TOP class=leftmenuitem>

							<DIV id="fileactions" style='display:none;'>
							<TABLE>
								<!-- Delete File -->
								<TR>
									<TD VALIGN=CENTER><IMG SRC="img/menu_delete.gif"></TD>
									<TD VALIGN=CENTER>
										<A HREF='javascript:deleteFile()' class=leftmenulink><?=$lblDeleteFile;?></A>
									</TD>
								</TR>

								<TR>
									<TD VALIGN=top><IMG SRC="img/menu_rename.gif"></TD>
									<TD VALIGN=top>
										<A HREF='javascript:setNewFileName("<?=$myDir["name"];?>")' class=leftmenulink><?=$lblRename;?></A>
										<!-- Rename file -->
										<DIV ID='renameFileEntry' style='display:none;'>
											<FORM NAME=renameFile>
											<TABLE CELLSPACING=0 class=lined align=center>
												<TR>
													<TD class=tinyblue>
													<B><?=$lblNewName;?></B><BR>
													<INPUT TYPE="text" NAME="newName" value=""></TD>
												</TR>
												</TABLE>
											<BR>
											<DIV ALIGN=CENTER><INPUT TYPE=button OnClick='renameItem();' VALUE='<?=$lblRename;?>'></DIV>
											</FORM>
											<BR>
										</DIV>
									</TD>
								</TR>

								<TR>
									<TD VALIGN=top><IMG SRC="img/menu_settings.gif"></TD>
									<TD VALIGN=top>
										<A HREF='javascript:;' OnClick='setPermissions()' class=leftmenulink><?=$lblSetPermissions;?></A>
										<!-- Change permissions -->
										<DIV ID='setPermissions' style='display:none;'>
											<FORM NAME=permissions>
											<TABLE CELLSPACING=0 class=lined align=center>
											<TR>
												<TD class=tinyblue ALIGN=CENTER><B><?=$lblOwner;?></B></TD>
												<TD class=tiny ALIGN=CENTER><B><?=$lblGroup;?></B></TD>
												<TD class=tinywhite ALIGN=CENTER><B><?=$lblPublic;?></B></TD>
											</TR>
											<TR>
												<TD class=tinyblue><INPUT TYPE="checkbox" NAME="iOr"> <?=$lblRead;?></TD>
												<TD class=tiny><INPUT TYPE="checkbox" NAME="iGr"> <?=$lblRead;?></TD>
												<TD class=tinywhite><INPUT TYPE="checkbox" NAME="iPr"> <?=$lblRead;?></TD>
											</TR>
											<TR>
												<TD class=tinyblue><INPUT TYPE="checkbox" NAME="iOw"> <?=$lblWrite;?></TD>
												<TD class=tiny><INPUT TYPE="checkbox" NAME="iGw"> <?=$lblWrite;?></TD>
												<TD class=tinywhite><INPUT TYPE="checkbox" NAME="iPw"> <?=$lblWrite;?></TD>
											</TR>
											<TR>
												<TD class=tinyblue><INPUT TYPE="checkbox" NAME="iOx"> <?=$lblExecute;?></TD>
												<TD class=tiny><INPUT TYPE="checkbox" NAME="iGx"> <?=$lblExecute;?></TD>
												<TD class=tinywhite><INPUT TYPE="checkbox" NAME="iPx"> <?=$lblExecute;?></TD>
											</TR>

											</TABLE>
											<BR>
											<DIV ALIGN=CENTER><INPUT TYPE=button OnClick='changePermissions()' VALUE='<?=$lblSetPermissions;?>'></DIV>
											</FORM>
											<BR>
										</DIV>
									</TD>
								</TR>
							</TABLE>
							</DIV>


							<!-- Standaard actions -->
							<TABLE>
								<TR>
									<TD VALIGN=top><IMG SRC="img/upload.gif" BORDER="0" ALT=""></TD>
									<TD VALIGN=top>
										<A HREF="JavaScript:toggle('uploadform');" class=leftmenulink><?=$lblUploadFile;?></A>
											<FORM id="uploadform" style='display:none;' NAME='putForm' ENCTYPE="multipart/form-data" METHOD=POST ACTION="<?=$PHP_SELF;?>">
												<INPUT TYPE="hidden" NAME="actionType" VALUE="put">
												<INPUT TYPE='hidden' NAME='currentDir' VALUE='<?=$currentDir;?>'>
												<INPUT TYPE="hidden" NAME="MAX_FILE_SIZE" VALUE="2000000">
												<INPUT TYPE='hidden' NAME='mode' VALUE='<?=$mode;?>'>
												<INPUT TYPE="file" NAME="file" STYLE="width:150px; font-size:7pt;"><BR>
												<INPUT TYPE="SUBMIT" VALUE="OK" STYLE='width=150px; font-size:7pt;'>
											</FORM>
									</TD>
								</TR>
								<TR>
									<TD VALIGN=top><IMG SRC="img/createdir.gif" BORDER="0" ALT=""></TD>
									<TD VALIGN=top>
										<A HREF="JavaScript:toggle('createform');" class=leftmenulink><?=$lblCreateDirectory;?></A>
										<FORM id="createform" style='display:none;' METHOD=POST NAME='dirinput' ACTION="<?=$PHP_SELF;?>">
											<INPUT TYPE="text" NAME="directory" VALUE="" STYLE="width:100px; font-size:7pt;">
											<INPUT TYPE="BUTTON" VALUE="OK" OnClick='javascript:createDirectory(dirinput.directory.value)' STYLE="width:40px; font-size:7pt;">
										</FORM>
									</TD>
								</TR>
								<TR>
									<TD VALIGN=top><IMG SRC="img/gotodir.gif" BORDER="0" ALT=""></TD>
									<TD VALIGN=top>
										<A HREF="JavaScript:toggle('gotoform');" class=leftmenulink><?=$lblGoToDirectory;?></A>
										<FORM id="gotoform" style='display:none;' NAME='cdDirect' METHOD=POST ACTION='<?=$PHP_SELF;?>'>
											<INPUT TYPE='hidden' NAME='actionType' VALUE='cd'>
											<INPUT TYPE='hidden' NAME='currentDir' VALUE='<?=$currentDir;?>'>
											<INPUT TYPE="text" NAME="file" VALUE="" STYLE="width:100px; font-size:7pt;">
											<INPUT TYPE="SUBMIT" VALUE="OK" STYLE="width:40px; font-size:7pt;">
										</FORM>
									</TD>
								</TR>
							</TABLE>
						</TD>
					</TR>
				</TABLE>
				<P>
				<!-- Details -->
				<TABLE CELLPADDING=0 CELLSPACING=0 class=item>
					<TR>
						<TD VALIGN=TOP class=itemhead>
							<B><?=$lblDetails;?></B>
						</TD>
						</FORM>
					</TR>
					<TR>
						<TD VALIGN=TOP class=leftmenuitem style='color:black' >
							<BR>
							<B><?=$msg;?></B>
							<P>
							<?=($loggedOn)?"$lblConnectedTo  $server:$port ($systype)":$lblNotConnected;?>
							<P>
							<?=$lblTransferMode;?> :<?=$mode==1?$lblBinaryMode:$lblASCIIMode;?>
							<BR><BR>
						</TD>
					</TR>

				</TABLE>

			</DIV>
		</TD>
		<TD VALIGN=TOP>

			<P>
			<?php
				$list=Array();
				$list=ftp_rawlist($connection, "");
			?>
			<TABLE WIDTH="650" CELLSPACING=0 CELLPADDING=0 onClick='resetEntries()'>
				<TR>
					<TD COLSPAN=2 class=listhead><?=$lblName;?></TD>
					<TD class=listhead><IMG SRC="img/listheaddiv.gif"></TD>
					<TD class=listhead align=right><?=$lblSize;?>&nbsp;</TD>
					<TD class=listhead><IMG SRC="img/listheaddiv.gif"></TD>
					<TD class=listhead><?=$lblFileType;?>&nbsp;</TD>
					<TD class=listhead><IMG SRC="img/listheaddiv.gif"></TD>
					<TD class=listhead><?=$lblDate;?></TD>
					<TD class=listhead><IMG SRC="img/listheaddiv.gif"></TD>
					<TD class=listhead><?=$lblPermissions;?></TD>
					<TD class=listhead><IMG SRC="img/listheaddiv.gif"></TD>
					<TD class=listhead><?=$lblOwner;?></TD>
					<TD class=listhead><IMG SRC="img/listheaddiv.gif"></TD>
					<TD class=listhead><?=$lblGroup;?></TD>
					<TD class=listhead><IMG SRC="img/listheaddiv.gif"></TD>
				</TR>
	 		<?php
				$list = parse_ftp_rawlist($list, $systype);

				if (is_array($list))
				{
					// Directories
					$counter=0;
					foreach($list as $myDir)
					{
						if ($myDir["is_dir"]==1)
						{
							$fileAction = "cd";
							$fileName = $myDir["name"];
							$fileSize="";
							$delAction = "deldir";
							$fileType['description'] = 'File Folder';
							$fileType['imgfilename'] = 'folder.gif';
						}

						if ($myDir["is_link"]==1)
						{
							$fileAction = "cd";
							$fileName = $myDir["target"];
							$fileSize="";
							$delAction = "delfile";
							$fileType['description'] = 'Symbolic Link';
							$fileType['imgfilename'] = 'link.gif';
						}

						if ($myDir["is_link"]!=1 && $myDir["is_dir"]!=1)
						{
						    $fileType = fileDescription($myDir["name"]);
							$fileAction = "get";
							$fileName = $myDir["name"];
							$image = "file.gif";
							if($myDir["size"]<1024) {
								$fileSize= $myDir["size"] . " bytes ";
							} else {
								$fileSize=sprintf("%01.2f", $myDir["size"]/1024) . " KB ";
							}
							$delAction = "delfile";
						}
				?>

							<TR>
							<TD class=filenamecol width=20><A HREF='javascript:selectEntry("<?=$fileAction;?>","<?=$fileName;?>","filename<?=$counter;?>","<?=$myDir["perms"];?>")' ondblclick='submitForm("<?=$fileAction;?>","<?=$fileName;?>")'><IMG SRC="img/<?=$fileType['imgfilename'];?>" ALIGN=TOP BORDER=0></A></TD>
							<TD class=filenamecol><span id='filename<?=$counter;?>'><A HREF='javascript:selectEntry("<?=$fileAction;?>","<?=$fileName;?>","filename<?=$counter;?>","<?=$myDir["perms"];?>")' ondblclick='submitForm("<?=$fileAction;?>","<?=$fileName;?>")'><?=$fileName;?></A></span></TD>
							<TD>&nbsp;</TD>
							<TD ALIGN=RIGHT><?=$fileSize;?></TD>
							<TD>&nbsp;</TD>
							<TD ALIGN=left><?=$fileType['description'];?></TD>
							<TD>&nbsp;</TD>
							<TD><?=$myDir["date"];?></TD>
							<TD>&nbsp;</TD>
							<TD><A HREF='javascript:;' OnDblClick='window.open("setpermission.php?file=<?=$fileName;?>&perms=<?=$myDir["perms"];?>","permissions","width=250,height=150,scrollbars=no,menubar=no,status=yes,directories=no,location=no")'><?=$myDir["perms"];?></A>							
							</TD>
							<TD>&nbsp;</TD>
							<TD><?=$myDir["user"];?></TD>
							<TD>&nbsp;</TD>
							<TD><?=$myDir["group"];?></TD>
							<TD>&nbsp;</TD>
							</TR>
				<?php
						$counter++;
					}
				} else {
				?>
							<TR>
							<TD colspan=14><BR><B><?=$lblDirectoryEmpty;?>...</B></TD>
							</TR>
				<?php
				}
				print "	</TABLE></TD></TR></TABLE>";
			}
			else
			{
				if(!isset($msg))
				{
					$msg = "$lblCouldNotConnectToServer  $server:$port $lblWithUser $user<P><A HREF='" . $PHP_SELF . "?logoff=true'>$lblTryAgain</A>";
				}
	?>
</TD></TR></TABLE>
<HTML>
<HEAD>
	<TITLE>WebFTP 2.3 By Edwin van Wijk</TITLE>
	<LINK REL=StyleSheet HREF="style/cm.css" TITLE=Contemporary TYPE="text/css">
	<SCRIPT LANGUAGE="JavaScript" SRC="include/script.js"></SCRIPT>
</HEAD>
<BODY>
<?php
			print $msg;
		}
	}
	else // Still need to logon...
	{
?>
<HTML>
<HEAD>
	<TITLE>WebFTP 2.3 By Edwin van Wijk</TITLE>
	<LINK REL=StyleSheet HREF="style/cm.css" TITLE=Contemporary TYPE="text/css">
	<SCRIPT LANGUAGE="JavaScript" SRC="include/script.js"></SCRIPT>
</HEAD>
<BODY>
		<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 WIDTH='100%'>
			<TR>
				<TD CLASS=titlebar>
					<B>WebFTP <?=$lblVersion;?> 2.3</B>
				</TD>
			</TR>
			<TR>
				<TD CLASS=menu>
					<TABLE CELLPADDING=0 CELLSPACING=0><TR>
					<TD VALIGN=CENTER><IMG SRC="img/1px.gif" HEIGHT=24 BORDER=0 ALIGN=CENTER></TD>
					<TD VALIGN=CENTER>&nbsp;</TD>
					</TR></TABLE>
				</TD>
			</TR>
		</TABLE>

		<FORM NAME=login action='<?=$PHP_SELF;?>' METHOD=POST>
		<TABLE class=login cellpadding=3>
			<TR>
				<TD COLSPAN=2><B>&nbsp;<?=$lblLogIn;?></B></TD>
			</TR>
			<TR>
				<TD COLSPAN=2><IMG SRC="img/1px.gif" HEIGHT=60></TD>
			</TR>
			<TR>
				<TD COLSPAN=2>&nbsp;<?=$lblConnectToFTPServer;?></TD>
			</TR>
			<TR>
				<TD VALIGN=TOP>&nbsp;<?=$lblServer;?></TD>
				<TD VALIGN=TOP>
					<TABLE CELLSPACING=0>
						<TR>
							<TD VALIGN=TOP><INPUT TYPE=TEXT NAME=server SIZE=15>&nbsp;</TD>
							<TD VALIGN=TOP>
								<TABLE CELLSPACING=0>
									<TR>
										<TD><?=$lblPort;?></TD>
										<TD><INPUT TYPE=TEXT NAME=port SIZE=3 VALUE=21></TD>
									</TR>
									<TR>
										<TD><?=$lblPasive;?></TD>
										<TD><INPUT TYPE="checkbox" NAME="goPassive"></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
				</TD>
			</TR>
			<TR>
				<TD>&nbsp;<?=$lblUser;?></TD>
				<TD>
					<INPUT TYPE=TEXT NAME=user SIZE=18>
				</TD>
			</TR>
			<TR>
				<TD>&nbsp;<?=$lblPassword;?></TD>
				<TD><INPUT TYPE=PASSWORD NAME=password SIZE=18>&nbsp;<INPUT TYPE=SUBMIT VALUE="Log on"></TD>
			</TR>
			<TR>
				<TD>&nbsp;<?=$lblLanguage;?></TD>
				<TD>
					<?php
					
					?>
					<SELECT NAME="language">
					<?php
						if ($handle = opendir('include/language/')) {
							while (false !== ($file = readdir($handle))) {
								if ($file != "." && $file != ".." ) {
								    $file=str_replace(".lang.php","",$file);
								    $counter=0;
								    foreach($languages as $thislang)
								    {
								        if($thislang==$file)
								        {
								            $counter++;
								        }
								    }
								    if($counter>0) {
					?>
										<OPTION VALUE="<?=$file;?>" <?=($language==$file)?"selected":"";?>><?=$file;?></OPTION>
					<?php
								    }

								}
							}
							closedir($handle);
						}
			 				?>
					</SELECT>
			</TR>
			<TR>
				<TD COLSPAN=2><IMG SRC="img/1px.gif" HEIGHT=5></TD>
			</TR>
		</TABLE>
		<TABLE WIDTH=328>
		<TR>
				<TD COLSPAN=2 VALIGN=TOP class=leftmenuitem>
					<DIV style='font-size:7pt;'>
					<?=$lblDisclaimer;?>
					<BR><BR>
					WebFTP <?=$lblVersion;?> 2.4<BR>
					&copy; 2002-2004, Edwin van Wijk,<BR>
					<A HREF="http://www.v-wijk.net" style='font-size:7pt;'>www.v-wijk.net</A>
					</div>
					<P>
				</TD>
			</TR>
			<TR>
			<TD ALIGN=LEFT>&nbsp;</TD>
			<TD ALIGN=RIGHT>
				&nbsp;
			</TD>
			</TR>
		</TABLE>
		</FORM>
<?php
	}
?>
<P>
</BODY>
</HTML>

