<?php
// All possible languages available, used for selecting the right language file.
$languages = array(
    'af' => 'african',
    'sq' => 'albanian',
    'ar' => 'arabic',
    'ar-dz' => 'arabic', // algeria
    'ar-bh' => 'arabic', // bahrain
    'ar-eg' => 'arabic', // egypt
    'ar-iq' => 'arabic', // iraq
    'ar-jo' => 'arabic', // jordan
    'ar-kw' => 'arabic', // kuwait
    'ar-lb' => 'arabic', // lebanon
    'ar-ly' => 'arabic', // libya
    'ar-ma' => 'arabic', // morocco
    'ar-om' => 'arabic', // oman
    'ar-qa' => 'arabic', // qatar
    'ar-sa' => 'arabic', // Saudi Arabia
    'ar-sy' => 'arabic', // syria
    'ar-tn' => 'arabic', // tunisia
    'ar-ae' => 'arabic', // U.A.E
    'ar-ye' => 'arabic', // yemen
    'hy' => 'armenian',
    'ast' => 'asturian',
    'eu' => 'basque',
    'be' => 'belarusian',
    'bs' => 'bosnian',
    'bg' => 'bulgarian',
    'ca' => 'catalan',
    'zh' => 'chinese',
    'zh-cn' => 'chinese', // China
    'zh-hk' => 'chinese', // Hong Kong
    'zh-sg' => 'chinese', // Singapore
    'zh-tw' => 'chinese', // Taiwan
    'hr' => 'croatian',
    'cs' => 'czech',
    'da' => 'danish',
    'nl' => 'dutch',
    'nl-be' => 'dutch', // Belgium
    'en' => 'english',
    'en-au' => 'english', // Australia
    'en-bz' => 'english', // Belize
    'en-ca' => 'english', // Canada
    'en-ie' => 'english', // Ireland
    'en-jm' => 'english', // Jamaica
    'en-nz' => 'english', // New Zealand
    'en-ph' => 'english', // Philippines
    'en-za' => 'english', // South Africa
    'en-tt' => 'english', // Trinidad
    'en-gb' => 'english', // United Kingdom
    'en-us' => 'english', // United States
    'en-zw' => 'english', // Zimbabwe
    'eo' => 'esperanto',
    'et' => 'estonian',
    'fo' => 'faeroese',
    'fi' => 'finnish',
    'fr' => 'french',
    'fr-be' => 'french', // Belgium
    'fr-ca' => 'french', // Canada
    'fr-fr' => 'french', // France
    'fr-lu' => 'french', // Luxembourg
    'fr-mc' => 'french', // Monaco
    'fr-ch' => 'french', // Switzerland
    'gl' => 'galician',
    'ka' => 'georgian',
    'de' => 'german',
    'de-at' => 'german', // Austria
    'de-de' => 'german', // Germany
    'de-li' => 'german', // Liechtenstein
    'de-lu' => 'german', // Luxembourg
    'de-ch' => 'german', // Switzerland
    'el' => 'greek',
    'he' => 'hebrew',
    'hu' => 'hungarian',
    'is' => 'icelandic',
    'id' => 'indonesian',
    'ga' => 'irish',
    'it' => 'italian',
    'it-ch' => 'italian', // Switzerland
    'ja' => 'japan',
    'ko' => 'korean',
    'ko-kp' => 'korean', // North Korea
    'ko-kr' => 'korean', // South Korea
    'lv' => 'latvian',
    'lt' => 'lithuanian',
    'mk' => 'macedonian',
    'ms' => 'malay',
    'no' => 'norwegian',
    'nb' => 'norwegian bokmal',
    'nn' => 'norwegian nynorsk',
    'pl' => 'polish',
    'pt' => 'portuguese',
    'pt-br' => 'portuguese', // Brazil
    'ro' => 'romanian',
    'ru' => 'russian',
    'gd' => 'scots gealic',
    'sr' => 'serbian',
    'sk' => 'slovak',
    'sl' => 'slovenian',
    'es' => 'spanish',
    'es-ar' => 'spanish', // Argentina
    'es-bo' => 'spanish', // Bolivia
    'es-cl' => 'spanish', // Chile
    'es-co' => 'spanish', // Colombia
    'es-cr' => 'spanish', // Costa Rica
    'es-do' => 'spanish', // Dominican Republic
    'es-ec' => 'spanish', // Ecuador
    'es-sv' => 'spanish', // El Salvador
    'es-gt' => 'spanish', // Guatemala
    'es-hn' => 'spanish', // Honduras
    'es-mx' => 'spanish', // Mexico
    'es-ni' => 'spanish', // Nicaragua
    'es-pa' => 'spanish', // Panama
    'es-py' => 'spanish', // Paraguay
    'es-pe' => 'spanish', // Peru
    'es-pr' => 'spanish', // Puerto Rico
    'es-es' => 'spanish', // Spain
    'es-uy' => 'spanish', // Uruguay
    'es-ve' => 'spanish', // Venezuela
    'sv' => 'swedish',
    'sv-fi' => 'swedish', // Finland
    'th' => 'thai',
    'tr' => 'turkish',
    'uk' => 'ukrainian',
    'vi' => 'vietnamese',
    'cy' => 'welsh',
    'xh' => 'xhosa',
    'yi' => 'yiddish',
    'zu' => 'zulu'
);

	function currentDirectory($string) {
		$stringArray = split("/",$string);
		$level = count($stringArray);
		$returnString = $stringArray[$level-1];
		if(trim($returnString)=="") {
			$returnString = "/";
		}
		return $returnString;
	}

	function directoryPath($string, $server) {
		$stringArray = split("/",$string);
		$level = count($stringArray);

		$down = "";
		$levelCount=0;
		while($levelCount<$level-1) {
			$down .= "../";
			$levelCount++;
		}
		$returnString = "<A HREF=\"javascript:submitForm('cd', '" . $down . "')\" style='text-decoration:underline;'>&lt;" . $server . "&gt;</A>";
		foreach($stringArray as $str) {
			$down = "";
			$level = $level - 1;
			$levelCount=0;
			while($levelCount<$level) {
				$down .= "../";
				$levelCount++;
			}

			if($level>0) {
				$returnString .= "<A HREF=\"javascript:submitForm('cd', '" . $down . "')\" style='text-decoration:underline;'>" .  $str . "</A>/";
			}
		}
		return $returnString;
	}

	function parse_ftp_rawlist($list, $type="UNIX") {
		if ($type == "UNIX")
		{
			$regexp = "([-ldrwxs]{10})[ ]+([0-9]+)[ ]+([A-Z|0-9|-]+)[ ]+([A-Z|0-9|-]+)[ ]+([0-9]+)[ ]+([A-Z]{3}[ ]+[0-9]{1,2}[ ]+[0-9|:]{4,5})[ ]+(.*)";
			$i=0;
			foreach ($list as $line) 
			{
				$is_dir = $is_link = FALSE;
				$target = "";

				if (eregi($regexp, $line, $regs))
				{
					if (!eregi("^[.]", $regs[7])) //hide hidden files
					if (!eregi("^[.]{2}", $regs[7])) // don't hide hidden files
					{
						$i++;
						if (eregi("^[d]", $regs[1]))
						{
							$is_dir = TRUE;
						}
						elseif (eregi("^[l]", $regs[1])) 
						{ 
							$is_link = TRUE;
							list($regs[7], $target) = split(" -> ", $regs[7]);
						}

						//Get extension from file name
						$regs_ex = explode(".",$regs[7]);
						if ((!$is_dir)&&(count($regs_ex) > 1))
						   $extension = $regs_ex[count($regs_ex)-1];
						else $extension = "";

						$files[$i] = array (
							"is_dir"	=> $is_dir,
							"extension"	=> $extension,
							"name"		=> $regs[7],
							"perms"		=> $regs[1],
							"num"		=> $regs[2],
							"user"		=> $regs[3],
							"group"		=> $regs[4],
							"size"		=> $regs[5],
							"date"		=> $regs[6],
							"is_link"	=> $is_link,
							"target"	=> $target );
					}
				}
			}
		}
		else
		{
			$regexp = "([0-9\-]{8})[ ]+([0-9:]{5}[APM]{2})[ ]+([0-9|<DIR>]+)[ ]+(.*)";
			foreach ($list as $line) 
			{
				$is_dir = false;
				if (eregi($regexp, $line, $regs)) 
				{
					if (!eregi("^[.]", $regs[4]))
					{
						if($regs[3] == "<DIR>")
						{
							$is_dir = true;
							$regs[3] = '';
						}
						$i++;
	
						// Get extension from filename
						$regs_ex = explode(".",$regs[4]);
						if ((!$is_dir)&&(count($regs_ex) > 1))
						   $extension = $regs_ex[count($regs_ex)-1];
						else $extension = "";

						$files[$i] = array (
							"is_dir"	=> $is_dir,
							"extension"	=> $extension,
							"name"		=> $regs[4],
							"date"		=> $regs[1],
							"time"		=> $regs[2],
							"size"		=> $regs[3],
							"is_link"	=> 0,
							"target"	=> "",
							"num"		=> "" );
					}
				}
			}
		}
		if ( is_array($files)  AND count($files) > 0)
		{
			$files=array_sort_multi($files, 1, 3);
		}
		return $files;
	}


	function array_sort_multi($array, $key,$key2)

	{
	  foreach ($array as $i => $k) { 
		   if(! empty($array[$i][$key][$key2])){
		   $sort_values[$i] = $array[$i][$key][$key2];
		   }else{
		   $sort_values[$i] = $array[$i];
		   }
	  } 
	  asort ($sort_values);
	  reset ($sort_values);
	  while (list ($arr_keys, $arr_values) = each ($sort_values)) {
			 $sorted_arr[] = $array[$arr_keys];
	  }
	  return $sorted_arr;
	} 

	function getExtention($filename){
		if(($dotpos = strrpos($filename, '.')) === false){
			return false;
		}else{
			return substr($filename, $dotpos+1);
		}
	}
	function fileDescription($filename){
		$ext = getExtention($filename);
		if($ext == 'png' OR $ext == 'gif' OR $ext == 'jpg' OR $ext == 'psp' OR $ext == 'bmp' OR $ext == 'ai' OR $ext == 'tiff'){
	    	$res['imgfilename'] = 'pic.gif';
			$res['description'] = strtoupper($ext).' Image/Picture';
	 	}elseif($ext == 'html' OR $ext == 'htm'){
	    	$res['imgfilename'] = 'html.gif';
			$res['description'] = 'HTML Document';
	 	}elseif($ext == 'css'){
	 		$res['imgfilename'] = 'txt.gif';
			$res['description'] = 'Stylesheet';
	 	}elseif($ext == 'doc'){
	 		$res['imgfilename'] = 'doc.gif';
			$res['description'] = 'Microsoft Word Document';
	 	}elseif($ext == 'pdf'){
	 		$res['imgfilename'] = 'pdf.gif';
			$res['description'] = 'PDF Document';
		}elseif($ext == 'php' OR $ext == 'php3'){
			$res['imgfilename'] = 'php.gif';
			$res['description'] = 'PHP Script';
		}elseif($ext == 'js'){
			$res['imgfilename'] = 'js.gif';
			$res['description'] = 'Javascript';
		}elseif($ext == 'swf'){
			$res['imgfilename'] = 'pic.gif';
			$res['description'] = 'Flash file';
		}elseif($ext == 'txt'){
			$res['imgfilename'] = 'txt.gif';
			$res['description'] = 'Textfile';
		}elseif($ext == 'avi' OR $ext == 'mov' OR $ext == 'mpg' OR $ext == 'rm'){
			$res['imgfilename'] = 'mov.gif';
			$res['description'] = 'Video file';
		}elseif($ext == 'mp3' OR $ext == 'wav' OR $ext == 'ogg'){
			$res['imgfilename'] = 'mov.gif';
			$res['description'] = 'Audio file';
		}elseif($ext == 'zip' OR $ext == 'rar' OR $ext == 'cab' OR $ext == 'b2z'){
			$res['imgfilename'] = 'zip.gif';
			$res['description'] = 'Compressed file';
		}elseif($ext == 'exe' OR $ext == 'com' OR $ext == 'bat'){
			$res['imgfilename'] = 'exe.gif';
			$res['description'] = 'Application';
		}else{
			$res['imgfilename'] = 'file.gif';
			$res['description'] = $ext . ' File';
		}
		return $res;
	}
?>
