<?php
defined('_IN_JOHNCMS') or die('Restricted access');
											
// Сравнивает массив с шаблоном
function sravnenie($array, array $default){
	if($default){
		$out_arr = array();
								
		foreach($default as $key => $val){
			if(isset($array[$key])){
				if(is_array($val)){
					$out_arr[$key] = sravnenie($array[$key], $val);
				}else
					$out_arr[$key] = $array[$key];
			}else
				$out_arr[$key] = $val;
		}
							
		return $out_arr;
	}else
		return $array;
}
								
// Время
function timecount($string){
    if($string >= 3600 && $string < 86400){
         $time = sprintf("%2d:%02d:%02d", (int)($string / 3600) % 24, (int)($string / 60) % 60, $string % 60);
         $string = "$time час.";
    }elseif($string >= 60 && $string < 3600){
         $time = sprintf("%2d:%02d", (int)($string / 60) % 60, $string % 60);
         $string = "$time мин.";
    }elseif($string < 60) {
         $time = floor($string);
         $string = "$time сек.";
    }else{
         $time = sprintf("%2d дн. %02d:%02d:%02d", (int) $string / 86400, (int)($string / 3600) % 24, (int)($string / 60) % 60, $string % 60);
         $string = "$time";
    }
     return $string; 
}
							
// 
function stats($parametr = ''){
	if($parametr){
		if(!is_array($parametr))
			$parametr = unserialize($parametr);
	}else
		$parametr = '';
	$parametr = sravnenie($parametr, array('sila' => 3, 'lovk' => 3, 'krit' => 3, 'vynosl' => 3));
																			
	$stat = array();
	$stat['max_uron'] = $parametr['sila'] * 3;
	$stat['min_uron'] = ceil($parametr['sila'] * 1.5);
	$stat['bron9'] = ceil($parametr['sila'] * 0.5);
												
	$stat['uvorot'] = $parametr['lovk'] * 3;
	$stat['anti_uvorot'] = ceil($parametr['lovk'] * 1.5);
													
	$stat['krit'] = $parametr['krit'] * 3;
	$stat['anti_krit'] = ceil($parametr['krit'] * 1.5);
													
	$stat['max_zdorov'] = ($parametr['vynosl'] * 10) + 20;
						
	return $stat;
}
									
// Таблица опыта
function tabl($lvl = 0){
	$tabl_array = array(
		2  => array('treb_opyt' => 100, 'nev_stat' => 5), 
		3  => array('treb_opyt' => 200, 'nev_stat' => 5), 
		4  => array('treb_opyt' => 400, 'nev_stat' => 5), 
		5  => array('treb_opyt' => 800, 'nev_stat' => 5), 
		6  => array('treb_opyt' => 1600, 'nev_stat' => 5), 
		7  => array('treb_opyt' => 3200, 'nev_stat' => 5), 
		8  => array('treb_opyt' => 6400, 'nev_stat' => 5), 
		9  => array('treb_opyt' => 12800, 'nev_stat' => 5), 
		10 => array('treb_opyt' => 25600, 'nev_stat' => 5), 
		11 => array('treb_opyt' => 51200, 'nev_stat' => 5), 
		12 => array('treb_opyt' => 102400, 'nev_stat' => 5), 
		13 => array('treb_opyt' => 204800, 'nev_stat' => 5), 
		14 => array('treb_opyt' => 409600, 'nev_stat' => 5), 
		15 => array('treb_opyt' => 819200, 'nev_stat' => 5), 
		16 => array('treb_opyt' => 1638400, 'nev_stat' => 5), 
		17 => array('treb_opyt' => 3276800, 'nev_stat' => 5), 
		18 => array('treb_opyt' => 6553600, 'nev_stat' => 5), 
		19 => array('treb_opyt' => 13107200, 'nev_stat' => 5), 
		20 => array('treb_opyt' => 26214400, 'nev_stat' => 5), 
		21 => array('treb_opyt' => 52428800, 'nev_stat' => 5));
															
	if($lvl){
		$opyt = 0;
		if(isset($tabl_array[$lvl + 1]))
			$opyt = $tabl_array[$lvl + 1]['treb_opyt'];
						
		return $opyt;
	}
						
	return $tabl_array;
}