<?php

/**
* @package     JohnCMS
* @link        http://johncms.com
* @copyright   Copyright (C) 2008-2011 JohnCMS Community
* @license     LICENSE.txt (see attached file)
* @version     VERSION.txt (see attached file)
* @author      http://johncms.com/about
*/

$file = isset($_GET['file']) ? htmlspecialchars(urldecode($_GET['file'])) : NULL;
if ($file && file_exists('../files/forum/attach/' . $file)) {
    list($width, $height, $type) = getimagesize('../files/forum/attach/' . $file);
	switch ($type) {
		case 1: $att_ext = 'gif' ;break;
		case 2: $att_ext = 'jpeg'; break;
		case 3: $att_ext = 'png'; break;
		case 4: $att_ext = 'jpg'; break;
	}
    if ($att_ext) {
        $sizs = GetImageSize('../files/forum/attach/' . $file);
        if ($sizs) {
            $razm = 50;
            $width = $sizs[0];
            $height = $sizs[1];
            $x_ratio = $razm / $width;
            $y_ratio = $razm / $height;
            if (($width <= $razm) && ($height <= $razm)) {
                $tn_width = $width;
                $tn_height = $height;
            } else if (($x_ratio * $height) < $razm) {
                $tn_height = ceil($x_ratio * $height);
                $tn_width = $razm;
            } else {
                $tn_width = ceil($y_ratio * $width);
                $tn_height = $razm;
            }
			
			$function = 'imageCreateFrom' . $att_ext;
			$image = $function('../files/forum/attach/' . $file);
			if($att_ext == 'gif') {
				$tmp = imagecreate($tn_width, $tn_height);
				$color = imagecolorallocate($tmp, 0, 0, 0); 
			}
			else
				$tmp = imageCreateTrueColor($tn_width, $tn_height);
			if($att_ext == 'png') {
				imageAlphaBlending($tmp, false);
				imageSaveAlpha($tmp, true);
			} else if($att_ext == 'gif') {
				imagecolortransparent($tmp, $color);
			}
			imageCopyResampled($tmp, $image, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);
			ob_start();
			switch($att_ext) {
				case 'jpg':
				case 'jpeg':
					@imagejpeg($tmp, null, 100);
					break;
				case 'gif':
					@imagegif($tmp, null);
					break;
				case 'png':
					@imagepng($tmp, null, 9);
					break;
				default:
					// *** No extension - No save.
				break;
			}
			ImageDestroy($tmp);
			imageDestroy($image);
			Header("Content-Type: image/" . $att_ext);
			Header('Content-Disposition: inline; filename=thumbinal.' . $att_ext);
			Header('Content-Length: ' . ob_get_length());
			ob_end_flush();
        }
    }
}
?>