SET SQL_MODE="";

DROP TABLE IF EXISTS `cms_menu_count`;
CREATE TABLE IF NOT EXISTS `cms_menu_count` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `code` text NOT NULL,
  PRIMARY KEY (`id`)
)
CHARACTER SET utf8 COLLATE utf8_general_ci;

INSERT INTO `cms_menu_count` (`name`, `code`) VALUES
('от галлереи', 'counters::gallery'),
('от библиотеки', 'counters::library'),
('от загрузок', 'counters::downloads'),
('от форума', 'counters::forum'),
('от гостевой', 'counters::guestbook'),
('от пользователей', 'counters::users'),
('от альбомов', 'counters::album');

DROP TABLE IF EXISTS `cms_menu_group`;
CREATE TABLE IF NOT EXISTS `cms_menu_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pos` int(11) NOT NULL,
  `pic` text NOT NULL,
  `name` text NOT NULL,
  `show` int(2) NOT NULL,
  `sumbo` text NOT NULL,
  PRIMARY KEY (`id`)
)
CHARACTER SET utf8 COLLATE utf8_general_ci;

INSERT INTO `cms_menu_group` (`pos`, `pic`, `name`, `show`, `sumbo`) VALUES
(1, '', 'Общение', 1, ''),
(2, '', 'Полезное', 1, ''),
(3, '', 'Актив сайта', 1, ''),
(4, '', 'Ссылки', 1, '');

DROP TABLE IF EXISTS `cms_menu_link`;
CREATE TABLE IF NOT EXISTS `cms_menu_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pos` int(11) NOT NULL,
  `pic` text NOT NULL,
  `type` int(11) NOT NULL,
  `show` int(2) NOT NULL,
  `name` text NOT NULL,
  `link` text NOT NULL,
  `group` text NOT NULL,
  `sumbo` text NOT NULL,
  PRIMARY KEY (`id`)
)
CHARACTER SET utf8 COLLATE utf8_general_ci;

INSERT INTO `cms_menu_link` (`pos`, `pic`, `type`, `show`, `name`, `link`, `group`, `sumbo`) VALUES
(3, 'Aluminium-library-64.png', 2, 1, 'Библиотека', 'library/', '2', ''),
(2, '3D-User-Black-64.png', 6, 1, 'Пользователи', 'users/index.php', '3', ''),
(3, 'Android-Gallery-64.png', 1, 1, 'Галерея', 'gallery/', '2', ''),
(1, '3D-Photocamera-64.png', 7, 1, 'Фотоальбомы', 'users/album.php', '3', ''),
(1, 'File-Manager-Android-64.png', 3, 1, 'Загрузки', 'download/', '2', ''),
(2, 'Android-Facebook-64.png', 4, 1, 'Форум', 'forum/', '1', ''),
(1, 'Android-Messages-64.png', 5, 1, 'Гостевая', 'guestbook/index.php', '1', ''),
(1, 'Android-Browser-64.png', 0, 1, 'Gazenwagen', 'http://gazenwagen.com/', '4', ''),
(2, 'Android--64.png', 0, 1, 'Dimko`s blog', 'http://dimkos.ru', '4', '');

DROP TABLE IF EXISTS `cms_menu_settings`;
CREATE TABLE IF NOT EXISTS `cms_menu_settings` (
  `key` tinytext NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`(30))
)
CHARACTER SET utf8 COLLATE utf8_general_ci;

INSERT INTO `cms_menu_settings` (`key`, `val`) VALUES
('enabled', '1'),
('pic_path', 'icons'),
('pic_cat', '1');

INSERT INTO `cms_settings` (`key`, `val`) VALUES
('webskindef', 'androidmarket');
