<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

defined('_IN_JOHNCMS') or die('Restricted access');

class core
{
    public static $root = '../';
    public static $ip;                                                         // Путь к корневой папке
    public static $ip_via_proxy;                                               // IP адрес за прокси-сервером
    public static $user_agent;                                                 // User Agent
    public static $system_set;                                                 // Системные настройки
    public static $deny_registration = false;                                  // Запрет регистрации пользователей
    public static $core_errors = array();                                      // Ошибки ядра

    public static $user_id = false;                                            // Идентификатор пользователя
    public static $user_rights = 0;                                            // Права доступа
    public static $user_data = array();                                        // Все данные пользователя
    public static $user_ban = array();                                         // Бан

    private $flood_chk = 0;                                                    // Включение - выключение функции IP антифлуда
    private $flood_interval = '120';                                           // Интервал времени в секундах
    private $flood_limit = '30';                                               // Число разрешенных запросов за интервал

    function __construct()
    {
        global $rootpath;
        if(isset($rootpath)) self::$root = $rootpath;                          // Задаем путь к корневой папке
        $this->get_ip();                                                       // Получаем адрес IP
        $this->get_ua();                                                       // Получаем UserAgent
        $this->ip_flood();                                                     // Проверка адреса IP на флуд
        if (get_magic_quotes_gpc()) $this->del_slashes();                      // Удаляем слэши
        $this->db_connect();                                                   // Соединяемся с базой данных
        $this->ip_ban();                                                       // Проверяем адрес IP на бан
        $this->session_start();                                                // Стартуем сессию
        $this->system_settings();                                              // Получаем системные настройки
        $this->auto_clean();                                                   // Автоочистка системы
        $this->authorize();                                                    // Авторизация пользователей
    }

    function __destruct()
    {
    }

    /*
    -----------------------------------------------------------------
    Валидация IP адреса
    -----------------------------------------------------------------
    */
    public static function ip_valid($ip = '')
    {
        if (empty($ip)) return false;
        $d = explode('.', $ip);
        for ($x = 0; $x < 4; $x++) if (!is_numeric($d[$x]) || ($d[$x] < 0) || ($d[$x] > 255)) return false;
        return $ip;
    }

    /*
    -----------------------------------------------------------------
    Показываем ошибки ядра (если есть)
    -----------------------------------------------------------------
    */
    public static function display_core_errors(){
        return !empty(self::$core_errors) ? '<p style="color:#FF0000"><b>CORE ERROR</b>: ' . implode('<br />', self::$core_errors) . '</p>' : '';
    }

    /*
    -----------------------------------------------------------------
    Подключаемся к базе данных
    -----------------------------------------------------------------
    */
    private function db_connect()
    {
        require(self::$root . 'incfiles/db.php');
        $db_host = isset($db_host) ? $db_host : 'localhost';
        $db_user = isset($db_user) ? $db_user : '';
        $db_pass = isset($db_pass) ? $db_pass : '';
        $db_name = isset($db_name) ? $db_name : '';
        $connect = @mysql_connect($db_host, $db_user, $db_pass) or die('Error: cannot connect to database server');
        @mysql_select_db($db_name) or die('Error: specified database does not exist');
        @mysql_query("SET NAMES 'utf8'", $connect);
    }

    /*
    -----------------------------------------------------------------
    Получаем адрес IP
    -----------------------------------------------------------------
    */
    private function get_ip()
    {
        self::$ip = ip2long($_SERVER['REMOTE_ADDR']) or die('Invalid IP');
        self::$ip_via_proxy = isset($_SERVER['HTTP_X_FORWARDED_FOR']) && self::ip_valid($_SERVER['HTTP_X_FORWARDED_FOR']) ? ip2long($_SERVER['HTTP_X_FORWARDED_FOR']) : false;
    }

    /*
    -----------------------------------------------------------------
    Получаем UserAgent
    -----------------------------------------------------------------
    */
    private function get_ua()
    {
        self::$user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? htmlentities(substr($_SERVER['HTTP_USER_AGENT'], 0, 200), ENT_QUOTES) : 'Not Recognised';
    }

    /*
    -----------------------------------------------------------------
    Проверка адреса IP на флуд
    -----------------------------------------------------------------
    */
    private function ip_flood()
    {
        if ($this->flood_chk) {
            if ($this->ip_whitelist(self::$ip))
                return true;
            $file = self::$root . 'files/cache/ip_flood.dat';
            $tmp = array();
            $requests = 1;
            if (!file_exists($file)) $in = fopen($file, "w+");
            else $in = fopen($file, "r+");
            flock($in, LOCK_EX) or die("Cannot flock ANTIFLOOD file.");
            $now = time();
            while ($block = fread($in, 8)) {
                $arr = unpack("Lip/Ltime", $block);
                if (($now - $arr['time']) > $this->flood_interval) continue;
                if ($arr['ip'] == self::$ip) $requests++;
                $tmp[] = $arr;
            }
            fseek($in, 0);
            ftruncate($in, 0);
            for ($i = 0; $i < count($tmp); $i++) fwrite($in, pack('LL', $tmp[$i]['ip'], $tmp[$i]['time']));
            fwrite($in, pack('LL', self::$ip, $now));
            fclose($in);
            if ($requests > $this->flood_limit){
                die('FLOOD: exceeded limit of allowed requests');
            }
        }
    }

    /*
    -----------------------------------------------------------------
    Обрабатываем "белый" список IP адресов
    -----------------------------------------------------------------
    */
    private function ip_whitelist($ip)
    {
        $file = self::$root . 'files/cache/ip_wlist.dat';
        if (file_exists($file)) {
            foreach (file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $val) {
                $tmp = explode(':', $val);
                if (!$tmp[1]) $tmp[1] = $tmp[0];
                if ($ip >= $tmp[0] && $ip <= $tmp[1]) return true;
            }
        }
        return false;
    }

    /*
    -----------------------------------------------------------------
    Удаляем слэши из глобальных переменных
    -----------------------------------------------------------------
    */
    private function del_slashes()
    {
        $in = array(
            &$_GET,
            &$_POST,
            &$_COOKIE
        );
        while ((list($k, $v) = each($in)) !== false) {
            foreach ($v as $key => $val) {
                if (!is_array($val)) {
                    $in[$k][$key] = stripslashes($val);
                    continue;
                }
                $in[] = &$in[$k][$key];
            }
        }
        unset($in);
        if (!empty($_FILES)) foreach ($_FILES as $k => $v) $_FILES[$k]['name'] = stripslashes((string)$v['name']);
    }

    /*
    -----------------------------------------------------------------
    Проверяем адрес IP на Бан
    -----------------------------------------------------------------
    */
    private function ip_ban()
    {
        $req = mysql_query("SELECT `ban_type`, `link` FROM `cms_ban_ip`
            WHERE '" . self::$ip . "' BETWEEN `ip1` AND `ip2`
            " . (self::$ip_via_proxy ? " OR '" . self::$ip_via_proxy . "' BETWEEN `ip1` AND `ip2`" : "") . "
            LIMIT 1
        ") or die('Error: table "cms_ban_ip"');
        if (mysql_num_rows($req)) {
            $res = mysql_fetch_array($req);
            switch ($res['ban_type']) {
                case 2:
                    if (!empty($res['link'])) header('Location: ' . $res['link']);
                    else header('Location: http://johncms.com');
                    exit;
                    break;
                case 3:
                    self::$deny_registration = true;
                    break;
                default :
                    header("HTTP/1.0 404 Not Found");
                    exit;
            }
        }
    }

    /*
    -----------------------------------------------------------------
    Стартуем Сессию
    -----------------------------------------------------------------
    */
    private function session_start()
    {
        session_name('SESID');
        session_start();
    }

    /*
    -----------------------------------------------------------------
    Получаем системные настройки
    -----------------------------------------------------------------
    */
    private function system_settings()
    {
        $set = array();
        $req = mysql_query("SELECT * FROM `cms_settings`");
        while (($res = mysql_fetch_row($req)) !== false) $set[$res[0]] = $res[1];
        self::$system_set = $set;
    }

    /*
    -----------------------------------------------------------------
    Авторизация пользователя и получение его данных из базы
    -----------------------------------------------------------------
    */
    private function authorize()
    {
        $user_id = false;
        $user_ps = false;
        if (isset($_SESSION['uid']) && isset($_SESSION['ups'])) {
            // Авторизация по сессии
            $user_id = abs(intval($_SESSION['uid']));
            $user_ps = $_SESSION['ups'];
        } elseif (isset($_COOKIE['cuid']) && isset($_COOKIE['cups'])) {
            // Авторизация по COOKIE
            $user_id = abs(intval(base64_decode(trim($_COOKIE['cuid']))));
            $_SESSION['uid'] = $user_id;
            $user_ps = md5(trim($_COOKIE['cups']));
            $_SESSION['ups'] = $user_ps;
        }
        if ($user_id && $user_ps) {
            $req = mysql_query("SELECT * FROM `users` WHERE `id` = '$user_id'");
            if (mysql_num_rows($req)) {
                $user_data = mysql_fetch_assoc($req);
                $permit = $user_data['failed_login'] < 3 || $user_data['failed_login'] > 2 && $user_data['ip'] == self::$ip && $user_data['browser'] == self::$user_agent ? true : false;
                if ($permit && $user_ps === $user_data['password']) {
                    // Если авторизация прошла успешно
                    self::$user_id = $user_id;
                    self::$user_rights = $user_data['rights'];
                    self::$user_data = $user_data;
                    $this->user_ip_history();
                    $this->user_ban_check();
                } else {
                    // Если авторизация не прошла
                    mysql_query("UPDATE `users` SET `failed_login` = '" . ($user_data['failed_login'] + 1) . "' WHERE `id` = '" . $user_data['id'] . "'");
                    $this->user_unset();
                }
            } else {
                // Если пользователь не существует
                $this->user_unset();
            }
        }
    }

    /*
    -----------------------------------------------------------------
    Проверка пользователя на Бан
    -----------------------------------------------------------------
    */
    private function user_ban_check()
    {
        $req = mysql_query("SELECT * FROM `cms_ban_users` WHERE `user_id` = '" . self::$user_id . "' AND `ban_time` > '" . time() . "'");
        if (mysql_num_rows($req)) {
            self::$user_rights = 0;
            while (($res = mysql_fetch_row($req)) !== false) self::$user_ban[$res[4]] = 1;
        }
    }

    /*
    -----------------------------------------------------------------
    Фиксация истории IP адресов пользователя
    -----------------------------------------------------------------
    */
    private function user_ip_history()
    {
        if (self::$user_data['ip'] != self::$ip || self::$user_data['ip_via_proxy'] != self::$ip_via_proxy) {
            // Удаляем из истории текущий адрес (если есть)
            @mysql_query("DELETE FROM `cms_users_iphistory`
                WHERE `user_id` = '" . self::$user_id . "'
                AND `ip` = '" . self::$ip . "'
                AND `ip_via_proxy` = '" . self::$ip_via_proxy . "'
                LIMIT 1
            ");
            if (!empty(self::$user_data['ip']) && self::ip_valid(long2ip(self::$user_data['ip']))) {
                // Вставляем в историю предыдущий адрес IP
                mysql_query("INSERT INTO `cms_users_iphistory` SET
                    `user_id` = '" . self::$user_id . "',
                    `ip` = '" . self::$user_data['ip'] . "',
                    `ip_via_proxy` = '" . self::$user_data['ip_via_proxy'] . "',
                    `time` = '" . self::$user_data['lastdate'] . "'
                ");
            }
            // Обновляем текущий адрес в таблице `users`
            mysql_query("UPDATE `users` SET
                `ip` = '" . self::$ip . "',
                `ip_via_proxy` = '" . self::$ip_via_proxy . "'
                WHERE `id` = '" . self::$user_id . "'
            ");
        }
    }

    /*
    -----------------------------------------------------------------
    Уничтожаем данные авторизации юзера
    -----------------------------------------------------------------
    */
    private function user_unset()
    {
        self::$user_id = false;
        self::$user_rights = 0;
        self::$user_data = array();
        unset($_SESSION['uid']);
        unset($_SESSION['ups']);
        setcookie('cuid', '');
        setcookie('cups', '');
    }

    /*
    -----------------------------------------------------------------
    Автоочистка системы
    -----------------------------------------------------------------
    */
    private function auto_clean()
    {
        if (self::$system_set['clean_time'] < time() - 86400) {
            mysql_query("DELETE FROM `cms_sessions` WHERE `lastdate` < '" . (time() - 86400) . "'");
            mysql_query("DELETE FROM `cms_users_iphistory` WHERE `time` < '" . (time() - 2592000) . "'");
            mysql_query("UPDATE `cms_settings` SET  `val` = '" . time() . "' WHERE `key` = 'clean_time' LIMIT 1");
            mysql_query("OPTIMIZE TABLE `cms_sessions` , `cms_users_iphistory`");
        }
    }
}