<?php

/* Автор Koenig | koenig.h2m.ru || compolom.ru */

function kfmcopy($dir, $dirto, $e=1) { 
if (is_file($dir)) {
if (file_exists($dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $dir)))) {
if ($e==1) {
return(3);
}
}
if (!copy($dir, $dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $dir)))) {
if ($e==1) {
return(2);
}
}
} elseif (is_dir($dir)) {
if (!@mkdir($dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $dir)), 0777, TRUE)) {
if ($e==1) {
return(3);
}
}
foreach (new DirectoryIterator($dir) as $fileInfo) {
if ($fileInfo->isDot()) continue;
if (is_file($fileInfo->getPathname())) {
if (file_exists(DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $dir)) . DIRECTORY_SEPARATOR . $fileInfo->getFilename())) {
if ($e==1) {
return(3);
}
}    
if (!copy($fileInfo->getPathname(), $dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $dir)) . DIRECTORY_SEPARATOR . $fileInfo->getFilename())) {
if ($e==1) {
return(2);    
}
}
} elseif (is_dir($fileInfo->getPathname())) {
kfmcopy($fileInfo->getPathname(), $dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $dir)));
}
}
}
if (!file_exists($dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $dir)))) {
if ($e==1) {
return(2);
}  
} else {
return true;    
}
}

function kfmmove($act, $dirto) {
if (is_file($act)) {
if (file_exists($dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $act)))) {
echo '<div>Файл с таким именем уже существует в этой директории</div>';    
return false;
} else {
$move = rename($act, $dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $act)));
if ($move) {
echo $act . ' -> ' .  $dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $act));
}
return true;
}
} elseif (is_dir($act)) {
if (is_dir($dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $act)))) {
echo '<div>Директория с таким именем уже существует в этой директории</div>';
return false;    
} else {
$move = rename($act, $dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $act)));
if ($move) {
echo $act . ' -> ' .  $dirto . DIRECTORY_SEPARATOR . end(explode(DIRECTORY_SEPARATOR, $act));
}
return true;    
}
}
}

function listdirs($listdirspg, $dir='root') {
global $rootpath;
$dir = ($dir=='root') ? realpath($rootpath) : $dir;
$dir = is_dir($dir) ? $dir : 'root';
$x=2;
foreach (new DirectoryIterator($dir) as $fileInfo) {
if($fileInfo->isDot() || $fileInfo->isFile()) continue;
elseif ($fileInfo->isDir()) {
echo ($x%2 ? '<div class="list1">' : '<div class="list2">') . '<img src="img/dir.png" class="ico" alt="" /> <a href="' . $listdirspg .'=' . $fileInfo->getPathname() . '">' .  $fileInfo->getFilename() . '</a></div>';
$x++;
}
}
}

function kfmdownload($dnlf){ 
if (headers_sent()) { 
die('Заголовки отправлены');
}
 
if (ini_get('zlib.output_compression')) {
ini_set('zlib.output_compression', 'Off');
} 
 
if (file_exists($dnlf)){ 
 
$fsize = filesize($dnlf); 
$path_parts = pathinfo($dnlf); 
$ext = strtolower($path_parts['extension']);
 
$fd = @fopen($dnlf, 'rb');
$f1 = fileinode($dnlf);
$f2 = filemtime($dnlf); 
$ftime = gmdate('r', $f2); 
 
$arr_types = array( 
"sis" => "application/vnd.symbian.install",
"amr" => "audio/amr",
"jad" => "text/vnd.sun.j2me.app-descriptor;charset=UTF-8",
"jar" => "application/java-archive",
"mp4" => "video/mp4",
"3gp" => "video/3gpp",  
"rar" => "application/x-rar-compressed",
"doc" => "application/msword", 
"exe" => "application/octet-stream", 
"pdf" => "application/pdf", 
"zip" => "application/zip", 
"mp3" => "audio/mpeg", 
"wav" => "audio/x-wav", 
"bmp" => "image/bmp", 
"gif" => "image/gif", 
"jpg" => "image/jpeg", 
"png" => "image/png", 
"css" => "text/css", 
"txt" => "text/plain", 
"mpg" => "video/mpeg", 
"avi" => "video/x-msvideo", 
);  
 
if (in_array($ext, $arr_types)) {
$type = $arr_types[$ext];  
} else {
$type = 'application/force-download';     
}
 
if (isset($_SERVER['HTTP_RANGE'])) { 
$range = $_SERVER['HTTP_RANGE']; 
$range = str_replace('bytes=', '', $range);
list($range, $end) = explode('-', $range);
 
if (!empty($range)) {
fseek($fd, $range);
}
} else {
$range = 0;
}
 
if ($range) {
header($_SERVER['SERVER_PROTOCOL'] . ' 206 Partial Content');
} else {
header($_SERVER['SERVER_PROTOCOL'] . ' 200 OK');
}
 
header('Last-Modified: ' . $ftime);
header('ETag: ' . sprintf('%x-%x-%x', $f1, $fsize, $f2));
header('Accept-Ranges: bytes');
header('Pragma: public'); 
header('Expires: 0'); 
header('Cache-Control: must-revalidate, post-check=0, pre-check=0'); 
header('Cache-Control: private', false);
header('Content-Type: ' . $type . '');
header('Content-Description: inline; File Transfer'); 
header('Content-Disposition: attachment; filename="' . basename($dnlf) . '";', false); 
header('Content-Transfer-Encoding: binary'); 
header('Content-Length: ' . ($fsize - $range));
 
if ($range) {
header('Content-Range: bytes ' . $range . '-' . ($fsize - 1) . '/' . $fsize);
}
 
header('Connection: close');  
 
ob_clean(); 
 
sleep(1);
 
$speed = 1024*8; // 8 - speed/kb 
while(!feof($fd) && connection_status()==0) { // проверяем коннект, чтоб процесс не висел при дисконнекте
$buf = fread($fd, $speed); // отдаем файл порцайками , менее напрягает сервер, актуально для файлов более 1 гб
print($buf);
flush();
#sleep(1);  // if speed > 8 разкоментирование приведет к ограничению скорости
} 
 
fclose($fd);
 
} else {
die('Файл не найден!'); 
}
}

function kfmdel($dir) {
if (is_file($dir) && is_readable($dir) && is_writable($dir)) {
unlink($dir);     
} elseif (is_file($dir) && !is_readable($dir) || !is_writable($dir)) { 
chmod($dir, 0666);
unlink($dir);         
} elseif (is_dir($dir)) {
foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::CHILD_FIRST) as $path) {
if ($path->isDir() && $path->isWritable() && $path->isReadable()) {
rmdir($path->__toString());
} elseif ($path->isDir() && !$path->isWritable() || !$path->isReadable()) {
chmod($path->__toString(), 0777);
rmdir($path->__toString());
} elseif ($path->isFile() && $path->isWritable() && $path->isReadable()) {
unlink($path->__toString());    
} elseif ($path->isFile() && !$path->isWritable() || !$path->isReadable()) {
chmod($path->__toString(), 0666);    
unlink($path->__toString());
} else {
return false;
}
}
rmdir($dir);
}
if (!is_file($dir) || !is_dir($dir)) {
return true;
} else {
return false;    
}
}

function sizeofdir($dir) {
$dir = realpath($dir);
$fileSPLObjects =  new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::CHILD_FIRST);
$dirs = 0;
$files = 0;
$dirsize = 0;
foreach( $fileSPLObjects as $fullFileName => $fileSPLObject ) {
if ($fileSPLObject->isDir()) {
$dirs++;
} elseif ($fileSPLObject->isFile()) {
$files++;
$dirsize += $fileSPLObject->getSize();
}
}
return $dirs . ' - Dir(s) , Total: ' . $files . ' file(s) , ' . file_size($dirsize);
}

function file_size($size) {
$filesizename = array(" Bytes", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB");
return $size ? round($size/pow(1024, ($i = floor(log($size, 1024)))), 2) . $filesizename[$i] : '0 Bytes';
}
  
?>
