<?php

/* Автор Koenig | koenig.h2m.ru || compolom.ru */

define('_IN_JOHNCMS', 1);

$rootpath = file_exists('login.php') ? '' : (file_exists('../login.php') ? '../' : (file_exists('../../login.php') ? '../../' : '../../../'));
require_once($rootpath . 'incfiles/core.php');

if ($rights<9) {
header('Status: 404 Not Found'); 
header('Location: ' . $rootpath . '?err');
exit;  
}

require_once($rootpath . 'incfiles/head.php');

include 'data/conf.php';

$pg2 = 'kfm.php';

$mode = isset($_GET['mode']) ? $_GET['mode'] : '';

switch ($mode) {

case 'download';
kfmdownload($dir);
echo '<div class="phdr"><a href="' . $pg2 . '?act=' . $_SESSION['backtodir'] . '">Назад</a></div>';
break;

case 'unpack';
if (!isset($_SESSION['backtodir'])) {
echo '<div class="phdr">Ошибка<br/><a href="' . $pg2 . '">Назад</a></div>';    
} else {
require_once($rootpath . 'incfiles/lib/pclzip.lib.php');
#require_once($rootpath . 'incfiles/class_pclzip.php'); 
$info = pathinfo(end(explode(DIRECTORY_SEPARATOR, $dir)));
$unpackdirname = $_SESSION['backtodir'] . '/' .  basename((end(explode(DIRECTORY_SEPARATOR, $dir))), '.' . $info['extension']) . '_' . date('d-m-Y-H-i-s');
if (!is_dir($unpackdirname)) {
if (mkdir($unpackdirname, 0777, TRUE)) {
echo '<div>Папка ' . $unpackdirname . ' успешно создана</div>' . PHP_EOL;    
} else {
echo '<div>Папка создана не была</div>' . PHP_EOL;    
}    
}
$arch = new PclZip($dir);
$res = $arch->extract(PCLZIP_OPT_PATH, $unpackdirname);
if ($res==true) {
echo '<div>Архив успешно извлечен</div>' . PHP_EOL;
} else {
echo 'Error : ' . $arch->errorInfo(true);
}
}
echo '<div class="phdr"><a href="' . $pg2 . '?act=' . $_SESSION['backtodir'] . '">Назад</a></div>';
break;

case 'delete';
if (isset($_GET['yes'])) {
if (kfmdel($dir)) {
echo end(explode(DIRECTORY_SEPARATOR, $dir)) . ' удалено';    
} else {
echo '<div>Произошла ошибка</div>' . PHP_EOL;
}
} else {
echo '<div>Вы действительно хотите удалить ' . end(explode(DIRECTORY_SEPARATOR, $dir)) . '?<br/><a href="' . $pg . '?act=' . $dir . '&amp;mode=delete&amp;yes">Да</a> | <a href="' . $pg . '?act=' . $dir . '">Нет</a></div>'; 
}
echo '<div class="phdr"><a href="' . $pg2 . '">Назад</a></div>'; // ?act=' . $_SESSION['backtodir'] . '
break;

case 'arch';
require_once($rootpath . 'incfiles/lib/pclzip.lib.php');
#require_once($rootpath . 'incfiles/class_pclzip.php'); 
$name = 'arch_' . date('d-m-Y-H-i-s') . '.zip';
$zip = new PclZip($_SESSION['backtodir'] . DIRECTORY_SEPARATOR . $name);
$act = $zip->add($dir, PCLZIP_OPT_REMOVE_PATH, $_SESSION['backtodir']);
if ($act==true) {
echo '<div>Архив успешно создан</div>' . PHP_EOL;
} else {
echo 'Error : ' .$zip->errorInfo(true);
}
echo '<div class="phdr"><a href="' . $pg2 . '?act=' . $_SESSION['backtodir'] . '">Назад</a></div>';
break;

case 'rename';
$df = is_dir($dir) ? 'dir' : 'file';
if (isset($_POST['submit'])) {
if (mb_strlen($_POST['newname'])>37 || empty($_POST['newname'])) {
echo '<dir>Ошибка переименования<br/>Длина имени пустое либо более 37 символов<br/><a href="' . $pg . '?act=' . $dir . '&amp;mode=rename' . $rnd . '">повторить</a></dir>' . PHP_EOL;
} elseif (preg_match("/[^a-zA-Z0-9-_.#]/", $_POST['newname'])) {
echo '<dir>Ошибка переименования<br/>В имени содержатся недопустимые символы, только латиница, . ,  - , _ символы<br/><a href="' . $pg . '?act=' . $dir . '&amp;mode=rename' . $rnd . '">повторить</a></dir>' . PHP_EOL;
} elseif ($df=='file' && file_exists($_SESSION['backtodir'] . DIRECTORY_SEPARATOR . mb_strtolower($_POST['newname']))) {
echo '<dir>Ошибка переименования файла<br/>Файл с таким именем уже существует<br/><a href="' . $pg . '?act=' . $dir . '&amp;mode=rename' . $rnd . '">повторить</a></dir>' . PHP_EOL;
} elseif ($df=='dir' && is_dir($_SESSION['backtodir'] . DIRECTORY_SEPARATOR . mb_strtolower($_POST['newname']))) {
echo '<dir>Ошибка переименования директории<br/>Директория с таким именем уже существует<br/><a href="' . $pg . '?act=' . $dir . '&amp;mode=rename' . $rnd . '">повторить</a></dir>' . PHP_EOL;    
} else {
$act = rename($dir, $_SESSION['backtodir'] . DIRECTORY_SEPARATOR . mb_strtolower($_POST['newname']));
if ($act) {    
echo '<div>' . end(explode(DIRECTORY_SEPARATOR, $dir)) . ' успешно переименованно в ' . mb_strtolower($_POST['newname']) . '</div>';
} else {
echo '<dir>Ошибка переименования<br/><a href="' . $pg . '?act=' . $dir . '&amp;mode=rename' . $rnd . '">повторить</a></dir>' . PHP_EOL;   
}
}
} else {
echo '<div><form action="' . $pg . '?act=' . $dir . '&amp;mode=rename" method="post">' . PHP_EOL;
echo '<fieldset><legend>Переименовать</legend><br/>' . PHP_EOL;
echo '<input type="text" name="newname" value="' . end(explode(DIRECTORY_SEPARATOR, $dir)) . '" size="10" maxlength="32" /><br/>' . PHP_EOL;
echo '<input type="submit" name="submit" value="Переименовать" /></fieldset></form></div>' . PHP_EOL;
}
echo '<div class="phdr"><a href="' . $pg2 . '?act=' . $_SESSION['backtodir'] . '">Назад</a></div>';
break;

case 'move';
if (isset($_GET['dirto'])) {
$dirto = $_GET['dirto'];
if (mb_strlen($dirto)<mb_strlen(realpath($rootpath))) {
$dirto = realpath($rootpath);
}
$act = kfmmove($dir, $dirto);
if ($act) {
echo '<div>Перемещение из ' . end(explode(DIRECTORY_SEPARATOR, $_SESSION['backtodir'])) . ' в ' . end(explode(DIRECTORY_SEPARATOR, $_GET['dirto'])) . ' выполнено</div>' . PHP_EOL;    
} else {
echo '<div>Ошибка перемещения<br/><a href="' . $pg . '?act=' . $dir . '&amp;mode=move' . $rnd . '">повторить</a></div>' . PHP_EOL;
}
} else {
$dirlist = isset($_GET['listdirs']) ? $_GET['listdirs'] : 'root';
if (mb_strlen($dirlist)<mb_strlen(realpath($rootpath))) {
$dirlist = 'root';
}
$back = explode(DIRECTORY_SEPARATOR, $dirlist);
unset($back[sizeof($back)-1]);
$back = implode(DIRECTORY_SEPARATOR, $back);
if ($dirlist) {
if (isset($_GET['createnewdir'])) {
$newdir = 'new_dir_' . date('d-m-Y_H-i-s', time());
if (mkdir($dirlist . DIRECTORY_SEPARATOR . $newdir, 0777, TRUE)) {
echo '<div>Директория создана</div>';        
} else {
echo '<div>Произошла ошибка при создании новой директории</div>';
}
}    
echo '<div><a href="' . $pg . '?act=' . $dir . '&amp;mode=move&amp;listdirs=' . $dirlist . '&amp;createnewdir">Создать новую директорию</a></div>';    
echo '<div><a href="' . $pg . '?act=' . $dir . '&amp;mode=move&amp;dirto=' . $dirlist . '">Выбрать текущую</a></div>';
}
listdirs($pg . '?act=' . $dir . '&amp;mode=move&amp;listdirs', $dirlist);
}
echo '<div class="phdr"><a href="' . $pg2 . '?act=' . $_SESSION['backtodir'] . '">Назад</a></div>';
break;

case 'copy';
if (isset($_GET['dirto'])) {
$dirto = $_GET['dirto'];
if (mb_strlen($dirto)<mb_strlen(realpath($rootpath))) {
$dirto = realpath($rootpath);
}
kfmcopy($dir, $dirto);
echo '<div>Копирование ' . end(explode(DIRECTORY_SEPARATOR, $dir)) . ' в ' . end(explode(DIRECTORY_SEPARATOR, $_GET['dirto'])) . ' выполнено</div>' . PHP_EOL;    
} else {
$dirlist = isset($_GET['listdirs']) ? $_GET['listdirs'] : 'root';
if (mb_strlen($dirlist)<mb_strlen(realpath($rootpath))) {
$dirlist = 'root';
}
$back = explode(DIRECTORY_SEPARATOR, $dirlist);
unset($back[sizeof($back)-1]);
$back = implode(DIRECTORY_SEPARATOR, $back);
if ($dirlist) {
if (isset($_GET['createnewdir'])) {
$newdir = 'new_dir_' . date('d-m-Y_H-i-s', time());
if (mkdir($dirlist . DIRECTORY_SEPARATOR . $newdir, 0777, TRUE)) {
echo '<div>Директория создана</div>';        
} else {
echo '<div>Произошла ошибка при создании новой директории</div>';
}
}    
echo '<div><a href="' . $pg . '?act=' . $dir . '&amp;mode=copy&amp;listdirs=' . $dirlist . '&amp;createnewdir">Создать новую директорию</a></div>';    
echo '<div><a href="' . $pg . '?act=' . $dir . '&amp;mode=copy&amp;dirto=' . $dirlist . '">Выбрать текущую</a></div>';
}
listdirs($pg . '?act=' . $dir . '&amp;mode=copy&amp;listdirs', $dirlist);
}
echo '<div class="phdr"><a href="' . $pg2 . '?act=' . $_SESSION['backtodir'] . '">Назад</a></div>';
break;    

default:
echo '<div class="phdr">Меню действий</div>';
echo '<p>';
if (is_file($dir)) {
echo '<a href="' . $pg . '?act=' . $dir . '&amp;mode=download">Скачать</a><br/>';
echo '<a href="editor.php?act=' . $dir . '">Редактор</a><br/>';
echo (end(explode('.', $dir))=='zip') ? '<a href="' . $pg . '?act=' . $dir . '&amp;mode=unpack">Извлечь архив</a><br/>' : '';
echo (end(explode('.', $dir))=='zip') ? '<a href="imgedit.php?act=' . $dir . '">Редактор картинок</a><br/>' : '';
}
echo (end(explode('.', $dir))!='zip') ? '<a href="' . $pg . '?act=' . $dir . '&amp;mode=arch">Архивировать</a><br/>' : '';
echo '<a href="' . $pg . '?act=' . $dir . '&amp;mode=rename">Переименовать</a><br/>';
echo '<a href="' . $pg . '?act=' . $dir . '&amp;mode=delete">Удалить</a><br/>';
echo '<a href="' . $pg . '?act=' . $dir . '&amp;mode=move">Переместить</a><br/>';
echo '<a href="' . $pg . '?act=' . $dir . '&amp;mode=copy">Копировать</a><br/>';
echo '<a href="' . $pg . '?act=' . $dir . '&amp;mode=chmod">Изменить права доступа</a></p>';
#echo '<a href="' . $pg . '?act=' . $dir . '&amp;mode=copy">Копировать</a></p>';
echo '<div class="phdr"><a href="kfm.php">Назад</a></div>';
break;    
}

require_once($rootpath . 'incfiles/end.php');  
  
?>
