<?php
error_reporting(0);

session_start();
if(!isset($_SESSION['admin_stat']))exit('access denied');


include_once 'scades_stat_viewer.php';
$Stat = new Scades_stat_viewer();

$tod = date('j', S_NOW);
$tom = date('n', S_NOW);
$toy = date('Y', S_NOW);

$from = '';
if(isset($_GET['from']))
{
$from = $_GET['from'];

    $arr = explode('.', $_GET['from']);
    if(count($arr)==3)
    {
    $d = $arr[0];
    $m = $arr[1];
    $y = $arr[2];
    }
}

$to = '';
if(isset($_GET['to']))
{
$to = $_GET['to'];
    $arr = explode('.', $_GET['to']);
    if(count($arr)==3)
    {
    $to_d = $arr[0];
    $to_m = $arr[1];
    $to_y = $arr[2];
    }
}

if(empty($d))$d = $tod;
if(empty($m))$m = $tom;
if(empty($y))$y = $toy;

if(empty($to_d))$to_d = $tod;
if(empty($to_m))$to_m = $tom;
if(empty($to_y))$to_y = $toy;

$start_time = mktime(0, 0, 0, $m, $d, $y);
$end_time = mktime(0, 0, 0, $to_m, $to_d, $to_y) + 3600*24;
$time_len = $end_time - $start_time;
$steps = 20;
$d = ceil($time_len / $steps);



$hosts = Array();
$hits = Array();

for($i = 0; $i < $steps; $i++)
{
$start = $start_time + $d * $i;
$end = $start_time + $d * ($i + 1);
$hosts[$i] = $Stat -> hosts($start, $end);
$hits[$i] = $Stat -> get_hits($start, $end);
$time_arr[$i] = $start;
}

$max_hosts = max($hosts);
$max_hits = max($hits);

$padding = 50;

$im = imagecreatefrompng('img/graph.png'); 

$h = imagesy($im);
$w = imagesx($im);

/*
//y
$x1 = $padding;
$y1 = $padding;
$x2 = $padding;
$y2 = $h-$padding + $padding / 2;
imageline ($im , $x1 , $y1 , $x2 , $y2 , $color );

//x
$x1 = $padding - $padding / 2;
$y1 = $h-$padding;
$x2 = $w-$padding;
$y2 = $h-$padding;
imageline ($im , $x1 , $y1 , $x2 , $y2 , $color );
*/

$color_nums = ImageColorAllocate($im, 0,0,0);

$color_hosts = ImageColorAllocate($im,49,183,33);
$color_hits = ImageColorAllocate($im,111,183,206);

$hosts_col = ImageColorAllocate($im,33,46,203);
$hits_col = ImageColorAllocate($im,183,39,103);


imagesetthickness ($im , 2);

$dx = ($w - 2 * $padding)/$steps;

$dy_hosts = ($h - 2 * $padding)/$max_hits;
$dy_hits = ($h - 2 * $padding)/$max_hits;


for($i = 0; $i < $steps-1; $i++)
{
$x1 = $padding + floor($dx * $i);
$y1 = $h - $padding - floor($hosts[$i] * $dy_hosts);
$x2 = floor($x1 + $dx);
$y2 = $h - $padding - floor($hosts[$i+1] * $dy_hosts);
imageline ($im , $x1 , $y1 , $x2 , $y2 , $color_hosts );
ImageString($im, 2, $x1 , $y1+7, $hosts[$i]+'', $hosts_col );

$x1 = 3 + $padding + floor($dx * $i);
$y1 = $h - $padding - floor($hits[$i] * $dy_hits);
$x2 =  floor($x1 + $dx);
$y2 = $h - $padding - floor($hits[$i+1] * $dy_hits);
imageline ($im , $x1 , $y1 , $x2 , $y2 , $color_hits );
ImageString($im, 2, $x1 , $y1-20, $hits[$i]+'', $hits_col );

ImageString($im, 1, $x1 , $h - $padding / 2 , date('H:i', $time_arr[$i]), $color_nums );
ImageString($im, 1, $x1 , $h - $padding / 2+10 , date('d.m', $time_arr[$i]), $color_nums );
}



$font = 'inc/arial.ttf';
imagettftext($im, 10, 0, 10, 20, $hosts_col, $font, 'Хосты');
imageline ($im, 60, 15, 90, 15, $color_hosts );
imagettftext($im, 10, 0, 10, 40, $hits_col, $font, 'Хиты');
imageline ($im, 60, 35, 90, 35, $color_hits );



Header('Content-type: image/png');
ImagePng($im);  
ImageDestroy($im);
?>