<?php
/**
 * Клас для работы с изображениями
 * Автор:  lugaro
 * E-mail: lugaro@bk.ru
 * ICQ:    2000882
 * Site:   wapnew.ru
 * Версия: 1
 * Дата:   12.03.2010 9:20 :-)
 */
class img {
    public $width;
    public $height;
    public $newwidth = 0;
    public $newheight = 0;
    public $mime;
    public $img;
    public $newimg;
    function __construct($img)
    {
        $this->img_down($img);
    }

    /* * * * * * * * * * * * * * * *
	* Функция загрузки изображеня
	* $img - путь к файлу
	* * * * * * * * * * * * * * * */
	public function img_down($img)
    {
        $info = getimagesize($img);
        switch ($info['mime']) {
            case'image/wbmp':
                $this->img = imagecreatefromWBMP($img);
                break;
            case'image/xbm':
                $this->img = imagecreatefromXBM($img);
                break;
            case'image/xpm':
                $this->img = imagecreatefromXPM($img);
                break;
            case'image/jpeg':
                $this->img = imagecreatefromJPEG($img);
                break;
            case'image/gif':
                $this->img = imagecreatefromGIF($img);
                break;
            case'image/png':
                $this->img = imagecreatefromPNG($img);
                break;
            default:
                $this->img = false;
                break;
        }
        $this->width = $info[0];
        $this->height = $info[1];
        $this->mime = $info['mime'];
    }
    /* * * * * * * * * * * * * * * *
	* Функция коректной смены размера изображения
	* $width - ширена изображения
	* $height - высота если не указывать изображение будет менять размер с пропорциями
	* * * * * * * * * * * * * * * */
	public function resize($width, $height = 0)
    {
    	if($height){
			$this->newwidth = $width;
			$this->newheight = $height;
    	}else{
        	$x_ratio = $width / $this->width;
        	$y_ratio = $width / $this->height;
        	if (($this->width <= $width) && ($this->height <= $width)) {
        	    $this->newwidth = $this->width;
        	    $this->newheight = $this->height;
        	    //$this->newheight = ceil(($width/100)*((100/$this->width) * $this->height));
        	} else if (($x_ratio * $this->height) < $width) {
        	    $this->newheight = ceil($x_ratio * $this->height);
        	    $this->newwidth = $width;
        	} else {
        	    $this->newwidth = ceil($y_ratio * $this->width);
        	    $this->newheight = $width;
        	}
        }
        //echo $this->newwidth.'/'.$this->newheight; exit;
        $this->newimg = imagecreatetruecolor($this->newwidth, $this->newheight);
        imagecopyresampled($this->newimg, $this->img, 0, 0, 0, 0, $this->newwidth, $this->newheight, $this->width, $this->height);
    }
    /* * * * * * * * * * * * * * * *
	* Сохранение изображения
	* $img   - Зугруженая картинка
	* $patch - Имя я путь куда сохранить изображение
	* $type  - В каком формате сохранить
	* $compres  - Сжатие, от 0 до 100 (для jpeg)
	* * * * * * * * * * * * * * * */
	public function save($patch, $type = 'jpg', $compres = 75)
    {
        if ($type == 'gif') imagegif($this->newimg, $patch);
        if ($type == 'jpg' || $type == 'jpeg') imagejpeg($this->newimg, $patch, $compres);
        if ($type == 'png') imagepng($this->newimg, $patch);
        @chmod($patch, 0666);
    }
    /* * * * * * * * * * * * * * * *
	* Вывод изображения
	* $type  - В каком формате выводить gif, jpg или png (по умолчанию jpg)
	* $compres  - Сжатие, от 0 до 100 (для jpeg)
	* * * * * * * * * * * * * * * */
	public function print_img($type = 'jpg', $compres = 75)
    {

        if ($type == 'gif'){
        	header("content-type: image/png");
        	imagegif($this->newimg);
        }elseif($type == 'jpg' || $type == 'jpeg'){
        	header("content-type: image/jpeg");
        	imagejpeg($this->newimg, '', $compres);
        }elseif($type == 'png'){
        	header("content-type: image/png");
        	imagepng($this->newimg);
        }
    }
	function __destruct()
    {
        //ImageDestroy($im);
    }
}
?>