<?php

// Begun Publisher Code
// Language: PHP 5
// Version: 20091229
// Copyright Begun, All rights reserved

/*
 *  1.  .       ,     .
 * : id ,   ().
 *        ( "a.example.ru" and "b.example.ru"),        
 *   init().         .
 */

BegunServerSideCode::init(246453858);

?>
<?php

/*
 *  2.     -      init!
 * : id ,     .
 *   -    .
 */

echo BegunServerSideCode::getBlock(246454114, 1);

?>
<?php

/*
 *  3.     .
 *  !      .
 *         require_once.
 */

class BegunServerSideCode {
    const VERSION = '20091229'; 
    const TIMEOUT = 1;  
    static private $instance = null;
    private $padId = 0;
    private $xBanners = array();
    private $begunUri = 'http://mobile.begun.ru/context.jsp?json=1&pid=19';

    static public function init($_padId, $_domain = '') {
        if (is_null(self::$instance)) {
            self::$instance = new BegunServerSideCode($_padId, $_domain);
        }
    }

    static public function getBlock($_blockId, $_timeout = 0) {
        if (is_null(self::$instance)) {
            return '';
        }
        return self::$instance->_getBlock($_blockId, $_timeout);
    }        

    private function __construct($_padId, $_domain) {
        $serverVars = array('SERVER_NAME', 'REMOTE_ADDR', 'REQUEST_URI');
        foreach ($serverVars as $varName) {
            if (!isset($_SERVER[$varName])) {
                $_SERVER[$varName] = null;
            }
        }
        $this->padId = (int) $_padId;
        if (empty($_domain)) {
            $_domain = $_SERVER['SERVER_NAME'];
        }
        if (isset($_COOKIE['BEGUN_ANKET_ID'])) {
            $uuid = $_COOKIE['BEGUN_ANKET_ID'];
        } else {
            $uuid = sprintf('%08x%08x%08x', $this->padId, time(), mt_rand(0, 2147483647));
        }
        setcookie('BEGUN_ANKET_ID', $uuid, time()+365*86400, '/', $_domain);

        $this->appendParam($this->begunUri, 'pad_id', $this->padId);
        $this->appendParam($this->begunUri, 'anket_id', $uuid);
        $this->appendParam($this->begunUri, 'ip', $_SERVER['REMOTE_ADDR']);
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http'; 
        $this->appendParam($this->begunUri, 'real_refer', $protocol . '://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']);
        if (isset($_SERVER['HTTP_REFERER'])) {
            $this->appendParam($this->begunUri, 'ref', $_SERVER['HTTP_REFERER']);
        }
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $this->appendParam($this->begunUri, 'xip', $_SERVER['HTTP_X_FORWARDED_FOR']);
        }
        $ua = array();
        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $ua[] = $_SERVER['HTTP_USER_AGENT'];
        }
        if (isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])) {
            $ua[] = $_SERVER['HTTP_X_OPERAMINI_PHONE_UA'];
        }
        if (isset($_SERVER['HTTP_X_OPERAMINI_PHONE'])) {
            $ua[] = $_SERVER['HTTP_X_OPERAMINI_PHONE'];
        }
        if ($ua) {
            $this->appendParam($this->begunUri, 'ua', join(' ', $ua));
        }
        $this->appendParam($this->begunUri, 'codeVersion', self::VERSION); 
    }

    private function _getBlock($_blockId, $_timeout) {
        if (0 >= $_timeout) {
            $_timeout = self::TIMEOUT;
        }
        $begunUri = $this->begunUri;
        $this->appendParam($begunUri, 'block_id', $_blockId);
        $this->appendParam($begunUri, 'banner_filter', implode(',', $this->xBanners));

        $ctx = stream_context_create(array('http' => array('timeout' => $_timeout)));
        if (!$fp = fopen($begunUri, 'r', false, $ctx)) {
            return '';
        }    
        $metadata = stream_get_meta_data($fp);
        $content = '';
        while (!feof($fp)) {
            $content .= fread($fp, 8192);
        }        
        fclose($fp);

        $xBanners = '';
        if (isset($metadata['wrapper_data'])) {
            $source = $metadata['wrapper_data'];
            if (isset($source['headers']) && is_array($source['headers'])) {
                $source = $source['headers'];
            }
            foreach($source AS $h) {
                if (!is_string($h)) {
                    continue;
                }
                if (preg_match("/^X\-Banners:\s+((\d+,?)+)/i", $h, $ar)) {
                    $xBanners = $ar[1];
                    break;
                }
            }
        }
        if (!empty($xBanners)) {
            $this->xBanners = array_unique(array_merge($this->xBanners, explode(',', $xBanners)));
        }
        return $content;    
    }

    private function appendParam(&$queryString, $key, $val) {
        if (!empty($val)) {
            $queryString .= '&' . urlencode($key) . '=' . urlencode($val);
        }
    }
}

?>