﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 8.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 8. ЗАПРАШИВАНИЕ НЕСКОЛЬКИХ ТАБЛИЦ<br>\n";
echo "ТАК ЖЕ, КАК ОДНОЙ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>До этого каждый запрос, который мы рассматривали, основывался на одиночной таблице. В этой главе вы узн&#x0301;аете, как сделать запрос любого числа таблиц с \n";
echo "помощью одной команды. Это чрезвычайно мощное средство, потому что оно не только объединяет вывод из многочисленных таблиц, но и определяет связи между \n";
echo "ними. Вы обучитесь различным формам, использующим эти связи, а также их \n";
echo "настройке и использованию, чтобы удовлетворять возможным специальным требованиям.<a name=\"8.1\"></a></p>\n";
echo "<h3>ОБЪЕДИНЕНИЕ ТАБЛИЦ</h3>\n";
echo "<p>Одна из наиболее важных особенностей запросов SQL -  их способность определять связи между многочисленными таблицами и выводить информацию из них, в \n";
echo "терминах этих связей, всю внутри одной команды. Этот вид операции называется  объединением, которое является одним из видов операций в реляционных базах \n";
echo "данных. Как установлено в <a href=\"ch1.php\">Главе 1</a>, главное в реляционном подходе это связи, которые можно создавать между позициями данных в \n";
echo "таблицах. Используя объединения, мы непосредственно связываем информацию с любым числом таблиц и таким образом способны создавать связи между сравнимыми \n";
echo "фрагментами данных. При объединении, таблицы, представленные списком в предложении FROM, отделяются запятыми. Предикат запроса может ссылаться \n";
echo "к любому столбцу любой связанной таблицы и, следовательно, может использоваться для связи между ими. Обычно предикат сравнивает значения в столбцах различных \n";
echo "таблиц, чтобы определить, удовлетворяет ли WHERE установленному условию.<a name=\"8.2\"></a></p>\n";
echo "<h3>ИМЕНА ТАБЛИЦ И СТОЛБЦОВ</h3>\n";
echo "<p>Полное имя столбца таблицы фактически состоит из имени таблицы, сопровождаемого точкой, \n";
echo "и затем имени столбца. Вот несколько примеров имён:</p>\n";
echo "<pre>                  Salespeople.snum\n";
echo "\n";
echo "                  Salespeople.city\n";
echo "\n";
echo "                  Orders.odate</pre>\n";
echo "<p>До этого вы могли опускать имена таблиц, потому что вы запрашивали единовременно только одну таблицу, а SQL достаточно интеллектуален, чтобы присвоить \n";
echo "соответствующий префикс имени таблицы. Даже когда вы делаете запрос нескольких таблиц, вы ещё можете опускать имена таблиц, если все их столбцы \n";
echo "имеют различные имена. Но так бывает не всегда. Например, мы имеем две типовые таблицы со столбцами, называемыми city.</p>\n";
echo "<p>Если мы должны связать эти столбцы (кратковременно), мы  должны будем указать их с именами Salespeople.city или Customers.city, чтобы SQL мог их различать.<a name=\"8.3\"></a></p>\n";
echo "<h3>СОЗДАНИЕ ОБЪЕДИНЕНИЯ</h3>\n";
echo "<p>Предположим, что вы хотите поставить в соответствие вашему продавцу ваших заказчиков в городе, в котором они живут, поэтому вы увидите все комбинации \n";
echo "продавцов и заказчиков для этого города. Вы  должны будете брать каждого продавца и искать в таблице Заказчиков всех заказчиков того же самого города. Вы могли бы сделать это, введя следующую команду (вывод показан на Рисунке 8.1):</p>\n";
echo "<pre>          SELECT Customers.cname, Salespeople.sname,\n";
echo "           Salespeople.city\n";
echo "             FROM Salespeople, Customers\n";
echo "             WHERE Salespeople.city = Customers.city;\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              | SELECT Customers.cname, Salespeople.sname,    |\n";
echo "              | Salespeople.city                              |\n";
echo "              | FROM  Salespeople, Customers                  |\n";
echo "              | WHERE Salespeople.city = Customers.city       |\n";
echo "              | ============================================= |\n";
echo "              |   cname       cname            city           |\n";
echo "              |  -------     --------          ----           |\n";
echo "              |  Hoffman     Peel              London         |\n";
echo "              |  Hoffman     Peel              London         |\n";
echo "              |  Liu         Serres            San Jose       |\n";
echo "              |  Cisneros    Serres            San Jose       |\n";
echo "              |  Hoffman     Motika            London         |\n";
echo "              |  Clemens     Motika            London         |\n";
echo "                =============================================\n";
echo "\n";
echo "		     Рисунок 8.1 Объединение двух таблиц</pre>\n";
echo "<p>Так как это city имеется и в таблице Продавцов, и таблице Заказчиков, имена таблиц должны использоваться как префиксы. Хотя это необходимо, только \n";
echo "когда два или более полей имеют одно и то же имя, в любом случае это хорошая идея: включать имя таблицы в объединение для лучшего понимания и непротиворечивости. \n";
echo "Несмотря на это, мы будем в наших примерах далее использовать имена таблиц только тогда, когда необходимо, так что будет ясно, когда они необходимы, а когда нет.</p>\n";
echo "<p>Что SQL в основном делает в объединении, так это исследует каждую комбинацию строк двух или более возможных таблиц и проверяет эти комбинации по их \n";
echo "предикатам. В предыдущем примере требовалась строка продавца Peel из таблицы Продавцов и объединение её с каждой строкой таблицы Пользователей, по одной в \n";
echo "каждый момент времени.</p><p>Если комбинация производит значение, которое делает предикат верным, и если \n";
echo "поле city из строк таблиц Заказчика равно London, то Peel - это то запрашиваемое значение, которое комбинация выберет для вывода. То же самое будет затем \n";
echo "выполнено для каждого продавца в таблице Продавцов (у некоторых из которых не было никаких заказчиков в этих городах).<a name=\"8.4\"></a></p>\n";
echo "<h3>ОБЪЕДИНЕНИЕ ТАБЛИЦ ЧЕРЕЗ СПРАВОЧНУЮ ЦЕЛОСТНОСТЬ</h3>\n";
echo "<p>Эта особенность часто используется просто для эксплуатации связей, встроенных в БД. В предыдущем примере мы установили связь между двумя таблицами в \n";
echo "объединении. Это прекрасно. Но эти таблицы уже были соединены через snum-поле. Эта связь называется состоянием справочной целостности, как мы уже говорили в \n";
echo "Главе 1. Используя объединение, можно извлекать данные в терминах этой связи.</p>\n";
echo "<p>Например, чтобы показать имена всех заказчиков, соответствующих продавцам, которые их обслуживают, мы будем использовать такой запрос:</p>\n";
echo "<pre>             SELECT Customers.cname, Salespeople.sname\n";
echo "                FROM Customers, Salespeople\n";
echo "                WHERE Salespeople.snum = Customers.snum;</pre>\n";
echo "<p>Вывод этого запроса показан на Рисунке 8.2.</p>\n";
echo "<p>Это пример объединения, в котором столбцы используются для определения предиката запроса, и в этом случае snum-столбцы из обеих таблиц удалены из \n";
echo "вывода. И это прекрасно. Вывод показывает, какие заказчики каким продавцом обслуживаются; значения поля snum, которые устанавливают связь, отсутствуют. \n";
echo "Однако, если вы введёте их в вывод, то вы должны или удостовериться, что вывод понятен сам по себе, или \n";
echo "должны обеспечить комментарий  данных при выводе.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              | SELECT Customers.cname, Salespeople.sname,    |\n";
echo "              | FROM  Salespeople, Customers                  |\n";
echo "              | WHERE Salespeople.snum = Customers.snum       |\n";
echo "              | ============================================= |\n";
echo "              |   cname       sname                           |\n";
echo "              |  -------     --------                         |\n";
echo "              |  Hoffman     Peel                             |\n";
echo "              |  Giovanni    Axelrod                          |\n";
echo "              |  Liu         Serres                           |\n";
echo "              |  Grass       Serres                           |\n";
echo "              |  Clemens     Peel                             |\n";
echo "              |  Cisneros    Rifkin                           |\n";
echo "              |  Pereira     Motika                           |\n";
echo "                =============================================\n";
echo "\n";
echo "	      Рисунок 8.2 Объединение продавцов с их заказчикам</pre>\n";
echo "<a name=\"8.5\"></a>\n";
echo "<h3>ОБЪЕДИНЕНИЕ ТАБЛИЦ ПО РАВЕНСТВУ ЗНАЧЕНИЙ<br>\n";
echo "В СТОЛБЦАХ И ДРУГИЕ ВИДЫ ОБЪЕДИНЕНИЙ</h3>\n";
echo "<p>Объединения, которые используют предикаты, основанные на равенствах, называются объединениями по равенству. Все наши примеры в этой главе до настоящего \n";
echo "времени относились именно к этой категории, потому что все условия в предложениях WHERE \n";
echo "базировались на математических выражениях, использующих знак равенства (=). Строки 'city = 'London' и 'Salespeople.snum = Orders.snum ' - примеры таких типов равенств, найденных в предикатах.</p>\n";
echo "<p>Объединения по равенству  это, вероятно, наиболее общий вид объединения, но имеются и другие. Вы можете использовать практически любую реляционную операцию в объединении. Здесь дан пример другого вида объединения (вывод показан на Рисунке 8.3):</p>\n";
echo "<pre>               SELECT sname, cname\n";
echo "                   FROM Salespeople, Customers\n";
echo "                   WHERE sname &lt; cname\n";
echo "                      AND rating &lt; 200;\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              | SELECT sname, cname                           |\n";
echo "              | FROM  Salespeople, Customers                  |\n";
echo "              | WHERE sname &lt; cname                           |\n";
echo "              | AND rating &lt; 200;                             |\n";
echo "              | ============================================= |\n";
echo "              |     sname       cname                         |\n";
echo "              |    --------    -------                        |\n";
echo "              |    Peel        Pereira                        |\n";
echo "              |    Motika      Pereira                        |\n";
echo "              |    Axelrod     Hoffman                        |\n";
echo "              |    Axelrod     Clemens                        |\n";
echo "              |    Axelrod     Pereira                        |\n";
echo "              |                                               |\n";
echo "                =============================================\n";
echo "\n";
echo "	     Рисунок 8.3 Объединение, основанное на неравенстве</pre>\n";
echo "<p>Эта команда не часто бывает полезна. Она воспроизводит все комбинации имени продавца и имени заказчика так, что первый предшествует последнему в алфавитном \n";
echo "порядке, а последний имеет оценку, меньше чем 200. Обычно вы не создаёте сложных связей, подобно этой, и по этой причине вы, вероятно, будете строить наиболее \n";
echo "общие объединения по равенству, но вы должны хорошо знать и другие возможности.</p>\n";
echo "<h3><a name=\"8.6\">О</a>БЪЕДИНЕНИЕ БОЛЕЕ ДВУХ ТАБЛИЦ</h3>\n";
echo "<p>Вы можете также создавать запросы, объединяющие более двух таблиц. Предположим, что мы хотим найти все заказы заказчиков, не находящихся в тех городах, где \n";
echo "находятся их продавцы. Для этого необходимо связать все три наши типовые таблицы (вывод показан на Рисунке 8.4):</p>\n";
echo "<pre>          SELECT onum, cname, Orders.cnum, Orders.snum\n";
echo "             FROM Salespeople, Customers, Orders\n";
echo "             WHERE Customers.city &lt; &gt; Salespeople.city\n";
echo "                AND Orders.cnum = Customers.cnum\n";
echo "                AND Orders.snum = Salespeople.snum;\n";
echo "\n";
echo "\n";
echo "            ===============  SQL Execution Log ==============\n";
echo "           |                                                 |\n";
echo "           | SELECT onum, cname, Orders.cnum, Orders.snum    |\n";
echo "           | FROM  Salespeople, Customers, Orders            |\n";
echo "           | WHERE Customers.city &lt; &gt; Salespeople.city       |\n";
echo "           | AND Orders.cnum = Customers.cnum                |\n";
echo "           | AND Orders.snum = Salespeople.snum;             |\n";
echo "           | =============================================== |\n";
echo "           |   onum    cname        cnum     snum            |\n";
echo "           |  ------  -------      -----    -----            |\n";
echo "           |   3001   Cisneros      2008     1007            |\n";
echo "           |   3002   Pereira       2007     1004            |\n";
echo "           |   3006   Cisneros      2008     1007            |\n";
echo "           |   3009   Giovanni      2002     1003            |\n";
echo "           |   3007   Grass         2004     1002            |\n";
echo "           |   3010   Grass         2004     1002            |\n";
echo "             ===============================================\n";
echo "\n";
echo "		 Рисунок 8.4 Объединение трёх таблиц</pre>\n";
echo "<p>Хотя эта команда выглядит скорее как комплексная, вы можете следовать за логикой, просто проверяя, что заказчики не размещены в тех городах, где \n";
echo "размещены их продавцы (совпадение двух snum полей), и что перечисленные заказы выполнены с помощью этих заказчиков (совпадение заказов с полями cnum и snum в таблице Заказов).<a name=\"8.7\"></a></p>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы больше не ограничиваетесь просмотром одной таблицы в каждый момент времени. Кроме того, вы можете делать сложные сравнения между любыми полями \n";
echo "любого количества таблиц и использовать полученные результаты, чтобы решать, какую информацию вы  хотели бы видеть. Фактически эта методика настолько полезна для \n";
echo "построения связей, что она часто используется для создания их внутри одиночной таблицы. Это будет правильным: вы сможете объединить таблицу с собой, а это \n";
echo "очень удобна вещь. Это будет темой <a href=\"ch9.php\">Главы 9</a>.<a name=\"8.8\"></a></p>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<ol><li><pre>Напишите запрос, который вывел бы список номеров заказов сопровождающихся\n";
echo "именем заказчика, который создавал эти заказы.</pre></li>\n";
echo "<li><pre>Напишите запрос, который выдавал бы имена продавца и заказчика для каждого заказа\n";
echo "после номера заказа.</pre></li>\n";
echo "<li><pre>Напишите запрос, который выводил бы всех заказчиков, обслуживаемых продавцом\n";
echo "с комиссионными выше 12%. Выведите имя заказчика, имя продавца и ставку\n";
echo "комиссионных продавца.</pre></li>\n";
echo "<li><pre>Напишите запрос, который вычислил бы сумму комиссионных продавца для каждого заказа\n";
echo "заказчика с оценкой выше 100.</pre></li></ol>\n";
echo "<pre>(См. ответы в <a href=\"a.php#8\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
