﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 5.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 5. ИСПОЛЬЗОВАНИЕ СПЕЦИАЛЬНЫХ ОПЕРАТОРОВ\n";
echo "В УСЛОВИЯХ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В дополнение к реляционным и булевым операциям, обсуждённым в\n";
echo "<a href=\"ch4.php\">Главе 4</a>, SQL использует специальные операторы: IN, BETWEEN, \n";
echo "LIKE и IS NULL.<br>\n";
echo "В этой главе вы узнаете, как их использовать и как реляционные \n";
echo "операторы позволяют создавать более сложные и мощные предикаты. Обсуждение \n";
echo "оператора IS NULL будет включать отсутствие данных и значение NULL, которое \n";
echo "указывает на то, что данные отсутствуют.<br>\n";
echo "Вы также узнаете о вариантах использования оператора, NOT применяющегося с этими операторами.</p>\n";
echo "<a name=\"5.1\"></a>\n";
echo "<h3>ОПЕРАТОР IN</h3>\n";
echo "<p>Оператор IN определяет набор значений, в который данное значение может или  может \n";
echo "не быть включено. В соответствии с нашей учебной базой данных, на которой вы \n";
echo "обучаетесь по настоящее время, если вы хотите найти всех продавцов, которые \n";
echo "находятся в Barcelona или в London, вы должны использовать следующий запрос (вывод \n";
echo "показан на Рисунке 5.1):</p>\n";
echo "<pre>      SELECT *\n";
echo "         FROM Salespeople\n";
echo "         WHERE city = 'Barcelona'\n";
echo "            OR city = 'London';</pre>\n";
echo "<p>Имеется и более простой способ получить ту же информацию:</p>\n";
echo "<pre>       SELECT *\n";
echo "          FROM Salespeople\n";
echo "          WHERE city IN ('Barcelona', 'London');</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 5.2.</p>\n";
echo "<p>Как  видите, IN определяет набор значений с помощью имён членов \n";
echo "набора, заключённых в круглые скобки и разделённых запятыми. Он затем проверяет \n";
echo "различные значения указанного поля, пытаясь найти совпадение со значениями из \n";
echo "набора. Если это случается, то предикат верен. Когда набор содержит числовые \n";
echo "значения, а не символы, одиночные кавычки опускаются. Давайте найдём всех \n";
echo "заказчиков, относящихся к продавцам, имеющих значения snum = 1001, 1007, и 1004. \n";
echo "Вывод для следующего запроса показан на Рисунке 5.3:</p>\n";
echo "<pre>     SELECT *\n";
echo "        FROM Customers\n";
echo "        WHERE snum IN (1001, 1007, 1004);\n";
echo "\n";
echo "\n";
echo "           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Salespeople                             |\n";
echo "          | WHERE city = 'Barcelona'                      |\n";
echo "          | OR city = 'London';                           |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname         city         comm   |\n";
echo "          | ------    ----------   -----------   -------  |\n";
echo "          |   1001      Peel         London        0.12   |\n";
echo "          |   1004      Motika       London        0.11   |\n";
echo "          |   1007      Rifkin       Barcelona     0.15   |\n";
echo "          |                                               |\n";
echo "           ===============================================\n";
echo "\n";
echo "	Рисунок 5.1 Нахождение продавцов в Барселоне и Лондоне\n";
echo "\n";
echo "\n";
echo "           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Salespeople                             |\n";
echo "          | WHERE city IN ('Barcelona', 'London';         |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname         city         comm   |\n";
echo "          | ------    ----------   -----------   -------  |\n";
echo "          |   1001      Peel         London        0.12   |\n";
echo "          |   1004      Motika       London        0.11   |\n";
echo "          |   1007      Rifkin       Barcelona     0.15   |\n";
echo "          |                                               |\n";
echo "           ===============================================\n";
echo "\n";
echo "		Рисунок 5.2 SELECT использует IN\n";
echo " \n";
echo "           ===============  SQL Execution Log ============\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Customers                               |\n";
echo "          | WHERE snum IN ( 1001, 1007, 1004 );           |\n";
echo "          | ============================================= |\n";
echo "          |   snum     cname    city     rating    snum   |\n";
echo "          |  ------   --------  ------    ----   ------   |\n";
echo "          |   2001     Hoffman  London     100     1001   |\n";
echo "          |   2006     Clemens  London     100     1001   |\n";
echo "          |   2008     Cisneros San Jose   300     1007   |\n";
echo "          |   2007     Pereira  Rome       100     1004   |\n";
echo "            =============================================\n";
echo "\n";
echo "	    Рисунок 5.3 SELECT использует IN с номерами</pre>\n";
echo "<a name=\"5.2\"></a>\n";
echo "<h3>ОПЕРАТОР BETWEEN</h3>\n";
echo "<p>Оператор BETWEEN похож на оператор IN. Но, в отличие от определения по числам из \n";
echo "набора, как это делает IN, BETWEEN определяет диапазон, значения которого должны \n";
echo "уменьшаться, что делает предикат верным. Вы должны ввести ключевое слово BETWEEN \n";
echo "с начальным значением, ключевое AND и конечное значение. В отличие от IN, \n";
echo "BETWEEN чувствителен к порядку, и первое значение в предложении должно быть \n";
echo "последним по алфавитному или числовому порядку. (Обратите внимание, что, в отличие \n";
echo "от английского языка, SQL не говорит, что &quot;значение находится (между) BETWEEN \n";
echo "значением и значением&quot;, а просто &quot;значение BETWEEN значение значение&quot;. Это \n";
echo "применимо и к оператору LIKE). Следующий пример будет извлекать из таблицы \n";
echo "Продавцов всех продавцов с комиссионными между .10 и .12 (вывод показан на \n";
echo "Рисунке 5.4):</p>\n";
echo "<pre>          SELECT *\n";
echo "             FROM Salespeople\n";
echo "             WHERE comm BETWEEN .10 AND .12;</pre>\n";
echo "<p>Для  оператора BETWEEN,  значение, совпадающее с любым из двух \n";
echo "значений границы (в данном случае это .10 и .12 ), заставляет предикат быть верным.</p>\n";
echo "<pre>           ===============  SQL Execution Log ============\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Salespeople                             |\n";
echo "          | WHERE comm BETWEEN .10 AND .12;               |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname         city         comm   |\n";
echo "          | ------    ----------   -----------   -------  |\n";
echo "          |   1001      Peel         London        0.12   |\n";
echo "          |   1004      Motika       London        0.11   |\n";
echo "          |   1003      Axelrod      New York      0.10   |\n";
echo "	   ===============================================\n";
echo "\n";
echo "		  Рисунок 5.4 SELECT с BETWEEN</pre>\n";
echo "<p>SQL не делает непосредственной поддержки невключения граничных значений BETWEEN. Вы должны или \n";
echo "определить ваши граничные значения так, чтобы включающая интерпретация была \n";
echo "приемлема, или сделать что-нибудь типа этого:</p>\n";
echo "<pre>      SELECT *\n";
echo "          FROM Salespeople\n";
echo "          WHERE (comm BETWEEN .10, AND .12)\n";
echo "            AND NOT comm IN (.10, .12);</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 5.5.</p>\n";
echo "<p>По общему признанию, это немного неуклюже, но зато показывает, как эти новые \n";
echo "операторы могут комбинироваться с булевыми операциями, чтобы производить более \n";
echo "сложные предикаты.</p>\n";
echo "<p>В основном вы используете IN и BETWEEN так же, как вы \n";
echo "использовали реляционные операции при сравнении значений, которые берутся \n";
echo "либо из набора (для IN), либо из диапазона (для BETWEEN).</p>\n";
echo "<p>Также, подобно реляционным операциям, BETWEEN может работать с символьными \n";
echo "полями в терминах эквивалентов ASCII. Это означает, что вы можете использовать BETWEEN \n";
echo "для выборки ряда значений из упорядоченных по алфавиту значений.</p>\n";
echo "<pre>           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Salespeople                             |\n";
echo "          | WHERE (comm BETWEEN .10 AND .12)              |\n";
echo "          | AND NOT comm IN (.10 .12);                    |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname         city         comm   |\n";
echo "          | ------    ----------   -----------   -------  |\n";
echo "          |   1004      Motika       London        0.11   |\n";
echo "          |                                               |\n";
echo "           ===============================================\n";
echo "\n";
echo "	    Рисунок 5.5 Сделать BETWEEN с невключением</pre>\n";
echo "<p>Этот запрос выбирает всех заказчиков, чьи имена попали в определенный \n";
echo "алфавитный диапазон:</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Customers\n";
echo "               WHERE cname BETWEEN 'A' AND 'G';</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 5.6.</p>\n";
echo "<p>Обратите внимание, что Grass и Giovanni отсутствуют даже при включенном BETWEEN. Это происходит из-за того, что BETWEEN сравнивает строки неравной длины. \n";
echo "Строка 'G' короче, чем строка Giovanni, поэтому BETWEEN выводит 'G' с \n";
echo "пробелами. Пробелы предшествуют символам в алфавитном порядке (в большинстве \n";
echo "реализаций), поэтому Giovanni не выбирается. То же самое происходит и с Grass. \n";
echo "Важно помнить это, когда вы используете BETWEEN для извлечения значений из \n";
echo "алфавитных диапазонов. Обычно вы указываете диапазон с помощью символа начала \n";
echo "диапазона и символа конца (вместо которого можно просто поставить z).</p>\n";
echo "<pre>           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Customers                               |\n";
echo "          | WHERE cname BETWEEN 'A' AND 'G';              |\n";
echo "          | ============================================= |\n";
echo "          |   cnum     cname    city     rating    snum   |\n";
echo "          |  ------   --------  ------    ----   ------   |\n";
echo "          |   2006     Clemens  London     100     1001   |\n";
echo "          |   2008     Cisneros San Jose   300     1007   |\n";
echo "          |                                               |\n";
echo "            =============================================\n";
echo "\n";
echo "	Рисунок 5.6 Использование BETWEEN в алфавитных порядках</pre>\n";
echo "<a name=\"5.3\"></a>\n";
echo "<h3>ОПЕРАТОР LIKE</h3>\n";
echo "<p>LIKE применим только к полям типа CHAR или VARCHAR, с которыми он \n";
echo "используется для поиска подстрок. Т.е. он ищет поле символа, чтобы увидеть, \n";
echo "совпадает ли с условием часть его строки. В качестве условия он использует \n";
echo "групповые символы-шаблоны (wildсards) - специальные символы, которые могут соответствовать \n";
echo "чему-нибудь.</p>\n";
echo "<p>Имеются два типа шаблонов, используемых с LIKE:</p>\n";
echo "<ul>\n";
echo "  <li>символ подчёркивания ( _ ) замещает любой одиночный символ. Например, \n";
echo "  'b_t' будет соответствовать словам 'bat' или 'bit', но не будет \n";
echo "  соответствовать 'brat'.</li>\n";
echo "  <li>знак процента (%) замещает последовательность любого количества символов \n";
echo "  (включая символы нуля). Например '%p%t' будет соответствовать словам 'put', \n";
echo "  'posit', или 'opt, но не 'spite'.</li>\n";
echo "</ul>\n";
echo "<p>Давайте найдём всех заказчиков, чьи имена начинаются с G (вывод показан на \n";
echo "Рисунке 5.7):</p>\n";
echo "<pre>       SELECT\n";
echo "          FROM Customers\n";
echo "          WHERE cname LIKE 'G%';\n";
echo "\n";
echo "\n";
echo "           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Customers                               |\n";
echo "          | WHERE cname LIKE 'G';                         |\n";
echo "          | ============================================= |\n";
echo "          |   cnum     cname    city     rating    snum   |\n";
echo "          |  ------   --------  ------    ----   ------   |\n";
echo "          |   2002     Giovanni Rome       200     1003   |\n";
echo "          |   2004     Grass    Berlin     300     1002   |\n";
echo "          |                                               |\n";
echo "            =============================================\n";
echo "\n";
echo "		Рисунок 5.7 SELECT использует LIKE с %</pre>\n";
echo "<p>LIKE может быть удобен, если вы ищете имя или другое значение и если вы не \n";
echo "помните, как они точно пишутся. Предположим, что вы не уверены, как записано по \n";
echo "буквам имя одного из ваших продавцов - Peal или Peel. Вы можете просто использовать \n";
echo "ту часть, которую вы знаете, и групповые символы, чтобы находить все возможные \n";
echo "совпадения \n";
echo "(вывод этого запроса показан на Рисунке 5.8):</p>\n";
echo "<pre>       SELECT *\n";
echo "          FROM Salespeople\n";
echo "          WHERE sname LIKE 'P _ _ l %';</pre>\n";
echo "<p>Группа символов подчёркивания, каждый из которых представляет один символ, \n";
echo "добавит только два символа к уже существующим 'P' и 'l' , поэтому имя наподобие Prettel не может быть показано. Групповой символ ' % ' в конце строки \n";
echo "необходим в большинстве реализаций, если длина поля sname больше, чем число \n";
echo "символов в имени Peel (потому что некоторые другие значения sname длиннее, чем \n";
echo "четыре символа). В этом варианте значение поля sname, фактически сохраняемое \n";
echo "как имя Peel, сопровождается рядом пробелов. Следовательно, символ 'l' не будет \n";
echo "считаться концом строки. Групповой символ ' % '  просто соответствует \n";
echo "этим пробелам. Это не обязательно, если поле sname имеет тип VARCHAR.</p>\n";
echo "<pre>           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Salespeople                             |\n";
echo "          | WHERE sname LIKE 'P__l';                   |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname         city         comm   |\n";
echo "          | ------    ----------   -----------   -------  |\n";
echo "          |   1001      Peel         London        0.12   |\n";
echo "          |                                               |\n";
echo "           ===============================================\n";
echo "\n";
echo " 	Рисунок 5.8 SELECT использует LIKE с подчёркиванием (_)</pre>\n";
echo "<p>А что вы будете делать, если вам нужно искать символ процента или символ \n";
echo "подчёркивания в строке? В LIKE-предикате вы можете определить любой одиночный \n";
echo "символ как символ ESC. Символ ESC используется сразу перед процентом или \n";
echo "подчёркиванием в предикате и означает, что процент или подчёркивание будет \n";
echo "интерпретироваться как символ, а не как групповой символ-шаблон. Например, мы могли бы \n";
echo "найти наш sname-столбец, где присутствует подчёркивание, следующим образом:</p>\n";
echo "<pre>          SELECT *\n";
echo "             FROM Salespeople\n";
echo "             WHERE sname LIKE '%/_%' ESCAPE '/';</pre>\n";
echo "<p>С этими данными не будет никакого вывода, потому что мы не включили никакого \n";
echo "подчёркивания в имя нашего продавца. Ключевое слово ESCAPE определяет '/ ' как ESC-символ. ESC-символ, используемый в LIKE-строке, сопровождается знаком \n";
echo "процента, знаком подчёркивания или знаком ESCAPE, который будет искаться в \n";
echo "столбце, а не обрабатываться как шаблон.</p>\n";
echo "<p>Символ ESC должен быть одиночным символом и применяется только к одиночному \n";
echo "символу сразу после него.</p>\n";
echo "<p>В примере выше, символ процента начала и символ процента окончания \n";
echo "обрабатываются как групповые символы; только подчёркивание представлено как сам \n";
echo "символ.</p>\n";
echo "<p>Как упомянуто выше, символ ESC может также использоваться самостоятельно. \n";
echo "Другими словами, если вы будете искать столбец с  символом ESC, вы просто \n";
echo "вводите его дважды. Символ ESC &quot;берёт следующий символ буквально как \n";
echo "символ&quot; и, во-вторых, символ ESC самостоятелен.</p>\n";
echo "<p>Вот предыдущий пример, который пересмотрен, чтобы найти местонахождение \n";
echo "строки '_/' в sname-столбце:</p>\n";
echo "<pre>     SELECT *\n";
echo "        FROM Salespeople\n";
echo "        WHERE sname LIKE '%/_//%' ESCAPE'/';</pre>\n";
echo "<p>Снова не будет никакого вывода с такими данными. Строка сравнивается с \n";
echo "содержанием любой последовательности символов (%), сопровождаемых символом \n";
echo "подчёркивания ( /_ ), символом ESC ( // ) и любой последовательностью символов \n";
echo "в конце строки (%).</p>\n";
echo "<a name=\"5.4\"></a>\n";
echo "<h3>РАБОТА СО ЗНАЧЕНИЯМИ NULL</h3>\n";
echo "<p>Часто в таблице будут записи, которые не имеют никаких значений  поля, например, потому что информация не завершена, или потому что это \n";
echo "поле просто не заполнялось. SQL учитывает такой вариант, позволяя вам вводить \n";
echo "значение NULL (ПУСТОЙ) в поле, вместо значения. Когда значение поля равно NULL, \n";
echo "это означает, что программа базы данных специально промаркировала это поле как \n";
echo "не имеющее никакого значения для этой строки (записи).<br>\n";
echo "Это отличается от \n";
echo "просто назначения полю значения нуль или пробела, которые база данных будет \n";
echo "обрабатывать так же, как и любое другое значение. Точно так же как NULL не \n";
echo "является техническим значением, оно не имеет и типа данных. Оно может помещаться \n";
echo "в любой тип поля. Тем не менее, NULL в SQL часто упоминается как &quot;нуль&quot;.</p>\n";
echo "<p>Предположим, что вы получили нового заказчика, который ещё не был назначен \n";
echo "продавцу. Чем ждать продавца, к которому его нужно назначить, вы можете ввести \n";
echo "заказчика в базу данных теперь же, так что он не потеряется при перестановке. Вы можете ввести строку для заказчика со значением NULL в поле snum и \n";
echo "заполнить это поле значением позже, когда продавец будет назначен.</p>\n";
echo "<a name=\"5.5\"></a>\n";
echo "<h3>ОПЕРАТОР IS NULL</h3>\n";
echo "<p>Так как NULL указывает на отсутствие значения, вы не можете знать, каков будет \n";
echo "результат любого сравнения с использованием NULL. Когда NULL сравнивается с \n";
echo "любым значением, даже с другим таким же NULL, результат будет ни true, ни \n";
echo "false, он неизвестен/undefined. Неизвестный булев вообще ведёт себя так же, как \n";
echo "неверная строка, которая, произведя неизвестное значение в предикате, не будет \n";
echo "выбрана запросом. Имейте в виду, что, в то время как NOT (неверное) равняется \n";
echo "верно, NOT (неизвестное) равняется неизвестно.</p>\n";
echo "<p>Следовательно, выражение типа 'city = NULL' или 'city IN (NULL)' будет \n";
echo "неизвестно в любом случае.</p>\n";
echo "<p>Часто вы должны отличать неверно и неизвестно  между строками, \n";
echo "содержащими значения столбцов, которые не соответствуют условию предиката и \n";
echo "которые содержат NULL в столбцах. По этой причине SQL предоставляет специальный \n";
echo "оператор IS, который используется с ключевым словом NULL, для размещения \n";
echo "значения NULL.</p>\n";
echo "<p>Найдём все записи в нашей таблице Заказчиков с NULL-значениями в столбце city:</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Customers\n";
echo "               WHERE city IS NULL;</pre>\n";
echo "<p>Здесь не будет никакого вывода, потому что мы не имеем никаких значений NULL \n";
echo "в наших типовых таблицах. Значения NULL очень важны, и мы вернёмся к ним \n";
echo "позже.</p>\n";
echo "\n";
echo "<a name=\"5.6\"></a>\n";
echo "<h3>ИСПОЛЬЗОВАНИЕ NOT СО СПЕЦИАЛЬНЫМИ ОПЕРАТОРАМИ</h3>\n";
echo "<p>Операнды могут непосредственно предшествовать булеву NOT.</p>\n";
echo "<p>Это противоположно реляционным операциям, когда оператор NOT должен идти \n";
echo "перед \n";
echo "вводимым выражением. Например, если мы хотим устранить NULL из нашего вывода, мы \n";
echo "будем использовать NOT, чтобы изменить на противоположное значение предиката:</p>\n";
echo "<pre>          SELECT *\n";
echo "             FROM Customers\n";
echo "             WHERE city NOT NULL;</pre>\n";
echo "<p>При отсутствии значений NULL (как в нашем случае), будет выведена вся \n";
echo "таблица Заказчиков. Аналогично можно ввести следующее</p>\n";
echo "<pre>           SELECT *\n";
echo "              FROM Customers\n";
echo "              WHERE NOT city IS NULL;</pre>\n";
echo "<p>что также приемлемо. Мы можем также использовать NOT с IN:</p>\n";
echo "<pre>         SELECT *\n";
echo "            FROM Salespeople\n";
echo "            WHERE city NOT IN ('London', 'San Jose');</pre>\n";
echo "<p>А вот другой способ подобного же выражения:</p>\n";
echo "<pre>       SELECT *\n";
echo "          FROM Salespeople\n";
echo "          WHERE NOT city IN ('London', ' San Jose');</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 5.9.</p>\n";
echo "<p>Таким же способом вы можете использовать NOT BETWEEN и NOT LIKE.</p>\n";
echo "<pre>           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT *                                      |\n";
echo "          | FROM  Salespeople                             |\n";
echo "          | WHERE сity NOT IN ('London', 'San Jose';)     |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname         city         comm   |\n";
echo "          | ------    ----------   -----------   -------  |\n";
echo "          |   1003      Rifkin       Barcelona     0.15   |\n";
echo "          |   1007      Axelrod      New York      0.10   |\n";
echo "          |                                               |\n";
echo "           ===============================================\n";
echo "\n";
echo "		Рисунок 5.9 Использование NOT с IN</pre>\n";
echo "<a name=\"5.7\"></a>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы можете создавать предикаты в терминах связей, специально \n";
echo "определённых в SQL. Вы можете искать значения в определённом диапазоне (BETWEEN) \n";
echo "или в числовом наборе (IN), или вы можете искать символьные значения, которые \n";
echo "соответствуют тексту внутри параметров (LIKE).</p>\n";
echo "<p>Вы также изучили кое-что о том, как SQL поступает при \n";
echo "отсутствии данных (а это реально), используя NULL вместо \n";
echo "конкретных значений. Вы можете извлекать или исключать значения NULL из вашего \n";
echo "вывода, используя оператор IS NULL.</p>\n";
echo "<p>Теперь, когда вы имеете в вашем распоряжении \n";
echo "весь набор стандартных математических и специальных операторов/операций, вы можете \n";
echo "переходить к специальным функциям SQL, которые работают на всех группах значений, \n";
echo "а не просто на одиночном значении, что важно. Это уже тема </a>\n";
echo "<a href=\"ch6.php\">Главы 6</a>.</p>\n";
echo "<a name=\"5.8\"></a>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<ol>\n";
echo "  <li>\n";
echo "  <pre>Напишите два запроса, которые могли бы вывести все заказы на 3 или 4 октября 1990.</pre>\n";
echo "  </li>\n";
echo "  <li>\n";
echo "  <pre>Напишите запрос, который выберет всех заказчиков, обслуживаемых продавцами Peel или Motika.\n";
echo "(Подсказка: из наших типовых таблиц поле snum связывает вторую таблицу с первой.)</pre>\n";
echo "  </li>\n";
echo "  <li>\n";
echo "  <pre>Напишите запрос, который может вывести всех заказчиков, чьи имена начинаются с буквы,\n";
echo "попадающей в диапазон от A до G.</pre>\n";
echo "  </li>\n";
echo "  <li>\n";
echo "  <pre>Напишите запрос, который выберет всех пользователей, чьи имена начинаются с буквы C.</pre>\n";
echo "  </li>\n";
echo "  <li>\n";
echo "  <pre>Напишите запрос, который выберет все заказы, имеющие нулевые значения или\n";
echo "NULL в поле amt (сумма).</pre>\n";
echo "  </li></ol>\n";
echo "<pre>(См. ответы в<a href=\"a.php#5\"> Приложении A</a>.)</pre>\n";
echo "\n";
echo "</body></html>\n";
require_once ("../incfiles/end.php");  

?> 
