﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 3.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 3. ИСПОЛЬЗОВАНИЕ SQL ДЛЯ ИЗВЛЕЧЕНИЯ ИНФОРМАЦИИ ИЗ ТАБЛИЦ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе мы покажем вам, как извлекать информацию из таблиц. Вы узнаете, \n";
echo "как пропускать или переупорядочивать столбцы и как автоматически устранять \n";
echo "избыточность данных в вашем выводе. В заключение вы узнаете, как устанавливать \n";
echo "условие (проверку), которую вы можете использовать, чтобы определить, какие строки \n";
echo "таблицы используются в выводе. Эта последняя особенность будет далее описана в \n";
echo "более поздних главах и является одной из наиболее изящных и мощных в SQL.</p>\n";
echo "<a name=\"3.1\"></a>\n";
echo "<h3>СОЗДАНИЕ ЗАПРОСА</h3>\n";
echo "<p>Как мы говорили ранее, SQL это Структурированный Язык \n";
echo "Запросов. Запросы, вероятно, наиболее часто используемый аспект SQL. Фактически \n";
echo "маловероятно, для категории SQL-пользователей, чтобы этот \n";
echo "язык использовался для чего-то другого. По этой причине мы будем начинать наше обсуждение SQL \n";
echo "с обсуждения запроса и того, как он выполняется на этом языке.</p>\n";
echo "<h5>ЧТО ТАКОЕ ЗАПРОС?</h5>\n";
echo "<p>Запрос это команда, которую вы даёте вашей программе базы данных и которая \n";
echo "сообщает ей, что нужно вывести определённую информацию из таблиц в память. Эта \n";
echo "информация обычно посылается непосредственно на экран компьютера или терминала, \n";
echo "которым вы пользуетесь, хотя в большинстве случаев её можно также послать \n";
echo "на принтер, сохранить в файле (как объект в памяти компьютера) или предоставить \n";
echo "как вводную информацию для другой команды или процесса.</p>\n";
echo "<a name=\"3.2\"></a>\n";
echo "<h3>ГДЕ ПРИМЕНЯЮТСЯ ЗАПРОСЫ?</h3>\n";
echo "<p>Запросы обычно рассматриваются как часть языка DML. Однако, так как запрос не \n";
echo "меняет информацию в таблицах, а просто показывает её пользователю, мы будем \n";
echo "рассматривать запросы как самостоятельную категорию среди команд DML, которые \n";
echo "производят действия, а не просто показывают содержание базы данных (БД).</p>\n";
echo "<p>Любой запрос SQL имеет в своём составе одну команду. Структура этой команды \n";
echo "обманчиво проста, потому что вы можете расширять её так, чтобы выполнить  сложные оценки и обработку \n";
echo "данных. Эта команда называется SELECT (ВЫБРАТЬ).</p>\n";
echo "<a name=\"3.3\"></a>\n";
echo "<h3>КОМАНДА SELECT</h3>\n";
echo "<p>В самой простой форме команда SELECT просто инструктирует БД, чтобы \n";
echo "извлечь информацию из таблицы. Например, вы могли бы вывести таблицу Продавцов, \n";
echo "напечатав следующее:</p>\n";
echo "<pre>       SELECT snum, sname, city, comm\n";
echo "          FROM  Salespeople;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 3.1.</p>\n";
echo "<pre>           ===============  SQL Execution Log ============\n";
echo "          |                                               |\n";
echo "          | SELECT snum, sname, city, comm                |\n";
echo "          | FROM  Salespeople;                            |\n";
echo "          |                                               |\n";
echo "          | ==============================================|\n";
echo "          |   snum      sname        city          comm   |\n";
echo "          | ------    ----------   -----------   -------  |\n";
echo "          |   1001      Peel         London        0.12   |\n";
echo "          |   1002      Serres       San Jose      0.13   |\n";
echo "          |   1004      Motika       London        0.11   |\n";
echo "          |   1007      Rifkin       Barcelona     0.15   |\n";
echo "          |   1003      Axelrod      New York      0.10   |\n";
echo "           ===============================================\n";
echo "\n";
echo "		   Рисунок 3.1 Команда SELECT</pre>\n";
echo "<p>Другими словами, эта команда просто выводит все данные из таблицы. \n";
echo "Большинство программ будут также давать заголовки столбца, как выше, а некоторые \n";
echo "позволяют определить детальное форматирование вывода, но это уже вне стандартной \n";
echo "спецификации.</p>\n";
echo "<p>Вот объяснение каждой части этой команды:</p>\n";
echo "<dl>\n";
echo "<dt>SELECT</dt>\n";
echo "<dd>Ключевое слово, которое сообщает базе данных, что эта команда - запрос. Все запросы начинаются этим словом с последующим пробелом.</dd>\n";
echo "<dt>snum, sname</dt>\n";
echo "<dd>Это список столбцов из таблицы, которые выбираются запросом. Любые столбцы, не перечисленные здесь, не будут включены в вывод команды. Это, \n";
echo "конечно, не значит, что они будут удалены или их информация будет стёрта из \n";
echo "таблиц, ведь запрос не воздействует на информацию в таблицах; он только показывает данные.</dd>\n";
echo "<dt>FROM Salespeople</dt>\n";
echo "<dd>FROM - ключевое слово, подобное SELECT, которое должно быть представлено в каждом запросе. Оно сопровождается пробелом и  именем таблицы, \n";
echo "используемой в качестве источника информации. В данном случае это таблица Продавцов (Salespeople).</dd>\n";
echo "<dt>;</dt>\n";
echo "<dd>Точка с запятой используется во всех интерактивных командах SQL, чтобы сообщать базе данных, что команда записана и готова к выполнению. В некоторых \n";
echo "системах индикатором конца команды является обратный слэш (\) в строке.</dd></dl>\n";
echo "<p>Естественно, запрос такого характера не обязательно будет упорядочивать вывод любым указанным способом. Та же самая команда, выполненная с теми же самыми \n";
echo "данными, но в другое время, не сможет вывести тот же самый заказ. Обычно строки обнаруживаются в том порядке, в котором они найдены в таблице, поскольку, как мы \n";
echo "установили в предыдущей главе, этот порядок произволен. Это не обязательно будет тот порядок, в котором данные вводились или сохранялись. Вы можете упорядочивать \n";
echo "вывод непосредственно командами SQL с помощью специального предложения. Позже мы покажем, как это делается. А сейчас просто \n";
echo "запомните, что, в отсутствие \n";
echo "явного упорядочивания, в вашем выводе нет никакого определенного порядка.</p><p>\n";
echo "Использование возврата каретки (клавиша ENTER) является произвольным. Мы \n";
echo "должны точно установить, как удобнее составить запрос - в несколько строк или в одну строку \n";
echo "- следующим образом:</p>\n";
echo "<pre>      SELECT snum, sname, city, comm FROM Salespeople;</pre>\n";
echo "<p>С тех пор как SQL использует точку с запятой, чтобы указывать конец команды, \n";
echo "большинство программ SQL обрабатывают возврат каретки (через нажатие Возврат или клавиши ENTER ) как пробел. \n";
echo "Хорошая идея - использовать возвраты каретки и выравнивание, как мы делали  ранее, чтобы сделать ваши команды более лёгкими для чтения и более \n";
echo "понятными.</p>\n";
echo "<a name=\"3.4\"></a>\n";
echo "<h3>ВЫБИРАЙТЕ ВСЕГДА САМЫЙ ПРОСТОЙ СПОСОБ</h3>\n";
echo "<p>Если вы хотите видеть все столбцы таблицы, имеется необязательное сокращение, которое вы можете использовать. Звёздочка (*) может применяться для \n";
echo "вывода полного списка столбцов следующим образом:</p>\n";
echo "<pre>      SELECT *\n";
echo "      FROM Salespeople;</pre>\n";
echo "<p>Это приведет к тому же результату, что и наша предыдущая команда.</p>\n";
echo "<a name=\"3.5\"></a>\n";
echo "<h3>ОПИСАНИЕ SELECT</h3>\n";
echo "<p>В общем случае команда SELECT начинается с ключевого слова SELECT, сопровождаемого пробелом. После этого должен следовать список имён столбцов, \n";
echo "которые вы хотите видеть, отделяемых запятыми. Если вы хотите видеть все столбцы таблицы, вы можете заменить этот список звездочкой (*). Ключевое слово FROM, \n";
echo "следующее далее, сопровождается пробелом и именем таблицы, запрос к которой делается. В конце должна использоваться точка с запятой (;) для окончания запроса \n";
echo "и указания на то, что команда готова к выполнению.</p>\n";
echo "<a name=\"3.6\"></a>\n";
echo "<h3>ПРОСМОТР ТОЛЬКО ОПРЕДЕЛЕННЫХ СТОЛБЦОВ ТАБЛИЦЫ</h3>\n";
echo "<p>Команда SELECT способна извлечь строго определенную информацию из таблицы. Сначала мы можем предоставить возможность увидеть только опредёленные столбцы \n";
echo "таблицы. Это выполняется легко: простым исключением столбцов, которые вы не хотите видеть, из  команды SELECT. Например, запрос</p>\n";
echo "<pre>   SELECT sname, comm\n";
echo "      FROM Salespeople;</pre>\n";
echo "<p>будет производить вывод, показанный на Рисунке 3.2.</p>\n";
echo "<pre>         ===============  SQL Execution Log ============\n";
echo "        |                                               |\n";
echo "        | SELECT snum, comm                             |\n";
echo "        | FROM  Salespeople;                            |\n";
echo "        |                                               |\n";
echo "        | ==============================================|\n";
echo "        |        sname             comm                 |\n";
echo "        |   -------------      ---------                |\n";
echo "        |        Peel              0.12                 |\n";
echo "        |        Serres            0.13                 |\n";
echo "        |        Motika            0.11                 |\n";
echo "        |        Rifkin            0.15                 |\n";
echo "        |        Axelrod           0.10                 |\n";
echo "         ===============================================\n";
echo "\n";
echo "	     Рисунок 3.2 Выбор определенных столбцов</pre>\n";
echo "<p>Могут иметься таблицы, которые имеют большое количество столбцов, содержащих данные, не все из которых \n";
echo "нужны для выполнения поставленной задачи. \n";
echo "Следовательно, вы можете найти способ подбора и выбора только полезных для вас столбцов.<a name=\"3.7\"></a></p>\n";
echo "<h3>ПЕРЕУПОРЯДОЧИВАНИЕ СТОЛБЦА</h3>\n";
echo "<p>Даже если столбцы таблицы, по определению, упорядочены, это не означает, что вы будете восстанавливать их в том же порядке. Конечно, звёздочка (*) покажет \n";
echo "все столбцы в их естественном порядке, но если вы укажете столбцы отдельно, вы можете получить их в том порядке, в котором хотите. Давайте рассмотрим таблицу \n";
echo "Заказов, содержащую дату приобретения (odate), номер продавца (snum), номер заказа (onum) и суммы приобретения (amt):</p>\n";
echo "<pre>   SELECT odate, snum, onum, amt\n";
echo "      FROM Orders;</pre>\n";
echo "<p>Вывод этого запроса показан на Рисунке 3.3.</p>\n";
echo "<pre>     =============  SQL Execution Log  ==============\n";
echo "    |                                                 |\n";
echo "    |  SELECT odate, snum, onum, amt                  |\n";
echo "    |  FROM Orders;                                   |\n";
echo "    |                                                 |\n";
echo "    | ------------------------------------------------|\n";
echo "    |     odate        snum        onum           amt |\n";
echo "    | -----------   -------      ------     --------- |\n";
echo "    | 10/03/1990       1007        3001         18.69 |\n";
echo "    | 10/03/1990       1001        3003        767.19 |\n";
echo "    | 10/03/1990       1004        3002       1900.10 |\n";
echo "    | 10/03/1990       1002        3005       5160.45 |\n";
echo "    | 10/03/1990       1007        3006       1098.16 |\n";
echo "    | 10/04/1990       1003        3009       1713.23 |\n";
echo "    | 10/04/1990       1002        3007         75.75 |\n";
echo "    | 10/05/1990       1001        3008       4723.00 |\n";
echo "    | 10/06/1990       1002        3010       1309.95 |\n";
echo "    | 10/06/1990       1001        3011       9891.88 |\n";
echo "    |                                                 |\n";
echo "      ===============================================\n";
echo "\n";
echo "	  Рисунок 3.3 Реконструкция столбцов</pre>\n";
echo "<p>Как  видите, структура информации в таблицах это просто основа для активной перестройки структуры в SQL.<a name=\"3.8\"></a></p>\n";
echo "<h3>УДАЛЕНИЕ ИЗБЫТОЧНЫХ ДАННЫХ</h3>\n";
echo "<p>DISTINCT (ОТЛИЧИЕ) - аргумент, который обеспечивает вас способом устранять \n";
echo "дублирующие значения из вашего предложения SELECT. Предположим, что вы хотите \n";
echo "знать, какие продавцы в настоящее время имеют свои заказы в таблице Заказов. Под \n";
echo "заказом (здесь и далее) будет пониматься запись в таблицу Заказов, \n";
echo "регистрирующая приобретения, сделанные в определённый день определённым заказчиком у определённого продавца на определённую сумму. Вам не нужно знать, \n";
echo "сколько заказов имеет каждый; вам нужен только список номеров продавцов (snum). Поэтому \n";
echo "вы можете ввести:</p>\n";
echo "<pre>     SELECT snum\n";
echo "       FROM Orders;</pre>\n";
echo "<p>для получения вывода показанного в Рисунке 3.4</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT snum                                   |\n";
echo "              | FROM  Orders;                                 |\n";
echo "              |                                               |\n";
echo "              | ============================================= |\n";
echo "              |   snum                                        |\n";
echo "              | -------                                       |\n";
echo "              |   1007                                        |\n";
echo "              |   1001                                        |\n";
echo "              |   1004                                        |\n";
echo "              |   1002                                        |\n";
echo "              |   1007                                        |\n";
echo "              |   1003                                        |\n";
echo "              |   1002                                        |\n";
echo "              |   1001                                        |\n";
echo "              |   1002                                        |\n";
echo "              |   1001                                        |\n";
echo "                =============================================\n";
echo "\n";
echo "	    Рисунок 3.4 SELECT с дублированием номеров продавцов</pre>\n";
echo "<p>Для получения списка без дубликатов, для удобочитаемости, вы можете ввести следующее:</p>\n";
echo "<pre>       SELECT DISTINCT snum\n";
echo "          FROM Orders;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 3.5.</p>\n";
echo "<p>Другими словами, DISTINCT следит за тем, какие значения были ранее, чтобы они \n";
echo "не дублировались в списке. Это полезный способ избежать \n";
echo "избыточности данных, но важно, чтобы при этом вы понимали, что вы делаете. Если вы не хотите потерять некоторые данные, вы не должны безоглядно использовать DISTINCT, потому что это может скрыть какую-то проблему или какие-то важные \n";
echo "данные. Например, вы могли бы предположить, что имена всех ваших заказчиков различны. Если кто-то помещает второго Clemens в таблицу Заказчиков, а вы \n";
echo "используете SELECT DISTINCT cname, вы не будете даже знать о существовании двойника. Вы можете получить не того Clemens и даже не знать об этом. Так как вы \n";
echo "не ожидаете избыточности, в этом случае вы не должны использовать DISTINCT.</p>\n";
echo "<h4>ПАРАМЕТРЫ DISTINCT</h4>\n";
echo "<p>DISTINCT может указываться только один раз в данном предложении SELECT. Если предложение выбирает несколько полей,</p>\n";
echo "<pre>               ===============  SQL Execution Log ===========\n";
echo "              |                                               |\n";
echo "              | SELECT DISTINCT snum                          |\n";
echo "              | FROM  Orders;                                 |\n";
echo "              |                                               |\n";
echo "              | ============================================= |\n";
echo "              |   snum                                        |\n";
echo "              | -------                                       |\n";
echo "              |   1001                                        |\n";
echo "              |   1002                                        |\n";
echo "              |   1003                                        |\n";
echo "              |   1004                                        |\n";
echo "              |   1007                                        |\n";
echo "                =============================================\n";
echo "\n";
echo "		   Рисунок 3.5 SELECT без дублирования</pre>\n";
echo "<p>DISTINCT опускает строки, где все выбранные поля идентичны. Строки, в которых некоторые значения одинаковы, а некоторые \n";
echo "- различны, будут сохранены. DISTINCT \n";
echo "фактически приводит к показу всей строки вывода, не указывая полей (за исключением \n";
echo "случав, когда он используется внутри агрегатных функций, как описано в Главе \n";
echo "6), так что нет никакого смысла  его повторять.</p>\n";
echo "<h4>ALL ВМЕСТО DISTINCT</h4>\n";
echo "<p>Вместо DISTINCT вы можете указать ALL. Это будет иметь противоположный эффект, дублирование строк вывода сохранится. Так как это - тот  самый случай, \n";
echo "когда вы не указываете ни DISTINCT ни ALL, то ALL - по существу скорее пояснительный, а не действующий аргумент.</p>\n";
echo "<a name=\"3.9\"></a>\n";
echo "<h3>КВАЛИФИЦИРОВАННЫЙ ВЫБОР ПРИ ИСПОЛЬЗОВАНИИ ПРЕДЛОЖЕНИЙ</h3>\n";
echo "<p>Таблица имеет тенденцию становиться очень большой, поскольку с течением времени всё большее и большее количество строк в неё добавляется. Поскольку \n";
echo "обычно  только определённые строки интересуют вас в данное время, SQL дает возможность  устанавливать критерии, чтобы определить, какие строки будут \n";
echo "выбраны для вывода.</p><p>WHERE - предложение команды SELECT, которое позволяет  устанавливать \n";
echo "предикаты, условие которых может быть или верным (true), или неверным (false) для любой строки таблицы. Команда извлекает только те строки из таблицы, для которых такое \n";
echo "утверждение верно. Например, предположим, вы хотите видеть имена и комиссионные всех продавцов в Лондоне. Вы можете ввести такую команду:</p>\n";
echo "<pre>      SELECT sname, city\n";
echo "        FROM Salespeople;\n";
echo "        WHERE city = &quot;LONDON&quot;;</pre>\n";
echo "<p>Когда предложение WHERE предоставлено, программа базы данных просматривает всю таблицу построчно и исследует каждую строку, чтобы определить, верно ли \n";
echo "утверждение. Следовательно, для записи Peel программа рассмотрит текущее значение столбца city, определит, что оно равно &quot;London&quot;, и включит эту строку в \n";
echo "вывод. Запись для Serres не будет включена, и так далее. Вывод для вышеупомянутого запроса показан на Рисунке 3.6.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT sname, city                            |\n";
echo "              | FROM  Salespeople                             |\n";
echo "              | WHERE city = 'London'                         |\n";
echo "              | ============================================= |\n";
echo "              |   sname           city                        |\n";
echo "              |  -------       ----------                     |\n";
echo "              |   Peel            London                      |\n";
echo "              |   Motika          London                      |\n";
echo "                =============================================\n";
echo "\n";
echo "		  Рисунок 3.6 SELECT с предложением WHERE</pre>\n";
echo "<p>Давайте попробуем пример с числовым полем в предложении WHERE. Поле rating таблицы Заказчиков предназначено для того, чтобы разделять заказчиков на группы, основанные \n";
echo "на некоторых критериях, которые могут быть получены в итоге через этот номер. Возможно это - форма оценки кредита или оценки, основанной на \n";
echo "объёме предыдущих \n";
echo "приобретений. Такие числовые коды могут быть полезны в реляционных базах данных как способ подведения итогов сложной информации. Мы можем выбрать всех \n";
echo "заказчиков с рейтингом 100 следующим образом:</p>\n";
echo "<pre>     SELECT *\n";
echo "        FROM Customers\n";
echo "        WHERE rating = 100;</pre>\n";
echo "<p>Одиночные кавычки не используются здесь, потому что оценка это числовое поле. Результаты запроса показаны на Рисунке 3. 7.</p>\n";
echo "<p>Предложение WHERE совместимо с предыдущим материалом в этой главе. Другими словами, вы можете использовать номера столбцов, устранять дубликаты или \n";
echo "переупорядочивать столбцы в команде SELECT, которая использует WHERE. Однако вы можете изменять порядок столбцов для имён только в предложении SELECT, но не в предложении WHERE.</p>\n";
echo "<pre>               ============  SQL Execution Log ==============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE rating = 100;                           |\n";
echo "              | ============================================= |\n";
echo "              |   сnum     cname    city       rating  snum   |\n";
echo "              |  ------   --------  ------     ----    ------ |\n";
echo "              |   2001     Hoffman  London     100     1001   |\n";
echo "              |   2006     Clemens  London     100     1001   |\n";
echo "              |   2007     Pereira  Rome       100     1001   |\n";
echo "                =============================================\n";
echo "\n";
echo "	      Рисунок 3.7 SELECT с числовым полем в предикате</pre>\n";
echo "<a name=\"3.10\"></a>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы знаете несколько способов, как заставить таблицу выдавать вам ту информацию, какую вы хотите, а не просто вываливать наружу всё её содержание. Вы \n";
echo "можете переупорядочивать столбцы таблицы или отбрасывать любой из них. Вы можете решать, хотите вы видеть дублированные значения, или нет.</p>\n";
echo "<p>Наиболее важно то, что вы можете устанавливать условие, называемое предикатом, которое определяет или не определяет,  из тысяч таких же \n";
echo "строк, будет ли  выбрана для вывода указанная строка.</p><p>Предикаты могут становиться очень сложными, предоставляя вам высокую точность \n";
echo "в решении того, какие строки вам выбирать с помощью запроса. Именно эта способность решать точно, что вы хотите видеть, делает запросы SQL такими мощными. Следующие \n";
echo "несколько глав будут посвящены в большей мере особенностям, которые расширяют мощность предикатов. В Главе 4 вам будут представлены операции, иные, нежели те, \n";
echo "которые используются в условиях предиката, а также способы объединения многочисленных условий в единый предикат.</p>\n";
echo "<a name=\"3.11\"></a>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<ol><li><pre>Напишите команду SELECT, которая вывела бы номер заказа, сумму и дату для всех\n";
echo "строк из таблицы Заказов.</pre></li>\n";
echo "<li><pre>Напишите запрос, который вывел бы все строки из таблицы Заказчиков, для которых\n";
echo "номер продавца = 1001.</pre></li>\n";
echo "<li><pre>Напишите запрос, который вывел бы таблицу со столбцами в следующем порядке:\n";
echo "city, sname, snum, comm.</pre></li>\n";
echo "<li><pre>Напишите команду SELECT, которая вывела бы оценку (rating), сопровождаемую именем\n";
echo "каждого заказчика в San Jose.</pre></li>\n";
echo "<li><pre>Напишите запрос, который вывел бы значения snum всех продавцов в текущем заказе\n";
echo "из таблицы Заказов без каких бы то ни было повторений.</pre></li></ol>\n";
echo "<pre>(См. ответы в<a href=\"a.php#3\"> Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>  
