﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");   
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 16.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 16. ИСПОЛЬЗОВАНИЕ ПОДЗАПРОСОВ<br>\n";
echo "С КОМАНДАМИ МОДИФИКАЦИИ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе вы узнаете, как использовать подзапросы в командах модификации. \n";
echo "Вы обнаружите, что нечто подобное вы уже видели при использовании подзапросов в \n";
echo "запросах. Понимание того, как подзапросы используются в командах SELECT, сделает \n";
echo "их применение в командах модификации более уверенным, хотя и останутся некоторые \n";
echo "вопросы. Завершением команды SELECT является подзапрос, но не предикат, и \n";
echo "поэтому его использование отличается от использования простых предикатов с \n";
echo "командами модификации, которые вы уже выполняли раннее с командами UPDATE и \n";
echo "DELETE. Вы использовали простые запросы, чтобы производить значения для INSERT, \n";
echo "а теперь мы можем расширить эти запросы, чтобы включать в них подзапросы.</p>\n";
echo "<p>Важный принцип, который надо соблюдать при работе с командами модификации: \n";
echo "нельзя в предложении FROM любого подзапроса \n";
echo "модифицировать таблицу, к которой обращаетесь с помощью основной команды. Это \n";
echo "относится ко всем трём командам модификации. Хотя имеется большое количество \n";
echo "ситуаций, в которых будет полезно сделать запрос той таблицы, которую вы хотите \n";
echo "модифицировать, причем во время её модификации, это слишком усложняет операцию, \n";
echo "чтобы использовать её на практике.</p>\n";
echo "<p>Не делайте ссылки к текущей строке таблицы, указанной в команде, которая \n";
echo "является соотнесённым подзапросом.</p>\n";
echo "<h3><a name=\"16.1\">И</a>СПОЛЬЗОВАНИЕ ПОДЗАПРОСОВ С INSERT</h3>\n";
echo "<p>INSERT это самый простой случай. Вы уже видели, как вставлять результаты \n";
echo "запроса в таблицу. Вы можете использовать подзапросы внутри любого запроса, \n";
echo "который генерирует значения для команды INSERT, тем же самым способом, которым вы \n";
echo "делали это для других запросов - т.е. внутри предиката или предложения HAVING.</p>\n";
echo "<p>Предположим, что  имеется таблица SJpeople, столбцы которой \n";
echo "совпадают со столбцами нашей таблицы Продавцов. Вы уже видели, как заполнять \n";
echo "таблицу, подобную этой, заказчиками в городе, например, в San Jose:</p>\n";
echo "<pre>                   INSERT INTO SJpeople\n";
echo "                      SELECT *\n";
echo "                      FROM Salespeople\n";
echo "                      WHERE city = 'San Jose';</pre>\n";
echo "<p>Теперь мы можем использовать подзапрос, чтобы добавить в таблицу SJpeople \n";
echo "всех продавцов, которые имеют заказчиков в San Jose, независимо от того, \n";
echo "находятся ли там продавцы или нет:</p>\n";
echo "<pre>       INSERT INTO SJpeople\n";
echo "          SELECT *\n";
echo "             FROM Salespeople\n";
echo "             WHERE snum = ANY\n";
echo "               (SELECT snum\n";
echo "                    FROM Customers\n";
echo "                    WHERE city = 'San Jose');</pre>\n";
echo "<p>Оба запроса в этой команде функционируют так же, как если бы они не являлись \n";
echo "частью выражения INSERT. Подзапрос находит все строки для заказчиков в San Jose \n";
echo "и формирует набор значений snum. Внешний запрос выбирает строки из таблицы \n";
echo "Salespeople, где эти значения snum найдены. В этом примере, строки для продавцов Rifkin и Serres, которые назначены заказчикам в San Jose - Liu и Cisneros, будут \n";
echo "вставлены в таблицу SJpeople.</p>\n";
echo "<h3><a name=\"16.2\">Н</a>Е ВСТАВЛЯЙТЕ ДУБЛИКАТЫ СТРОК</h3>\n";
echo "<p>Последовательность команд в предшествующем разделе может быть критичной. \n";
echo "Продавец Serres находится в San Jose и, следовательно, будет вставлен с помощью \n";
echo "первой команды. Вторая команда попытается вставить его снова, поскольку он имеет \n";
echo "ещё одного заказчика в San Jose. Если имеются любые ограничения в таблице \n";
echo "SJpeople, которые вынуждают её иметь уникальные значения, эта вторая вставка \n";
echo "потерпит неудачу (как  и должно  быть).</p>\n";
echo "<p>Дублирующие строки это плохо. (См. в <a href=\"ch18.php\">Главе 18</a> \n";
echo "подробности об ограничениях.) Было бы лучше, если бы вы могли как-то выяснить, \n";
echo "что эти значения уже были вставлены в таблицу, прежде чем  попытаетесь сделать \n";
echo "это снова, с помощью добавления другого подзапроса (использующего операторы типа EXISTS, IN,&nbsp; &lt; &gt; ALL и так далее) к предикату.</p>\n";
echo "<p>К сожалению, чтобы сделать эту работу, вы должны будете сослаться на саму \n";
echo "таблицу SJpeople в предложении FROM этого нового подзапроса, а, как мы говорили \n";
echo "ранее, вы не можете ссылаться на таблицу, которая задействована (целиком) в \n";
echo "любом подзапросе команды модификации. В случае с INSERT это будет также \n";
echo "препятствовать соотнесённым подзапросам, основанным на таблице, в которую вы \n";
echo "вставляете значения. Это имеет значение, потому что, с помощью INSERT, вы \n";
echo "создаете новую строку в таблице. &quot;Текущая строка&quot; не будет существовать до тех \n";
echo "пор, пока INSERT не закончит её обрабатывать.</p>\n";
echo "<h3><a name=\"16.3\">И</a>СПОЛЬЗОВАНИЕ ПОДЗАПРОСОВ,<br>\n";
echo "СОЗДАННЫХ ВО ВНЕШНИХ ЗАПРОСАХ ТАБЛИЦ</h3>\n";
echo "<p>Запрещение на обращение к таблице, которая модифицируется командой INSERT, не \n";
echo "предохранит вас от использования подзапросов, которые обращаются к таблице, \n";
echo "используемой в предложении FROM внешней команды SELECT. Таблица, из которой вы \n";
echo "выбираете значения, чтобы произвести их для INSERT, не будет задействована \n";
echo "командой, и вы сможете обращаться к этой таблице любым способом, которым вы \n";
echo "обычно это делали, но только если эта таблица указана в автономном запросе. \n";
echo "Предположим, что  имеется таблица Samecity, в которой мы запомним \n";
echo "продавцов с заказчиками в их городах. Мы можем заполнить таблицу используя, \n";
echo "соотнесённый подзапрос:</p>\n";
echo "<pre>      INSERT INTO (Samecity\n";
echo "	 SELECT *\n";
echo "	    FROM (Salespeople outer\n";
echo "	    WHERE city IN\n";
echo "	      (SELECT city\n";
echo "		   FROM Customers inner\n";
echo "		   WHERE inner.snum = outer.snum);</pre>\n";
echo "<p>Ни таблица Samecity, ни таблица Продавцов не должны быть использованы во \n";
echo "внешних или внутренних запросах INSERT. В качестве другого примера предположим, \n";
echo "что у вас установлена премия для продавца, имеющего самый большой заказ, на \n";
echo "каждый день. Вы следите за этим в таблице с именем Bonus, которая содержит поле \n";
echo "snum продавцов, поле odate и поле amt. Вы должны заполнить эту таблицу \n";
echo "информацией, которая хранится в таблице Заказов, используя следующую команду:</p>\n";
echo "<pre>   INSERT INTO Bonus\n";
echo "      SELECT snum, odate, amt\n";
echo "	 FROM Orders a\n";
echo "	 WHERE amt =\n";
echo "	   (SELECT MAX (amt)\n";
echo "		FROM Orders b\n";
echo "		WHERE a.odate = b.odate);</pre>\n";
echo "<p>Даже если эта команда имеет подзапрос, который базируется на той же самой \n";
echo "таблице, что и внешний запрос, он не обращается к таблице Bonus, на которую \n";
echo "воздействует команда. Что для нас абсолютно приемлемо. Логика запроса, \n";
echo "естественно, должна просматривать таблицу Заказов и находить для каждой строки \n";
echo "максимальную сумму заказа  для данной даты. Если эта величина - \n";
echo "такая же, как у текущей строки, текущая строка является наибольшим заказом для \n";
echo "этой даты, и данные вставляются в таблицу Bonus.</p>\n";
echo "<h3><a name=\"16.4\">И</a>СПОЛЬЗОВАНИЕ ПОДЗАПРОСОВ С DELETE</h3>\n";
echo "<p>Вы можете также использовать подзапросы в предикате команды DELETE. Это даст \n";
echo "вам возможность определять некоторые довольно сложные критерии, чтобы \n";
echo "установить, какие строки будут удаляться, что важно, так как вы, конечно же, не \n";
echo "захотите по неосторожности удалить нужную строку. Например, если мы закрыли наше \n";
echo "ведомство в Лондоне, мы могли бы использовать следующий запрос чтобы удалить \n";
echo "всех заказчиков, назначенных продавцам в Лондоне:</p>\n";
echo "<pre>     DELETE\n";
echo "	FROM Customers\n";
echo "	WHERE snum = ANY\n";
echo "	  (SELECT snum\n";
echo "	      FROM Salespeople\n";
echo "	      WHERE city = 'London');</pre>\n";
echo "<p>Эта команда удалит из таблицы Заказчиков строки Hoffman и Clemens \n";
echo "(назначенных для Peel), и Pereira (назначенного для Motika). Конечно, вы захотите \n";
echo "удостовериться, правильно ли сформирована эта операция, прежде чем удалить или \n";
echo "изменить строки Peel и Motika.</p>\n";
echo "<p>Это важно. Обычно, когда мы делаем модификацию в базе данных, которая \n";
echo "повлечет другие модификации, наше первое желание - сделать сначала основное \n";
echo "действие, а затем проследить другие, вторичные. Этот пример, покажет, почему \n";
echo "более эффективно делать наоборот, выполнив сначала вторичные действия.</p>\n";
echo "<p>Если, например, вы решили изменить значения полей city ваших продавцов везде, \n";
echo "где они переназначены, вы должны рассмотреть всех этих заказчиков более сложным \n";
echo "способом.</p>\n";
echo "<p>Так как реальные БД имеют тенденцию разрастаться до значительно больших \n";
echo "размеров, чем наши небольшие типовые таблицы, это может стать серьезной \n";
echo "проблемой. SQL может предоставить некоторую помощь в этой области, используя \n";
echo "механизм справочной целостности (обсуждённый в <a href=\"ch19.php\">Главе 19</a>), \n";
echo "но это не всегда доступно и не всегда применимо.</p>\n";
echo "<p>Хотя вы не можете обращаться к \n";
echo "таблице, из которой вы будете удалять строки, в предложении FROM подзапроса, вы \n";
echo "можете в предикате сослаться на текущую строку-кандидат этой таблицы, которая \n";
echo "является строкой, которая проверяется в основном предикате. Другими словами, вы \n";
echo "можете использовать соотнесённые подзапросы. Они отличаются от тех соотнесённых \n";
echo "подзапросов, которые вы могли использовать с INSERT, в котором они фактически \n";
echo "базировались на строках-кандидатах таблицы, задействованной в команде, а не на \n";
echo "запросе другой таблицы.</p>\n";
echo "<pre>  DELETE FROM Salespeople\n";
echo "     WHERE EXISTS\n";
echo "       (SELECT *\n";
echo "	   FROM Customers\n";
echo "	   WHERE rating = 100\n";
echo "	   AND Salespeople.snum = Customers.snum);</pre>\n";
echo "<p>Обратите внимание, что часть AND предиката внутреннего запроса обращается к \n";
echo "таблице Продавцов. Это означает, что весь подзапрос будет выполняться отдельно \n";
echo "для каждой строки таблицы Продавцов, так же, как это выполнялось с другими \n";
echo "соотнесенными подзапросами. Эта команда удалит всех продавцов, которые имели по \n";
echo "меньшей мере одного заказчика с оценкой 100 в таблице Продавцов. Конечно же, \n";
echo "имеется другой способ сделать то же:</p>\n";
echo "<pre>     DELETE FROM Salespeople\n";
echo "	WHERE 100 IN\n";
echo "	  (SELECT rating\n";
echo "	      FROM Customers\n";
echo "	      WHERE Salespeople.snum = Customers.snum);</pre>\n";
echo "<p>Эта команда находит все оценки для каждого заказчика продавцов и удаляет тех \n";
echo "продавцов, заказчики которых имеют оценку = 100.</p>\n";
echo "<p>Обычно соотнесённые подзапросы это подзапросы, связанные с таблицей, к \n";
echo "которой они ссылаются во внешнем запросе (а не в самом предложении DELETE), и \n";
echo "так же часто используемые. Вы можете найти наименьший заказ на каждый день и \n";
echo "удалить продавцов, которые произвели его, с помощью следующей команды:</p>\n";
echo "<pre>      DELETE FROM Salespeople\n";
echo "	 WHERE snum IN\n";
echo "	   	(SELECT snum\n";
echo "		 FROM Orders\n";
echo "		 WHERE amt =\n";
echo "		  (SELECT MIN (amt)\n";
echo "		       FROM Orders b\n";
echo "		       WHERE a.odate = b.odate));</pre>\n";
echo "<p>Подзапрос в предикате DELETE принимает соотнесённый подзапрос. Этот \n";
echo "внутренний запрос находит минимальный заказ суммы приобретений для даты каждой \n";
echo "строки внешнего запроса. Если эта сумма - такая же, как и сумма текущей строки, \n";
echo "предикат внешнего запроса верен, что означает, что текущая строка имеет \n";
echo "наименьший заказ для этой даты. Поле snum продавца, ответственного за этот \n";
echo "заказ, извлекается и передается в основной предикат команды DELETE, которая \n";
echo "затем удаляет все строки с этим значением поля snum из таблицы Продавцов (так \n";
echo "как snum это первичный ключ таблицы Продавцов, то, естественно, там должна \n";
echo "иметься только одна удаляемая строка для значения поля snum, выведенного с \n";
echo "помощью подзапроса. Если имеется больше одной строки, все они будут удалены.) \n";
echo "Поле snum = 1007, которое будет удалено, имеет наименьшее значение на 3 октября; \n";
echo "поле snum = 1002, наименьшее на 4 октября; поле snum = 1001, наименьшее в \n";
echo "заказах на 5 октября (эта команда кажется довольно грубой, особенно когда она \n";
echo "удаляет Peel создавшего единственный заказ на 5 октября, но зато это хорошая \n";
echo "иллюстрация).</p>\n";
echo "<p>Если вы хотите сохранить Peel, вы могли бы добавить другой подзапрос, который \n";
echo "сделал бы это:</p>\n";
echo "<pre>   DELETE FROM Salespeople\n";
echo "      WHERE snum IN\n";
echo "		(SELECT snum\n";
echo "	     	FROM Orders a\n";
echo "	     WHERE amt =\n";
echo "	       	(SELECT MIN (amt)\n";
echo "		    FROM Orders b\n";
echo "		    WHERE a.odate = b.odate)\n";
echo "	     AND 1 &lt;\n";
echo "	      (SELECT COUNT onum\n";
echo "		   FROM Orders b\n";
echo "		   WHERE a.odate = b.odate));</pre>\n";
echo "<p>Теперь для дня, в котором был создан только один заказ, будет произведен счёт \n";
echo "= 1 во втором соотнесённом подзапросе. Это сделает предикат внешнего запроса \n";
echo "неправильным, и поля snum, следовательно, не будут переданы в основной предикат.</p>\n";
echo "<h3><a name=\"16.5\">И</a>СПОЛЬЗОВАНИЕ ПОДЗАПРОСОВ С UPDATE</h3>\n";
echo "<p>UPDATE использует подзапросы тем же самым способом, что и DELETE, внутри этого \n";
echo "необязательного предиката. Вы можете использовать соотнесённые подзапросы в \n";
echo "форме, пригодной для использования с DELETE - связанной или с модифицируемой \n";
echo "таблицей, или с таблицей вызываемой во внешнем запросе. Например, с помощью \n";
echo "соотнесённого подзапроса к таблице, которая будет модифицироваться, вы можете \n";
echo "увеличить комиссионные всех продавцов которые были назначены по крайней мере \n";
echo "двум заказчикам:</p>\n";
echo "<pre>UPDATE Salespeople\n";
echo "   SET comm = comm + .01\n";
echo "   WHERE 2 &lt; =\n";
echo "      (SELECT COUNT (cnum)\n";
echo "	   FROM Customers\n";
echo "	   WHERE Customers.snum =\n";
echo "	    Salespeople.snum);</pre>\n";
echo "<p>Теперь продавцы Peel и Serres, имеющие нескольких заказчиков, получат \n";
echo "повышение своих комиссионных. Имеется разновидность последнего примера из \n";
echo "предыдущего раздела с DELETE. Он уменьшает комиссионные продавцов которые \n";
echo "оформили наименьшие заказы, но не стирает их в таблице:</p>\n";
echo "<pre>   UPDATE Salespeople\n";
echo "      SET comm = comm - .01\n";
echo "      WHERE snum IN\n";
echo "	(SELECT snum\n";
echo "	     FROM Orders a\n";
echo "	     WHERE amt =\n";
echo "	       (SELECT MIN (amt)\n";
echo "		    FROM Orders b\n";
echo "		    WHERE a.odat = b.odate));</pre>\n";
echo "<h3><a name=\"16.6\">О</a>ГРАНИЧЕНИЯ ПОДЗАПРОСОВ КОМАНД DML</h3>\n";
echo "<p>Невозможность обратиться к таблице, задействованной в любом подзапросе, из \n";
echo "команды модификации (UPDATE) исключает целые категории возможных действий. \n";
echo "Например, вы не можете просто выполнить такую операцию как удаление всех \n";
echo "заказчиков с оценками ниже средней. Вероятно, лучше всего вы могли бы сначала \n";
echo "(Шаг 1.) выполнить запрос, получающий среднюю величину, а затем (Шаг 2.) \n";
echo "удалить все строки с оценкой ниже этой величины.</p>\n";
echo "<p>Шаг 1.</p>\n";
echo "<pre>  SELECT AVG (rating) \n";
echo "     FROM Customers; \n";
echo "\n";
echo "</pre>\n";
echo "<p>Вывод = 200.</p>\n";
echo "<p>Шаг 2.</p>\n";
echo "<pre>  DELETE \n";
echo "     FROM Customers \n";
echo "     WHERE rating &lt; 200;</pre>\n";
echo "<h3><a name=\"16.7\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы овладели тремя командами, которые управляют всем содержимым вашей \n";
echo "БД. Осталось только несколько общих вопросов относительно ввода и стирания \n";
echo "значений таблицы, когда, например, эти команды могут выполниться данным \n";
echo "пользователем в данной таблице и когда действия, сделанные ими, становятся \n";
echo "постоянными.</p>\n";
echo "<p>Подведём итог: вы используете команду INSERT, чтобы добавлять строки в \n";
echo "таблицу. Вы можете или дать имена значениям этих строк в предложении VALUES \n";
echo "(когда только одна строка может быть добавлена), или вывести значения с помощью \n";
echo "запроса (когда любое число строк можно добавить одной командой).</p>\n";
echo "<p>Если используется запрос, он не может обращаться к таблице, в которую вы \n";
echo "делаете вставку, каким бы способом вы её ни делали, ни в предложении FROM, ни с \n";
echo "помощью внешней ссылки (как это делается в соотнесённых подзапросах). Всё это \n";
echo "относится к любым подзапросам внутри этого запроса.</p>\n";
echo "<p>Запрос, однако, оставляет вам свободу использования соотнесённых подзапросов \n";
echo "или подзапросов, которые дают в предложении FROM имя таблице, которое уже было \n";
echo "указано в предложении FROM внешнего запроса (это - общий случай для запросов).</p>\n";
echo "<p>DELETE и UPDATE используются, чтобы, соответственно, удалить строки из таблицы \n";
echo "и изменить в них значения. Оба они применимы ко всем строкам таблицы, если не \n";
echo "используется предикат, определяющий, какие строки должны быть удалены или \n";
echo "модифицированы. Этот предикат может содержать подзапросы, которые могут быть \n";
echo "связаны с таблицей, удаляемой или модифицируемой с помощью внешней ссылки. Эти \n";
echo "подзапросы, однако, не могут ссылаться на таблицу, модифицируемой любым \n";
echo "предложением FROM.</p>\n";
echo "<p>Может показаться, что мы прошли материал SQL, который обладает не самой понятной \n";
echo "логикой. Сначала мы сделали запрос таблицы, которая уже заполнена данными. Потом \n";
echo "мы показали, как можно фактически помещать эти значения изначально. Но, как вы \n";
echo "видите, полное ознакомление с запросами здесь неоценимо.</p>\n";
echo "<p>Теперь, когда мы показали вам, как заполнять значениями таблицы, которые уже \n";
echo "были созданы (по определению), мы покажем (начиная со <a href=\"ch17.php\">\n";
echo "следующей главы</a>), откуда появляются эти таблицы.</p>\n";
echo "<h3><a name=\"16.8\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Предположите, что имеется таблица Multicust с такими\n";
echo "   же именами столбцов, что и в таблице Продавцов. Напишите команду,\n";
echo "   которая вставила бы всех продавцов (из таблицы Продавцов), имеющих \n";
echo "   более чем одного заказчика, в эту таблицу.\n";
echo "\n";
echo "2. Напишите команду, которая удаляла бы всех заказчиков не имеющих текущих заказов.\n";
echo "\n";
echo "3. Напишите команду, которая увеличила бы на двадцать процентов комиссионные\n";
echo "   всех продавцов, имеющих сумму текущих заказов выше $3,000.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#16\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
