﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 11.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 11. СООТНЕСЁННЫЕ ПОДЗАПРОСЫ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе мы рассмотрим тип подзапроса, о котором мы не говорили в\n";
echo "<a href=\"ch10.php\">Главе 10</a>, - соотнесённый подзапрос. Вы \n";
echo "узнаете, как использовать соотнесённые подзапросы в предложениях WHERE \n";
echo "и HAVING. Сходства и различия между соотнесёнными подзапросами и объединениями \n";
echo "будут обсуждаться далее, и вы сможете расширить ваше знание о псевдонимах и \n";
echo "префиксах имени таблицы - когда они необходимы и как их использовать.</p>\n";
echo "<h3><a name=\"11.1\">К</a>АК СФОРМИРОВАТЬ СООТНЕСЁННЫЙ ПОДЗАПРОС?</h3>\n";
echo "<p>Когда вы используете подзапросы в SQL, вы можете обратиться к внутреннему \n";
echo "запросу таблицы в предложении внешнего запроса FROM, сформировав соотнесённый \n";
echo "подзапрос. Когда вы делаете это, подзапрос выполняется неоднократно, по одному \n";
echo "разу для каждой строки таблицы основного запроса. Соотнесённый подзапрос - одно \n";
echo "из большого количества тонких понятий в SQL. Если вы \n";
echo "сумеете овладеть им, вы найдёте, что он очень мощен, поскольку может выполнять \n";
echo "сложные функции с помощью очень лаконичных указаний.</p>\n";
echo "<p>Например, вот способ найти всех заказчиков в Заказах на 3-е октября \n";
echo "(вывод показан на Рисунке 11.1):</p>\n";
echo "<pre>             SELECT *\n";
echo "                FROM Customers outer\n";
echo "                WHERE 10/03/1990 IN\n";
echo "                  (SELECT odate\n";
echo "                       FROM Orders inner\n";
echo "                       WHERE outer.cnum = inner.cnum);</pre>\n";
echo "<h3><a name=\"11.2\">К</a>АК РАБОТАЕТ СООТНЕСЕННЫЙ ПОДЗАПРОС?</h3>\n";
echo "<p>В вышеупомянутом примере, &quot;внутренний&quot; (inner) и &quot;внешний&quot; (outer) это \n";
echo "псевдонимы, подробно обсуждённые в <a href=\"ch9.php\">Главе 9</a>. Мы выбрали \n";
echo "эти имена для большей ясности; они отсылают к значениям внутренних и внешних \n";
echo "запросов, соответственно. Так как значение в поле cnum&nbsp; внешнего запроса \n";
echo "меняется, внутренний запрос должен выполняться отдельно для каждой строки \n";
echo "внешнего запроса. Строка внешнего запроса, для которого внутренний запрос каждый \n";
echo "раз будет выполнен, называется текущей строкой-кандидатом.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers outer                         |\n";
echo "              | WHERE 10/03/1990 IN                           |\n";
echo "              | (SELECT odate                                 |\n";
echo "              | FROM Orders inner                             |\n";
echo "              | WHERE outer.cnum = inner.cnum);               |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city    rating    snum   |\n";
echo "              |  -----    --------   ----    ------   -----   |\n";
echo "              |   2001    Hoffman    London     100    1001   |\n";
echo "              |   2003    Liu        San Jose   200    1002   |\n";
echo "              |   2008    Cisneros   San Jose   300    1007   |\n";
echo "              |   2007    Pereira    Rome       100    1004   |\n";
echo "                =============================================\n";
echo "\n";
echo "	     Рисунок 11.1 Использование соотнесённого подзапроса</pre>\n";
echo "<p>Следовательно, процедура оценки, выполняемой соотнесённым подзапросом:</p>\n";
echo "<ol>\n";
echo "  <li>Выбрать строку из таблицы, именованной во внешнем запросе. Это будет текущая строка-кандидат.</li>\n";
echo "  <li>Сохранить значения из этой строки-кандидата в псевдониме с именем в предложении FROM внешнего запроса.</li>\n";
echo "  <li>Выполнить подзапрос. Везде, где псевдоним, заданный для внешнего запроса, найден (в данном случае &quot;внешний&quot;), использовать значение текущей строки-кандидата. Использование значения из строки-кандидата внешнего запроса в подзапросе называется внешней ссылкой.</li>\n";
echo "  <li>Оценить предикат внешнего запроса на основе результатов подзапроса, выполняемого в шаге 3. Он определяет, выбирается ли строка-кандидат для вывода.</li>\n";
echo "  <li>Повторить процедуру для следующей строки-кандидата таблицы, и так далее, пока все строки таблицы не будут проверены.</li>\n";
echo "</ol>\n";
echo "<p>В вышеупомянутом примере SQL осуществляет следующую процедуру:</p>\n";
echo "<ol>\n";
echo "  <li>Выбирает строку Hoffman из таблицы Заказчиков.</li>\n";
echo "  <li>Сохраняет эту строку как текущую строку-кандидат под псевдонимом &quot;внешний&quot;.</li>\n";
echo "  <li>Затем он выполняет подзапрос. Подзапрос просматривает всю таблицу Заказов, чтобы найти строки, где значение поля cnum - такое же, как значение outer.cnum, которое в настоящее время равно 2001 - поле cnum строки \n";
echo "  Hoffman.<br>\n";
echo "  Затем он извлекает поле odate из каждой строки таблицы Заказов, для которой это верно, и формирует набор значений поля odate.</li>\n";
echo "  <li>Получив набор всех значений поля odate для поля cnum = 2001, он проверяет предикат основного запроса, чтобы увидеть, имеется ли значение на 3 \n";
echo "  октября в этом наборе.<br>\n";
echo "  Если это так (а это так), то он выбирает строку Hoffman для вывода её из основного запроса.</li>\n";
echo "  <li>Он повторяет всю процедуру, используя строку Giovanni как строку-кандидат, а затем сохраняет повторно, пока каждая строка таблицы Заказчиков не будет проверена.</li>\n";
echo "</ol>\n";
echo "<p>Как  видите, вычисления, которые SQL выполняет с помощью этих \n";
echo "простых инструкций, довольно сложны. Конечно, вы могли бы решить ту же самую \n";
echo "проблему, используя объединение следующего вида (вывод для этого запроса показан \n";
echo "на Рисунке 11.2):</p>\n";
echo "<pre>               SELECT *\n";
echo "                 FROM Customers first, Orders second\n";
echo "                 WHERE first.cnum = second.cnum\n";
echo "                    AND second.odate = 10/03/1990;</pre>\n";
echo "<p>Обратите внимание, что Cisneros был выбран дважды, по одному разу для каждого \n";
echo "заказа, который он имел для данной даты. Мы могли бы устранить это, используя \n";
echo "SELECT DISTINCT вместо просто SELECT. Но это не обязательно в варианте \n";
echo "подзапроса. Оператор IN, используемый в варианте подзапроса, не делает никакого \n";
echo "различия между значениями, которые выбираются подзапросом один раз, и \n";
echo "значениями, которые выбираются неоднократно. Следовательно, DISTINCT \n";
echo "не обязателен.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers first, Orders second          |\n";
echo "              | WHERE first.cnum = second.cnum                |\n";
echo "              | (SELECT COUNT (*)                             |\n";
echo "              | FROM Customers                                |\n";
echo "              | WHERE snum = main.snum;                       |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname                              |\n";
echo "              |  -----    --------                            |\n";
echo "              |   1001     Peel                               |\n";
echo "              |   1002     Serres                             |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 11.2 Использование объединения вместо соотнесенного подзапроса</pre>\n";
echo "<p>Предположим, что мы хотим видеть имена и номера всех продавцов, которые имеют \n";
echo "более одного заказчика. Следующий запрос выполнит это для вас (вывод показан на \n";
echo "Рисунке 11.3):</p>\n";
echo "<pre>             SELECT snum, sname\n";
echo "                FROM Salespeople main\n";
echo "                WHERE 1 &lt;\n";
echo "                    ( SELECT COUNT (*)\n";
echo "                         FROM Customers\n";
echo "                         WHERE snum = main.snum );</pre>\n";
echo "<p>Обратите внимание, что предложение FROM подзапроса в этом примере не \n";
echo "использует псевдоним. При отсутствии имени таблицы или префикса псевдонима, SQL \n";
echo "может для начала принять, что любое поле выводится из таблицы с именем, \n";
echo "указанным в предложении FROM текущего запроса. Если поле с этим именем \n";
echo "отсутствует (в нашем случае - snum ) в той таблице, SQL будет проверять внешние \n";
echo "запросы. Именно поэтому префикс имени таблицы обычно необходим в соотнесенных \n";
echo "подзапросах  для отмены этого предположения.<br>\n";
echo "Псевдонимы также часто \n";
echo "запрашиваются, чтобы дать возможность ссылаться к той же самой таблице во \n";
echo "внутреннем и внешнем запросе без какой-либо неоднозначности.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT snum sname                             |\n";
echo "              | FROM  Salespeople main                        |\n";
echo "              | WHERE 1 &lt;                                     |\n";
echo "              | AND second.odate = 10/03/1990;                |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city    rating    snum   |\n";
echo "              |  -----    --------   ----    ------   -----   |\n";
echo "              |   2001    Hoffman    London     100    1001   |\n";
echo "              |   2003    Liu        San Jose   200    1002   |\n";
echo "              |   2008    Cisneros   San Jose   300    1007   |\n";
echo "              |   2007    Pereira    Rome       100    1004   |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 11.3 Нахождение продавцов с несколькими заказчиками</pre>\n";
echo "<h3><a name=\"11.3\">И</a>СПОЛЬЗОВАНИЕ СООТНЕСЁННЫХ ПОДЗАПРОСОВ ДЛЯ ПОИСКА ОШИБОК</h3>\n";
echo "<p>Иногда полезно выполнять запросы, которые разработаны специально так, чтобы \n";
echo "находить ошибки. Это всегда возможно при появлении дефектной информации, которую \n";
echo "можно ввести в вашу БД, и, если она введена, бывает трудно её выявить. \n";
echo "Следующий запрос не должен производить никакого вывода. Он просматривает таблицу \n";
echo "Заказов, чтобы увидеть, совпадают ли поля snum и cnum в каждой строке таблицы \n";
echo "Заказчиков, и выводит каждую строку, где этого совпадения нет. Другими словами, \n";
echo "запрос выясняет, тот ли продавец кредитовал каждую продажу (он принимает поле \n";
echo "cnum как первичный ключ таблицы Заказчиков, который не будет иметь никаких \n";
echo "двойных значений в этой таблице).</p>\n";
echo "<pre>        SELECT *\n";
echo "           FROM Orders main\n";
echo "           WHERE NOT snum =\n";
echo "              (SELECT snum\n";
echo "                  FROM Customers\n";
echo "                  WHERE cnum = main.cnum);</pre>\n";
echo "<p>При использовании механизма справочной целостности (обсуждённого в\n";
echo "<a href=\"ch19.php\">Главе 19</a>), вы можете быть гарантированы от некоторых \n";
echo "ошибок такого вида. Этот механизм не всегда доступен, хотя его использование \n";
echo "желательно во всех случаях, причем поиск ошибки запроса, описанный выше, может \n";
echo "быть ещё полезнее.</p>\n";
echo "<h3><a name=\"11.4\">С</a>РАВНЕНИЕ ТАБЛИЦЫ С СОБОЙ</h3>\n";
echo "<p>Вы можете также использовать соотнесённый подзапрос, основанный на той же \n";
echo "самой таблице, что и основной запрос. Это даст вам возможность извлечь сложные формы произведённой информации. Например, мы можем найти \n";
echo "все заказы со значениями сумм приобретений выше среднего для их заказчиков \n";
echo "(вывод показан на Рисунке 11.4):</p>\n";
echo "<pre>           SELECT *\n";
echo "              FROM Orders outer\n";
echo "              WHERE amt &gt;\n";
echo "                  (SELECT AVG amt\n";
echo "                       FROM Orders inter\n";
echo "                       WHERE inner.cnum = outer.cnum);\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders outer                              |\n";
echo "              | WHERE amt &gt;                                     |\n";
echo "              | (SELECT AVG (amt)                               |\n";
echo "              | FROM Orders inner                               |\n";
echo "              | WHERE inner.cnum = outer.cnum                   |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----    --------  ----------  -----   ------  |\n";
echo "              |   3006     1098.19  10/03/1990   2008     1007  |\n";
echo "              |   3010     1309.00  10/06/1990   2004     1002  |\n";
echo "              |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "                ================================================\n";
echo "\n";
echo "		  Рисунок 11.4 Соотнесение таблицы с собой\n";
echo "</pre>\n";
echo "<p>Конечно, в нашей маленькой (психиатрической больнице) типовой таблице, где большинство заказчиков имеют \n";
echo "только один заказ, большинство значений являются одновременно средними и, \n";
echo "следовательно, не выбираются. Давайте введём команду другим способом (вывод \n";
echo "показан на Рисунке 11.5):</p>\n";
echo "<pre>              SELECT *\n";
echo "                  FROM Orders outer\n";
echo "                  WHERE amt &gt; =\n";
echo "                      (SELECT AVG (amt)\n";
echo "                          FROM Orders inner\n";
echo "                          WHERE inner.cnum = outer.cnum);\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders outer                              |\n";
echo "              | WHERE amt &gt; =                                   |\n";
echo "              | (SELECT AVG (amt)                               |\n";
echo "              | FROM Orders inner                               |\n";
echo "              | WHERE inner.cnum = outer.cnum);                 |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----    --------  ----------  -----   ------  |\n";
echo "              |   3003      767.19  10/03/1990   2001     1001  |\n";
echo "              |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "              |   3005     5160.45  10/03/1990   2003     1002  |\n";
echo "              |   3006     1098.19  10/03/1990   2008     1007  |\n";
echo "              |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "              |   3010     1309.95  10/06/1990   2004     1002  |\n";
echo "              |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "                ================================================\n";
echo "\n";
echo "	Рисунок 11.5 Выбираются заказы, которые &gt;= средней сумме приобретений их заказчиков.\n";
echo "</pre>\n";
echo "<p>Различие, конечно, в том, что реляционная операция основного предиката \n";
echo "включает значения, которые равняются среднему (что обычно означает, что они - \n";
echo "единственные заказы данных заказчиков).</p>\n";
echo "<h3><a name=\"11.5\">С</a>ООТНЕСЁННЫЕ ПОДЗАПРОСЫ В ПРЕДЛОЖЕНИИ HAVING</h3>\n";
echo "<p>Предложение HAVING может принимать подзапросы и соотнесённые подзапросы. Когда вы \n";
echo "используете соотнесённый подзапрос в предложении HAVING, вы должны ограничивать \n";
echo "внешние ссылки на позиции, которые могли бы непосредственно использоваться в \n";
echo "самом предложении HAVING. Вы помните из <a href=\"ch6.php\">Главы 6</a>, \n";
echo "что предложение HAVING может использовать только агрегатные функции, которые \n";
echo "указаны в их предложении SELECT, или поля, используемые в их предложении GROUP \n";
echo "BY. Они являются только внешними ссылками, которые вы можете делать. Всё это \n";
echo "потому, что предикат предложения HAVING оценивается для каждой группы из \n";
echo "внешнего запроса, а не для каждой строки. Следовательно, подзапрос будет \n";
echo "выполняться один раз для каждой группы, выведённой из внешнего запроса, а не для \n";
echo "каждой строки. Предположим, что вы хотите суммировать значения сумм приобретений \n";
echo "покупок из таблицы Заказов, сгруппировав их по датам, удалив все даты, где бы SUM не был по крайней мере на 2000.00 выше максимальной (MAX) суммы:</p>\n";
echo "<pre>           SELECT odate, SUM (amt)\n";
echo "              FROM Orders a\n";
echo "              GROUP BY odate\n";
echo "              HAVING SUM (amt) &gt;\n";
echo "                  ( SELECT 2000.00 + MAX (amt)\n";
echo "                       FROM Orders b\n";
echo "                       WHERE a.odate = b.odate );\n";
echo "</pre>\n";
echo "<p>Подзапрос вычисляет значение MAX для всех строк с той же самой датой, что и у \n";
echo "текущей агрегатной группы основного запроса. Это должно быть выполнено, как и \n";
echo "ранее, с использованием предложения WHERE. Сам подзапрос не должен использовать \n";
echo "предложения GROUP BY или HAVING.</p>\n";
echo "<h3><a name=\"11.6\">С</a>ООТНЕСЁННЫЕ ПОДЗАПРОСЫ И ОБЪЕДИНЕНИЯ</h3>\n";
echo "<p>Как вы и могли предположить, соотнесённые подзапросы по своей природе близки \n";
echo "объединениям - они оба включают сверку каждой строки одной таблицы с каждой \n";
echo "строкой другой (или псевдонимом) таблицы. Вы найдёте, что большинство \n";
echo "операций, которые могут выполняться с одним из них, будут также работать и с \n";
echo "другим.<br>\n";
echo "Однако в прикладной программе между ними имеется различие, такое как \n";
echo "вышеупомянутая потребность в использовании DISTINCT с объединением и его необязательность с подзапросом.<br>\n";
echo "Имеются также некоторые вещи, которые каждый \n";
echo "из них может делать так, как этого не может другой. Подзапросы, например, могут \n";
echo "использовать агрегатную функцию в предикате, делая возможным выполнение операций \n";
echo "типа нашего предыдущего примера, в котором мы извлекли заказы, усреднённые для \n";
echo "их заказчиков. Объединения, с другой стороны, могут выводить строки из обеих \n";
echo "сравниваемых таблиц, в то время как вывод подзапросов используется только в \n";
echo "предикатах внешних запросов.</p>\n";
echo "<p>Как правило форма запроса, которая кажется наиболее \n";
echo "интуитивной, будет, вероятно, лучшей в использовании, но при этом хорошо бы \n";
echo "знать обе техники для тех ситуаций, когда та или иная могут не работать.</p>\n";
echo "<h3><a name=\"11.7\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Вы можете поздравить себя с овладением большого блока понятий SQL - \n";
echo "соотнесённого подзапроса. Вы видели, как соотнесённый подзапрос связан с \n";
echo "объединением, а также - как его можно использовать с агрегатными функциями и в \n";
echo "предложении HAVING. В общем, вы теперь  знаете все типы подзапросов.<br>\n";
echo "Следующий шаг - описание некоторых специальных операторов SQL. Они берут \n";
echo "подзапросы как аргументы, как это делает IN, но, в отличие от IN, они могут \n";
echo "использоваться только в подзапросах. Первый из них представлен в\n";
echo "<a href=\"ch12.php\">Главе 12</a> и называется EXISTS.</p>\n";
echo "<h3><a name=\"11.8\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Напишите команду SELECT, использующую соотнесенный подзапрос,\n";
echo "   которая выберет имена и номера всех заказчиков с максимальными для их городов оценками.\n";
echo "\n";
echo "2. Напишите два запроса, которые выберут всех продавцов (по их имени\n";
echo "   и номеру), имеющих в своих городах заказчиков, которых они не\n";
echo "   обслуживают. Один запрос - с использованием объединения, а другой -\n";
echo "   с соотнесённым подзапросом.\n";
echo "   Которое из решений будет более изящным?\n";
echo "\n";
echo " (Подсказка: один из способов сделать это состоит в том, чтобы найти\n";
echo "  всех заказчиков, не обслуживаемых данным продавцом, и определить,\n";
echo "  находится ли каждый из них в городе продавца.)\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php\">Приложении A</a>.)</pre>\n";
echo "</body></html>\n";
require_once ("../incfiles/end.php");  

?>
