﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 4.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 4. ИСПОЛЬЗОВАНИЕ РЕЛЯЦИОННЫХ<br>\n";
echo "И БУЛЕВЫХ ОПЕРАЦИЙ ДЛЯ СОЗДАНИЯ<br>\n";
echo "БОЛЕЕ СЛОЖНЫХ ПРЕДИКАТОВ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В <a href=\"ch3.php\">Главе 3</a> вы узнали, что предикаты могут оценивать \n";
echo "равенство в операции как true/верное или false/неверное. Они могут также оценивать другие \n";
echo "виды связей, помимо равенств.</p>\n";
echo "<p>Эта глава будет исследовать другие реляционные \n";
echo "операции, используемые в SQL. Вы также узнаете, как использовать булевы операции, \n";
echo "чтобы изменять и объединять значения предиката. С помощью булевых операций  (или, \n";
echo "проще говоря, логических операций) одиночный предикат может содержать любое \n";
echo "число условий. Это позволяет  создавать очень сложные предикаты. \n";
echo "Использование круглых скобок в структуре этих сложных предикатов будет также разъясняться.</p>\n";
echo "<a name=\"4.1\"></a>\n";
echo "<h3>РЕЛЯЦИОННЫЕ ОПЕРАЦИИ</h3>\n";
echo "<p>Реляционная операция - математический символ, который указывает на \n";
echo "определённый тип сравнения двух значений. Вы уже видели, как используются \n";
echo "равенства, такие как 2 + 3 = 5 или city = &quot;London&quot;. Но имеются также и другие \n";
echo "реляционные операции. Предположим, что вы хотите видеть всех Продавцов с их \n";
echo "комиссионными, выше определенного значения. Вы можете использовать тип сравнения \n";
echo "&quot;больше чем&quot; (&gt;). Вот реляционные операции (операции \n";
echo "сравнения), которыми располагает SQL:</p>\n";
echo "<dl><dt>=</dt><dd>Равно</dd><dt>&gt;</dt><dd>Больше</dd><dt>&lt;</dt><dd>Меньше</dd>\n";
echo "<dt>&gt;=</dt><dd>Больше  или равно</dd><dt>&lt;=</dt><dd>Меньше  или равно</dd><dt>&lt;&gt;</dt><dd>Не равно</dd></dl>\n";
echo "<p>Эти операции имеют стандартное значение для чисел. Для  символов их определение зависит от формата преобразования, ASCII или EBCDIC, который вы используете.</p>\n";
echo "<p>SQL сравнивает символьные значения в терминах основных чисел, как определено в формате преобразования. Даже значение символа, такого как &quot;1&quot;, который \n";
echo "представляет число, не обязательно равняется числу, которое он представляет. Вы можете использовать реляционные операции, чтобы установить алфавитный порядок, \n";
echo "например, &quot;a&quot; &lt; &quot;n&quot;, где a идёт раньше в алфавитном порядке, но всё это \n";
echo "ограничивается с помощью параметра преобразования формата.</p>\n";
echo "<p>И в ASCII, и в EBCDIC символы сортируются по значению: символ имеет значение меньше, чем все другие символы, \n";
echo "которым он предшествует в алфавитном порядке и которые имеют с ним один вариант \n";
echo "регистра (верхний или нижний). В ASCII все символы верхнего регистра  меньше, чем все символы \n";
echo "нижнего регистра, поэтому &quot;Z&quot; &lt; &quot;a&quot;, а все числа - меньше чем все символы, \n";
echo "поэтому &quot;1&quot; &lt; &quot;Z&quot;. То же относится и к EBCDIC.</p>\n";
echo "<p>Чтобы сохранить обсуждение более \n";
echo "простым, мы допустим, что вы будете использовать текстовый формат ASCII. Проконсультируйтесь в документации вашей системы, если вы не уверены, какой \n";
echo "формат вы используете или как он работает.</p><p>Значения, сравниваемые здесь, называются скалярными значениями. Скалярные \n";
echo "значения производятся скалярными выражениями; 1 + 2 это скалярное выражение, которое производит скалярное значение 3. Скалярное значение может быть символом \n";
echo "или числом, хотя очевидно, что только числа используются с арифметическими операциями, такими как + (сложение) или * (умножение).</p>\n";
echo "<p>Предикаты обычно сравнивают значения скалярных величин, используя реляционные операции или специальные операции SQL, чтобы увидеть, верно ли это сравнение. \n";
echo "Некоторые операции/операторы SQL описаны в <a href=\"ch5.php\">Главе 5</a>.</p><p>Предположим, что вы хотите увидеть всех заказчиков с оценкой (rating) выше \n";
echo "200. Так как 200 - скалярное значение, как и значение в столбце оценки, для их сравнения вы можете использовать реляционную операцию.</p>\n";
echo "<pre>    SELECT *\n";
echo "       FROM Customers\n";
echo "       WHERE rating &gt; 200;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 4.1.</p>\n";
echo "<p>Конечно, если бы мы захотели увидеть ещё и заказчиков с оценкой, равной 200, мы \n";
echo "использовали бы предикат</p>\n";
echo "<pre>             rating &gt; = 200</pre>\n";
echo "<a name=\"4.2\"></a>\n";
echo "<h3>БУЛЕВЫ ОПЕРАЦИИ</h3>\n";
echo "<p>Основные булевы операции также распознаются в SQL. Выражения Буля являются или верными/true, или неверными/false, подобно предикатам. Булевы операции связывают одно \n";
echo "или более верных/неверных значений и производят единственное верное или неверное значение.</p>\n";
echo "<p>Стандартными булевыми операциями, распознаваемыми в SQL, являются AND, OR и NOT.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE rating &gt; 200;                           |\n";
echo "              | ============================================= |\n";
echo "              |   snum     cname    city       rating  snum   |\n";
echo "              |  -----   --------  --------   -----    -----  |\n";
echo "              |   2004     Crass    Berlin     300     1002   |\n";
echo "              |   2008     Cirneros San Jose   300     1007   |\n";
echo "                =============================================\n";
echo "\n";
echo "		 Рисунок 4.1 Использование операции &quot;больше&quot; (&gt;)</pre>\n";
echo "<p>Существуют другие, более сложные булевы операции (типа &quot;исключающее ИЛИ&quot;), но они могут быть сформированы из этих трёх простых операций - AND, OR, NOT.</p>\n";
echo "<p>Как вы можете понять, булева логика верно/неверно  основана на цифровой компьютерной операции; и фактически весь SQL (или любой другой язык) может \n";
echo "быть сведён до уровня булевой логики.</p><p>Булевы операции, и как они работают:</p>\n";
echo "<ul><li>AND берет два булевых значения (в форме A AND B) как аргументы и оценивает, верны ли они оба.</li>\n";
echo "<li>OR берет два булевых значения (в форме A OR B) как аргументы и оценивает, верен ли один из них.</li>\n";
echo "<li>NOT берет одиночное булево значение (в форме NOT A) как аргумент и заменяет его значение с неверного на верное или с верного на неверное \n";
echo "(инвертирует).</li></ul>\n";
echo "<p>Связывая предикаты с булевыми операциями, вы можете значительно расширить их возможности. Предположим, вы хотите видеть всех заказчиков в San Jose, которые \n";
echo "имеют оценку (рейтинг) выше 200:</p>\n";
echo "<pre>         SELECT  *\n";
echo "            FROM Customers\n";
echo "            WHERE city = &quot; San Jose'\n";
echo "            AND rating &gt; 200;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 4.2. Имеется только один заказчик, который удовлетворяет этому условию.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE city = 'San Jose'                       |\n";
echo "              | AND rating &gt; 200;                             |\n";
echo "              | ============================================= |\n";
echo "              |   сnum     cname    city     rating    snum   |\n";
echo "              |  ------   --------  --------  ----    -----   |\n";
echo "              |   2008     Cirneros San Jose   300     1007   |\n";
echo "                =============================================\n";
echo "\n";
echo "		   Рисунок 4.2 SELECT, использующий AND\n";
echo " </pre>\n";
echo "<p>Если  же вы используете OR, вы получите всех заказчиков, которые находились в San Jose или (OR) которые имели оценку выше 200.</p>\n";
echo "<pre>           SELECT *\n";
echo "              FROM Customers\n";
echo "              WHERE city = &quot; San Jose'\n";
echo "              OR rating &gt; 200;</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 4.3.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE city = 'San Jose'                       |\n";
echo "              | OR rating &gt; 200;                              |\n";
echo "              | ============================================= |\n";
echo "              |   сnum     cname    city     rating    snum   |\n";
echo "              |  -----    -------  --------  -----   ------   |\n";
echo "              |   2003     Liu      San Jose   200     1002   |\n";
echo "              |   2004     Grass    Berlin     300     1002   |\n";
echo "              |   2008     Cirneros San Jose   300     1007   |\n";
echo "                =============================================\n";
echo "\n";
echo "		   Рисунок 4.3 SELECT, использующий OR</pre>\n";
echo "<p>NOT может использоваться для инвертирования \n";
echo "булевых значений.</p>\n";
echo "<p>Имеется пример запроса с NOT:</p>\n";
echo "<pre>                    SELECT *\n";
echo "                       FROM Customers\n";
echo "                       WHERE city = &quot; San Jose'\n";
echo "                       OR NOT rating &gt; 200;</pre>\n";
echo "<p>Вывод этого запроса показан на Рисунке 4.4.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE city = 'San Jose'                       |\n";
echo "              | OR NOT rating &gt; 200;                          |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname    city     rating    snum   |\n";
echo "              |  ------   --------  ------   -----    -----   |\n";
echo "              |   2001     Hoffman  London     100     1001   |\n";
echo "              |   2002     Giovanni Rome       200     1003   |\n";
echo "              |   2003     Liu      San Jose   200     1002   |\n";
echo "              |   2006     Clemens  London     100     1001   |\n";
echo "              |   2008     Cirneros San Jose   300     1007   |\n";
echo "              |   2007     Pereira  Rome       100     1004   |\n";
echo "                =============================================\n";
echo "\n";
echo "		   Рисунок 4.4 SELECT, использующий NOT</pre>\n";
echo "<p>Все записи, за исключением Grass, были выбраны. Grass не был в San Jose, и его оценка была больше, чем 200, так что он потерпел неудачу при обеих проверках. В \n";
echo "каждой из других строк встретился тот или другой, или оба критерия.<br>\n";
echo "Обратите внимание, что операция NOT должна предшествовать булевой операции, чьё значение \n";
echo "должно измениться, и не должна помещаться перед реляционной операцией. Например: неправильным вводом  предиката оценки будет:</p>\n";
echo "<pre>                 rating NOT &gt; 200</pre>\n";
echo "<p>Он выдаст другую отметку. А как SQL оценит следующее?</p>\n";
echo "<pre>                   SELECT *\n";
echo "                      FROM Customers\n";
echo "                      WHERE NOT city = &quot; San Jose'\n";
echo "                      OR rating &gt; 200;</pre>\n";
echo "<p>NOT применяется здесь только к выражению city = 'SanJose', или к выражению rating &gt; 200 тоже? Как \n";
echo "уже было сказано, правильный ответ будет прежним: SQL может \n";
echo "применять NOT с булевым выражением, которое идёт  только сразу после него. Вы можете получить другой результат при команде:</p>\n";
echo "<pre>                   SELECT *\n";
echo "                      FROM Customers\n";
echo "                      WHERE NOT(city = &quot; San Jose'\n";
echo "                      OR rating &gt; 200);</pre>\n";
echo "<p>Здесь SQL понимает круглые скобки как означающие, что всё внутри них будет \n";
echo "вычисляться в первую очередь и обрабатываться как единое выражение с помощью всего, что \n";
echo "снаружи них (это является стандартной интерпретацией, как в математике). Другими словами, SQL берет каждую строку и определяет, соответствует ли истине равенство city \n";
echo "=&nbsp; 'San Jose' или равенство rating &gt; 200.<br>\n";
echo "Если любое условие верно, булево выражение  внутри круглых скобок верно. Однако, \n";
echo "если булево выражение внутри круглых скобок верно, предикат как единое целое неверен, потому что NOT преобразует верно в неверно и наоборот.</p>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 4.5. Имеется намеренно усложнённый \n";
echo "пример. Сможете ли вы проследить его логику (вывод показан на Рисунке 4.6)?</p>\n";
echo "<pre>        SELECT *\n";
echo "           FROM Orders\n";
echo "             WHERE NOT ((odate = 10/03/1990 AND snum &gt;1002)\n";
echo "                OR amt &gt; 2000.00);\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT *                                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE NOT  (city = 'San Jose'                 |\n";
echo "              | OR rating &gt; 200);                             |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname    city     rating    snum   |\n";
echo "              |  -----   --------  -------   -----   ------   |\n";
echo "              |   2001     Hoffman  London     100     1001   |\n";
echo "              |   2002     Giovanni Rome       200     1003   |\n";
echo "              |   2006     Clemens  London     100     1001   |\n";
echo "              |   2007     Pereira  Rome       100     1004   |\n";
echo "                =============================================\n";
echo "\n";
echo "	  Рисунок 4.5 SELECT, использующий NOT и вводное предложение\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders                                    |\n";
echo "              | WHERE NOT ((odate = 10/03/1990 AND snum &gt; 1002) |\n";
echo "              | OR amt &gt; 2000.00);                              |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  ------   --------  ----------  -----    -----  |\n";
echo "              |   3003      767.19  10/03/1990   2001     1001  |\n";
echo "              |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "              |   3007       75.75  10/04/1990   2004     1002  |\n";
echo "              |   3010     1309.95  10/06/1990   2004     1002  |\n";
echo "               =================================================\n";
echo "\n";
echo "		 Рисунок 4.6 Полный (комплексный) запрос</pre>\n";
echo "<p>Несмотря на то что булевы операции по отдельности просты, они не так просты, когда комбинируются в комплексное выражение.</p>\n";
echo "<p>Способ оценки булева комплекса  состоит в том, чтобы оценивать булевы выражения, наиболее глубоко вложенные в круглых скобках, объединять их в \n";
echo "единое булево значение, а затем объединять его с вышележащими значениями.</p><p>\n";
echo "Вот подробное объяснение того, как пример выше был вычислен. Наиболее \n";
echo "глубоко вложенные булевы выражения, в предикате это odate = 10/03/1990 и snum &gt; 1002, \n";
echo "объединяются с помощью AND, формируя одно булево выражение, которое \n";
echo "будет оценено как верное для всех строк, в которых встретились оба эти условия. Это составное булево выражение (которое мы будем называть булево номер 1, или B1, \n";
echo "для краткости) объединяется с выражением (amt) &gt; 2000.00 (B2) с помощью OR, формируя третье выражение (B3), которое является верным для данной строки, если \n";
echo "или B1 или B2  верны для этой строки.</p><p>B3 полностью содержится в круглых скобках, которым предшествует NOT, формируя \n";
echo "последнее булево выражение  (B4), которое является условием предиката.</p><p>Таким образом, B4 - предикат запроса - будет верен всякий раз, когда B3 \n";
echo "неправилен. B3  неправилен всегда, когда B1 и B2 оба неверны. B1 неправилен для строки, если дата  строки заказа не 10/03/1990 или если значение snum не \n";
echo "больше, чем 1002. B2 неправилен для всех строк, значение суммы приобретений которых не превышает 2000.00. Любая строка со значением выше 2000.00 сделает B2  \n";
echo "верным; в результате B3 будет верен, а B4 - нет. Следовательно, все эти строки будут удалены из вывода.</p>\n";
echo "<p>Из оставшихся, строки, которые на 3 октября имеют snum &gt; 1002 (такие как строки для onum 3001 на 3 \n";
echo "октября с snum = 1007), делают B1 верным с помощью \n";
echo "верного B3 и неверного предиката запроса. Они будут также удалены из вывода. Вывод показан для строк, которые оставлены.<a name=\"4.3\"></a></p>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>В этой главе вы значительно расширили ваше знакомство с предикатами. Теперь вы можете находить значения, которые связаны с данным значением любым способом, \n";
echo "определяемым различными реляционными операциями.</p><p>Вы можете также использовать булевы операции AND и OR, чтобы \n";
echo "несколько условий, \n";
echo "каждое из которых автономно в предикатах, объединять в единый предикат.</p><p>Булева операция NOT, как вы уже видели, может изменять значение условия или \n";
echo "группы условий на противоположное.</p><p>Булевы и Реляционные операции могут эффективно управляться с помощью круглых \n";
echo "скобок, которые определяют порядок, в котором операции будут выполнены. Эти операции применимы к любому уровню сложности, и вы поняли, как сложные условия \n";
echo "могут создаваться из этих простых частей.</p><p>Теперь, когда мы показали, как \n";
echo "используются стандартные математические операции, мы можем перейти к операциям \n";
echo "которые являются специфичными для SQL. Это мы сделаем в <a href=\"ch5.php\">Главе 5</a>.</p>\n";
echo "<a name=\"4.4\"></a>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<ol><li>  <pre>Напишите запрос, который может выдать вам все заказы со значениями суммы выше $1,000.</pre></li>\n";
echo "<li><pre>Напишите запрос, который может выдать вам поля sname и city для всех продавцов\n";
echo "в Лондоне с комиссионными выше .10.</pre></li>\n";
echo "<li><pre>Напишите запрос к таблице Заказчиков, чей вывод включит всех заказчиков\n";
echo "с оценкой =&lt; 100, если они не находятся в Риме.</pre></li>\n";
echo "<li><pre>Что может быть выведено в результате следующего запроса?</pre>\n";
echo "  <pre>              SELECT *\n";
echo "                 FROM Orders\n";
echo "                 WHERE (amt &lt; 1000 OR\n";
echo "                     NOT (odate = 10/03/1990\n";
echo "                         AND cnum &gt; 2003));</pre></li>\n";
echo "<li><pre>Что может быть выведено в результате следующего запроса?</pre>\n";
echo "  <pre>              SELECT *\n";
echo "                 FROM Orders\n";
echo "                 WHERE NOT ((odate = 10/03/1990 OR snum &gt; 1006)\n";
echo "                    AND amt &gt; = 1500 );</pre></li>\n";
echo "<li><pre>Как можно проще переписать такой запрос?</pre>\n";
echo "  <pre>              SELECT snum, sname, city, comm\n";
echo "                 FROM Salespeople\n";
echo "                 WHERE (comm &gt; + .12 OR\n";
echo "                    comm &lt; .14);</pre></li></ol>\n";
echo "<pre>(См. ответы в<a href=\"a.php#4\"> Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
