﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 25.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 25. ИСПОЛЬЗОВАНИЕ SQL С ДРУГИМ ЯЗЫКОМ (ВЛОЖЕННЫЙ/ВСТРОЕННЫЙ SQL)</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе вы узнаете, как SQL используется для расширения программ, написанных на других языках. Хотя непроцедурность языка SQL делает его очень мощным, \n";
echo "одновременно это накладывает на него большое \n";
echo "количество ограничений. Чтобы преодолеть эти ограничения, вы можете включать SQL в программы, написанные на том или \n";
echo "ином процедурном языке (имеющем определённый алгоритм).<br>\n";
echo "Для наших примеров мы выбрали Паскаль, считая, что\n";
echo "этот язык наиболее прост в понимании для начинающих, и ещё потому, что Паскаль - один из языков, для которых ANSI имеет полуофициальный стандарт.</p>\n";
echo "<a name=\"25.1\"></a>\n";
echo "<h3>ЧТО ТАКОЕ - ВЛОЖЕНИЕ SQL?</h3>\n";
echo "<p>Чтобы вложить SQL в другой язык, вы должны использовать пакет программ, который  обеспечивал бы поддержку вложения SQL в этот язык и,\n";
echo "конечно же, поддержку самого языка. Естественно, вы должны быть знакомы с языком, \n";
echo "который вы используете.</p>\n";
echo "<p>В основном вы будете использовать команды SQL для работы в таблицах баз данных, передачи\n";
echo "результатов вывода в программу и получение ввода из программы, в которую они вкладываются, обобщённо ссылаясь к главной программе\n";
echo "(которая может или не может принимать их из диалога или посылать обратно в диалог пользователя и программы).</p>\n";
echo "<a name=\"25.2\"></a>\n";
echo "<h3>ЗАЧЕМ ВКЛАДЫВАТЬ SQL?</h3>\n";
echo "<p>Хотя мы и потратили некоторое время на то, чтобы показать возможности SQL, но, если вы - опытный программист, вы, вероятно, отметили, что\n";
echo "сам по себе он не очень полезен при написании программ. Самое очевидное ограничение -  то, что, в то время как SQL может сразу выполнить пакет команды, интерактивный SQL в основном выполняет\n";
echo "по одной команде в каждый момент времени.</p>\n";
echo "<p>Логические конструкции типа if ... then (&quot;если ... то&quot;), for ... do\n";
echo "(&quot;для ... выполнить&quot;) и while ... repeat (&quot;пока ... повторять&quot;), используемые для структур большинства компьютерных программ, здесь отсутствуют, так что вы не сможете принять решение - выполнять ли, как выполнять или как долго выполнять одно действие в результате другого действия. Кроме того, интерактивный SQL не может делать \n";
echo "ничего со значениями, кроме ввода их в таблицу, размещения или распределения их с помощью запросов и, конечно, вывода их на какое-то устройство.</p>\n";
echo "<p>Более традиционные языки, однако,  разработаны так, чтобы программист мог начинать обработку данных \n";
echo "и, основываясь на её результатах, решать, делать ли  то действие или другое, или же повторять действие до тех \n";
echo "пор, пока не встретится некоторое условие, создавая логические маршруты и циклы. Значения сохраняются в переменных, которые могут использоваться и изменяться с помощью любого\n";
echo "числа команд. Это даёт вам возможность указывать пользователям на ввод или вывод этих команд из файла и возможность форматировать вывод сложными способами (например, \n";
echo "преобразовывать числовые данные в диаграммы).</p>\n";
echo "<p>Цель вложенного SQL состоит в том, чтобы объединить эти возможности, позволяющие вам создавать сложные процедурные программы, которые \n";
echo "адресуют базу данных (БД) посредством SQL, позволяя  устранить сложные действия в таблицах на процедурном языке, который не ориентирован на такую структуру данных, в то же время поддерживая структурную\n";
echo "строгость процедурного языка.</p>\n";
echo "<a name=\"25.3\"></a>\n";
echo "<h3>КАК ДЕЛАЕТСЯ ВЛОЖЕНИЕ SQL?</h3>\n";
echo "<p>Команды SQL помещаются в исходный текст главной программы; им предшествует фраза EXEC SQL (EXECute SQL). Далее устанавливаются некоторые команды, которые являются специальными для вложенной\n";
echo "формы SQL и которые будут рассмотрены в этой главе.</p>\n";
echo "<p>Строго говоря, стандарт ANSI не поддерживает вложенный SQL как таковой. Он поддерживает понятие, называемое \n";
echo "&quot;модуль&quot;, которое, более точно, является вызываемым набором процедур SQL, а не вложением в другой язык. Официальное определение синтаксиса вложения SQL будет включать\n";
echo "расширение официального синтаксиса каждого языка, в который может вкладываться SQL, что весьма долгая и неблагодарна \n";
echo "работа, которой ANSI избегает. Однако ANSI обеспечивает четыре приложения (не являющиеся \n";
echo "частью стандарта), которые определяют синтаксис вложения SQL для четырех языков: КОБОЛ, ПАСКАЛЬ, ФОРТРАН и ПЛ/1.</p>\n";
echo "<p>Язык C так же широко поддерживается, как и другие языки. Когда вы вставляете команды SQL в текст программы, написанной на другом языке, вы должны выполнить прекомпиляцию, прежде чем вы окончательно её скомпилируете.</p>\n";
echo "<p>Программа, называемая прекомпилятором (или препроцессором), будет просматривать текст вашей программы и преобразовывать команды SQL \n";
echo "в форму, удобную для использования базовым языком.</p>\n";
echo "<p>Затем вы используете обычный транслятор, чтобы преобразовывать программу из исходного текста в исполняемый код.</p>\n";
echo "<p>Согласно подходу к модульному языку, определённому ANSI, основная программа вызывает процедуры SQL. Процедуры выбирают параметры из главной программы и возвращают уже обработанные значения обратно в основную программу. Модуль может содержать любое число процедур, каждая из\n";
echo "которых состоит из одиночной команды SQL. Идея в том, чтобы процедуры могли работать тем же самым способом, что и процедуры на языке, в который они были вложены (хотя модуль ещё должен идентифицировать базовый\n";
echo "язык из-за различий в типах данных различных языков).</p>\n";
echo "<p>Реализации могут удовлетворить стандарту, выполнив вложение SQL таким \n";
echo "способом, как если бы модули уже были точно определены. Для этой цели прекомпилятор будет создавать модуль, называемый модулем доступа. Только \n";
echo "один модуль, содержащий любое число процедур SQL, может существовать для данной программы. Размещение операторов SQL непосредственно в главном коде происходит более просто и более практично, чем непосредственно\n";
echo "создание самих модулей.</p><p>Каждая из программ, использующих вложение SQL, связана с ID доступа \n";
echo "во время её выполнения. ID доступа, связанный с программой, должен иметь все привилегии, чтобы выполнять операции SQL в программе. \n";
echo "Вообще-то вложенная программа SQL регистрируется в БД, так же как и пользователь, выполняющий программу. Более подробно это определяет проектировщик, но, вероятно, было бы неплохо  включить в вашу программу команду CONNECT или ей подобную.</p>\n";
echo "<a name=\"25.4\"></a>\n";
echo "<h3>ИСПОЛЬЗОВАНИЕ ПЕРЕМЕННЫХ ОСНОВНОГО ЯЗЫКА В SQL </h3>\n";
echo "<p>Основной способ, которым SQL и части базового языка ваших программ будут связываться друг с другом -  значения \n";
echo "переменных. Естественно, что разные языки распознают различные типы данных для \n";
echo "переменных. ANSI определяет эквиваленты SQL для четыре базовых языков: ПЛ/1, Паскаль, КОБОЛ и ФОРТРАН; всё это подробно описано в \n";
echo "<a href=\"b.php\">Приложении B</a>. \n";
echo "Эквиваленты для других языков определяет проектировщик.</p><p>Имейте в виду, что такие типы как DATE не распознаются ANSI, и, \n";
echo "следовательно, никакие эквивалентные типы данных для базовых языков не существуют в стандарте ANSI. Более сложные типы данных базового \n";
echo "языка, такие как матрицы, не имеют эквивалентов в SQL. Вы можете использовать переменные из главной программы во вложенных операторах SQL везде, где вы будете использовать выражения значений. (SQL, используемый в этой главе, будет пониматься как вложенный SQL до тех пор, пока это не будет оговорено особо.)</p>\n";
echo "<p>Текущим значением переменной может быть значение, используемое в команде. Главные переменные должны:</p>\n";
echo "<ul><li>быть объявленными в SQL DECLARE SESSION (РАЗДЕЛ ОБЪЯВЛЕНИЙ), который будет описан далее;</li>\n";
echo "<li>иметь совместимый тип данных с их функциями в команде SQL (например, числовой тип, если он вставляется в числовое поле);</li>\n";
echo "<li>быть присвоенными значению во время их использования в команде SQL, если команда SQL самостоятельно не может сделать назначение;</li>\n";
echo "<li>предшествовать двоеточию (:), когда они упоминаются в команде SQL.</li></ul>\n";
echo "<p>Так как главные переменные отличаются от имён столбцов SQL наличием у них двоеточия, вы можете использовать переменные с теми же самыми \n";
echo "именами, что и ваши столбцы, если это, конечно, нужно.</p>\n";
echo "<p>Предположим, что у вас есть четыре переменные с именами id_num, salesperson, loc и comm. Они содержат значения, \n";
echo "которые вы хотите вставить в таблицу Продавцов. Вы могли бы вложить следующую команду SQL в вашу программу:</p>\n";
echo "<pre>      EXEC SQL INSERT INTO Salespeople\n";
echo "         VALUES (:id_num, :salesperson, :loc, :comm)</pre>\n";
echo "<p>Текущие значения этих переменных будут помещены в таблицу. Как  видите, переменная comm имеет то же самое имя, что и столбец, в \n";
echo "который это значение вкладывается. Обратите внимание, что точка с запятой в конце команды отсутствует. Это \n";
echo "потому, что соответствующее завершение для вложенной команды SQL зависит от языка, для которого делается вложение.</p>\n";
echo "<p>Для Паскаля и PL/1 это будет точка с запятой, для КОБОЛА - слово END-EXEC, а для ФОРТРАНА не будет никакого завершения. \n";
echo "В других языках это зависит от реализации, и поэтому мы договоримся, \n";
echo "что будем использовать точку с запятой (в этой книге) всегда, чтобы не \n";
echo "противоречить интерактивному SQL и Паскалю. Паскаль завершает вложенный SQL и собственные команды одинаково: точкой с запятой.\n";
echo "Способ сделать команду полностью такой, как описано выше, состоит в том, чтобы включать её в цикл и повторять её с различными значениями переменных, как показано в следующем примере:</p>\n";
echo "<pre>        while not end-ot-file (input) do\n";
echo "           begin\n";
echo "           readln (id_num, salesperson, loc, comm);\n";
echo "           EXEC SOL INSERT INTO Salespeople\n";
echo "              VALUES (:id_num, :salesperson, :loc, :comm);\n";
echo "           end;</pre>\n";
echo "<p>Фрагмент программы на ПАСКАЛЕ определяет цикл, который будет считывать значения из файла, сохранять их в четырёх именованных \n";
echo "переменных, сохранять значения этих переменных в таблице Продавцов, а затем считывать следующие четыре значения, повторяя этот процесс \n";
echo "до тех пор, пока весь входной файл не будет прочитан. Считается, что каждый набор значений завершается возвратом каретки (для не знакомых\n";
echo "с Паскалем: функция readln считывает вводимую информацию и переходит на следующую строку источника этой информации). Это дает вам \n";
echo "простой способ передать данные из текстового файла в реляционную структуру.</p>\n";
echo "<p>Конечно, вы можете сначала обработать данные любыми возможными \n";
echo "способами на вашем главном языке, например, для исключения всех комиссионных ниже значения .12</p>\n";
echo "<pre>          while not end-ot-file (input) do\n";
echo "             begin\n";
echo "             readln (id_num, salesperson, loc, comm);\n";
echo "             if comm &gt; = .12 then\n";
echo "             EXEC SQL INSERT INTO Salespeople\n";
echo "                VALUES (:id_num, :salesperson, :loc, :comm);\n";
echo "             end;</pre>\n";
echo "<p>Только строки, которые выполнят условие comm &gt;= .12, будут вставлены в вывод. Это показывает, что можно использовать и циклы, и условия как \n";
echo "нормальные для главного языка.</p>\n";
echo "<a name=\"25.5\"></a>\n";
echo "<h3>ОБЪЯВЛЕНИЕ ПЕРЕМЕННЫХ</h3>\n";
echo "<p>Все переменные, на которые имеется ссылка в предложениях SQL, должны сначала быть объявлены в SQL DECLARE SECTION (РАЗДЕЛЕ ОБЪЯВЛЕНИЙ), использующем обычный синтаксис главного языка. Вы можете иметь любое число таких разделов в программе, и они могут размещаться где-нибудь в коде перед используемой переменной, подчиняясь ограничениям, определённым в соответствии с главным языком.</p>\n";
echo "<p>Раздел объявлений должен начинаться и кончаться вложенными командами SQL: BEGIN DECLARE SECTION (Начало Раздела Объявлений) \n";
echo "и END DECLARE SECTION (Конец Раздела Объявлений), которым предшествует, как обычно, EXEC SQL (Выполнить \n";
echo "SQL).</p>\n";
echo "<p>Чтобы объявить переменные, используемые в предыдущем примере, вы можете ввести следующее:</p>\n";
echo "<pre>          EXEC SQL BEGIN DECLARE SECTION;\n";
echo "          Var\n";
echo "             id-num:       integer;\n";
echo "             Salesperson:  packed array (1 . .10) ot char;\n";
echo "             loc:            packed array (1. .10) ot char;\n";
echo "             comm:         real;\n";
echo "          EXEC SQL END DECLARE SECTION;</pre>\n";
echo "<p>Для не знакомых с ПАСКАЛем: Var это заголовок, который предшествует ряду объявляемых переменных и упакованным (или распакованным) массивам, являющимися серией фиксированных переменных значений, различаемых с помощью номеров (например, третий символ loc будет loc (3)).\n";
echo "Использование точки с запятой после каждой переменной указывает на то, что это - Паскаль, а не SQL.</p>\n";
echo "<a name=\"25.6\"></a>\n";
echo "<h3>ИЗВЛЕЧЕНИЕ ЗНАЧЕНИЙ ПЕРЕМЕННЫХ</h3>\n";
echo "<p>Кроме помещения значений переменных в таблицы с помощью команды \n";
echo "SQL, вы можете использовать SQL для получения значений этих переменных.<br>\n";
echo "Один из способов \n";
echo "сделать это - с помощью разновидности команды SELECT, которая содержит предложение INTO. Давайте вернемся\n";
echo "к нашему предыдущему примеру и переместим строку Peel из таблицы Продавцов в наши переменные главного языка.</p>\n";
echo "<pre>             EXEC SQL SELECT snum, sname, city, comm\n";
echo "               INTO :id_num, :salesperson, :loc, :comm\n";
echo "               FROM Salespeople\n";
echo "               WHERE snum = 1001;</pre>\n";
echo "<p>Выбранные значения помещаются в переменные с упорядоченными именами, указанными в предложении INTO. Разумеется, переменные с именами, указанными в предложении INTO, должны иметь соответствующий\n";
echo "тип, чтобы принять эти значения, и должна быть своя переменная для каждого выбранного столбца. \n";
echo "Если не учитывать присутствие предложения INTO, то этот запрос  похож на любой другой. Однако предложение INTO добавляет значительное ограничение к запросу. Запрос должен извлекать не более одной строки. Если он извлекает много строк, все они не могут быть вставлены\n";
echo "одновременно в одну и ту же переменную. Команда, естественно, потерпит неудачу.</p>\n";
echo "<p>По этой причине, SELECT INTO должна использоваться \n";
echo "только при следующих условиях:</p>\n";
echo "<ul><li>когда вы используете предикат, проверяющий значения, которые, как вы знаете, могут быть уникальным, как в этом примере. Значения, которые,\n";
echo "как вы знаете, могут быть уникальными, это те значения, которые имеют принудительное ограничение уникальности или уникальный индекс,\n";
echo "как это говорилось в Главах <a href=\"ch17.php\">17</a> и <a href=\"ch18.php\">18</a>;</li>\n";
echo "<li>когда вы используете одну или более агрегатных функций и не используете GROUP BY;</li>\n";
echo "<li>когда вы используете SELECT DISTINCT во внешнем ключе с предикатом, ссылающимся на единственное значение родительского ключа\n";
echo "(обеспечивая вашей системе предписание справочной целостности), как в следующем примере:</li></ul>\n";
echo "<pre>           EXEC SQL SELECT DISTINCT snum\n";
echo "             INTO :salesnum\n";
echo "             FROM Customers\n";
echo "             WHERE snum =\n";
echo "               (SELECT snum\n";
echo "                   FROM Salespeople\n";
echo "                   WHERE sname = 'Motika');</pre>\n";
echo "<p>Предполагалось что Salespeople.sname и Salespeople.snum это, соответственно, уникальный и первичный ключи этой таблицы, а Customers.snum\n";
echo "-  внешний ключ, ссылающийся на Salespeople.snum, и вы предполагали, что этот запрос произведёт единственную строку.</p>\n";
echo "<p>Имеются другие случаи, когда вы знаете, что запрос должен произвести единственную строку вывода, но они мало известны, и в большинстве случаев вы основываетесь на том, что ваши данные имеют целостность, которая не может быть предписана с помощью ограничений. Не\n";
echo "полагайтесь на это! Вы создаёте программу, которая, вероятно, будет использоваться в течение некоторого времени, и лучше всего проиграть её,\n";
echo "чтобы иметь гарантированное отсутствие в будущем  возможных отказов. Во всяком случае, нет необходимости группировать запросы, которые производят\n";
echo "одиночные строки, поскольку SELECT INTO используется только для удобства.</p>\n";
echo "<p>Как вы увидите,  можно использовать запросы, выводящие многочисленные строки, с помощью курсора.</p>\n";
echo "<a name=\"25.7\"></a>\n";
echo "<h3>КУРСОР</h3>\n";
echo "<p>Одно из сильных качеств SQL -  способность функционировать на всех строках таблицы, чтобы найти определенное условие как блок \n";
echo "&quot;запись&quot;, \n";
echo "не зная сколько таких строк там может быть. Если десять строк удовлетворяют предикату, то запрос может вывести все десять строк. Если десять\n";
echo "миллионов строк определены, все десять миллионов строк будут выведены. Это несколько затруднительно, когда вы попробуете связать это с другими \n";
echo "языками. Как вы сможете назначать вывод запроса для переменных, когда не знаете, насколько велик будет вывод? Решение состоит в том, чтобы использовать то, что называется курсором.\n";
echo "Вы, вероятно, знакомы с курсором - мигающей черточкой, которая отмечает вашу позицию на экране компьютера. Вы можете рассматривать\n";
echo "SQL-курсор как устройство, которое, аналогично этому, отмечает ваше место в выводе запроса, хотя аналогия не полная.</p>\n";
echo "<p>Курсор это вид переменной, которая связана с запросом. Значением этой переменной может быть каждая строка, которая выводится при запросе.\n";
echo "Подобно главным переменным, курсоры должны быть объявлены, прежде чем они будут использованы. Это делается командой DECLARE CURSOR \n";
echo "следующим образом:</p>\n";
echo "<pre>                EXEC SQL DECLARE CURSOR Londonsales FOR\n";
echo "                  SELECT *\n";
echo "                  FROM Salespeople\n";
echo "                  WHERE city = 'London';</pre>\n";
echo "<p>Запрос не выполнится немедленно; он только определяется.</p>\n";
echo "<p>Курсор немного напоминает представление, в котором курсор содержит запрос, \n";
echo "а содержание курсора  напоминает любой вывод запроса каждый раз, когда курсор становится открытым. Однако, в отличие от базовых таблиц или представлений, \n";
echo "строки курсора упорядочены: имеются первая, вторая ... и последняя строка курсора. Этот порядок может быть произвольным, \n";
echo "с явным управлением с помощью предложения ORDER BY в запросе, или же по умолчанию следовать какому-то упорядочиванию, определяемому инструментально определяемой схемой.\n";
echo "Когда вы ищете точку в вашей программе, в которой вы хотите выполнить запрос, вы открываете курсор с помощью следующей команды:</p>\n";
echo "<pre>       EXEC SQL OPEN CURSOR Londonsales;</pre>\n";
echo "<p>Значения в курсоре могут быть получены, когда вы выполняете именно эту команду, но не предыдущую команду DECLARE и не последующую \n";
echo "команду FETСH. Затем вы используете команду FETCH, чтобы извлечь вывод из этого запроса, по одной строке в каждый момент времени.</p>\n";
echo "<pre>       EXEC SQL FETCH Londonsales INTO :id_num,\n";
echo "        :salesperson, :loc, :comm;</pre>\n";
echo "<p> Это выражение переместит значения из первой выбранной строки в переменные. Другая команда FETCH выводит следующий набор значений. Идея состоит в том, чтобы поместить команду FETCH внутрь цикла\n";
echo "так, чтобы, выбрав строку, вы могли, переместив набор значений из этой строки в переменные, возвращаться обратно в цикл, чтобы переместить \n";
echo "следующий набор значений в те же самые переменные.</p>\n";
echo "<p> Например, возможно, вам нужно, чтобы вывод выдавался по одной строке, \n";
echo "спрашивая каждый раз у пользователя, хочет ли он продолжить, чтобы увидеть следующую строку</p>\n";
echo "<pre>         Look_at_more:= True;\n";
echo "            EXEC SQL OPEN CURSOR Londonsales;\n";
echo "             while Look_at_more do\n";
echo "               begin\n";
echo "               EXEC SQL FETCH Londonsales\n";
echo "               INTO :id_num, :Salesperson, :loc, :comm;\n";
echo "               writeln (id_num, Salesperson, loc, comm);\n";
echo "               writeln ('Do you want to see more data? (Y/N)');\n";
echo "               readln (response);\n";
echo "               it response = 'N' then Look_at_more: = False\n";
echo "               end;\n";
echo "            EXEC SQL CLOSE CURSOR Londonsales;</pre>\n";
echo "<p>В Паскале знак : = означает &quot;является назначенным значением из&quot;,\n";
echo "в то время как = ещё имеет обычное значение &quot;равно&quot;. Функция writeln записывает её вывод, а затем переходит к новой строке. \n";
echo "Одиночные кавычки вокруг символьных значений во втором writeln и в предложении if ... then обычны для Паскаля, что случается при \n";
echo "дубликатах в SQL.</p><p>В результате выполнения этого фрагмента, булева переменная с именем Look_at _more должна быть установлена в состояние верно, открыт курсор, и \n";
echo "запущен цикл. Внутри цикла строка выбирается из курсора и выводится на экран. У пользователя спрашивают, хочет ли он видеть следующую \n";
echo "строку. Пока он не ответил N (Нет), цикл повторяется, и следующая строка значений будет выбрана.</p>\n";
echo "<p>Хотя переменные Look_at_more и ответ должны быть объявлены как булева переменная и символьная (char) переменная, соответственно, в \n";
echo "разделе объявлений переменных в Паскаля, они не должны быть включены в раздел объявлений SQL, потому что они не используются в командах SQL.</p>\n";
echo "<p>Как видите, двоеточия перед именами переменных не используются для не-SQL операторов. \n";
echo "Также обратите внимание, что имеется оператор CLOSE CURSOR, соответствующий оператору OPEN\n";
echo "CURSOR. Он, как вы поняли, освобождает курсор значений, поэтому запрос  нужно будет выполнить повторно с оператором OPEN CURSOR, \n";
echo "прежде чем перейти в выбору следующих значений. Это не обязательно для тех строк, которые были выбраны запросом после закрытия курсора, хотя это и обычная процедура.\n";
echo "Пока курсор закрыт, SQL не следит за тем, какие строки  выбраны. Если вы открываете курсор снова, запрос повторно выполняется с этой \n";
echo "точки, и вы начинаете всё сначала.</p>\n";
echo "<p>Этот пример не обеспечивает автоматический выхода из цикла, когда \n";
echo "все строки уже будут выбраны. Когда у FETCH нет больше строк которые надо извлекать, он просто не меняет значений в переменных предложения INTO. \n";
echo "Следовательно, если данные исчерпались, эти переменные будут неоднократно \n";
echo "выводиться с идентичными значениями до тех пор, пока пользователь не завершит \n";
echo "цикл, введя ответ N.</p>\n";
echo "<a name=\"25.8\"></a>\n";
echo "<h3>SQLCODE</h3>\n";
echo "<p>Хорошо было бы знать, когда данные будут исчерпаны,  чтобы можно было сообщить об этом пользователю, и цикл завершился бы автоматически. \n";
echo "Это даже более важно, чем, например, знать, что команда SQL выполнена с ошибкой. Переменная SQLCODE (называемая еще SQLCOD в \n";
echo "ФОРТРАНе) предназначена для того, чтобы обеспечить эту функцию. Она должна быть определена как переменная главного языка и должна иметь\n";
echo "тип данных, который в главном языке соответствует одному из точных числовых типов SQL, как это показано в <a href=\"b.php\">Приложении B</a>. \n";
echo "Значение SQLCODE устанавливается каждый раз, когда выполняется команда SQL.</p>\n";
echo "<p>В основном существуют три возможности:</p>\n";
echo "<ol><li>Команда выполнилась без ошибки, но не произвела никакого действия. Для различных команд это выглядит по разному:<br>\n";
echo "а) Для SELECT, ни одна строка не выбрана запросом.<br>б) Для FETCH, последняя строка уже была выбрана, или ни \n";
echo "одной строки не выбрано запросом в курсоре.<br>в) Для INSERT, ни одной строки не было вставлено (подразумевается, что запрос использовался, чтобы сгенерировать значения для вставки, и был отвергнут при попытке извлечения любой строки.<br>\n";
echo "г) Для UPDATE и DELETE, ни одна строка не ответила условию предиката и, следовательно, никаких изменений  в таблице \n";
echo "сделано не будет. В любом случае будет установлен код SQLCODE = 100.</li>\n";
echo "<li>Команда выполнилась нормально, не удовлетворив ни одному из вышеуказанных условий. В этом случае будет установлен код SQLCOD = 0.</li>\n";
echo "<li>Команда сгенерировала ошибку. Если это случилось, изменения, сделанные в БД текущей транзакцией, будут восстановлены (см.\n";
echo "<a href=\"ch23.php\">Главу 23</a>). В этом случае будет установлен код SQLCODE = некоторому отрицательному числу, определяемому проектировщиком. Задача этого числа\n";
echo "- идентифицировать проблему так точно, насколько это возможно. В принципе, ваша система должна быть снабжена подпрограммой, которая в этом случае должна выполниться, чтобы выдать для вас информацию, \n";
echo "расшифровывающую значение негативного числа, определенного вашим проектировщиком. В этом случае некоторое сообщение об ошибке будет выведено на экран или записано в файл протокола, а программа в это время \n";
echo "выполнит восстановление изменений для текущей транзакции, откл&#x0301;ючится от базы данных и выйдет из нее.</li></ol>\n";
echo "<a name=\"25.9\"></a>\n";
echo "<h3>ИСПОЛЬЗОВАНИЕ SQLCODE ДЛЯ УПРАВЛЕНИЯ ЦИКЛАМИ</h3>\n";
echo "<p>Теперь мы можем усовершенствовать наш предыдущий пример для выхода из цикла автоматически, при условии что курсор пуст, все строки выбраны или произошла ошибка:</p>\n";
echo "<pre>            Look_at_more: = lhe;\n";
echo "            EXEC SQL OPEN CURSOR Londonsales;\n";
echo "              while Look_at_more\n";
echo "              and SQLCODE = O do\n";
echo "                begin\n";
echo "                EXEC SQL FETCH London$ales\n";
echo "                   INTO :id_num, :Salesperson, :loc, :comm;\n";
echo "                writeln (id_num, Salesperson, loc, comm);\n";
echo "                writeln ('Do you want to see more data? (Y/N)');\n";
echo "                readln (response);\n";
echo "                If response = 'N' then Look_at_more: = Fabe;\n";
echo "                end;\n";
echo "            EXEC SQL CLOSE CURSOR Londonsales;</pre>\n";
echo "<a name=\"25.10\"></a>\n";
echo "<h3>ПРЕДЛОЖЕНИЕ WHENEVER</h3>\n";
echo "<p>Это удобно для выхода при выполненном условии, что все строки выбраны. Но если вы получили ошибку, вы должны предпринять нечто такое, что \n";
echo "описано для третьего случая, выше. Для этой цели, SQL предоставляет \n";
echo "предложение GOTO. Фактически SQL позволяет вам применять его достаточно широко, так что программа может выполнить команду GOTO \n";
echo "автоматически, если будет произведено определенное значение SQLCODE.</p>\n";
echo "<p>Вы можете сделать это совместно с предложением WHENEVER.\n";
echo "Вот блок из примера для этого случая:</p>\n";
echo "<pre>  EXEC SQL WHENEVER SQLERROR GOTO Error_handler;\n";
echo "  EXEC SQL WHENEVER NOT FOUND CONTINUE;</pre>\n";
echo "<p>SQLERROR это другой способ сообщить, что SQLCODE &lt; 0; а NOT FOUND это другой способ сообщить, что SQLCODE \n";
echo "= 100. (Некоторые реализации называют последний случай ещё SQLWARNING.)<br>\n";
echo "Error_handler это имя того места в программе, в которое будет передано выполнение программы, если произошла ошибка (GOTO может \n";
echo "состоять из одного или двух слов). Такое место определяется любым способом главного языка, например, с помощью метки в Паскале или имени раздела или имени параграфа в КОБОЛе (в\n";
echo "дальнейшем мы будем использовать термин &quot;метка&quot;). Метка более удачно идентифицирует стандартную процедуру, распространяемую проектировщиком для включения во все программы.</p>\n";
echo "<p>CONTINUE не делает чего-то специального для значения SQLCODE. Оно \n";
echo "также является значением по умолчанию, если вы не используете команду WHENEVER, определяющую значение SQLCODE. Однако эти неактивные \n";
echo "определения дают вам возможность переключаться вперёд и назад, выполняя и не выполняя действия в различных точках (метках) вашей программы.<br>\n";
echo "Например, если ваша программа включает в себя несколько команд INSERT, использующих запросы, которые реально должны производить значения, вы \n";
echo "могли бы напечатать специальное сообщение или сделать что-то такое, что поясняло бы, что запросы возвращаются пустыми и никакие значения не были вставлены. В этом случае, вы можете ввести следующее:</p>\n";
echo "<pre> EXEC SQL WHENEVER NOT FOUND GOTO No_rows;</pre>\n";
echo "<p>No_rows это метка в некотором коде, содержащем определенное действие. С другой стороны, если вам нужно сделать выборку в программе позже, \n";
echo "вы можете ввести следующее в этой точке:</p>\n";
echo "<pre> EXEC SQL WHENEVER NOT FOUND CONTINUE;</pre>\n";
echo "<p>чтобы выполнение выборки повторялось до тех пор, пока все строки не будут извлечены, что является нормальной процедурой не требующей специальной обработки.</p>\n";
echo "<a name=\"25.11\"></a>\n";
echo "<h3>МОДИФИЦИРОВАНИЕ КУРСОРОВ</h3>\n";
echo "<p>Курсоры могут также быть использованы, чтобы выбирать группу строк из таблицы, которые могут быть затем модифицированы или удалены одна за другой. Это дает вам возможность, обходить некоторые ограничения \n";
echo "предикатов, используемых в командах UPDATE и DELETE. Вы можете ссылаться на таблицу, задействованную в предикате запроса курсора или любом из его подзапросов, которые вы не можете выполнить в предикатах\n";
echo "самих этих команд. Как подчёркнуто в <a href=\"ch16.php\">Главе 16</a>, стандарт SQL отклоняет попытку удалить всех пользователей с рейтингом ниже среднего, в следующей форме:</p>\n";
echo "<pre>                  EXEC SQL DELETE FROM Customers\n";
echo "                    WHERE rating &lt;\n";
echo "                       (SELECT AVG (rating)\n";
echo "                         FROM Customers);</pre>\n";
echo "<p>Однако вы можете получить тот же эффект, используя запрос для выбора соответствующих строк, запомнив их в курсоре и выполнив DELETE с использованием курсора. Сначала вы должны объявить курсор:</p>\n";
echo "<pre>               EXEC SQL DECLARE Belowavg CURSOR FOR\n";
echo "                 SELECT *\n";
echo "                   FROM Customers\n";
echo "                   WHERE rating &lt;\n";
echo "                      (SELECT AVG (rating)\n";
echo "                        FROM Customers);</pre>\n";
echo "<p>Затем вы должны создать цикл, чтобы удалить всех заказчиков, выбранных курсором:</p>\n";
echo "<pre>            EXEC SQL WHENEVER SQLERROR GOTO Error_handler;\n";
echo "             EXEC SQL OPEN CURSOR Belowavg;\n";
echo "             while not SOLCODE = 100 do\n";
echo "               begin\n";
echo "               EXEC SOL FETCH Belowavg INTO :a, :b, :c, :d, :e;\n";
echo "               EXEC SOL DELETE FROM Customers\n";
echo "                 WHERE CURRENT OF Belowavg;\n";
echo "               end;\n";
echo "             EXEC SOL CLOSE CURSOR Belowavg;</pre>\n";
echo "<p>Предложение WHERE CURRENT OF означает, что DELETE применяется к строке, которая в настоящее время выбрана курсором. Здесь подразумевается, что и курсор, и команда DELETE ссылаются на одну и ту же таблицу и, следовательно, что запрос в курсоре - это не объединение.\n";
echo " Курсор должен также быть модифицируемым. Являясь модифицируемым, курсор должен удовлетворять тем же условиям, что и представления\n";
echo "(см. <a href=\"ch21.php\">Главу 21</a>).</p>\n";
echo "<p>Кроме того, ORDER BY и UNION, которые не разрешены в представлениях, в курсорах разрешаются, но предохраняют курсор от модифицируемости. Обратите внимание в вышеупомянутом примере, что \n";
echo "мы должны выбирать строки из курсора в набор переменных, даже если \n";
echo "мы не собирались использовать эти переменные. Этого требует синтаксис команды FETCH.</p>\n";
echo "<p>UPDATE работает так же.</p>\n";
echo "<p>Вы можете увеличить значение комиссионных всем продавцам, которые имеют заказчиков с оценкой = 300, следующим способом. Сначала вы объявляете курсор:</p>\n";
echo "<pre>        EXEC SOL DECLARE CURSOR High_Cust AS\n";
echo "           SELECT *\n";
echo "              FROM Salespeople\n";
echo "              WHERE snum IN\n";
echo "                 (SELECT snum\n";
echo "                    FROM Customers\n";
echo "                    WHERE rating = 300);</pre>\n";
echo "<p>Затем вы выполняете модификации в цикле:</p>\n";
echo "<pre>             EXEC SQL OPEN CURSOR High_cust;\n";
echo "            while SQLCODE = 0 do\n";
echo "               begin\n";
echo "               EXEC SOL FETCH High_cust\n";
echo "                  INTO :id_num, :salesperson, :loc, :comm;\n";
echo "               EXEC SQL UPDATE Salespeople\n";
echo "                  SET comm = comm + .01\n";
echo "                  WHERE CURRENT OF High_cust;\n";
echo "               end;\n";
echo "            EXEC SQL CLOSE CURSOR High_cust;</pre>\n";
echo "<p>Обратите внимание, что некоторые реализации требуют, чтобы вы указывали в определении курсора, что курсор будет использоваться для выполнения команды UPDATE на определенных столбцах. Это делается с помощью заключительной фразы определения курсора - FOR UPDATE <column list />. \n";
echo "Для объявления курсора High_cust таким способом, чтобы вы могли модифицировать командой UPDATE столбец comm, вы должны ввести \n";
echo "следующее предложение:</p>\n";
echo "<pre>             EXEC SQL DECLARE CURSOR High_Cust AS\n";
echo "                SELECT *\n";
echo "                   FROM Salespeople\n";
echo "                   WHERE snum IN\n";
echo "                      (SELECT snum\n";
echo "                          FROM Customers\n";
echo "                          WHERE rating = 300)\n";
echo "                 FOR UPDATE OF comm;</pre>\n";
echo "<p>Это обеспечит вас определенной защитой от случайных модификаций, которые могут разрушить весь порядок в базе данных.</p>\n";
echo "<a name=\"25.12\"></a>\n";
echo "<h3>ПЕРЕМЕННАЯ INDICATOR</h3>\n";
echo "<p>Пустые (NULL) значения это специальные маркеры, определяемые самим SQL. Они не могут помещаться в главные переменные. Попытка вставить NULL-значения в главную переменную будет некорректна, так как главные языки не поддерживают NULL-значений в SQL по определению. Хотя результат при попытке вставить NULL-значение в главную переменную \n";
echo "определяет проектировщик, этот результат не должен противоречить теории БД и поэтому обязан выдавать ошибку - код SQLCODE в виде \n";
echo "отрицательного числа - и вызывать подпрограмму управления ошибкой. Естественно, вам нужно этого избежать. Поэтому вы можете \n";
echo "заменить NULL-значения на допустимые значения, не приводящие к разрушению вашей\n";
echo "программы. Даже если программа и не разрушится, значения в главных переменных станут неправильными, потому что они не могут иметь NULL-значений.</p>\n";
echo "<p>Альтернативным методом, предоставляемым для этой ситуации, является функция переменной indicator (указатель). \n";
echo "Переменная indicator, объявленная в разделе объявлений SQL, напоминает другие переменные. Она может иметь тип главного языка, который соответствует числовому типу в SQL. Всякий раз, когда вы выполняете операцию,\n";
echo "которая должна поместить NULL-значение в переменную главного языка, вы должны использовать переменную indicator для надежности.<br>\n";
echo "Вы помещаете переменную indicator в команду SQL непосредственно после переменной главного языка, которую вы хотите защитить, без каких-либо пробелов \n";
echo "или запятых, хотя вы и можете, при желании, вставить слово INDICATOR. Переменной indicator в команде изначально присваивается значение 0. \n";
echo "Однако, если производится значение NULL, переменная indicator становится равной отрицательному числу. Вы можете проверить значение переменной indicator, чтобы узнать, было ли найдено значение NULL.</p>\n";
echo "<p>Давайте \n";
echo "предположим, что поля city и comm таблицы Продавцов не имеют ограничения NOT NULL, и что мы объявили в разделе объявлений SQL две ПАСКАЛевские переменные целого типа, i_a и i_b. \n";
echo "(Нет ничего такого в разделе объявлений, что могло бы представить их как переменные indicator. Они станут переменными indicator, когда будут использоваться как переменные indicator.)</p>\n";
echo "<p>Имеется одна возможность:</p>\n";
echo "<pre>      EXEC SQL OPEN CURSOR High_cust;\n";
echo "      while SQLCODE = O do\n";
echo "         begin\n";
echo "         EXEC SQL FETCH High_cust\n";
echo "            INTO :id_num, :salesperson,\n";
echo "               :loc:i_a, :commINDlCATOR:i_b;\n";
echo "         If i_a &gt; = O and i_b &gt; = O then\n";
echo "                       {no NULLs produced}\n";
echo "              EXEC SQL UPDATE Salespeople\n";
echo "                 SET comm = comm + .01\n";
echo "                 WHERE CURRENT OF Hlgh_cust;\n";
echo "         else\n";
echo "                    {one or both NULL}\n";
echo "         begin\n";
echo "            If i_a &lt; O then\n";
echo "                 writeln ('salesperson ', id_num, ' has no city');\n";
echo "            If i_b &lt; O then\n";
echo "                 writeln ('salesperson ', id_num, ' has no\n";
echo "                 commission');\n";
echo "         end;\n";
echo "                   {else}\n";
echo "         end; {while}\n";
echo "      EXEC SQL CLOSE CURSOR High_cust;</pre>\n";
echo "<p>Как  видите, мы включили, ключевое слово INDICATOR в одном случае и исключили его в другом случае, чтобы показать, что эффект будет одинаковым в любом случае. Каждая строка будет выбрана, но команда UPDATE выполнится, только если NULL-значения не будут обнаружены. \n";
echo "Если будут обнаружены NULL-значения, выполнится ещё одна часть программы, которая распечатает предупреждающее сообщение \n";
echo "- где было найдено каждое NULL-значение.</p>\n";
echo "<p>Обратите внимание: переменные indicator должны проверяться в главном \n";
echo "языке, как указывалось выше, а не в предложении WHERE команды SQL. Последнее в принципе не запрещено, но результат часто бывает непредсказуем.</p>\n";
echo "<a name=\"25.13\"></a>\n";
echo "<h3>ИСПОЛЬЗОВАНИЕ ПЕРЕМЕННОЙ INDICATOR<br>\n";
echo "ДЛЯ ЭМУЛЯЦИИ NULL-ЗНАЧЕНИЙ SQL</h3>\n";
echo "<p>Другая возможность состоит в том, чтобы обрабатывать переменную indicator, связывая её с каждой переменной главного языка, специальным способом, эмулирующим поведение NULL-значений SQL.\n";
echo "Всякий раз, когда вы используете одно из этих значений в вашей программе, например, в предложении if ... then, вы можете сначала проверить связанную переменную indicator: \n";
echo "равно ли её значение NULL. Если это так, то вы обрабатываете переменную по-другому.<br>\n";
echo "Например, \n";
echo "если NULL-значение было извлечено из поля city для главной переменной city, которая связана с переменной indicator i_city, вы должны \n";
echo "установить значение city, равное последовательности пробелов. Это будет необходимо, только если вы будете распечатывать его на принтере;\n";
echo "его значение не должно отличаться от логики вашей программы. \n";
echo "Естественно, i_city автоматически устанавливается в отрицательное значение.</p>\n";
echo "<p>Предположим, что вы имели следующую конструкцию в вашей программе:</p>\n";
echo "<pre>        If sity = 'London' then\n";
echo "             comm: = comm + .01\n";
echo "        else comm: = comm - .01</pre>\n";
echo "<p>Любое значение, вводимое в переменную city,  будет равно &quot;London&quot;\n";
echo "или не будет равно. Следовательно, в каждом случае значение комиссионных будет либо увеличено, либо уменьшено. Однако эквивалентные\n";
echo "команды в SQL выполняются по разному:</p>\n";
echo "<pre>         EXEC SQL UPDATE Salespeople\n";
echo "            SET comm = comm + .01\n";
echo "            WHERE sity = 'London';</pre>\n";
echo "<p>и</p>\n";
echo "<pre>         EXEC SQL UPDATE Salespeople\n";
echo "            SET comm = comm  .01;\n";
echo "            WHERE sity &lt; &gt; 'London';</pre>\n";
echo "<p>(Вариант на ПАСКАЛе работает только с единственным значением, в то время как вариант на SQL работает со всеми таблицами.) \n";
echo "Если значение city в варианте на SQL будет равно значению NULL, оба предиката будут неизвестны, и значение comm, следовательно, не будет \n";
echo "изменено в любом случае. Вы можете использовать переменную indicator, чтобы сделать поведение вашего главного языка не противоречащим этому, с помощью создания условия, которое исключает NULL значения:</p>\n";
echo "<pre>        If i_city &gt; = O then\n";
echo "             begin\n";
echo "             If city = 'London' then\n";
echo "                  comm: = comm + .01\n";
echo "             else comm: = comm - .01;\n";
echo "             end;\n";
echo "       {begin and end нужны здесь только для понимания}</pre>\n";
echo "<h6><b>ПРИМЕЧАНИЕ:</b> Последняя строка этого примера содержит ремарку - { begin и end необходимы только для понимания}</h6>\n";
echo "<p>В более сложной программе вы можете захотеть установить булеву переменную в &quot;true/верно&quot;, чтобы указать, что значение city = NULL. Затем вы\n";
echo "можете просто проверять эту переменную всякий раз, когда вам это необходимо.</p>\n";
echo "<a name=\"25.14\"></a>\n";
echo "<h3>ДРУГОЕ ИСПОЛЬЗОВАНИЕ ПЕРЕМЕННОЙ INDICATOR</h3>\n";
echo "<p>Переменная indicator также может использоваться для просвоения  NULL-значения. Просто добавьте её к имени главной переменной в команде UPDATE или INSERT тем же способом, что и в команде SELECT. \n";
echo "Если переменная indicator имеет отрицательное значение, значение NULL \n";
echo "будет помещено в поле.</p>\n";
echo "<p>Например, следующая команда помещает значения NULL в поля city и comm таблицы Продавцов всякий раз, когда\n";
echo "переменные indicator i_a или i_b будут отрицательными; в противном случае она помещает туда значения главных переменных:</p>\n";
echo "<pre>EXEC SQL INSERT INTO Salespeople \n";
echo " VALUES (:Id_num, :salesperson, :loc:i_a, :comm:i_b);</pre>\n";
echo "<p>Переменная indicator также используется, чтобы показывать отбрасываемую \n";
echo "строку. Это произойдет, если вы вставляете значения символов SQL в главную переменную, которая недостаточно длинна, чтобы вместить все символы.\n";
echo "Это особая проблема с нестандартным типами данных VARCHAR и LONG (смотри <a href=\"c.php\">Приложение C</a>). В этом случае переменная будет заполнена\n";
echo "первыми символами строки, а последние символы будут потеряны. Если используется переменная indicator, в неё будет установлено положительное значение, указывающее на длину отбрасываемой части строки, позволяя таким образом  узнать, сколько символов было потеряно.\n";
echo "В этом случае вы можете проверить с помощью просмотра  значение переменной indicator &gt; 0 или &lt; 0.</p>\n";
echo "<a name=\"25.15\"></a>\n";
echo "<h3>РЕЗЮМЕ</h3>\n";
echo "<p>Команды SQL вкладываются в процедурные языки, чтобы объединить возможности двух подходов. Некоторые дополнительные средства SQL необходимы \n";
echo "для выполнения этой работу. Вложенные команды SQL, транслируемые программой, называемой прекомпилятором, в форму, пригодную для использования транслятором главного языка, и используемые в этом главном языке как вызовы процедуры к подпрограммам, которые создаёт прекомпилятор, называются модулями доступа.\n";
echo "ANSI поддерживает вложение SQL в языки ПАСКАЛЬ, ФОРТРАН, КОБОЛ и PL/I. Другие языки также используются, особенно С.<br>\n";
echo "В попытке кратко описать вложенный SQL,  наиболее важное в этой главе:</p>\n";
echo "<ul><li>Все вложенные команды SQL начинаются словами EXEC SQL и заканчиваются способом, который зависит от используемого главного языка;</li>\n";
echo "<li>Все главные переменные, доступные в командах SQL, должны быть объявлены в разделе объявлений SQL, прежде чем они будут использованы;</li>\n";
echo "<li>Всем главным переменным должно предшествовать двоеточие, когда они используются в команде SQL;</li>\n";
echo "<li>Запросы могут сохранять свой вывод непосредственно в главных переменных, используя предложение INTO, если, и только если, они выбирают единственную строку;</li>\n";
echo "<li>Курсоры могут использоваться для сохранения вывода запроса и доступа к одной строке в каждый момент времени. Курсоры бывают объявленными \n";
echo "(если определяют запрос, в котором будут содержаться), открытыми (если выполняют запрос) и закрытыми (если удаляют вывод запроса из курсора). Если курсор открыт, команда FETCH используется, \n";
echo "чтобы перемещать его по очереди к каждой строке вывода запроса;</li>\n";
echo "<li>Курсоры являются модифицируемыми или только-для-чтения. Чтобы стать модифицируемым, курсор должен удовлетворять всем критериям, которым удовлетворяет просмотр; кроме того, он не должен использовать\n";
echo "предложений ORDER BY или UNION, которые в любом случае не могут использоваться просмотрами. Немодифицируемый курсор является курсором только-для-чтения;</li>\n";
echo "<li>Если курсор - модифицируемый, он может использоваться для определения того, какие строки задействованы вложенными командами UPDATE и\n";
echo "DELETE, через предложение WHERE CURRENT OF. DELETE или UPDATE должны быть вне той таблицы, к которой курсор обращается в \n";
echo "запросе;</li><li>SQLCODE должен быть объявлен как переменная числового типа для каждой программы, использующей вложенный SQL. Его значение устанавливается \n";
echo "автоматически после выполнения каждой команды SQL;</li>\n";
echo "<li>Если команда SQL выполнена, как обычно, но не произвела вывода или ожидаемого изменения в базе данных, SQLCODE = 100. Если команда \n";
echo "произвела ошибку, SQLCODE будет равняться некоторому аппаратно определяемому отрицательному числу, которое описывает ошибку. В противном случае SQLCODE = 0;</li>\n";
echo "<li>Предложение WHENEVER может использоваться для определения действия, которое нужно предпринять, когда SQLCODE = 100 (не найдено)\n";
echo "или когда SQLCODE равен отрицательному числу (SQLERROR). Действием может быть или переход к некоторой определённой метке в \n";
echo "программе (GOTO &lt;метка&gt;), или отсутствие какого-либо действия вообще (продолжить). Последнее установлено по умолчанию;</li>\n";
echo "<li>Числовые переменные могут также использоваться как переменные indicator. Переменные indicator следуют за другим именами переменных в команде SQL без каких бы то ни было посторонних символов\n";
echo "кроме (необязательного) слова INDICATOR;</li>\n";
echo "<li>Обычно значение переменной indicator = 0. Если команда SQL пытается поместить NULL-значение в главную переменную, которая использует indicator, \n";
echo "в indicator будет установлено отрицательное значение. Этот факт можно \n";
echo "использовать для предотвращения ошибки и для пометки NULL-значений SQL для специальной обработки их в главной программе;</li>\n";
echo "<li>Переменная indicator может использоваться для вставки NULL-значений в \n";
echo "SQL-команды INSERT или UPDATE. Она также может\n";
echo "принимать положительное значение, указывающее  длину отбрасываемой части строки, не поместившейся в предельные границы какой-нибудь переменной, куда эта строка помещалась.</li></ul>\n";
echo "<a name=\"25.16\"></a>\n";
echo "<h3>РАБОТА СО SQL</h3>\n";
echo "<p><i><b>Обратите внимание:</b></i> ответы для этих упражнений написаны в псевдокодах, являющихся английским языком описания логики, которой должна\n";
echo "следовать программа. Это сделано для того, чтобы помочь читателям, которые могут быть не знакомы с ПАСКАЛем (или любым другим языком).<br>\n";
echo "Кроме того, это лучше сфокусирует ваше внимание на включаемых понятиях, опуская частности того или другого языка. Чтобы не противоречить нашим примерам, стиль псевдокода будет напоминать Паскаль.</p>\n";
echo "<p>Мы опустим из программ всё, что не относится напрямую к рассматриваемым вопросам, например, определение устройств ввода-вывода, подключение к базе данных и так далее. Конечно, имеется много способов\n";
echo "выполнения таких упражнений; и совсем не обязательно, что представленные варианты решений являются самыми удачными.</p>\n";
echo "<pre>1. Разработайте простую программу, которая выберет все комбинации полей snum и cnum\n";
echo "   из таблиц Заказов и Заказчиков, и выясните, всегда ли предыдущая\n";
echo "   комбинация - такая же, как последующая. Если комбинация из таблицы Заказов не найдена\n";
echo "   в таблице Заказчиков, значение поля snum для этой строки будет изменено на удовлетворяющее\n";
echo "   условию совпадения. Вы должны помнить, что курсор с подзапросом\n";
echo "   модифицируем (ANSI-ограничение также применимо к просмотрам) и что\n";
echo "   базисная целостность базы данных это не тоже самое, что проверка на ошибку\n";
echo "   (т.е. первичные ключи уникальны, все поля cnums в таблице Заказов правильны, и так далее).\n";
echo "   Проверьте раздел объявлений и убедитесь, что там объявлены все используемые курсоры.\n";
echo "\n";
echo "2. Предположим, что ваша программа предписывает ANSI запрещение\n";
echo "   курсоров или просмотров, использующих модифицируемые подзапросы. Как вы\n";
echo "   должны изменить вышеупомянутую программу?\n";
echo "\n";
echo "3. Разработайте программу, которая подсказывает пользователям изменить значения\n";
echo "   поля city продавца, автоматически увеличивает комиссионные на .01 для продавца,\n";
echo "   переводимого в Барселону, и уменьшает их на .01 для продавца, переводимого в Сан-Хосе.\n";
echo "   Кроме того, продавец находящийся в Лондоне, должен потерять .02 из своих комиссионных,\n";
echo "   независимо от того, меняет он город, или нет, в то время как продавец, не находящийся\n";
echo "   в Лондоне должен иметь увеличение комиссионных на .02.\n";
echo "   Изменение в комиссионных, основывающееся на нахождении продавца в Лондоне, может\n";
echo "   применяться независимо от того, куда тот переводится.\n";
echo "   Выясните, может ли поле city или поле comm содержать NULL-значения, и обработайте их,\n";
echo "   как это делается в SQL.\n";
echo "\n";
echo "   Предупреждение! Эта программа имеет некоторые сокращения.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#25\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>  
