﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 21.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 21. ИЗМЕНЕНИЕ ЗНАЧЕНИЙ С ПОМОЩЬЮ ПРЕДСТАВЛЕНИЙ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В этой главе рассказано о командах модификации языка DML - ВСТАВИТЬ (INSERT), \n";
echo "ИЗМЕНИТЬ (UPDATE) и УДАЛИТЬ (DELETE) - и о том, когда они применяются для \n";
echo "представлений. Как сказано в предыдущей главе, использование команд \n";
echo "модификации в представлениях это косвенный способ использования их в ссылочных \n";
echo "таблицах с помощью запросов представлений. Однако не все представления могут \n";
echo "модифицироваться.</p>\n";
echo "<p>В этой главе мы будем обсуждать правила, определяющие, является ли \n";
echo "представление модифицируемым. Кроме того, вы научитесь использовать предложение \n";
echo "WITH CHECK OPTION, управляющее указанными значениями, которые можно вводить в \n";
echo "таблицу с помощью представления.</p>\n";
echo "<p>Как сказано в <a href=\"ch18.php\">Главе 18</a>, это, в некоторых случаях, \n";
echo "может быть желательным вариантом непосредственного ограничения таблицы.</p>\n";
echo "<h3><a name=\"21.1\">М</a>ОДИФИЦИРОВАНИЕ ПРЕДСТАВЛЕНИЯ</h3>\n";
echo "<p>Один из наиболее трудных и неоднозначных аспектов представлений - \n";
echo "непосредственное их использование с командами модификации DML. Как упомянуто в \n";
echo "предыдущей главе, эти команды фактически воздействуют на значения в базовой \n";
echo "таблице представления. Это является некоторым противоречием.</p>\n";
echo "<p>Представление \n";
echo "состоит из результатов запроса, и, когда вы модифицируете представление, вы \n";
echo "модифицируете набор результатов запроса. Но модификация не должна воздействовать \n";
echo "на запрос; она должна воздействовать на значения в таблице, к которой был сделан \n";
echo "запрос, и таким образом изменять вывод запроса. Это не простой вопрос. Следующий \n";
echo "оператор будет создавать представление, показанное на Рисунке 21.1:</p>\n";
echo "<pre>      CREATE VIEW Citymatch (custcity, salescity)\n";
echo "          AS SELECT DISTINCT a.city, b.city\n";
echo "             FROM Customers a, Salespeople b\n";
echo "             WHERE a.snum = b.snum;</pre>\n";
echo "<p>Это представление показывает все совпадения заказчиков с их продавцами так, \n";
echo "что имеется по крайней мере один заказчик в городе_заказчика, обслуживаемый \n";
echo "продавцом в городе_продавца.</p>\n";
echo "<p>Например, одна строка этой таблицы - London London - показывает, что имеется \n";
echo "по крайней мере один заказчик в Лондоне, обслуживаемый продавцом в Лондоне. Эта \n";
echo "строка может быть произведена при совпадении Hoffmanа с его продавцом Peel, \n";
echo "причем если оба они из Лондона.</p>\n";
echo "<pre>            ===============  SQL Execution Log ==============\n";
echo "           |                                                 |\n";
echo "           | SELECT *                                        |\n";
echo "           | FROM  Citymatch;                                |\n";
echo "           | =============================================== |\n";
echo "           |   custcity    salescity                         |\n";
echo "           |  ---------    ---------                         |\n";
echo "           |  Berlin       San Jose                          |\n";
echo "           |  London       London                            |\n";
echo "           |  Rome         London                            |\n";
echo "           |  Rome         New York                          |\n";
echo "           |  San Jose     Barselona                         |\n";
echo "           |  San Jose     San Jose                          |\n";
echo "           |                                                 |\n";
echo "             ================================================\n";
echo "\n";
echo "	     Рисунок 21.1 Представление совпадения по городам</pre>\n";
echo "<p>Однако то же самое значение будет произведено при совпадении Clemens из \n";
echo "Лондона с его продавцом, который также оказался с именем Peel. Пока отличающиеся \n";
echo "комбинации городов выбирались конкретно, только одна строка из этих значений была произведена.</p>\n";
echo "<p>Даже если вы не получите выбора, используя отличия, вы всё ещё будете в том \n";
echo "же самом положении, потому что вы будете тогда иметь две строки в представлении \n";
echo "с идентичными значениями, то есть с обоими столбцами, равными &quot; Lоndon London &quot;. \n";
echo "Эти две строки представления будут отличаться друг от друга, так что вы пока не \n";
echo "сможете сообщить, какая строка представления исходила из каких значений базовых \n";
echo "таблиц (имейте в виду, что запросы, не использующие предложение ORDER BY, \n";
echo "производят вывод в произвольном порядке).<br>\n";
echo "Это относится также и к запросам, \n";
echo "используемым внутри представлений, которые не могут использовать ORDER BY. Таким \n";
echo "образом, заказ из двух строк не может быть использован для их отличий. Это \n";
echo "означает, что мы будем снова обращаться к выводу строк, которые не могут быть \n";
echo "точно связаны с указанными строками запрашиваемой таблицы.<br>\n";
echo "Что, если вы пробуете \n";
echo "удалить строку &quot; London London &quot; из представления? Означало бы это удаление \n";
echo "Hoffman из таблицы Заказчиков, удаление Clemens из той же таблицы, или удаление \n";
echo "их обоих? Должен ли SQL также удалить Peel из таблицы Продавцов? На эти вопросы \n";
echo "невозможно ответить точно, поэтому удаления не разрешены в представлениях такого \n";
echo "типа. Представление Citymatch это пример представления только_для_чтения: оно \n";
echo "может быть только запрошено, но не изменено.</p>\n";
echo "<h3><a name=\"21.2\">О</a>ПРЕДЕЛЕНИЕ МОДИФИЦИРУЕМОСТИ ПРЕДСТАВЛЕНИЯ</h3>\n";
echo "<p>Если команды модификации могут выполняться в представлении, представление, \n";
echo "как уже говорилось, будет модифицируемым; в противном случае оно предназначено \n";
echo "только для чтения при запросе. Не противореча этой терминологии, мы будем \n";
echo "использовать выражение &quot;модифицировать представление&quot; (updating a view), что \n";
echo "означает возможность выполнения в представление любой из трёх команд модификации DML (Вставить, Изменить и Удалить), которые могут изменять значения.</p>\n";
echo "<p>Как вы \n";
echo "определите, является ли представление модифицируемым? В теории базы данных, это \n";
echo "- пока обсуждаемая тема. Основной  принцип таков: модифицируемое представление \n";
echo "это представление, в котором команда модификации может выполниться, чтобы \n";
echo "изменить одну, и только одну, строку основной таблицы в каждый момент времени, \n";
echo "не воздействуя на любые другие строки любой таблицы. Использование этого \n";
echo "принципа на практике, однако, затруднено.</p>\n";
echo "<p>Кроме того, некоторые представления, \n";
echo "которые теоретически являются модифицируемыми, на самом деле не являются \n";
echo "модифицируемыми в SQL.</p>\n";
echo "<p>Вот критерии, по которым определяют, является ли в SQL-представление \n";
echo "модифицируемым, или нет:</p>\n";
echo "<ul>\n";
echo "<li>Оно должно выводиться из одной, и только из одной, базовой таблицы.</li>\n";
echo "<li>Оно должно содержать первичный ключ этой таблицы (это технически не \n";
echo "предписывается стандартом ANSI, но было бы неплохо придерживаться этого).</li>\n";
echo "<li>Оно не должно иметь никаких полей, которые являлись бы агрегатными функциями.</li>\n";
echo "<li>Оно не должно содержать DISTINCT в своем определении.</li>\n";
echo "<li>Оно не должно использовать GROUP BY или HAVING в своем определении.</li>\n";
echo "<li>Оно не должно использовать подзапросы (это ANSI-ограничение, которое не \n";
echo "предписано для некоторых реализаций).</li>\n";
echo "<li>Оно может быть использовано в другом представлении, но это представление \n";
echo "должно также быть модифицируемым.</li>\n";
echo "<li>Оно не должно использовать константы, строки или выражения для значений \n";
echo "(например: comm * 100) среди выбранных полей вывода.</li>\n";
echo "<li>Для INSERT оно должно содержать любые поля основной таблицы, которые имеют \n";
echo "ограничение NOT NULL, если другое ограничение по умолчанию не определено.</li></ul>\n";
echo "<h3><a name=\"21.3\">М</a>ОДИФИЦИРУЕМЫЕ ПРЕДСТАВЛЕНИЯ<br>\n";
echo "И ПРЕДСТАВЛЕНИЯ ТОЛЬКО_ДЛЯ_ЧТЕНИЯ.</h3>\n";
echo "<p>Одно из этих ограничений - то, что модифицируемые представления фактически \n";
echo "подобны окнам в базовых таблицах. Они показывают кое-что, но не обязательно всё, \n";
echo "из содержимого таблицы. Они могут ограничивать определенные строки \n";
echo "(использованием предикатов) или специально именованные столбцы (с исключениями), \n";
echo "но они представляют значения непосредственно и не выводят  информацию с \n";
echo "использованием составных функций и выражений.</p>\n";
echo "<p>Они также не сравнивают строки таблиц друг с другом (как в объединениях и \n";
echo "подзапросах или как с DISTINCT).</p>\n";
echo "<p>Различия между модифицируемыми представлениями и представлениями \n";
echo "только_чтение не случайны.</p>\n";
echo "<p>Цели для которых вы их используете, часто различны. Модифицируемые \n";
echo "представления в основном используются точно так же, как и базовые таблицы. \n";
echo "Фактически пользователи не могут даже осознать, является ли объект, который они \n";
echo "запрашивают, базовой таблицей или представлением. Это превосходный механизм \n";
echo "защиты для скрытия частей таблицы, которые являются конфиденциальными или не \n";
echo "относятся к потребностям данного пользователя. (В <a href=\"ch22.php\">Главе 22</a> \n";
echo "мы покажем вам, как разрешить пользователям обращаться к представлению, а не к \n";
echo "базовой таблице).</p>\n";
echo "<p>Представления только_чтение, с другой стороны, позволяют вам получать и \n";
echo "переформатировать данные более рационально. Они дают вам библиотеку сложных \n";
echo "запросов, которые вы можете выполнить и повторить снова, сохраняя полученную \n";
echo "вами информацию до последней минуты.<br>\n";
echo "Кроме того, результаты этих запросов в \n";
echo "таблицах, которые могут затем использоваться в запросах самостоятельно \n";
echo "(например, в объединениях), имеют преимущество над просто выполнением запросов.</p>\n";
echo "<p>Представления только_чтение могут также иметь прикладные программы защиты. \n";
echo "Например, вы можете захотеть, чтобы некоторые пользователи видели агрегатные \n";
echo "данные, такие как усредненное значение комиссионных продавца, а не представление \n";
echo "индивидуальных значений комиссионных.</p>\n";
echo "<h3><a name=\"21.4\">КАКОЕ</a> ПРЕДСТАВЛЕНИЕ ЯВЛЯЕТСЯ МОДИФИЦИРУЕМЫМИ?</h3>\n";
echo "<p>Вот некоторые примеры модифицируемых представлений и представлений только_чтение.</p>\n";
echo "<pre>           CREATE VIEW Dateorders (odate, ocount)\n";
echo "              AS SELECT odate, COUNT (*)\n";
echo "                 FROM Orders\n";
echo "                 GROUP BY odate;</pre>\n";
echo "<p>Это представление только_чтение из-за присутствия в нём агрегатной функции и GROUP BY.<br>\n";
echo "&nbsp;</p>\n";
echo "<pre>              CREATE VIEW Londoncust\n";
echo "                 AS SELECT *\n";
echo "                    FROM Customers\n";
echo "                    WHERE city = 'London';</pre>\n";
echo "<p>А это - модифицируемое представление.<br>\n";
echo "&nbsp;</p>\n";
echo "<pre>             CREATE VIEW SJsales (name, number, percentage)\n";
echo "                 AS SELECT sname, snum, comm * 100\n";
echo "                    FROM Salespeople\n";
echo "                    WHERE city = 'SanJose';</pre>\n";
echo "<p>Это - представление только_чтение из-за выражения &quot;comm * 100&quot;. При этом, \n";
echo "однако, возможны переупорядочивание и переименование полей. Некоторые программы \n";
echo "будут позволять удаление в этом представлении или в заказах столбцов snum и \n";
echo "sname.<br>\n";
echo "&nbsp;</p>\n";
echo "<pre>             CREATE VIEW Salesonthird\n";
echo "                AS SELECT *\n";
echo "                  FROM Salespeople\n";
echo "                  WHERE snum IN\n";
echo "                    (SELECT snum\n";
echo "                       FROM Orders\n";
echo "                       WHERE odate = 10/03/1990);</pre>\n";
echo "<p>Это - представление только_чтение в ANSI из-за присутствия в нём подзапроса. \n";
echo "В некоторых программах, это может быть приемлемо.<br>\n";
echo "&nbsp;</p>\n";
echo "<pre>            CREATE VIEW Someorders\n";
echo "               AS SELECT snum, onum, cnum\n";
echo "                  FROM Orders\n";
echo "                  WHERE odate IN (10/03/1990,10/05/1990);</pre>\n";
echo "<p>Это - модифицируемое представление.</p>\n";
echo "<h3><a name=\"21.5\">П</a>РОВЕРКА ЗНАЧЕНИЙ, ПОМЕЩАЕМЫХ В ПРЕДСТАВЛЕНИЕ</h3>\n";
echo "<p>Другой вывод о модифицируемости представления -  вы можете вводить \n";
echo "значения, которые &quot;проглатываются&quot; (swallowed) в базовой таблице. Рассмотрим \n";
echo "такое представление:</p>\n";
echo "<pre>          CREATE VIEW Highratings\n";
echo "             AS SELECT cnum, rating\n";
echo "                FROM Customers\n";
echo "                WHERE rating = 300;</pre>\n";
echo "<p>Это представление - модифицируемое. Оно просто ограничивает ваш доступ к \n";
echo "определенным строкам и столбцам в таблице. Предположим, что вы вставляете \n";
echo "(INSERT) следующую строку:</p>\n";
echo "<pre>       INSERT INTO Highratings\n";
echo "          VALUES (2018, 200);</pre>\n";
echo "<p>Команда INSERT допустима в данном представлении. Строка будет \n";
echo "вставлена с помощью представления Highratings в таблицу Заказчиков. Однако, \n";
echo "когда она появится там, она исчезнет из представления, поскольку значение оценки \n";
echo "не равно 300. Это - обычная проблема.</p>\n";
echo "<p>Значение 200 может быть просто напечатано, но теперь строка находится уже в \n";
echo "таблице Заказчиков, где вы не можете даже увидеть её. Пользователь не сможет \n";
echo "понять, почему введя строку он не может её увидеть и будет неспособен при этом \n";
echo "удалить её. Вы можете быть гарантированы от модификаций такого типа с помощью \n";
echo "включения WITH CHECK OPTION (С ОПЦИЕЙ ПРОВЕРКИ) в определение представления. Мы \n";
echo "можем использовать WITH CHECK OPTION в определении представления Highratmgs.</p>\n";
echo "<pre>          CREATE VIEW Highratings\n";
echo "             AS SELECT cnum, rating\n";
echo "                FROM Customers\n";
echo "                WHERE rating = 300\n";
echo "                WITH CHECK OPTION;</pre>\n";
echo "<p>Вышеупомянутая вставка будет отклонена.</p>\n";
echo "<p>WITH CHECK OPTION производит действие все_или_ничего (all-or-nothing). Вы \n";
echo "помещаете его в определение представления, а не в команду DML, так что или все \n";
echo "команды модификации в представлении будут проверяться, или ни одна не будет \n";
echo "проверена. Обычно вы хотите использовать опцию проверки, применяя её в \n";
echo "определении представления, что может быть удобно. В общем, вы должны \n";
echo "использовать эту опцию, если у вас нет причины разрешать представлению помещать \n";
echo "в таблицу значения, которые оно само не может содержать.</p>\n";
echo "<h3><a name=\"21.6\">П</a>РЕДИКАТЫ И ИСКЛЮЧЁННЫЕ ПОЛЯ</h3>\n";
echo "<p>Похожая проблема, о которой вы должны знать, включает в себя вставку строк в \n";
echo "представление с предикатом, базирующемся на одном или более исключённых полях. \n";
echo "Например, может показаться разумным создание Londonstaff, как здесь:</p>\n";
echo "<pre>            CREATE VIEW Londonsta1t\n";
echo "               AS SELECT snum, sname, comm\n";
echo "                  FROM Salespeople\n";
echo "                  WHERE city = 'London';</pre>\n";
echo "<p>В конце концов, зачем включать значение city, если все значения city будут \n";
echo "одинаковыми?</p>\n";
echo "<p>А как будет выглядеть картинка, получаемая всякий раз, когда мы пробуем \n";
echo "вставить строку?</p>\n";
echo "<p>Так как мы не можем указать значение city как значение по \n";
echo "умолчанию, этим значением, вероятно, будет NULL, и оно будет введено в поле city \n";
echo "(NULL используется, если другое значение по умолчанию не было определено. См. \n";
echo "подробности в <a href=\"ch18.php\">Главе 18</a>). Так как в этом случае поле city \n";
echo "не будет равняться значению London, вставляемая строка будет исключена из \n";
echo "представления.</p>\n";
echo "<p>Это будет верным для любой строки, которую вы попробуете вставить в просмотр \n";
echo "Londonstaff. Все они должны быть введены с помощью представления Londonstaff в \n";
echo "таблицу Продавцов, а затем исключены из самого представления (если определением \n";
echo "по умолчанию был не London, то это особый случай). Пользователь не сможет \n";
echo "вводить строки в это представление, хотя всё ещё не известно, может ли он \n";
echo "вводить строки в базовую таблицу. Даже если мы добавим WITH CHECK OPTION в \n";
echo "определение представления,</p>\n";
echo "<pre>       CREATE VIEW Londonstate\n";
echo "          AS SELECT snum, sname, comm\n";
echo "             FROM Salespeople\n";
echo "             WHERE city = 'London'\n";
echo "             WITH CHECK OPTION;</pre>\n";
echo "<p>проблема не обязательно будет решена. В результате этого мы получим \n";
echo "представление, которое мы могли бы модифицировать или из которого мы могли бы \n";
echo "удалять, но не вставлять в него. В некоторых случаях это может быть хорошо; \n";
echo "хотя, возможно, нет смысла пользователям, имеющим доступ к этому представлению, \n";
echo "иметь возможность добавлять строки. Но вы должны точно определить, что может \n";
echo "произойти, прежде чем вы создадите такое представление.</p>\n";
echo "<p>Даже если это не всегда может обеспечить вас нужной информацией, полезно \n";
echo "включать в ваше представление все поля, на которые имеется ссылка в предикате. \n";
echo "Если вы не хотите видеть эти поля в вашем выводе, вы всегда сможете исключить их \n";
echo "из запроса в представлении, в противоположность запросу внутри представления. \n";
echo "Другими словами, вы могли бы определить представление Londonstaff так:</p>\n";
echo "<pre>           CREATE VIEW Londonstaff\n";
echo "              AS SELECT *\n";
echo "                 FROM Salespeople\n";
echo "                 WHERE city = 'London'\n";
echo "                 WITH CHECK OPTION;</pre>\n";
echo "<p>Эта команда заполнит представление одинаковыми значениями в поле city, \n";
echo "которые вы можете просто исключить из вывода с помощью запроса, где указаны \n";
echo "только те поля, которые вы хотите видеть:</p>\n";
echo "<pre>           SELECT snum, sname, comm\n";
echo "              FROM Londonstaff;</pre>\n";
echo "<h3><a name=\"21.7\">П</a>РОВЕРКА ПРЕДСТАВЛЕНИЙ, КОТОРЫЕ БАЗИРУЮТСЯ<br>\n";
echo "НА ДРУГИХ ПРЕДСТАВЛЕНИЯХ</h3>\n";
echo "<p>Еще одно надо упомянуть относительно предложения WITH CHECK OPTION в ANSI: \n";
echo "оно не делает каскадированного изменения: оно применяется только в \n";
echo "представлениях, в которых оно определено, но не в представлениях, основанных на \n";
echo "этом представлении. Например, в предыдущем примере</p>\n";
echo "<pre>          CREATE VIEW Highratings\n";
echo "             AS SELECT cnum, rating\n";
echo "                FROM Customers\n";
echo "                WHERE rating = 300\n";
echo "                WITH CHECK OPTION;</pre>\n";
echo "<p>попытка вставить или модифицировать значение оценки, не равное 300, потерпит \n";
echo "неудачу. Однако мы можем создать второе представление (с идентичным \n";
echo "содержанием), основанное на первом:</p>\n";
echo "<pre>           CREATE VIEW Myratings\n";
echo "             AS SELECT *\n";
echo "             FROM Highratings;</pre>\n";
echo "<p>Теперь мы можем модифицировать оценки, не равные 300:</p>\n";
echo "<pre>           UPDATE Myratings\n";
echo "              SET rating = 200\n";
echo "              WHERE cnum = 2004;</pre>\n";
echo "<p>Эта команда, выполняемая так, как если бы она выполнялась как первое \n";
echo "представление, будет допустима. Предложение WITH CHECK OPTION просто \n";
echo "гарантирует, что любая модификация в представлении произведет значения, которые \n";
echo "удовлетворяют предикату этого представления.</p>\n";
echo "<p>Модификация других представлений, \n";
echo "базирующихся на первом текущем, является всё ещё допустимой, если эти \n";
echo "представления не защищены предложениями WITH CHECK OPTION внутри этих \n";
echo "представлений. Даже если такие предложения установлены, они проверяют только те \n";
echo "предикаты представлений, в которых они содержатся. Так, например, даже если \n";
echo "представление Myratings создавалось следующим образом,</p>\n";
echo "<pre>             CREATE VIEW Myratings\n";
echo "                AS SELECT *\n";
echo "                   FROM Highratings\n";
echo "                   WITH CHECK OPTION;</pre>\n";
echo "<p>проблема не будет решена. Предложение WITH CHECK OPTION будет исследовать \n";
echo "только предикат представления Myratings. Пока у Myratings фактически не имеется \n";
echo "никакого предиката, WITH CHECK OPTION ничего не будет делать. Если используется \n";
echo "предикат, то он будет проверяться всякий раз, когда представление Myratings \n";
echo "будет модифицироваться, но предикат Highratings все равно будет проигнорирован. \n";
echo "Это - дефект в стандарте ANSI, который у большинства программ исправлен. Вы \n";
echo "можете попробовать использовать представление наподобие последнего примера и \n";
echo "посмотреть, избавлена ли ваша система от этого дефекта. (Попытка выяснить это \n";
echo "самостоятельно может иногда оказаться проще и яснее, чем поиск ответа в \n";
echo "документации системы.)</p>\n";
echo "<h3><a name=\"21.8\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Вы теперь полностью овладели знаниями о представлениях. Кроме правил, \n";
echo "определяющих, является ли данное представление модифицируемыми в SQL, вы \n";
echo "познакомились с основными понятиями, на которых эти правила базируются - т.е., \n";
echo "что модификации в представлениях допустимы только тогда, когда SQL может \n";
echo "недвусмысленно определить, какие значения базовой таблицы можно изменять. Это \n";
echo "означает, что команда модификации при выполнении не должна требовать ни \n";
echo "изменений для многих строк сразу, ни сравнений между многочисленными строками \n";
echo "либо базовой таблицы, либо вывода запроса.</p>\n";
echo "<p>Поскольку объединения включают в себя сравнение строк, они также запрещены.</p>\n";
echo "<p>Вы \n";
echo "также поняли различие между некоторыми способами, которые используют \n";
echo "модифицируемые представления и представления только_чтение.</p>\n";
echo "<p>Вы научились \n";
echo "воспринимать модифицируемые представления как окна, отображающие данные \n";
echo "одиночной таблицы, но не обязательно исключающие или реорганизующие столбцы \n";
echo "посредством выбора только определенных строк отвечающих условию предиката.</p>\n";
echo "<p>Представления только_чтение, с другой стороны, могут содержать более допустимые \n";
echo "запросы SQL; они могут, следовательно, стать способом хранения запросов, которые \n";
echo "вам нужно часто выполнять в неизменной форме. Кроме того, наличие запроса, чей \n";
echo "вывод обрабатывается как объект данных, дает вам возможность иметь ясность и \n";
echo "удобство при создании запросов в выводе запросов.</p>\n";
echo "<p>Вы  можете теперь в представлении предотвращать создание командами модификации строк в базовой \n";
echo "таблице, которые не представлены в самом представлении, с \n";
echo "помощью предложения WITH CHECK OPTION в определения представления.</p>\n";
echo "<p>Вы можете \n";
echo "также использовать WITH CHECK OPTION как один из способов ограничения в базовой \n";
echo "таблице. В автономных запросах, вы обычно используете один или более столбцов в \n";
echo "предикате, не представленные среди выбранных для вывода, что не вызывает никаких \n";
echo "проблем. Но если эти запросы используются в модифицируемых представлениях, \n";
echo "появляются проблемы, так как эти запросы производят представления, которые не \n";
echo "могут иметь вставляемых в них строк.</p>\n";
echo "<p>Вы видели некоторые подходы к этим \n";
echo "проблемам. В Главах <a href=\"ch20.php\">20</a> и 21, мы говорили, что представления имеют прикладные \n";
echo "программы защиты. Вы можете дать пользователям возможность обращаться к \n";
echo "представлениям, не разрешая в то же время обращаться к таблицам, в которых эти \n";
echo "представления непосредственно находятся. Глава 22 будет исследовать вопросы \n";
echo "доступа к объектам данных в SQL.</p>\n";
echo "<h3><a name=\"21.9\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Какое из этих представлений - модифицируемое?\n";
echo "\n";
echo "       #1 CREATE VIEW Dailyorders\n";
echo "             AS SELECT DISTINCT cnum, snum, onum,\n";
echo "             odate\n";
echo "               FROM Orders;\n";
echo "\n";
echo "       #2 CREATE VIEW Custotals\n";
echo "             AS SELECT cname, SUM (amt)\n";
echo "                FROM Orders, Customers\n";
echo "                WHERE Orders.cnum = customer.cnum\n";
echo "                GROUP BY cname;\n";
echo "\n";
echo "       #3 CREATE VIEW Thirdorders\n";
echo "             AS SELECT *\n";
echo "                FROM Dailyorders\n";
echo "                WHERE odate = 10/03/1990;\n";
echo "\n";
echo "       #4 CREATE VIEW Nullcities\n";
echo "             AS SELECT snum, sname, city\n";
echo "                FROM Salespeople\n";
echo "                WHERE city IS NULL\n";
echo "                   OR sname BETWEEN 'A' AND 'MZ';\n";
echo "\n";
echo "2. Создайте представление таблицы Продавцов с именем Commissions\n";
echo "   (Комиссионные). Это представление должно включать только поля\n";
echo "   comm и snum. С помощью этого представления можно будет вводить\n";
echo "   или изменять комиссионные, но только для значений между .10 и .20.\n";
echo "\n";
echo "3. Некоторые SQL-реализации имеют встроенную константу, представляющую текущую дату,\n";
echo "   иногда называемую &quot; CURDATE &quot;. \n";
echo "   Слово CURDATE может, следовательно, использоваться в операторе SQL\n";
echo "   и заменяться текущей датой, когда его значение станет доступным, с помощью таких\n";
echo "   команд как SELECT или INSERT. Мы будем использовать\n";
echo "   представление таблицы Заказов с именем Entryorders для вставки строк\n";
echo "   в таблицу Заказов. Создайте таблицу заказов так, чтобы CURDATE\n";
echo "   автоматически вставлялась в поле odate, если не указано другое значение.\n";
echo "   Затем создайте представление Entryorders так, чтобы значения не могли быть указаны.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#21\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>  
