﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 18.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 18. ОГРАНИЧЕНИЕ ЗНАЧЕНИЙ ВАШИХ ДАННЫХ</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В <a href=\"ch17.php\">Главе 17</a> вы узнали, как создаются таблицы. Теперь \n";
echo "мы более основательно покажем вам, как вы можете устанавливать ограничения в \n";
echo "таблицах. Ограничения это часть определений таблицы, вводящая ограничения на значения, \n";
echo "которые вы можете вводить в столбцы. До этого места в данной книге ограничениями \n";
echo "на значения, которые вы могли вводить, были тип данных и размер вводимых \n";
echo "значений, которые должны быть совместимы с теми столбцами, куда эти значения \n";
echo "помещаются (как определено для команды CREATE TABLE или команды ALTER TABLE).</p>\n";
echo "<p>Ограничения дают вам значительно б&#769;ольшие возможности, и скоро вы это \n";
echo "увидите. Вы также узнаете, как определять значения по умолчанию. По умолчанию - \n";
echo "это значение, которое вставляется автоматически в любой столбец таблицы, когда \n";
echo "значение для этого столбца отсутствует в команде INSERT для этой таблицы. NULL \n";
echo "это наиболее широко используемое значение по умолчанию, но в этой главе будет \n";
echo "показано, как определять и другие значения по умолчанию.</p>\n";
echo "<h3><a name=\"18.1\">О</a>ГРАНИЧЕНИЕ ТАБЛИЦ</h3>\n";
echo "<p>Когда вы создаёте таблицу (или, когда вы её изменяете), вы можете указывать ограничения на значения, которые могут быть введены в поля. Если вы это сделали, \n";
echo "SQL будет отклонять любые значения, нарушающие критерии, которые вы определили.</p>\n";
echo "<p>Есть два основных типа ограничений: ограничение столбца и ограничение \n";
echo "таблицы. Различие между ними в том, что ограничение столбца применяется только к \n";
echo "отдельным столбцам, в то время как ограничение таблицы применяется к группам из \n";
echo "одного и более столбцов.</p>\n";
echo "<h3><a name=\"18.2\">О</a>БЪЯВЛЕНИЕ ОГРАНИЧЕНИЙ</h3>\n";
echo "<p>Вы вставляете ограничение столбца в конец имени столбца после типа данных и \n";
echo "перед запятой. Ограничение таблицы помещается в конец имени таблицы после \n";
echo "последнего имени столбца, но перед заключительной круглой скобкой. Далее показан \n";
echo "синтаксис для команды CREATE TABLE, расширенной для включения в неё ограничения:</p>\n";
echo "<pre>      CREATE TABLE &lt;table name&gt;\n";
echo "         (&lt;column name&gt; &lt;data type&gt; &lt;column constraint&gt;,\n";
echo "         &lt;column name&gt; &lt;data type&gt; &lt;column constraint&gt; ...\n";
echo "         &lt;table constraint&gt; (&lt;column name&gt;\n";
echo "         [, &lt;column name&gt; ])...);</pre>\n";
echo "<p>(Для краткости мы опустили аргумент размера, который иногда используется с \n";
echo "типом данных.) Поля данных в круглых скобках после ограничения таблицы это \n";
echo "поля, к которым применено данное ограничение. Ограничение столбца, естественно, \n";
echo "применяется к тем столбцам, после чьих имен оно следует. Остальная часть этой \n";
echo "глава будет описывать различные типы ограничений и их использование.</p>\n";
echo "<h3><a name=\"18.3\">И</a>СПОЛЬЗОВАНИЕ ОГРАНИЧЕНИЙ ДЛЯ ИСКЛЮЧЕНИЯ ПУСТЫХ (NULL) \n";
echo "ЗНАЧЕНИЙ</h3>\n";
echo "<p>Вы можете использовать команду CREATE TABLE, чтобы предотвратить появление в \n";
echo "поле пустых (NULL) указателей с помощью ограничения NOT NULL. Это ограничение \n";
echo "накладывается только для разнообразных столбцов. Вы можете вспомнить, что NULL \n";
echo "это специальное обозначение, которое отмечает поле как пустое. NULL может быть \n";
echo "полезен в тех случаях, когда вы хотите быть от этого гарантированы.</p>\n";
echo "<p>Очевидно, \n";
echo "что первичные ключи никогда не должны быть пустыми, поскольку это будет нарушать \n";
echo "их функциональные возможности. Кроме того, такие поля как имена требуют в \n";
echo "большинстве случаев определённых значений. Например, вы, вероятно, захотите \n";
echo "иметь имя для каждого заказчика в таблице Заказчиков. Если вы поместите ключевые \n";
echo "слова NOT NULL сразу после типа данных (включая размер) столбца, любая попытка \n";
echo "поместить значение NULL в это поле будет отклонена. В противном случае SQL \n";
echo "принимает, что NULL разрешен.</p>\n";
echo "<p>Например, давайте улучшим наше определение таблицы \n";
echo "Продавцов, не позволяя помещать NULL-значения в столбцы snum или sname:</p>\n";
echo "<pre>       CREATE TABLE Salespeople\n";
echo "          (Snum    integer NOT,\n";
echo "            Sname  char (10) NOT,\n";
echo "            city   char (10),\n";
echo "            comm   decimal);</pre>\n";
echo "<p>Важно помнить, что любому столбцу с ограничением NOT NULL должно быть \n";
echo "установлено значение в каждом предложении INSERT, воздействующем на таблицу. При \n";
echo "отсутствии NULL, SQL может не иметь значений для установки в эти столбцы, если, \n";
echo "конечно, значение по умолчанию, описанное ранее в этой главе, уже не было \n";
echo "назначено. Если ваша система поддерживает использование ALTER TABLE, чтобы \n";
echo "добавлять новые столбцы к уже существующей таблице, вы можете, вероятно, \n";
echo "помещать ограничение столбцов типа NOT NULL для этих новых столбцов. Однако, \n";
echo "если вы предписываете новому столбцу значение NOT NULL, текущая таблица должна \n";
echo "быть пустой.</p>\n";
echo "<h3><a name=\"18.4\">У</a>БЕДИТЕСЬ, ЧТО ЗНАЧЕНИЯ УНИКАЛЬНЫ</h3>\n";
echo "<p>В <a href=\"ch17.php\">Главе 17</a> мы обсудили использование уникальных \n";
echo "индексов, чтобы заставить поля иметь различные значения для каждой строки. Эта \n";
echo "практика осталась с прежних времен, когда SQL поддерживал ограничение UNIQUE. \n";
echo "Уникальность это свойство данных в таблице, и поэтому его более логично назвать \n";
echo "ограничением этих данных, а не просто свойством логического отличия, связывающим \n";
echo "объект данных (индекс). Несомненно, уникальные индексы - один из самых простых и \n";
echo "наиболее эффективных методов предписания уникальности. По этой причине некоторые \n";
echo "реализации ограничения UNIQUE используют уникальные индексы; то есть они создают \n";
echo "индекс, не сообщая вам об этом. Остается фактом, что вероятность беспорядка в \n";
echo "базе данных достаточно мала, если вы предписываете уникальность вместе с \n";
echo "ограничением.</p>\n";
echo "<h4>УНИКАЛЬНОСТЬ КАК ОГРАНИЧЕНИЕ СТОЛБЦА</h4>\n";
echo "<p>Время от времени вам нужно будет убедиться, что все значения, введённые в \n";
echo "столбец, отличаются друг от друга. Например, первичные ключи. Если вы помещаете \n";
echo "ограничение столбца UNIQUE в поле при создании таблицы, база данных отклонит \n";
echo "любую попытку ввода в это поле для одной из строк значения, которое уже \n";
echo "представлено в другой строке. Это ограничение может применяться только к полям, \n";
echo "которые были объявлены как непустые (NOT NULL), так как не имеет смысла позволить \n";
echo "одной строке таблицы иметь значение NULL, а затем исключать другие строки с NULL-значениями как дубликаты.</p>\n";
echo "<p>Вот дальнейшее усовершенствование нашей команды \n";
echo "создания таблицы Продавцов:</p>\n";
echo "<pre>      CREATE TABLE Salespeople\n";
echo "       (Snum    integer NOT NULL UNIQUE,\n";
echo "         Sname  char (10) NOT NULL UNIQUE,\n";
echo "         city   char (10),\n";
echo "         comm   decimal);</pre>\n";
echo "<p>Когда вы объявляете поле sname уникальным, убедитесь, что две Mary Smith \n";
echo "будут введены различными способами, например, Mary Smith и M. Smith. В то же \n";
echo "время это не так уж необходимо с функциональной точки зрения, потому что поле \n";
echo "snum в качестве первичного ключа всё равно обеспечит отличие этих двух строк, \n";
echo "что проще, нежели помнить, что эти Smith не идентичны. Столбцы (не первичные \n";
echo "ключи), чьи значения требуют уникальности, называются ключами-кандидатами или \n";
echo "уникальными ключами.</p>\n";
echo "<h4>УНИКАЛЬНОСТЬ КАК ОГРАНИЧЕНИЕ ТАБЛИЦЫ</h4>\n";
echo "<p>Вы можете также определить группу полей как уникальную с помощью команды \n";
echo "UNIQUE ограничения таблицы. Объявление группы полей уникальной отличается от \n";
echo "объявления уникальными индивидуальных полей, так как это комбинация значений, а \n";
echo "не просто индивидуальное значение, которое обязано быть уникальным.<br>\n";
echo "Уникальность \n";
echo "группы это представление порядка так, что бы пары строк со значениями столбцов &quot;a&quot;, \n";
echo "&quot;b&quot; и &quot;b&quot;, &quot;a&quot; рассматривались отдельно одна от другой. Наша БД сделана так, \n";
echo "чтобы каждый заказчик был назначен одному, и только одному, продавцу. Это \n";
echo "означает, что каждая комбинация номера заказчика (cnum) и номера продавца (snum) \n";
echo "в таблице Заказчиков должна быть уникальной. Вы можете убедиться в этом, создав \n";
echo "таблицу Заказчиков таким способом:</p>\n";
echo "<pre>       CREATE TABLE Customers\n";
echo "          (cnum       integer NOT NULL,\n";
echo "            cname     char (10) NOT NULL,\n";
echo "            city      char (10),\n";
echo "            rating    integer,\n";
echo "            snum      integer NOT NULL,\n";
echo "            UNIQUE    (cnum, snum));</pre>\n";
echo "<p>Обратите внимание, что оба поля в ограничении таблицы UNIQUE всё ещё \n";
echo "используют ограничение столбца NOT NULL. Если бы мы использовали ограничение \n";
echo "столбца UNIQUE для поля cnum, такое ограничение таблицы было бы необязательным. \n";
echo "Если значения поля cnum различны для каждой строки, то не может быть двух строк \n";
echo "с идентичной комбинацией значений полей cnum и snum. То же самое получится, если \n";
echo "мы объявим поле snum уникальным, хотя это и не будет соответствовать нашему \n";
echo "примеру, так как продавец будет назначен многочисленным заказчикам. \n";
echo "Следовательно, ограничение UNIQUE таблицы наиболее полезно, когда вы не хотите, \n";
echo "чтобы отдельные поля были уникальными.</p>\n";
echo "<p>Предположим, например, что мы разработали \n";
echo "таблицу для отслеживания всех заказов каждый день для каждого продавца. Каждая \n";
echo "строка такой таблицы представляет сумму чисел любых заказов, а не просто \n";
echo "индивидуальный заказ. В этом случае мы могли бы устранить некоторые возможные \n";
echo "ошибки, убедившись, что на каждый день имеется не более чем одна строка для \n";
echo "данного продавца или что каждая комбинация полей snum и odate является \n";
echo "уникальной. Вот как, например, мы могли бы создать таблицу с именем Salestotal:</p>\n";
echo "<pre>         CREATE TABLE Salestotal\n";
echo "          (cnum      integer NOT NULL,\n";
echo "            odate    date NULL,\n";
echo "            totamt   decimal,\n";
echo "            UNIQUE   (snum, odate));</pre>\n";
echo "<p>Кроме того, имеется команда, которую вы будете использовать, чтобы помещать \n";
echo "текущие данные в эту таблицу:</p>\n";
echo "<pre>            INSERT INTO Salestotal\n";
echo "               SELECT snum, odate, SUM (amt)\n";
echo "                  FROM Orders\n";
echo "                  GROUP BY snum, odate;</pre>\n";
echo "<h3><a name=\"18.5\">О</a>ГРАНИЧЕНИЕ ПЕРВИЧНЫХ КЛЮЧЕЙ</h3>\n";
echo "<p>До этого мы воспринимали первичные ключи исключительно как логические \n";
echo "понятия. Хоть мы и знаем, что такое первичный ключ и как он должен \n";
echo "использоваться в любой таблице, мы не в курсе, &quot;знает&quot; ли об этом SQL. Поэтому мы \n";
echo "использовали ограничение UNIQUE или уникальные индексы в первичных ключах, чтобы \n";
echo "предписывать им уникальность. В более ранних версиях языка SQL это было \n";
echo "необходимо и могло выполняться данным способом. Однако теперь SQL поддерживает \n";
echo "первичные ключи непосредственно ограничением Первичный Ключ (PRIMARE KEY). Это \n";
echo "ограничение может быть доступным или недоступным в вашей системе. PRIMARY KEY \n";
echo "может ограничивать таблицы или их столбцы. Это ограничение работает так же, как \n";
echo "и ограничение UNIQUE, за исключением случая, когда только один первичный ключ \n";
echo "(для любого числа столбцов) может быть определен для данной таблицы.&nbsp; \n";
echo "Имеется также различие между первичными ключами и уникальностью столбцов в \n";
echo "способе их использования с внешними ключами, о которых будет рассказано в\n";
echo "<a href=\"ch19.php\">Главе 19</a>. Синтаксис и определение их уникальности - те \n";
echo "же, что и для ограничения UNIQUE. Первичные ключи не могут позволить значений \n";
echo "NULL. Это означает, что, подобно полям в ограничении UNIQUE, любое поле, \n";
echo "используемое в ограничении PRIMARY KEY, должно уже быть объявлено NOT NULL. \n";
echo "Имеется улучшенный вариант создания нашей таблицы Продавцов:</p>\n";
echo "<pre>       CREATE TABLE Salestotal\n";
echo "          (snum     integer NOT NULL PRIMARY KEY,\n";
echo "            sname   char(10) NOT NULL UNIQUE,\n";
echo "            city    char(10),\n";
echo "            comm    decimal);</pre>\n";
echo "<p>Как  видите, уникальность (UNIQUE) полей может быть объявлена для той же \n";
echo "самой таблицы. Лучше всего помещать ограничение PRIMARY KEY в поле (или в поля), \n";
echo "которое будет образовывать ваш уникальный идентификатор строки, и сохранять \n";
echo "ограничение UNIQUE для полей, которые должны быть уникальными логически (такие \n";
echo "как номера телефона или поле sname), а не для идентификации строк.</p>\n";
echo "<h4>ПЕРВИЧНЫЕ КЛЮЧИ БОЛЕЕ ЧЕМ ОДНОГО ПОЛЯ</h4>\n";
echo "<p>Ограничение PRIMARY KEY может также быть применено для нескольких полей, \n";
echo "составляющих уникальную комбинацию значений. Предположим, что ваш первичный ключ \n";
echo "это имя и вы имеете первое имя и последнее имя, сохранёнными в двух различных \n";
echo "полях (так, что вы можете организовывать данные с помощью любого из них). \n";
echo "Очевидно, что ни первое, ни последнее имя нельзя заставить быть уникальным \n";
echo "самостоятельно, но мы можем каждую из этих двух комбинаций сделать уникальной.</p>\n";
echo "<p>Мы можем применить ограничение таблицы PRIMARY KEY для пар:</p>\n";
echo "<pre>        CREATE TABLE  Namefield\n";
echo "        (firstname      char (10) NOT NULL,\n";
echo "          lastname      char (10) NOT NULL\n";
echo "          city          char (10),\n";
echo "          PRIMARY KEY  (firstname, lastname));\n";
echo " \n";
echo "</pre>\n";
echo "<p>Одна проблема в этом подходе - мы можем вынудить появление уникальности, \n";
echo "например, введя Mary Smith и M. Smith. Это может ввести в заблуждение, потому \n";
echo "что ваши служащие могут не знать, кто из них кто. Обычно более надежный способ \n";
echo "определения числового поля, которое могло бы отличать одну строку от другой, - \n";
echo "иметь первичный ключ и применять ограничение UNIQUE для двух имен полей.</p>\n";
echo "<h3><a name=\"18.6\">П</a>РОВЕРКА ЗНАЧЕНИЙ ПОЛЕЙ</h3>\n";
echo "<p>Конечно, имеется любое число ограничений, которые можно устанавливать для \n";
echo "данных, вводимых в ваши таблицы, чтобы увидеть, например, находятся ли данные в \n";
echo "соответствующем диапазоне или правильном формате, о чем SQL, естественно, не \n";
echo "может знать заранее. Для этого SQL предоставляет вам ограничение CHECK, \n";
echo "позволяющее установить условие, которому должно удовлетворять значение, вводимое \n";
echo "в таблицу, прежде чем оно будет принято.</p>\n";
echo "<p>Ограничение CHECK состоит из ключевого \n";
echo "слова CHECK, сопровождаемого предложением предиката, который использует \n";
echo "указанное поле. Любая попытка модифицировать или вставить значение поля, которое \n";
echo "могло бы сделать этот предикат неверным, будет отклонена.</p>\n";
echo "<p>Давайте рассмотрим ещё \n";
echo "раз таблицу Продавцов. Столбец комиссионных выражается десятеричным числом и \n";
echo "поэтому может быть умножен непосредственно на сумму приобретений, в результате \n";
echo "чего будет получена сумма комиссионных (в долларах) продавца с установленным \n";
echo "справа значком доллара ($). Кто-то может использовать понятие процента, однако \n";
echo "можно ведь об этом и не знать. Если человек введёт по ошибке 14 вместо .14 для \n";
echo "указания, в процентах, своих комиссионных, это будет расценено как 14.0 , что \n";
echo "является законным десятеричным значением и будет нормально воспринято системой. \n";
echo "Чтобы предотвратить эту ошибку, мы можем наложить ограничение CHECK столбца, \n";
echo "чтобы убедиться, что вводимое значение меньше 1.</p>\n";
echo "<pre>       CREATE TABLE Salespeople\n";
echo "          (snum      integer NOT NULL PRIMARY KEY,\n";
echo "            sname    char(10) NOT NULL UNIQUE,\n";
echo "            city     char(10),\n";
echo "            comm     decimal CHECK (comm &lt; 1));</pre>\n";
echo "<h4>ИСПОЛЬЗОВАНИЕ CHECK ДЛЯ ПРЕДОПРЕДЕЛЕНИЯ ДОПУСТИМОГО ВВОДИМОГО ЗНАЧЕНИЯ</h4>\n";
echo "<p>Мы можем также использовать ограничение CHECK, чтобы защитить от ввода в поле \n";
echo "определённых значений, и таким образом предотвратить ошибку. Например, \n";
echo "предположим, что городами, в которых мы имеем офисы сбыта, являются Лондон, \n";
echo "Барселона, Сан-Хосе и Нью-Йорк. Если вам известны все продавцы, работающие в \n";
echo "каждом из этих офисов, нет необходимости разрешать ввод других значений. Если же \n";
echo "нет, использование ограничения может предотвратить опечатки и другие ошибки.</p>\n";
echo "<pre>    CREATE TABLE Salespeople\n";
echo "        (snum     integer NOT NULL UNIQUE,\n";
echo "         sname    char(10) NOT NULL UNIQUE,\n";
echo "         city     char(10) CHECK,\n";
echo "        (city IN ('London', 'New York', 'San Jose', 'Barselona')),\n";
echo "         comm     decimal CHECK (comm &lt; 1));</pre>\n";
echo "<p>Конечно, если вы собираетесь сделать это, вы должны быть уверены, что ваша \n";
echo "компания не открыла уже других новых офисов сбыта. Большинство программ баз \n";
echo "данных поддерживают команду ALTER TABLE (см. <a href=\"ch17.php\">Главу 17</a>), \n";
echo "которая позволяет изменять определение таблицы, даже когда она находится в \n";
echo "использовании. Однако изменение или удаление ограничений не всегда возможно для \n";
echo "этих команд, даже там, где это вроде бы поддерживается.<br>\n";
echo "Если вы используете \n";
echo "систему, которая не может удалять ограничения, вы должны будете создавать (CREATE) \n";
echo "новую таблицу и передавать информацию из старой таблицы в неё всякий раз, когда \n";
echo "вы хотите изменить ограничение. Конечно же, вы не захотите делать это часто и со \n";
echo "временем вообще перестанете это делать. Создадим таблицу Заказов:</p>\n";
echo "<pre>  CREATE TABLE Orders\n";
echo "    (onum     integer NOT NULL UNIQUE,\n";
echo "     amt      decimal,\n";
echo "     odate    date NOT NULL,\n";
echo "     cnum     integer NOT NULL,\n";
echo "     snum     integer NOT NULL);</pre>\n";
echo "<p>Как мы уже говорили в <a href=\"ch2.php\">Главе 2</a>, тип DATЕ (ДАТА) \n";
echo "широко поддерживается, но не является частью стандарта ANSI. Что же делать, если \n";
echo "мы используем БД, которая, следуя ANSI, не распознаёт тип DATЕ? Если мы объявим \n";
echo "поле odate с любым числовым типом, мы не сможем использовать слэш (/) или тире \n";
echo "(-) в качестве разделителя. Так как печатаемые номера это символы ASCII, мы \n";
echo "можем объявить тип поля date - CHAR. Основная проблема в том, что мы должны \n";
echo "будем использовать одинарные кавычки всякий раз, когда ссылаемся на значение \n";
echo "поля odate в запросе. Нет более простого решения этой проблемы там, где тип DATЕ \n";
echo "стал таким популярным. В качестве иллюстрации, давайте объявим поле odate типом \n";
echo "CHAR. Мы можем, как минимум, наложить на него наш формат с ограничением CHECK:</p>\n";
echo "<pre>       CREATE TABLE Orders\n";
echo "         (onum         integer NOT NULL UNIQUE,\n";
echo "           amt         decimal,\n";
echo "           odate       char (10) NOT NULL CHECK (odate LIKE '--/--/----'),\n";
echo "           cnum        NOT NULL,\n";
echo "           snum        NOT NULL);</pre>\n";
echo "<p>Кроме того, если вы хотите, вы можете наложить ограничения, гарантирующие, \n";
echo "что введенные символы - числа и что они в пределах значений нашего диапазона.</p>\n";
echo "<h4>ПРОВЕРКА УСЛОВИЙ, БАЗИРУЮЩИХСЯ НА НЕСКОЛЬКИХ ПОЛЯХ</h4>\n";
echo "<p>Вы можете также использовать CHECK в качестве табличного ограничения. Это \n";
echo "полезно в тех случаях, когда вы хотите включить более одного поля строки в \n";
echo "условие. Предположим, что комиссионные .15 и выше будут разрешены только для \n";
echo "продавца из Барселоны. Вы можете указать это с помощью следующего табличного \n";
echo "ограничения CHECK:</p>\n";
echo "<pre>       CREATE TABLE Salespeople\n";
echo "         (snum      integer NOT NULL UNIQUE,\n";
echo "           sname    char (10) NOT NULL UNIQUE,\n";
echo "           city     char(10),\n";
echo "           comm     decimal,\n";
echo "           CHECK    (comm &lt; .15 OR city = 'Barcelona'));</pre>\n";
echo "<p>Как видите, два различных поля должны быть проверены, чтобы определить, верен \n";
echo "предикат или нет. Имейте в виду, что это - два разных поля одной и той же \n";
echo "строки. Хотя вы можете использовать несколько полей, SQL не может проверить \n";
echo "более одной строки одновременно. Вы не можете, например, использовать \n";
echo "ограничение CHECK, чтобы удостовериться, что все комиссионные в данном городе \n";
echo "одинаковы. Чтобы сделать это, SQL должен всякий раз, просматривая другие строки \n";
echo "таблицы, когда вы модифицируете или вставляете строку, видеть, что значение \n";
echo "комиссионных указано для текущего города. SQL этого делать не умеет.<br>\n";
echo "Фактически \n";
echo "вы могли бы использовать сложное ограничение CHECK для вышеупомянутого, если бы \n";
echo "знали заранее, каковы должны быть комиссионные в разных городах. Например, вы \n";
echo "могли бы установить такое ограничение:</p>\n";
echo "<pre>     CHECK ((comm = .15 AND city = 'London')\n";
echo "        OR  (comm = .14 AND city = 'Barcelona')\n";
echo "        OR  (comm = 11  AND city = 'San Jose')..)</pre>\n";
echo "<p>Мы подали вам идею. Чем налагать такой комплекс ограничений, вы могли бы просто \n";
echo "использовать представление с предложением WITH CHECK OPTION, которое имеет все \n";
echo "эти условия в своем предикате (смотри в Главах <a href=\"ch20.php\">20</a> и\n";
echo "<a href=\"ch21.php\">21</a> информацию о представлении и о WITH CHECK OPTION).</p>\n";
echo "<p>Пользователи могут обращаться к представлению таблицы вместо самой таблицы. \n";
echo "Одним из преимуществ этого будет то, что процедура изменения в ограничении не \n";
echo "будет такой болезненной или трудоёмкой. Представление с WITH CHECK OPTION - \n";
echo "хороший заменитель ограничению CHECK, что будет показано в <a href=\"ch21.php\">\n";
echo "Главе 21</a>.</p>\n";
echo "<h3><a name=\"18.7\">У</a>СТАНОВКА ЗНАЧЕНИЙ ПО УМОЛЧАНИЮ</h3>\n";
echo "<p>Когда вы вставляете строку в таблицу без указания в ней значений  для каждого \n";
echo "поля, SQL должен иметь значение по умолчанию для включения его в определённое \n";
echo "поле, или же команда будет отклонена. Наиболее общим значением по умолчанию \n";
echo "является NULL. Это - значение по умолчанию для любого столбца, которому не было \n";
echo "дано ограничение NOT NULL или который имеет другое  значение по умолчанию. \n";
echo "Значение DEFAULT (ПО УМОЛЧАНИЮ) указывается в команде CREATE TABLE тем же \n";
echo "способом, что и ограничение столбца, хотя, с технической точки зрения, значение \n";
echo "DEFAULT - не ограничительного свойства: оно не ограничивает значения, которые вы \n";
echo "можете вводить, а просто определяет, что может случиться, если вы не введёте \n";
echo "любое из них.</p>\n";
echo "<p>Предположим, что вы работаете в офисе Нью-Йорка и подавляющее \n";
echo "большинство ваших продавцов живут в Нью-Йорке. Вы можете указать Нью-Йорк в \n";
echo "качестве значения поля city по умолчанию для вашей таблицы Продавцов:</p>\n";
echo "<pre>CREATE TABLE Salespeople (snum integer NOT NULL UNIQUE,\n";
echo "	sname char(10) NOT NULL UNIQUE,\n";
echo "	city char(10) DEFAULT = 'New York',\n";
echo "	comm decimal CHECK (comm &lt; 1);</pre>\n";
echo "<p>Конечно, вводить значение Нью-Йорк в таблицу каждый раз, когда назначается \n";
echo "новый продавец, не так уж необходимо, и можно просто пренебречь им (не вводя \n";
echo "его), даже если оно должно иметь некоторое значение. Значение по умолчанию \n";
echo "такого типа более предпочтительно, чем, например, длинный конторский номер, \n";
echo "указывающий на ваш собственный офис в таблице Заказов. Длинные числовые значения \n";
echo "более предрасположены к ошибке, поэтому, если подавляющее большинство (или все) \n";
echo "ваших заказов должны иметь ваш собственный конторский номер, желательно \n";
echo "устанавливать для них значение по умолчанию.</p>\n";
echo "<p>Другой способ использования значения \n";
echo "по умолчанию - использовать его как альтернативу  NULL. Так как NULL \n";
echo "(фактически) является false при любом сравнении, ином, нежели IS NULL, он может \n";
echo "быть исключён с помощью большинства предикатов.</p>\n";
echo "<p>Иногда вам нужно видеть пустые \n";
echo "значения ваших полей, не обрабатывая их каким-то определённым образом. Вы можете \n";
echo "установить значения по умолчанию, типа нуль или пробел, которые функционально \n";
echo "меньше по значению, чем просто не установленное значение - пустое значение \n";
echo "(NULL). Различие между ними и обычным NULL в том, что SQL будет обрабатывать их \n";
echo "так же, как и любое другое значение.</p>\n";
echo "<p>Предположим, что заказчикам не назначены \n";
echo "оценки изначально. Каждые шесть месяцев вы повышаете оценку всем вашим \n";
echo "заказчикам, имеющим оценку ниже средней, включая и тех, кто предварительно не \n";
echo "имел никакого назначения оценки. Если вы хотите выбрать всех этих заказчиков как \n";
echo "группу, следующий запрос исключит всех заказчиков с оценкой = NULL:</p>\n";
echo "<pre>         SELECT *\n";
echo "            FROM Customers\n";
echo "            WHERE rating &lt; = 100;</pre>\n";
echo "<p>Однако, если вы назначили значение по умолчанию = 000, в поле rating, \n";
echo "заказчики без оценок будут выбраны наряду с другими. Приоритет каждого метода \n";
echo "зависит от ситуации. Если вы будете делать запрос с помощью поля оценки, то \n";
echo "захотите ли вы включить строки без значений, или исключите их?<br>\n";
echo "Другая \n";
echo "характеристика значений по умолчанию этого типа позволит объявить  поле \n";
echo "оценки как NOT NULL. Если вы используете его по умолчанию, чтобы избежать \n";
echo "значений = NULL, то это, вероятно, хорошая защита от ошибок. Вы можете также \n";
echo "использовать ограничения UNIQUE или PRIMARY KEY в этом поле. Если вы сделаете \n";
echo "это, то имеете в виду, что только одна строка одновременно может иметь значение \n";
echo "по умолчанию. Любую строку, которая содержит значение по умолчанию нужно будет \n";
echo "модифицировать, прежде чем другая строка с установкой по умолчанию будет \n";
echo "вставлена. Это не так, как при обычном использовании значений по умолчанию, \n";
echo "поэтому ограничения UNIQUE и PRIMARY KEY (особенно последнее) обычно не \n";
echo "устанавливаются для строк со значениями по умолчанию.</p>\n";
echo "<h3><a name=\"18.8\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Вы теперь владеете несколькими способами управления значениями, которые могут \n";
echo "быть введены в ваши таблицы. Вы можете использовать ограничение NOT NULL, чтобы \n";
echo "исключать NULL; ограничение UNIQUE, чтобы вынуждать все значения в группе из \n";
echo "одного или более столбцов отличаться друг от друга; ограничение PRIMARY KEY, для \n";
echo "того чтобы делать в основном то же самое что и UNIQUE, но с различным \n";
echo "окончанием, и наконец ограничение CHECK - для определения ваших собственных \n";
echo "специальных условий, чтобы значения, встреченные перед ними, могли бы быть \n";
echo "введены.</p>\n";
echo "<p>Кроме того, вы можете использовать предложение DEFAULT, которое будет \n";
echo "автоматически вставлять значение по умолчанию в любое поле с именем, не \n";
echo "указанным в INSERT, так же, как вставляется значение NULL, когда предложение \n";
echo "DEFAULT не установлено и отсутствует ограничение NOT NULL.<br>\n";
echo "Ограничения FOREIGN \n";
echo "KEY или REFERENCES, о которых вы узнаете в <a href=\"ch19.php\">Главе 19</a>, \n";
echo "очень похожи на них, за исключением того, что они связывают группу из одного или \n";
echo "более полей с другой группой, и таким образом, сразу воздействуют на значения, \n";
echo "которые могут быть введены в любую из этих групп.</p>\n";
echo "<h3><a name=\"18.9\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Создайте таблицу Заказов так, чтобы все значения полей onum, а также\n";
echo "   все комбинации полей cnum и snum, отличались друг от друга и чтобы\n";
echo "   значения NULL исключались из поля даты.\n";
echo "\n";
echo "2. Создайте таблицу Продавцов так, чтобы комиссионные по умолчанию\n";
echo "   составляли 10%, не разрешались значения NULL, поле snum являлось первичным ключом\n";
echo "   и чтобы все имена были в алфавитном порядке между A и M включительно\n";
echo "   (учитывая, что все имена будут напечатаны в верхнем регистре).\n";
echo "\n";
echo "3. Создайте таблицу Заказов учётом того, что поле onum\n";
echo "   больше, чем поле cnum, а cnum больше, чем snum. Запрещены значения\n";
echo "   NULL в любом из этих трех полей.\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#18\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
