﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 12.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 12. Использование оператора EXISTS</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>Теперь, когда вы уже познакомились с подзапросами, мы можем поговорить о \n";
echo "некоторых специальных операторах, которые всегда принимают подзапросы как \n";
echo "аргументы. Вы узнаете о первом из их в этой главе. Остальные будут описаны в \n";
echo "следующей главе.</p>\n";
echo "<p>Оператор EXISTS используется, чтобы указать предикату, производить ли \n";
echo "подзапросу вывод или нет. В этой главе вы узнаете, как использовать этот \n";
echo "оператор со стандартными и (обычно) соотнесёнными подзапросами. Мы будем также \n";
echo "обсуждать специальные вопросы, которые перейдут в игру, когда вы будете \n";
echo "использовать этот оператор как относительный агрегат, как пустой указатель NULL \n";
echo "и как булев оператор. Кроме того, вы сможете повысить ваш профессиональный \n";
echo "уровень относительно подзапросов, исследуя их в более сложных прикладных \n";
echo "программах, чем те, которые мы видели до сих пор.</p>\n";
echo "<h3><a name=\"12.1\">К</a>АК РАБОТАЕТ EXISTS?</h3>\n";
echo "<p>EXISTS это оператор, который производит верное или неверное значение, другими \n";
echo "словами, булево выражение (см. в <a href=\"ch4.php\">Главе 4</a> обзор этого \n";
echo "термина).</p>\n";
echo "<p>Это означает, что он может работать автономно в предикате или в комбинации с \n";
echo "другими выражениями, использующими булевы операторы AND, OR и NOT. Он берет \n";
echo "подзапрос как аргумент и оценивает его как верный, если тот производит любой \n";
echo "вывод, или как неверный, если тот не делает этого. Этим он отличается от других \n";
echo "операторов предиката, в которых он не может быть неизвестным.</p>\n";
echo "<p>Например, мы можем \n";
echo "решить, извлекать ли нам некоторые данные из таблицы Заказчиков, если, и только \n";
echo "если, один или более заказчиков в этой таблице находятся в San Jose (вывод для \n";
echo "этого запроса показан на Рисунке 12.1):</p>\n";
echo "<pre>              SELECT cnum, cname, city\n";
echo "                  FROM Customers\n";
echo "                  WHERE EXISTS\n";
echo "                      (SELECT *\n";
echo "                          FROM Customers\n";
echo "                          WHERE city = &quot; San Jose');</pre>\n";
echo "<p>Внутренний запрос выбирает все данные для всех заказчиков в San Jose. \n";
echo "Оператор EXISTS во внешнем предикате отмечает, что некоторый вывод был \n";
echo "произведён подзапросом, и, поскольку выражение EXISTS было полным предикатом, \n";
echo "делает предикат верным. Подзапрос (не соотнесённый) был выполнен только один раз \n";
echo "для всего внешнего запроса, и, следовательно, имеет одно значение во всех \n";
echo "случаях. Поэтому EXISTS, когда используется этим способом, делает предикат \n";
echo "верным или неверным для всех строк сразу, что не так уж полезно для извлечения \n";
echo "определенной информации.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT snum, sname, city                      |\n";
echo "              | FROM  Customers                               |\n";
echo "              | WHERE EXISTS                                  |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers                                |\n";
echo "              | WHERE city = 'San Jose');                     |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city                     |\n";
echo "              |  -----    --------   ----                     |\n";
echo "              |   2001    Hoffman    London                   |\n";
echo "              |   2002    Giovanni   Rome                     |\n";
echo "              |   2003    Liu        San Jose                 |\n";
echo "              |   2004    Grass      Berlin                   |\n";
echo "              |   2006    Clemens    London                   |\n";
echo "              |   2008    Cisneros   San Jose                 |\n";
echo "              |   2007    Pereira    Rome                     |\n";
echo "                =============================================\n";
echo "\n";
echo "		Рисунок 12.1 Использование оператора EXISTS</pre>\n";
echo "<h3><a name=\"12.2\">В</a>ЫБОР СТОЛБЦОВ С ПОМОЩЬЮ EXISTS</h3>\n";
echo "<p>В вышеупомянутом примере, EXISTS должен быть установлен так, чтобы легко \n";
echo "выбрать один столбец, вместо того чтобы выбирать все столбцы, используя в выборе \n";
echo "звёздочку (SELECT *). В этом состоит его отличие от подзапроса, который (как вы \n";
echo "видели ранее в <a href=\"ch10.php\">Главе 10</a>, мог выбрать только один \n";
echo "столбец). Однако в принципе он мало отличается при выборе EXISTS-столбцов или \n";
echo "когда выбираются все столбцы, потому что он просто замечает, выполняется или нет \n";
echo "вывод из подзапроса, а не использует выведенные значения.</p>\n";
echo "<h3><a name=\"12.3\">И</a>СПОЛЬЗОВАНИЕ EXISTS С СООТНЕСЁННЫМИ ПОДЗАПРОСАМИ</h3>\n";
echo "<p>В соотнесённом подзапросе предложение EXISTS оценивается отдельно для каждой \n";
echo "строки таблицы, имя которой указано во внешнем запросе, точно так же, как и \n";
echo "другие операторы предиката, когда вы используете соотнесённый подзапрос. Это \n";
echo "даёт возможность использовать EXISTS как верный предикат, который генерирует \n";
echo "различные ответы для каждой строки таблицы, указанной в основном запросе. \n";
echo "Следовательно, информация из внутреннего запроса будет сохранена, если выведена \n";
echo "непосредственно, когда вы используете EXISTS таким способом. Например, мы можем \n";
echo "вывести продавцов, которые имеют нескольких заказчиков (вывод для этого \n";
echo "запроса показан на Рисунке 12.2):</p>\n";
echo "<pre>              SELECT DISTINCT snum\n";
echo "                  FROM Customers outer\n";
echo "                  WHERE EXISTS\n";
echo "                      (SELECT *\n";
echo "                           FROM Customers inner\n";
echo "                           WHERE inner.snum = outer.snum\n";
echo "                               AND inner.cnum &lt; &gt; outer.cnum);\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT DISTINCT cnum                          |\n";
echo "              | FROM  Customers outer                         |\n";
echo "              | WHERE EXISTS                                  |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers inner                          |\n";
echo "              | WHERE inner.snum = outer.snum                 |\n";
echo "              | AND inner.cnum &lt; &gt; outer.cnum);               |\n";
echo "              | ============================================= |\n";
echo "              |   cnum                                        |\n";
echo "              |  -----                                        |\n";
echo "              |   1001                                        |\n";
echo "              |   1002                                        |\n";
echo "                =============================================\n";
echo "\n";
echo "	  Рисунок 12.2 Использование EXISTS с соотнесённым подзапросом</pre>\n";
echo "<p>Для каждой строки-кандидата внешнего запроса (представляющей заказчика, \n";
echo "проверяемого в настоящее время) внутренний запрос находит строки, которые \n";
echo "совпадают со значением поля snum (которое имел продавец), но не со значением \n";
echo "поля cnum (соответствующего другим заказчикам). Если любые такие строки найдены \n";
echo "внутренним запросом, это означает, что имеются два разных заказчика, \n";
echo "обслуживаемых текущим продавцом (то есть продавцом заказчика в текущей \n";
echo "строке-кандидате из внешнего запроса). Предикат EXISTS поэтому верен для текущей \n";
echo "строки, и номер продавца поля (snum) таблицы, указанной во внешнем запросе, \n";
echo "будет выведен. Если DISTINCT не был указан, каждый из этих продавцов будет \n";
echo "выбран один раз для каждого заказчика, которому он назначен.</p>\n";
echo "<h3><a name=\"12.4\">К</a>ОМБИНАЦИЯ ИЗ EXISTS И ОБЪЕДИНЕНИЯ</h3>\n";
echo "<p>Однако для нас может быть полезнее вывести больше информации об этих \n";
echo "продавцах, а не только их номера. Мы можем сделать это, объединив таблицу \n";
echo "Заказчиков с таблицей Продавцов (вывод для запроса показан на Рисунке 12.3):</p>\n";
echo "<pre>             SELECT DISTINCT first.snum, sname, first.city\n";
echo "                FROM Salespeople first, Customers second\n";
echo "                WHERE EXISTS\n";
echo "                   (SELECT *\n";
echo "                      FROM Customers third\n";
echo "                      WHERE second.snum = third.snum\n";
echo "                            AND second.cnum &lt; &gt; third.cnum)\n";
echo "                   AND first.snum = second.snum;\n";
echo "\n";
echo "               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT DISTINCT first.snum, sname, first.city |\n";
echo "              | FROM  Salespeople first, Customers second     |\n";
echo "              | WHERE EXISTS                                  |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers third                          |\n";
echo "              | WHERE second.snum = third.snum                |\n";
echo "              | AND second.cnum &lt; &gt; third.cnum)               |\n";
echo "              | AND first.snum = second.snum;                 |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city                     |\n";
echo "              |  -----    --------   ----                     |\n";
echo "              |   1001    Peel       London                   |\n";
echo "              |   1002    Serres     San Jose                 |\n";
echo "                =============================================\n";
echo "\n";
echo "		Рисунок 12.3 Комбинация EXISTS с объединением</pre>\n";
echo "<p>Внутренний запрос здесь, как и в предыдущем варианте, фактически сообщает, \n";
echo "что псевдоним был изменён. Внешний запрос это объединение таблицы Продавцов с \n";
echo "таблицей Заказчиков, наподобие того, что мы видели прежде. Новое предложение \n";
echo "основного предиката (AND first.snum = second.snum), естественно, оценивается на \n";
echo "том же самом уровне, что и предложение EXISTS. Это функциональный предикат \n";
echo "самого объединения, сравнивающий две таблицы из внешнего запроса в терминах поля \n";
echo "snum, которое является для них общим. Из-за булева оператора AND, оба условия \n";
echo "основного предиката должны быть верны в заказе для верного предиката. \n";
echo "Следовательно, результаты подзапроса имеют смысл только в тех случаях, когда \n";
echo "вторая часть запроса верна, а объединение - выполнимо. Таким образом, комбинация \n";
echo "объединения и подзапроса может стать очень мощным способом обработки данных.</p>\n";
echo "<h3><a name=\"12.5\">И</a>СПОЛЬЗОВАНИЕ NOT EXISTS</h3>\n";
echo "<p>Предыдущий пример показал, что EXISTS может работать в комбинации с булевыми \n";
echo "операторами. Конечно, самым простым способом (и, вероятно, чаще всего \n";
echo "используемым с EXISTS) является оператор NOT. Один из способов, которым мы могли \n";
echo "бы найти всех продавцов только с одним заказчиком, будет состоять в том, чтобы \n";
echo "инвертировать наш предыдущий пример. (Вывод для этого запроса показан на Рисунке \n";
echo "12.4:)</p>\n";
echo "<pre>	SELECT DISTINCT snum\n";
echo "		FROM Customers outer\n";
echo "		WHERE NOT EXISTS\n";
echo "			(SELECT *\n";
echo "			FROM Customers inner\n";
echo "				WHERE inner.snum = outer.snum\n";
echo "				AND inner.cnum &lt; &gt; outer.cnum);</pre>\n";
echo "<h3><a name=\"12.6\">E</a>XISTS И АГРЕГАТЫ</h3>\n";
echo "<p>Одна вещь которую EXISTS не может сделать - использовать функцию агрегата в \n";
echo "подзапросе. Это имеет значение. Если функция агрегата находит любые строки для \n";
echo "операций с ними, EXISTS верен, невзирая на то, что это значение функции; если \n";
echo "же агрегатная функция не находит никаких строк, EXISTS неправилен.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | SELECT DISTINCT snum                          |\n";
echo "              | FROM  Salespeople outer                       |\n";
echo "              | WHERE NOT EXISTS                              |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers inner                          |\n";
echo "              | WHERE inner.snum = outer.snum                 |\n";
echo "              | AND inner.cnum &lt; &gt; outer.cnum);               |\n";
echo "              | ============================================= |\n";
echo "              |   cnum                                        |\n";
echo "              |  -----                                        |\n";
echo "              |   1003                                        |\n";
echo "              |   1004                                        |\n";
echo "              |   1007                                        |\n";
echo "                =============================================\n";
echo "\n";
echo "		Рисунок 12.4 Использование EXISTS с NOT</pre>\n";
echo "<p>Попытка использовать агрегаты с EXISTS таким способом, вероятно, покажет, что \n";
echo "проблема неверно решалась от начала до конца. Конечно, подзапрос в предикате \n";
echo "EXISTS может также использовать один или более из его собственных подзапросов. \n";
echo "Они могут иметь любой из различных типов, с которыми мы уже знакомы (или \n";
echo "познакомимся далее). Такие подзапросы и любые другие в них позволяют \n";
echo "использовать агрегаты, если нет другой причины, по которой они не могут быть \n";
echo "использованы. Следующий раздел приводит этому пример. В любом случае вы можете \n";
echo "получить тот же самый результат более легко, выбрав поле, которое вы \n";
echo "использовали в агрегатной функции, вместо использования самой этой функции. \n";
echo "Другими словами, предикат</p>\n";
echo "<pre>EXISTS (SELECT COUNT (DISTINCT sname) FROM Salespeople)</pre>\n";
echo "<p>будет эквивалентен</p>\n";
echo "<pre>EXISTS (SELECT sname FROM Salespeople)</pre>\n";
echo "<p>который был показан выше.</p>\n";
echo "<h3><a name=\"12.7\">У</a>ЛУЧШЕННЫЙ ПРИМЕР ПОДЗАПРОСА</h3>\n";
echo "<p>В возможных прикладных программах подзапросы могут становиться многократно \n";
echo "вкладываемыми. Вы можете вкладывать их два или более в одиночный запрос, и даже \n";
echo "один внутрь другого. Так как можно рассмотреть небольшой блок, чтобы получить \n";
echo "всю картину работы этой команды, вы можете воспользоваться способом в SQL, \n";
echo "который может принимать различные команды из большинства других языков.</p>\n";
echo "<p>Вот запрос, извлекающий строки всех продавцов, которые имеют заказчиков с более чем \n";
echo "одним текущим заказом. Это не обязательно самое простое решение этой проблемы, \n";
echo "но оно предназначено для того, чтобы показать улучшенную логику SQL. Вывод этой \n";
echo "информации связывает все три наши типовые таблицы:</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Salespeople first\n";
echo "               WHERE EXISTS\n";
echo "                  (SELECT *\n";
echo "                      FROM Customers second\n";
echo "                      WHERE first.snum = second.snum\n";
echo "                      AND 1 &lt;\n";
echo "                         (SELECT COUNT (*)\n";
echo "                              FROM Orders\n";
echo "                              WHERE Orders.cnum =\n";
echo "                               second.cnum));</pre>\n";
echo "<p>Вывод для этого запроса показан на Рисунке 12.5.</p>\n";
echo "<pre>               ===============  SQL Execution Log ============\n";
echo "              |                                               |\n";
echo "              | FROM  Salespeople first                       |\n";
echo "              | WHERE EXISTS                                  |\n";
echo "              | (SELECT *                                     |\n";
echo "              | FROM Customers second                         |\n";
echo "              | WHERE first.snum = second.snum                |\n";
echo "              | AND 1 &lt;                                       |\n";
echo "              | (SELECT  CONT (*)                             |\n";
echo "              | FROM Orders                                   |\n";
echo "              | WHERE Orders.cnum = second.cnum));            |\n";
echo "              | ============================================= |\n";
echo "              |   cnum     cname     city         comm        |\n";
echo "              |  -----    --------   ----       --------      |\n";
echo "              |   1001    Peel       London         0.17      |\n";
echo "              |   1002    Serres     San Jose       0.13      |\n";
echo "              |   1007    Rifkin     Barselona      0.15      |\n";
echo "                =============================================\n";
echo "\n";
echo "	Рисунок 12.5 Использование EXISTS с комплексным подзапросом</pre>\n";
echo "<p>Мы могли бы разобрать вышеупомянутый запрос примерно так:</p>\n";
echo "<p>Берём каждую строку таблицы Продавцов как строку-кандидат (внешний запрос) и \n";
echo "выполняем подзапросы. Для каждой строки-кандидата из внешнего запроса ставим в \n";
echo "соответствие каждую строку из таблицы Заказчиков (средний запрос). Если текущая \n";
echo "строка заказчиков не совпадает с текущей строкой продавца (т.е. если first.snum \n";
echo "&lt; &gt; second.snum), предикат среднего запроса неправилен. Всякий раз, когда мы \n";
echo "находим заказчика в среднем запросе который совпадает с продавцом во внешнем \n";
echo "запросе, мы должны рассматривать сам внутренний запрос чтобы определить, будет \n";
echo "ли наш средний предикат запроса верен. Внутренний запрос считает число заказов текущего заказчика (из среднего запроса). Если это число больше 1, предикат \n";
echo "среднего запроса верен, и строки выбираются. Это делает EXISTS-предикат внешнего \n";
echo "запроса верным для текущей строки продавца и означает, что по крайней мере один \n";
echo "из текущих заказчиков продавца имеет более чем один заказ.</p>\n";
echo "<p>Если это не кажется достаточно понятным для вас на данной стадии разбора примера, \n";
echo "не волнуйтесь. Сложность этого примера хороша, независимо от того, как часто вы \n";
echo "будете использовать её в деловой ситуации. Основная цель примеров такого типа \n";
echo "состоит в том, чтобы показать вам некоторые возможности, которые могут оказаться \n";
echo "в дальнейшем полезными. После работы со сложными ситуациями, подобными этой, \n";
echo "простые запросы, которые являются наиболее часто используемыми в SQL, покажутся \n";
echo "вам элементарными.</p>\n";
echo "<p>Кроме того, данный запрос, даже если он кажется удобным, довольно изощрён \n";
echo "как способ извлечения информации и делает много работы. Он связывает три разные \n";
echo "таблицы, чтобы дать вам эту информацию, а если таблиц больше, чем здесь указано, \n";
echo "будет трудно получить её напрямую (хотя это не единственный способ, и не \n";
echo "обязательно лучший способ в SQL). Возможно, вам нужно увидеть эту информацию \n";
echo "относительно регулярной основы - если, например, вы имеете премию в конце недели \n";
echo "для продавца, который получил несколько заказов от одного заказчика. В этом \n";
echo "случае нужно было бы вывести команду и сохранить её, чтобы использовать снова и \n";
echo "снова, по мере того как данные будут меняться (лучше всего сделать это с помощью \n";
echo "представления, которое мы будем проходить в <a href=\"ch20.php\">Главе 20</a>).</p>\n";
echo "<h3><a name=\"12.8\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>EXISTS, хотя он и кажется простым, может быть одним из самых непонятных \n";
echo "операторов SQL. Однако он обладает гибкостью и мощностью. В этой главе овладели \n";
echo "большинством возможностей, которые предоставляет EXISTS. В дальнейшем ваше \n";
echo "понимание улучшенной логики подзапроса значительно расширится.</p>\n";
echo "<p>Следующим шагом будет овладение тремя другими специальными операторами, \n";
echo "которые принимают подзапросы как аргументы: это ANY, ALL и SOME. Как вы \n";
echo "увидите в <a href=\"ch13.php\">Главе 13</a>, это альтернативные формулировки \n";
echo "некоторых возможностей, которые вы уже использовали, но которые иногда могут \n";
echo "оказаться предпочтительными.</p>\n";
echo "<h3><a name=\"12.9\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Напишите запрос, который использовал бы оператор EXISTS для извлечения всех\n";
echo "   продавцов, имеющих заказчиков с оценкой 300.\n";
echo "\n";
echo "2. Как бы вы решили предыдущую проблему, используя объединение?\n";
echo "\n";
echo "3. Напишите запрос, использующий оператор EXISTS, который выберет\n";
echo "   всех продавцов с заказчиками, размещёнными в их городах, которые ими не обслуживаются.\n";
echo "\n";
echo "4. Напишите запрос, который извлекал бы из таблицы Заказчиков каждого\n";
echo "   заказчика, назначенного продавцу, который в данный момент имеет\n";
echo "   по крайней мере ещё одного заказчика (кроме заказчика, которого вы\n";
echo "   выберете) с заказами в таблице Заказов (подсказка: это может\n";
echo "   быть похоже на структуру в примере с нашим трехуровневым подзапросом).\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php\">Приложении A</a>.)</pre>\n";
echo "</body></html>\n";
require_once ("../incfiles/end.php");  

?>
