﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8");  
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 10.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 10. ВСТАВКА ОДНОГО ЗАПРОСА ВНУТРЬ ДРУГОГО</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<p>В конце <a href=\"ch9.php\">Главы 9</a> мы говорили, что запросы могут \n";
echo "управлять другими запросами. В этой главе вы узнаете, как это делается (большей \n";
echo "частью) путём помещения запроса внутрь предиката другого запроса и \n";
echo "использования вывода внутреннего запроса в верном или неверном условии \n";
echo "предиката.</p>\n";
echo "<p>Вы сможете выяснить, какие виды операторов могут использовать \n";
echo "подзапросы, и посмотреть, как подзапросы работают со средствами SQL, такими как DISTINCT, с составными функциями и выводимыми выражениями.</p>\n";
echo "<p>Вы узнаете, как \n";
echo "использовать подзапросы с предложением HAVING, и получите некоторые наставления, \n";
echo "как правильно использовать подзапросы.</p>\n";
echo "<h3><a name=\"10.1\">К</a>АК РАБОТАЕТ ПОДЗАПРОС?</h3>\n";
echo "<p>С помощью SQL вы можете вкладывать запросы друга в друга. Обычно внутренний \n";
echo "запрос генерирует значение, которое проверяется в предикате внешнего запроса, \n";
echo "определяющего, верно оно или нет. Например, предположим, что мы знаем имя \n";
echo "продавца: Motika, но не знаем значение его поля snum и хотим извлечь все заказы \n";
echo "из таблицы Заказов. Вот способ сделать это (вывод показан на Рис. 10.1 \n";
echo "):</p>\n";
echo "<pre>	SELECT *\n";
echo "       		FROM Orders\n";
echo "       		WHERE snum =\n";
echo "           		(SELECT snum\n";
echo "                		FROM Salespeople\n";
echo "                		WHERE sname = 'Motika');</pre>\n";
echo "<p>Чтобы оценить внешний (основной) запрос, SQL сначала должен оценить \n";
echo "внутренний запрос (или подзапрос) внутри предложения WHERE. Он делает это так, \n";
echo "как и должен делать запрос, имеющий единственную цель - отыскать через таблицу \n";
echo "Продавцов все строки, где поле sname равно значению Motika, а затем извлечь \n";
echo "значения поля snum этих строк.</p>\n";
echo "<p>Единственной найденной строкой, естественно, будет snum = 1004. Однако SQL не \n";
echo "просто выдает это значение, а помещает его в предикат основного запроса вместо \n";
echo "самого подзапроса, так чтобы предикат прочитал, что</p>\n";
echo "<pre>			WHERE snum = 1004\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders                                    |\n";
echo "              | WHERE snum =                                    |\n";
echo "              | (SELECT snum                                    |\n";
echo "              | FROM Salespeople                                |\n";
echo "              | WHERE sname = 'Motika');                        |\n";
echo "              |=================================================|\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----     -------  ----------  -----    -----  |\n";
echo "              |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "              |                                                 |\n";
echo "               =================================================</pre>\n";
echo "<pre>	<span lang=\"en-us\">	    </span>Рисунок 10.1 Использование подзапроса</pre>\n";
echo "<p>Основной запрос затем выполняется как обычно с вышеупомянутыми результатами. \n";
echo "Разумеется, подзапрос должен выбрать один, и только один, столбец, а тип данных \n";
echo "этого столбца должен совпадать с тем значением, с которым он будет сравниваться \n";
echo "в предикате.<br>\n";
echo "Часто, как показано выше, выбранное поле и его значение будут иметь \n";
echo "одинаковые имена (в данном случае snum), но это не обязательно. Конечно, если бы \n";
echo "мы уже знали номер продавца Motika, мы могли бы просто напечатать WHERE snum = \n";
echo "1004 и работать далее с подзапросом в целом, но это было бы не так \n";
echo "универсально. Этот же запрос будет продолжать работать, даже если номер Motika изменился, а \n";
echo "с помощью простого изменения имени в подзапросе вы можете использовать его для \n";
echo "чего угодно.</p>\n";
echo "<h3><a name=\"10.2\">З</a>НАЧЕНИЯ, КОТОРЫЕ ПОДЗАПРОС МОЖЕТ ВЫВОДИТЬ</h3>\n";
echo "<p>Скорее всего, было бы удобнее, чтобы наш подзапрос в предыдущем примере \n";
echo "возвращал одно, и только одно, значение.</p>\n";
echo "<p>Имея выбранное поле snum &quot; WHERE city = &quot;London&quot; вместо &quot;WHERE sname = 'Motika&quot;, \n";
echo "можно получить несколько различных значений. Это может сделать в предикате \n";
echo "основного запроса невозможным оценку верности или неверности, и команда выдаст \n";
echo "ошибку.</p>\n";
echo "<p>При использовании подзапросов в предикатах, основанных на реляционных \n";
echo "операциях (уравнениях или неравенствах, как объяснено в <a href=\"ch4.php\">\n";
echo "Главе 4</a>), вы должны убедиться, что использовали подзапрос, который будет \n";
echo "выдавать одну, и только одну, строку вывода. Если вы используете подзапрос, \n";
echo "который не выводит никаких значений вообще, команда не потерпит неудачи, но \n";
echo "основной запрос не выведет никаких значений. Подзапросы, которые не производят \n";
echo "никакого вывода (или нулевой вывод), вынуждают рассматривать предикат ни как \n";
echo "верный, ни как неверный, а как неизвестный. Однако неизвестный предикат имеет \n";
echo "тот же самый эффект, что и неверный: никакие строки не выбираются основным \n";
echo "запросом (смотри в <a href=\"ch5.php\">Главе 5</a> подробную информацию о \n";
echo "неизвестном предикате).</p>\n";
echo "<p>Вот пример плохой стратегии:</p>\n";
echo "<pre>                 SELECT *\n";
echo "                    FROM Orders\n";
echo "                    WHERE snum =\n";
echo "                      (SELECT snum\n";
echo "                           FROM Salespeople\n";
echo "                           WHERE city = Barcelona);\n";
echo "</pre>\n";
echo "<p>Поскольку мы имеем только одного продавца в Barcelona - Rifkin, то подзапрос \n";
echo "будет выбирать одиночное значение snum, и, следовательно, будет принят. Но это \n";
echo "только в данном случае. Большинство БД SQL имеют многочисленных пользователей, \n";
echo "и, если другой пользователь добавит нового продавца из Barcelona в таблицу, \n";
echo "подзапрос выберет два значения, и ваша команда потерпит неудачу.</p>\n";
echo "<h3><a name=\"10.3\">D</a>ISTINCT С ПОДЗАПРОСАМИ</h3>\n";
echo "<p>В некоторых случаях вы можете использовать DISTINCT чтобы вынудить \n";
echo "подзапрос генерировать одиночное значение. Предположим что мы хотим найти все \n";
echo "порядки кредитования для тех продавцов, которые обслуживают Hoffman'а (cnum = \n";
echo "2001).</p>\n";
echo "<p>Вот способ сделать это (вывод показан на Рисунке 10.2):</p>\n";
echo "<pre>            SELECT *\n";
echo "               FROM Orders\n";
echo "               WHERE snum =\n";
echo "                  (SELECT DISTINCT snum\n";
echo "                       FROM Orders\n";
echo "                       WHERE cnum = 2001);\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders                                    |\n";
echo "              | WHERE snum =                                    |\n";
echo "              | (SELECT DISTINCT snum                           |\n";
echo "              | FROM Orders                                     |\n";
echo "              | Where cnum = 2001);                             |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----   ---------  ---------   ------  ------- |\n";
echo "              |   3003      767.19  10/03/1990   2001     1001  |\n";
echo "              |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "              |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "                ================================================\n";
echo "\n";
echo "\n";
echo "  Рисунок 10.2 Использование DISTINCT для получения одного значения из подзапроса\n";
echo "</pre>\n";
echo "<p>Подзапрос установил, что значение поля snum совпало с Hoffman - 1001, а затем \n";
echo "основной запрос выделил все заказы с этим значением snum из таблицы Заказов (не \n";
echo "разбирая, относятся они к Hoffman или нет). Так как каждый заказчик назначен \n";
echo "продавцу, мы знаем, что каждая строка в таблице Заказов с данным значением cnum \n";
echo "должна иметь такое же значение snum. Однако, поскольку там может быть любое \n";
echo "число таких строк, подзапрос мог бы вывести много (хотя и идентичных) значений \n";
echo "snum для данного поля cnum. Аргумент DISTINCT предотвращает это. Если наш \n";
echo "подзапрос возвратит более одного значения, это будет указывать на ошибку в наших \n";
echo "данных - хорошая вещь для знающих об этом.<br>\n";
echo "Должен быть и альтернативный подход, \n";
echo "чтобы ссылаться к таблице Заказчиков, а не к таблице Заказов в подзапросе. Так \n";
echo "как поле cnum это первичный ключ таблицы Заказчиков, запрос, выбирающий его, \n";
echo "должен выдать только одно значение. Это рационально, только если вы как \n";
echo "пользователь имеете доступ к таблице Заказов, но не к таблице Заказчиков. В этом \n";
echo "случае вы можете использовать решение, которое мы показали выше. (SQL имеет \n";
echo "механизмы, которые определяют, кто имеет привилегии на выполнение действий в \n";
echo "определённой таблице. Это будет объясняться в <a href=\"ch22.php\">Главе 22</a>.)</p>\n";
echo "<p>Пожалуйста, учтите, что методика, используемая в предшествующем примере, \n";
echo "применима, только когда вы знаете, что два различных поля в таблице должны \n";
echo "всегда совпадать, как в нашем случае. Эта ситуация не является типичной в \n";
echo "реляционных базах данных (РБД), она является исключением из правил.</p>\n";
echo "<h3><a name=\"10.4\">П</a>РЕДИКАТЫ С ПОДЗАПРОСАМИ ЯВЛЯЮТСЯ НЕОБРАТИМЫМИ</h3>\n";
echo "<p>Вы должны обратить внимание что предикаты, включающие подзапросы, используют \n";
echo "выражение</p>\n";
echo "<pre>            &lt;скалярная форма&gt; &lt;оператор&gt; &lt;подзапрос&gt;,</pre>\n";
echo "<p>а не</p>\n";
echo "<pre>           &lt;подзапрос&gt; &lt;оператор&gt; &lt;скалярное выражение&gt;</pre>\n";
echo "<p>или</p>\n";
echo "<pre>           &lt;подзапрос&gt; &lt;оператор&gt; &lt;подзапрос&gt;.</pre>\n";
echo "<p>Другими словами, вы не должны записывать предыдущий пример так:</p>\n";
echo "<pre>                   SELECT *\n";
echo "                      FROM Orders\n";
echo "                      WHERE (SELECT DISTINCT snum\n";
echo "                           FROM Orders\n";
echo "                           WHERE cnum = 2001)\n";
echo "                      = snum;</pre>\n";
echo "<p>В строгой ANSI-реализации это приведет к неудаче, хотя некоторые программы и \n";
echo "позволяют делать такие вещи. ANSI также предохраняет  от появления в выводе \n";
echo "подзапроса обоих \n";
echo "значений при сравнении.</p>\n";
echo "<h3><a name=\"10.5\">И</a>СПОЛЬЗОВАНИЕ АГРЕГАТНЫХ ФУНКЦИЙ В ПОДЗАПРОСАХ</h3>\n";
echo "<p>Тип функций, который автоматически может производить одиночное значение для \n";
echo "любого числа строк, конечно же - агрегатная функция.</p>\n";
echo "<p>Любой запрос, использующий одиночную функцию агрегата без предложения GROUP \n";
echo "BY, будет выбирать одиночное значение для использования в основном предикате. \n";
echo "Например, вы хотите увидеть все заказы, имеющие сумму выше средней на 4-е \n";
echo "октября (вывод показан на Рисунке 10.3):</p>\n";
echo "<pre>             SELECT *\n";
echo "                 FROM Orders\n";
echo "                 WHERE amt &gt;\n";
echo "                    (SELECT AVG (amt)\n";
echo "                         FROM Orders\n";
echo "                         WHERE odate = 10/04/1990);\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders                                    |\n";
echo "              | WHERE amt &gt;                                     |\n";
echo "              | (SELECT AVG (amt)                               |\n";
echo "              | FROM Orders                                     |\n";
echo "              | WHERE odate = 01/04/1990);                      |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----    --------  ----------  -----    -----  |\n";
echo "              |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "              |   3005     2345.45  10/03/1990   2003     1002  |\n";
echo "              |   3006     1098.19  10/03/1990   2008     1007  |\n";
echo "              |   3009     1713.23  10/04/1990   2002     1003  |\n";
echo "              |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "              |   3010     1309.95  10/06/1990   2004     1002  |\n";
echo "              |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "                ================================================\n";
echo "\n";
echo "	Рисунок 10.3 Выбор всех сумм со значением выше среднего на 10/04/1990</pre>\n";
echo "<p>Средняя сумма приобретений на 4 октября - 1788.98 (1713.23 + 75.75) делится \n";
echo "пополам, что в целом равняется 894.49. Все строки со значением в поле amt выше \n";
echo "этого являются выбранными. Имейте в виду, что сгруппированные агрегатные функции, \n";
echo "которые являются агрегатными функциями, определёнными в терминах предложения GROUP BY, могут производить многочисленные значения. Они, следовательно, \n";
echo "недопустимы в подзапросах такого характера. Даже если GROUP BY и HAVING \n";
echo "используются таким способом, что только одна группа выводится с помощью \n";
echo "подзапроса, команда будет отклонена в принципе. Вы должны использовать одиночную \n";
echo "агрегатную функцию с предложением WHERE, что устранит нежелательные группы.</p>\n";
echo "<p>Например, следующий запрос который должен найти среднее значение комиссионных \n";
echo "продавца в Лондоне,</p>\n";
echo "<pre>                SELECT AVG (comm)\n";
echo "                    FROM Salespeople\n";
echo "                    GROUP BY city\n";
echo "                    HAVlNG city = &quot;London&quot;;</pre>\n";
echo "<p>не может использоваться в подзапросе! Во всяком случае, это не лучший способ \n";
echo "формировать запрос.</p>\n";
echo "<p>Другим способом может быть</p>\n";
echo "<pre>                 SELECT AVG (comm)\n";
echo "                    FROM Salespeople\n";
echo "                    WHERE city = &quot;London&quot;;</pre>\n";
echo "<h3><a name=\"10.6\">И</a>СПОЛЬЗОВАНИЕ ПОДЗАПРОСОВ, КОТОРЫЕ ВЫДАЮТ МНОГО СТРОК С ПОМОЩЬЮ ОПЕРАТОРА IN</h3>\n";
echo "<p>Вы можете использовать подзапросы, которые производят любое число строк, если \n";
echo "вы применяете специальный оператор IN (операторы BETWEEN, LIKE и IS NULL не \n";
echo "могут использоваться с подзапросами). Как вы помните, IN определяет набор \n";
echo "значений, одно из которых должно совпадать с другим термином уравнения предиката \n";
echo "в заказе, чтобы предикат был верным.<br>\n";
echo "Когда вы используете IN с подзапросом, SQL \n";
echo "просто формирует этот набор из вывода подзапроса. Мы можем, следовательно, \n";
echo "использовать IN чтобы выполнить такой  подзапрос, который не будет работать с \n";
echo "реляционным оператором, и найти все атрибуты таблицы Заказов для продавца в \n";
echo "Лондоне (вывод показан на Рисунке 10.4):</p>\n";
echo "<pre>            SELECT *\n";
echo "                FROM Orders\n";
echo "                WHERE snum IN\n";
echo "                     (SELECT snum\n";
echo "                         FROM Salespeople\n";
echo "                         WHERE city = &quot;LONDON&quot;);\n";
echo "\n";
echo "\n";
echo "               ===============  SQL Execution Log ==============\n";
echo "              |                                                 |\n";
echo "              | SELECT *                                        |\n";
echo "              | FROM  Orders                                    |\n";
echo "              | WHERE snum IN                                   |\n";
echo "              | (SELECT snum                                    |\n";
echo "              | FROM Salespeople                                |\n";
echo "              | WHERE city = 'London');                         |\n";
echo "              | =============================================== |\n";
echo "              |   onum       amt      odate      cnum     snum  |\n";
echo "              |  -----    --------  ----------  -----   ------  |\n";
echo "              |   3003      767.19  10/03/1990   2001     1001  |\n";
echo "              |   3002     1900.10  10/03/1990   2007     1004  |\n";
echo "              |   3006     1098.19  10/03/1990   2008     1007  |\n";
echo "              |   3008     4723.00  10/05/1990   2006     1001  |\n";
echo "              |   3011     9891.88  10/06/1990   2006     1001  |\n";
echo "                ================================================\n";
echo "\n";
echo "		  Рисунок 10.4 Использование подзапроса с IN</pre>\n";
echo "<p>В ситуации, подобной этой, подзапрос  проще для понимания пользователем и  проще для \n";
echo "выполнения компьютером,  чем если бы вы \n";
echo "использовали объединение:</p>\n";
echo "<pre>		SELECT onum, amt, odate, cnum, Orders.snum\n";
echo "			FROM Orders, Salespeople\n";
echo "			WHERE Orders.snum = Salespeople.snum\n";
echo "				AND Salespeople.city = &quot;London&quot;;</pre>\n";
echo "<p>Хотя это и произведёт тот же самый вывод, что в примере с подзапросом, SQL \n";
echo "должен будет просмотреть каждую возможную комбинацию строк из двух таблиц и \n";
echo "проверить их снова по составному предикату. Проще и эффективнее извлекать из \n";
echo "таблицы Продавцов значения поля snum, где city = &quot;London&quot;, а затем искать эти \n";
echo "значения в таблице Заказов, как это делается в варианте с подзапросом. \n";
echo "Внутренний запрос даёт нам snums=1001 и snum=1004. Внешний запрос затем даёт нам \n";
echo "строки из таблицы Заказов, где эти поля snum найдены.<br>\n";
echo "Строго говоря, то, быстрее или нет работает вариант подзапроса, практически \n";
echo "зависит от реализации - в какой программе вы это используете. Часть вашей \n";
echo "программы, называемая оптимизатор, \n";
echo "пытается найти наиболее эффективный способ выполнения ваших запросов. Хороший \n";
echo "оптимизатор в любом случае преобразует вариант объединения в подзапрос, но нет \n";
echo "достаточно простого способа, чтобы выяснить, выполнено это или нет. \n";
echo "Лучше сохранить ваши запросы в памяти, нежели полагаться полностью на \n";
echo "оптимизатор.<br>\n";
echo "Конечно, вы можете также использовать оператор IN, даже когда вы \n";
echo "уверены, что подзапрос произведет одиночное значение. В любой ситуации, где вы \n";
echo "можете использовать реляционный оператор сравнения (=), вы можете использовать \n";
echo "IN. В отличие от реляционных операторов, IN не может заставить команду потерпеть \n";
echo "неудачу, если больше чем одно значение выбрано подзапросом. Это может быть или \n";
echo "преимуществом или недостатком. Вы не увидите непосредственно вывода из \n";
echo "подзапросов, если вы полагаете, что подзапрос собирается произвести только одно \n";
echo "значение, а он производит несколько. Вы не сможете объяснить различия в выводе \n";
echo "основного запроса. Например, рассмотрим команду, которая похожа на предыдущую:</p>\n";
echo "<pre>              SELECT onum, amt, odate\n";
echo "                  FROM Orders\n";
echo "                  WHERE snum =\n";
echo "                      (SELECT  snum\n";
echo "                      FROM Orders\n";
echo "                      WHERE cnum = 2001);</pre>\n";
echo "<p>Вы можете устранить потребность в DISTINCT, используя IN вместо (=):</p>\n";
echo "<pre>              SELECT onum, amt, odate\n";
echo "                  FROM Orders\n";
echo "                  WHERE snum IN\n";
echo "                      (SELECT snum\n";
echo "                      FROM Orders\n";
echo "                      WHERE cnum = 2001);</pre>\n";
echo "<p>Что случится, если есть ошибка и один из заказов был аккредитован различным \n";
echo "продавцам? Версия, использующая IN, будет выдавать вам все заказы для обоих \n";
echo "продавцов. Нет никакого очевидного способа наблюдения за ошибкой, и поэтому \n";
echo "сгенерированные отчеты или решения, сделанные на основе этого запроса, не будут \n";
echo "содержать ошибки. Вариант, использующий (=), просто потерпит неудачу. Это, по \n";
echo "крайней мере, позволило вам узнать, что имеется такая проблема. Вы должны затем \n";
echo "выполнять поиск неисправности, выполнив этот подзапрос отдельно и наблюдая \n";
echo "значения, которые он производит. В принципе, если вы знаете, что подзапрос должен \n";
echo "(по логике) вывести только одно значение, вы должны использовать =.<br>\n";
echo "IN является \n";
echo "подходящим, если запрос может ограниченно производить одно или более значений, \n";
echo "независимо от того, ожидаете вы их или нет. Предположим, мы хотим знать \n";
echo "комиссионные всех продавцов, обслуживающих заказчиков в Лондоне:</p>\n";
echo "<pre>           SELECT comm\n";
echo "              FROM Salespeople\n";
echo "              WHERE snum IN\n";
echo "                (SELECT snum\n";
echo "                    FROM Customers\n";
echo "                    WHERE city = &quot;London&quot;);</pre>\n";
echo "<p>Выводимыми для этого запроса, показанного в Рисунке 10.5, являются значения \n";
echo "комиссионных продавца Peel (snum = 1001), который имеет обоих заказчиков в \n";
echo "Лондоне. Но это только для данного случая. Нет никакой причины, чтобы некоторые \n";
echo "заказчики в Лондоне не могли быть назначены кому-то ещё. Следовательно, IN - это \n";
echo "наиболее логичная форма для использования в запросе.</p>\n";
echo "<pre>                   ===============  SQL Execution Log ==============\n";
echo "                  |                                                 |\n";
echo "                  | SELECT comm                                     |\n";
echo "                  | FROM  Salespeople                               |\n";
echo "                  | WHERE snum IN                                   |\n";
echo "                  | (SELECT snum                                    |\n";
echo "                  | FROM Customers                                  |\n";
echo "                  | WHERE city = 'London');                         |\n";
echo "                  | =============================================== |\n";
echo "                  |    comm                                         |\n";
echo "                  |  -------                                        |\n";
echo "                  |    0.12                                         |\n";
echo "                  |                                                 |\n";
echo "                  |                                                 |\n";
echo "                    ================================================\n";
echo "\n";
echo "\n";
echo "	Рисунок 10.5 Использование IN с подзапросом для вывода одного значения</pre>\n";
echo "<p>Между прочим, префикс таблицы для поля city в предыдущем примере не \n";
echo "обязателен, несмотря на возможную неоднозначность между полями city таблицы \n";
echo "Заказчика и таблицы Продавцов. SQL всегда ищет первое поле в таблице, \n";
echo "обозначенной в предложении FROM текущего подзапроса. Если поле с данным именем \n";
echo "там не найдено, проверяются внешние запросы. В вышеупомянутом примере, &quot;city&quot; в \n";
echo "предложении WHERE означает, что имеется ссылка на Customer.city (поле city \n";
echo "таблицы Заказчиков). Так как таблица Заказчиков указана в предложении FROM \n";
echo "текущего запроса, SQL предполагает что это правильно. Это предположение может \n";
echo "быть отменено полным именем таблицы или префиксом псевдонима, о которых мы \n";
echo "поговорим позже, когда будем говорить о соотнесенных подзапросах. Если возможен \n";
echo "беспорядок, конечно же, лучше всего использовать префиксы.</p>\n";
echo "<h4>ПОДЗАПРОСЫ ВЫБИРАЮТ ОДИНОЧНЫЕ СТОЛБЦЫ</h4>\n";
echo "<p>Смысл всех подзапросов, обсуждённых в этой главе, в том, что все они выбирают \n";
echo "одиночный столбец. Это обязательно, поскольку полученный вывод сравнивается с \n";
echo "одиночным значением. Подтверждением этому является то, что SELECT * не может \n";
echo "использоваться в подзапросе. Имеется исключение из этого, когда подзапросы \n";
echo "используются с оператором EXISTS, о котором мы будем говорить в\n";
echo "<a href=\"ch12.php\">Главе 12</a>.</p>\n";
echo "<h4>ИСПОЛЬЗОВАНИЕ ВЫРАЖЕНИЙ В ПОДЗАПРОСАХ</h4>\n";
echo "<p>Вы можете использовать выражение, основанное на столбце, а не просто сам \n";
echo "столбец, в предложении SELECT подзапроса. Это может быть выполнено или с помощью \n";
echo "реляционных операторов, или с IN. Например, следующий запрос использует \n";
echo "реляционный оператор = (вывод показан на Рисунке 10.6):</p>\n";
echo "<pre>             SELECT *\n";
echo "             FROM Customers\n";
echo "             WHERE cnum =\n";
echo "                 (SELECT snum + 1000\n";
echo "                      FROM Salespeople\n";
echo "                      WHERE sname = Serres);</pre>\n";
echo "<p>Он находит всех заказчиков, чьё значение поля cnum, равное 1000, выше поля \n";
echo "snum Serres. Мы предполагаем, что столбец sname не имеет никаких двойных \n";
echo "значений (это может быть предписано или UNIQUE INDEX, обсуждаемым в\n";
echo "<a href=\"ch17.php\">Главе 17</a>, или ограничением UNIQUE, обсуждаемым в\n";
echo "<a href=\"ch18.php\">Главе 18</a>); иначе</p>\n";
echo "<pre>            ===============  SQL Execution Log ============\n";
echo "           |                                               |\n";
echo "           | SELECT *                                      |\n";
echo "           | FROM  Customers                               |\n";
echo "           | WHERE cnum =                                  |\n";
echo "           | (SELECT snum + 1000                           |\n";
echo "           | WHERE Salespeople                             |\n";
echo "           | WHERE sname = 'Serres'                        |\n";
echo "           | ============================================= |\n";
echo "           |   cnum     cname     city    rating    snum   |\n";
echo "           |  -----    --------   ----    ------   -----   |\n";
echo "           |   2002    Giovanni   Rome       200    1003   |\n";
echo "             =============================================\n";
echo "\n";
echo "	    Рисунок 10.6 Использование подзапроса с выражением</pre>\n";
echo "<p>подзапрос может произвести несколько значений. Когда поля snum и сnum не \n";
echo "имеют такого простого функционального значения как, например, первичный ключ, \n";
echo "что не всегда хорошо, запрос типа вышеупомянутого невероятно полезен.</p>\n";
echo "<h3><a name=\"10.7\">П</a>ОДЗАПРОСЫ В ПРЕДЛОЖЕНИИ HAVING</h3>\n";
echo "<p>Вы можете также использовать подзапросы внутри предложения HAVING. Эти \n";
echo "подзапросы могут использовать свои собственные агрегатные функции, если они не \n";
echo "производят нескольких значений, или использовать GROUP BY или HAVING. \n";
echo "Следующий запрос является примером этого (вывод показан на Рисунке 10.7):</p>\n";
echo "<pre>        SELECT rating, COUNT (DISTINCT cnum)\n";
echo "            FROM Customers\n";
echo "            GROUP BY rating\n";
echo "            HAVING rating &gt;\n";
echo "             (SELECT AVG (rating)\n";
echo "                  FROM Customers\n";
echo "                  WHERE city = &quot; San Jose');\n";
echo "\n";
echo "\n";
echo "            ===============  SQL Execution Log =============\n";
echo "           |                                                 |\n";
echo "           | SELECT rating,count (DISTINCT cnum)             |\n";
echo "           | FROM  Customers                                 |\n";
echo "           | GROUP BY rating                                 |\n";
echo "           | HAVING rating &gt;                                 |\n";
echo "           | (SELECT AVG (rating)snum + 1000                 |\n";
echo "           | FROM Custimers                                  |\n";
echo "           | WHERE city = 'San Jose');                       |\n";
echo "           |================================================ |\n";
echo "           |  rating                                         |\n";
echo "           | --------    --------                            |\n";
echo "           |   200             2                             |\n";
echo "            ================================================</pre>\n";
echo "<pre>	Рисунок 10.7 Поиск в San Jose заказчиков с оценкой выше среднего</pre>\n";
echo "<p>Эта команда подсчитывает заказчиков в San Jose с рейтингами выше среднего. Так \n";
echo "как имеются другие оценки, отличные от 300, они должны быть выведены с числом \n";
echo "номеров заказчиков, которые имели эту оценку.</p>\n";
echo "<h3><a name=\"10.8\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы используете запросы в иерархической манере. Вы видели, что \n";
echo "использование результата одного запроса для управления другим расширяет \n";
echo "возможности, позволяя выполнить большее количество функций.</p>\n";
echo "<p>Вы теперь понимаете, \n";
echo "как использовать подзапросы с реляционными операциями и со специальным \n";
echo "оператором IN, или в предложении WHERE, или в предложении HAVING внешнего \n";
echo "запроса.</p>\n";
echo "<p>В следующих главах мы будем рассматривать подзапросы. Сначала, в\n";
echo "<a href=\"ch11.php\">Главе 11</a>, мы обсудим другой вид подзапроса, который \n";
echo "выполняется отдельно для каждой строки таблицы, вызываемой во внешнем запросе. \n";
echo "Затем, в Главах <a href=\"ch12.php\">12</a> и <a href=\"ch13.php\">13</a>, мы \n";
echo "представим вам несколько специальных операторов, которые функционируют на всех \n";
echo "подзапросах, как это делает IN, за исключением случаев, когда эти операторы \n";
echo "могут использоваться только в подзапросах.</p>\n";
echo "<h3><a name=\"10.9\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Напишите запрос, который использовал бы подзапрос для получения\n";
echo "   всех заказов для заказчика с именем Cisneros.\n";
echo "   Предположим, что вы не знаете номера этого заказчика, указываемого в поле cnum.\n";
echo "\n";
echo "2. Напишите запрос, который вывел бы имена и оценки всех заказчиков,\n";
echo "   имеющих усреднённые заказы.\n";
echo "\n";
echo "3. Напишите запрос, который выбрал бы общую сумму всех приобретений\n";
echo "   в заказах для каждого продавца, у которого эта общая сумма больше,\n";
echo "   чем сумма наибольшего заказа в таблице.\n";
echo "\n";
echo "(См. ответы в<a href=\"a.php\"> Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?> 
