﻿<?php 

define('_IN_JOHNCMS', 1); 
$textl = 'ОСНОВЫ SQL | Online только на OwApE.Ru'; 
require_once ("../incfiles/core.php"); 
require_once ("../incfiles/head.php"); 
header("Content-type:text/html; charset=utf-8"); 
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n";
echo "<html><head>\n";
echo "<link rel=\"stylesheet\" href=\"css.css\" type=\"text/css\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ru\">\n";
echo "<title>Глава 1.</title></head>\n";
echo "<body>\n";
echo "<h1>Глава 1. РЕЛЯЦИОННЫЕ БАЗЫ ДАННЫХ. ВВЕДЕНИЕ.</h1>\n";
echo "<hr width=\"50%\">\n";
echo "<h3>ВВЕДЕНИЕ</h3>\n";
echo "<p><b>SQL</b> (произносится обычно &quot;СЭКВЭЛ&quot; (или, более англообразно - \n";
echo "СКЬЮЭЛ)) означает <b> Структурированный Язык Запросов.</b></p>\n";
echo "<p>Это язык, который дает  возможность создавать реляционные базы данных (и работать с \n";
echo "ними), которые представляют собой наборы связанной информации, сохраняемой в таблицах.</p>\n";
echo "<p>Мир БД становится всё более единым, что привело к необходимости \n";
echo "создания стандартного языка, который мог бы использоваться для функционирования \n";
echo "в большом количестве различных видов компьютерных сред. Стандартный язык \n";
echo "даст возможность пользователям, знающим один набор команд, использовать их, чтобы \n";
echo "создавать, отыскивать, изменять и передавать информацию, независимо от того, \n";
echo "где идёт работа: на персональном компьютере, сетевой рабочей станции или на универсальной ЭВМ.</p>\n";
echo "<p>В нашем, всё более и более взаимосвязанном компьютерном мире, пользователь, \n";
echo "снабжённый таким языком, имеет огромное преимущество в использовании и обобщении \n";
echo "информации из ряда источников с помощью большого количества способов.</p>\n";
echo "<p>Элегантность и независимость от специфики компьютерных технологий, а также \n";
echo "его поддержка лидерами промышленности в области технологии РБД, сделали <b>SQL</b> \n";
echo "(и, вероятно, в течение обозримого будущего, оставят его) основным стандартным языком БД. По этой причине любой, кто хочет работать с \n";
echo "базами данных 90-х годов (прошлого века), должен знать<b> SQL.</b></p>\n";
echo "<p><b>Стандарт SQL</b> определяется<b> ANSI (Американским Национальным \n";
echo "Институтом Стандартов)</b> и в данное время также принимается <b>ISO \n";
echo "(Международной организацией по стандартизации).</b> Однако большинство \n";
echo "коммерческих программ БД расширяют<b> SQL</b> без уведомления<b> ANSI</b>, \n";
echo "добавляя разные особенности в этот язык, которые, как они считают, будут весьма полезны.<br>\n";
echo "Иногда это несколько нарушает стандарт языка, хотя хорошие идеи имеют тенденцию \n";
echo "развиваться и становиться стандартами  рынка в силу полезности своих качеств.</p>\n";
echo "<p>В этой книге мы будем в основном следовать стандарту ANSI, но одновременно \n";
echo "иногда будем давать и некоторые наиболее распространённые отклонения от его стандарта.</p>\n";
echo "<p>Вы должны проконсультироваться в документации вашего пакета программ, \n";
echo "который будете использовать, чтобы знать, где в нём этот стандарт видоизменен.</p>\n";
echo "<p>ПРЕЖДЕ ЧЕМ ВЫ СМОЖЕТЕ ИСПОЛЬЗОВАТЬ SQL, вы должны понять, <b>что такое реляционные базы данных.</b></p>\n";
echo "<p>В этой главе мы  объясним и покажем, насколько РБД полезны. Мы не будем \n";
echo "обсуждать SQL именно здесь, и, если вы уже знаете эти понятия достаточно хорошо, вы можете просто пропустить эту главу. <br>\n";
echo "В любом случае вы должны просмотреть три таблицы, которые предоставляются и \n";
echo "объясняются в конце главы; они станут основой наших примеров в этой книге. \n";
echo "Вторая копия этих таблиц находится в <a href=\"e.php\">Приложении E</a>, и мы рекомендуем скопировать их для удобства ссылки к ним.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"what\">Ч</a>ТО ТАКОЕ &quot;РЕЛЯЦИОННАЯ БАЗА ДАННЫХ&quot;?</h3>\n";
echo "<p><b>Реляционная база данных </b>это тело связанной информации, сохраняемой в \n";
echo "двухмерных таблицах. Это напоминает адресную или телефонную книгу.</p>\n";
echo "<p>В любой книге имеется большое количество разделов, каждый из которых соответствует \n";
echo "определённой особенности. Для каждой такой особенности может быть несколько \n";
echo "независимых фрагментов данных, например: имя, телефонный номер и адрес.<br>\n";
echo "Предположим, что вы должны сформатировать эту адресную книгу в виде таблицы со \n";
echo "строками и столбцами. Каждая строка (называемая также записью) будет \n";
echo "соответствовать определённой личности; каждый столбец будет содержать \n";
echo "значение для каждого типа данных: имени, телефонного номера и адреса, представляемых в каждой строке.</p>\n";
echo "<p>Адресная книга могла бы выглядеть следующим образом:</p>\n";
echo "<table cellSpacing=\"15\">\n";
echo "<tr><td>Имя</font></td><td>Телефон</font></td><td>Адрес</font></td></tr>\n";
echo "<tr><th>Gerry Farish</th><th>(415)365-8775</th><th>127 Primrose Ave.,SF</th></tr>\n";
echo "<tr><th>Celia Brock</th><th>(707)874-3553</th><th>246 #3rd St.,Sonoma</th></tr>\n";
echo "<tr><th>Yves Grillet</th><th>(762)976-3665</th><th>778 Modernas,Barcelona</th></tr></table>\n";
echo "<p>То, что вы получили, является<b> основой реляционной базы данных</b>, как и \n";
echo "было определено в начале этого обсуждения, а именно - <b>двухмерной (строка и столбец) таблицей информации.</b></p>\n";
echo "<p>Однако РБД редко состоят из одной таблицы. Такая таблица меньше, чем файловая \n";
echo "система. Создав несколько таблиц взаимосвязанной информации, вы сможете \n";
echo "выполнять более сложные и мощные операции с вашими данными. Мощность БД зависит \n";
echo "от связи, которую вы можете создать между фрагментами информации, а не от самого фрагмента информации.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"Table\">С</a>ВЯЗЫВАНИЕ ОДНОЙ ТАБЛИЦЫ С ДРУГОЙ</h3>\n";
echo "<p>Давайте используем пример нашей адресной книги, чтобы начать \n";
echo "обсуждение БД, которая может реально использоваться в деловой ситуации. \n";
echo "Предположим, что персонажи в нашей первой таблице (адресной книге) это пациенты \n";
echo "больницы. В другой таблице мы могли бы запомнить дополнительную информацию об \n";
echo "этих пациентах. Столбцы второй таблицы можно назвать Пациент, Доктор, Страховка и Баланс.</p>\n";
echo "<pre>   Пациент   Доктор    Страховка    Баланс\n";
echo "\n";
echo "   Farish    Drume     B.C./B.S.    $272.99\n";
echo "\n";
echo "   Grillet   Halben    None         $44. 76\n";
echo "\n";
echo "   Brock     Halben    Health,Inc.  $9077.47</pre>\n";
echo "<p>Много мощных функций можно использовать для извлечения информации из этих \n";
echo "таблиц, согласно указанным параметрам, особенно когда эти параметры включают в \n";
echo "себя фрагменты информации, связанные в различных таблицах друг с другом. \n";
echo "Например, возьмём докторов. Предположим доктор Halben захотел получить номера \n";
echo "телефонов всех своих пациентов. Чтобы извлечь эту информацию, он мог бы связать \n";
echo "таблицу с номерами телефонов пациентов (по адресной книге) с таблицей, которая \n";
echo "указывала бы, какой из пациентов - его. Хотя в этом простом примере он мог бы \n";
echo "держать это в голове и сразу получать номера телефонов пациентов Grillet и Brock, \n";
echo "эти таблицы могут быть достаточно большими и сложными.</p>\n";
echo "<p>Программы РБД разрабатывались для того, чтобы обрабатывать большие и сложные совокупности \n";
echo "данных такого типа, что, очевидно, является более универсальным методом в \n";
echo "деловом мире. Даже если бы БД больницы содержала сотни или тысячи имен, как это \n";
echo "вероятно и бывает на практике, одна команда SQL могла бы выдать доктору Halben информацию, в которой он нуждается, почти немедленно.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"Lines\">П</a>ОРЯДОК СТРОК ПРОИЗВОЛЕН</h3>\n";
echo "<p>Чтобы поддерживать максимальную гибкость, строки таблицы, по определению, не \n";
echo "должны находиться в каком-то определенном порядке. С этой точки зрения структура БД отличается от нашей адресной книги.</p>\n";
echo "<p>Вход в адресную книгу обычно упорядочивается в алфавитном порядке. В системах \n";
echo "с РБД имеется одна мощная возможность для пользователей: способность \n";
echo "упорядочивать информацию так, чтобы они могли восстанавливать её.</p>\n";
echo "<p>Рассмотрим вторую таблицу. Иногда вам необходимо видеть эту информацию упорядоченной в алфавитном порядке по именам, иногда - в возрастающем или \n";
echo "убывающем порядке, а иногда - сгруппированной по отношению к какому-нибудь доктору.</p>\n";
echo "<p>Порядок набора в строках будет конфликтовать со способностью заказчика \n";
echo "изменять его, поэтому строки всегда рассматриваются как неупорядоченные. По этой \n";
echo "причине вы не можете просто сказать: &quot;Мы хотим посмотреть пятую строку \n";
echo "таблицы&quot;. Пренебрегая порядком, в котором данные вводились, или любым другим \n";
echo "критерием, мы определим не ту строку, хотя она и будет пятой. Строки таблицы не находятся в какой-либо определенной последовательности.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"IdenLine\">И</a>ДЕНТИФИКАЦИЯ СТРОК (ПЕРВИЧНЫЙ КЛЮЧ)</h3>\n";
echo "<p>По этим и другим причинам вы должны иметь в вашей таблице столбец, который  идентифицировал \n";
echo "бы каждую строку уникально. Обычно этот столбец содержит номер, \n";
echo "например: номер пациента, назначаемый каждому пациенту. Конечно, вы могли бы \n";
echo "использовать имена пациентов, но возможно, что имеется несколько Mary Smith, и \n";
echo "в этом случае вы не будете иметь другого способа отличить этих пациентов друг от друга.</p>\n";
echo "<p>Вот почему номера так необходимы. Такой уникальный столбец (или уникальная \n";
echo "группа столбцов), используемый для идентификации каждой строки и хранения всех \n";
echo "строк по отдельности, называется первичным ключом таблицы.</p>\n";
echo "<p>Первичные ключи таблицы - важный элемент в структуре базы данных. Они - \n";
echo "основа вашей системы записи в файл; и, когда вы хотите найти определённую строку \n";
echo "в таблице, вы ссылаетесь на этот первичный ключ. Кроме того, первичные ключи \n";
echo "гарантируют, что ваши данные имеют определенную целостность. Если первичный ключ \n";
echo "правильно используется и поддерживается, вы будете знать, что нет пустых строк \n";
echo "таблицы и что каждая строка отличается от любой другой строки. Мы будем \n";
echo "обсуждать ключи и далее, когда поговорим относительно справочной целостности в <a href=\"ch19.php\">Главе 19</a>.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"NumSt\">С</a>ТОЛБЦЫ ИМЕНУЮТСЯ И НУМЕРУЮТСЯ</h3>\n";
echo "<p>В отличие от строк, столбцы таблицы (называемые также полями) упорядочиваются \n";
echo "и именуются. Таким образом, в нашей таблице адресной книги можно указать на \n";
echo "&quot;адрес столбца&quot; или на &quot;столбец 3&quot;. Это означает, что каждый столбец \n";
echo "данной таблицы должен иметь уникальное имя, чтобы избежать неоднозначности. Лучше \n";
echo "всего, если эти имена указывают на содержание поля. В типовых таблицах этой \n";
echo "книги мы будем использовать такие сокращения для имени столбца как cname для \n";
echo "имени заказчика и odate для даты заказа. Мы также дадим каждой таблице личный \n";
echo "числовой номер столбца в качестве первичного ключа. Следующий раздел будет рассматривать эти таблицы и их ключи более подробно.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"Data\">Т</a>ИПОВАЯ БАЗА ДАННЫХ</h3>\n";
echo "<p>Таблицы 1.1, 1.2 и 1.3 составляют реляционную базу данных, которая является \n";
echo "минимально достаточной, чтобы легко её отслеживать, и достаточно полной, чтобы \n";
echo "иллюстрировать главные понятия и практику использования SQL. Эти таблицы \n";
echo "напечатаны в этой главе, а также в <a href=\"e.php\">Приложении E</a>.</p>\n";
echo "<p>Так как они будут использоваться для иллюстрирования различных особенностей \n";
echo "SQL по всей этой книге, мы рекомендуем  вам скопировать их для удобства использования.</p>\n";
echo "<p>Вы могли уже заметить, что первый столбец каждой таблицы содержит номера,  значения \n";
echo "которых различны для каждой строки. Как вы, наверное, уже предположили, это - \n";
echo "первичные ключи таблиц. Некоторые из этих номеров также показаны в столбцах \n";
echo "других таблиц. В этом нет ничего неверного. Они показывают связь между строками, \n";
echo "которые используют значение, принимаемое из первичного ключа, и строками, где это значение используется в самом первичном ключе.</p>\n";
echo "<pre>Таблица 1.1: Продавцы\n";
echo "\n";
echo "      ----------------------------------------------\n";
echo "        SNUM  |   SNAME   |  CITY        |   COMM\n";
echo "      --------|-----------|--------------|----------\n";
echo "        1001  |  Peel     |  London      |    .12\n";
echo "        1002  |  Serres   |  San Jose    |    .13\n";
echo "        1004  |  Motika   |  London      |    .11\n";
echo "        1007  |  Rifkin   |  Barcelona   |    .15\n";
echo "        1003  |  Axelrod  |  New York    |    .10\n";
echo "       ---------------------------------------------\n";
echo "\n";
echo "\n";
echo "Таблица 1.2: Заказчики\n";
echo "\n";
echo "       ----------------------------------------------\n";
echo "        CNUM  |  CNAME     | CITY    | RATING | SNUM\n";
echo "       -------|------------|---------|--------|------\n";
echo "        2001  |  Hoffman   | London  |   100  | 1001\n";
echo "        2002  |  Giovanni  | Rome    |   200  | 1003\n";
echo "        2003  |  Liu       | SanJose |   200  | 1002\n";
echo "        2004  |  Grass     | Berlin  |   300  | 1002\n";
echo "        2006  |  Clemens   | London  |   100  | 1001\n";
echo "        2008  |  Cisneros  | SanJose |   300  | 1007\n";
echo "        2007  |  Pereira   | Rome    |   100  | 1004\n";
echo "       ----------------------------------------------\n";
echo "\n";
echo "Таблица 1.3: Заказы\n";
echo "\n";
echo "       -----------------------------------------------\n";
echo "        ONUM  |    AMT    |    ODATE    | CNUM | SNUM\n";
echo "       -------|-----------|-------------|------|------\n";
echo "        3001  |    18.69  |  10/03/1990 | 2008 | 1007\n";
echo "        3003  |   767.19  |  10/03/1990 | 2001 | 1001\n";
echo "        3002  |  1900.10  |  10/03/1990 | 2007 | 1004\n";
echo "        3005  |  5160.45  |  10/03/1990 | 2003 | 1002\n";
echo "        3006  |  1098.16  |  10/03/1990 | 2008 | 1007\n";
echo "        3009  |  1713.23  |  10/04/1990 | 2002 | 1003\n";
echo "        3007  |    75.75  |  10/04/1990 | 2004 | 1002\n";
echo "        3008  |  4723.00  |  10/05/1990 | 2006 | 1001\n";
echo "        3010  |  1309.95  |  10/06/1990 | 2004 | 1002\n";
echo "        3011  |  9891.88  |  10/06/1990 | 2006 | 1001\n";
echo "       -----------------------------------------------</pre>\n";
echo "<p>Например, поле snum в таблице Заказчиков указывает, какому продавцу назначен \n";
echo "данный заказчик. Номер поля snum связан с таблицей Продавцов, которая даёт \n";
echo "информацию об этих продавцах. Очевидно, что продавец, которому назначены \n";
echo "заказчики, должен уже существовать - то есть значение snum из таблицы Заказчиков \n";
echo "должно также быть представлено в таблице Продавцов. Если это так, то говорят, \n";
echo "что &quot;система находится в состоянии справочной целостности&quot;. Этот вывод будет \n";
echo "более полно и формально объяснен в <a href=\"ch19.php\">Главе 19</a>.</p>\n";
echo "<h6><b>ПРИМЕЧАНИЕ:</b> эти три представленных таблицы в тексте имеют \n";
echo "русскоязычные имена - Продавцы, Заказчики и Заказы - и далее будут упоминаться именно под этими \n";
echo "именами. Имена любых других применяемых в книге таблиц будут написаны \n";
echo "по-английски, чтобы отличать их от  базовых таблиц этой БД. Кроме того, в \n";
echo "целях однозначности имена заказчиков, продавцов, Системных Каталогов, а также полей в тексте, также будут даны на латыни.</h6>\n";
echo "<p>Таблицы приведены как пример похожей ситуации в реальной жизни, когда вы \n";
echo "будете использовать SQL, чтобы следить за продавцами, их заказчиками и заказами \n";
echo "заказчиков. Давайте рассмотрим эти три таблицы и значения их полей. Здесь показаны столбцы Таблицы 1.1:</p>\n";
echo "<pre>   ПОЛЕ         СОДЕРЖАНИЕ\n";
echo "  ---------    ----------------------------------------------\n";
echo "   snum        уникальный номер назначенный каждому продавцу\n";
echo "               (&quot;номер служащего&quot;).\n";
echo "\n";
echo "   sname       имя продавца.\n";
echo "\n";
echo "   city        местонахождение продавца (город).\n";
echo "\n";
echo "   comm        комиссионные продавцов в десятичной форме.\n";
echo "\n";
echo "\n";
echo "Таблица 1.2 содержит следующие столбцы:\n";
echo "\n";
echo "   ПОЛЕ        СОДЕРЖАНИЕ\n";
echo "  --------    ---------------------------------------------------\n";
echo "   cnum       уникальный номер, назначенный каждому заказчику.\n";
echo "\n";
echo "   cname      имя заказчика.\n";
echo "\n";
echo "   city       местонахождение заказчика (город).\n";
echo "\n";
echo "   rating     код, указывающий уровень предпочтения данного заказчика\n";
echo "              перед другими. Более высокий номер указывают на большее предпочтение (рейтинг).\n";
echo "   snum       номер продавца, назначенного этому заказчику (из таблицы Продавцов).\n";
echo "\n";
echo "\n";
echo " И столбцы в Таблице 1.3:\n";
echo "\n";
echo "     ПОЛЕ      СОДЕРЖАНИЕ\n";
echo "    --------- ---------------------------------------------------\n";
echo "    onum      уникальный номер, данный каждому приобретению.\n";
echo "\n";
echo "    amt       значение суммы приобретений.\n";
echo "\n";
echo "    odate     дата приобретения.\n";
echo "\n";
echo "    cnum      номер заказчика, делающего приобретение (из таблицы Заказчиков).\n";
echo "    snum      номер продавца, продающего приобретение (из таблицы Продавцов).</pre>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"Res\">Р</a>ЕЗЮМЕ</h3>\n";
echo "<p>Теперь вы знаете, что такое реляционная база данных - понятие, которое звучит \n";
echo "сложнее, чем это есть на самом деле. Вы также изучили некоторые фундаментальные \n";
echo "принципы  того, как сделаны таблицы: как работают строки и столбцы, \n";
echo "как первичные ключи отличают строки друг друга и как столбцы могут ссылаться на значения в других столбцах.</p>\n";
echo "<p>Вы поняли, что запись это синоним строки и что поле это синоним столбца. Оба \n";
echo "термина встречаются в обсуждении SQL, и мы будем использовать их в равной степени в этой книге.</p>\n";
echo "<p>Вы теперь знакомы с таблицами примеров. Краткие и простые, они способны \n";
echo "показать большинство особенностей языка, как вы это увидите далее. В некоторых \n";
echo "случаях мы будем использовать одни таблицы или постулаты  различных \n";
echo "данных в другой таблице, чтобы показать вам некоторые другие возможности.</p>\n";
echo "<p>Теперь вы готовы к погружению в SQL. Следующая глава даст \n";
echo "краткое рассмотрение языка и информацию, которая поможет вам обращаться к уже пройденным местам.</p>\n";
echo "<hr width=\"50%\">\n";
echo "<h3><a name=\"Work\">Р</a>АБОТА СО SQL</h3>\n";
echo "<pre>1. Какое поле таблицы Заказчиков является первичным ключом?\n";
echo "\n";
echo "2. Что является столбцом 4 из таблицы Заказчиков?\n";
echo "\n";
echo "3. Как по другому называется строка? Столбец?\n";
echo "\n";
echo "4. Почему вы не можете запрашивать для просмотра первые пять строк таблицы?\n";
echo "\n";
echo "(См. ответы в <a href=\"a.php#1\">Приложении A</a>.)</pre></body></html>\n";
require_once ("../incfiles/end.php");  

?>
