<?php
/**
 * project:
 * WB Engine (Multi User)
 *
 * version:
 * 2.0
 * authors:
 * Kohana Team, 2008
 * Egorov Artem, 2009
 *
 *
 * last edit:
 * 01/07/2009 01:28
 *
 * GNU General Public License, version 2:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

defined('IN_WBENGINE') or die('Hacking attempt');

/**
 * Retrieves ip.
 *
 * @return string
 */
function ip() {
	$ip = null;
	
	if(is_null($ip)) {
		if (!($ip = getenv('HTTP_CLIENT_IP'))) {
			if (!($ip = getenv('HTTP_X_FORWARDED_FOR'))) {
				if (!($ip = getenv('REMOTE_ADDR'))) {
					$ip = '';
				}
			}
		}
		
		preg_match('/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/', $ip, & $ip);
		list($ip) = $ip;
	}
	
	return $ip;
}

/**
 * Retrieves current user agent information:
 * keys:  browser, version, platform, mobile, robot, referrer, languages, charsets
 * tests: is_browser, is_mobile, is_robot, accept_lang, accept_charset
 *
 * @authors: Kohana Team, 2008
 *
 * @param string key or test name
 * @param string used with "accept" tests: user_agent(accept_lang, en)
 * @return array languages and charsets
 * @return string all other keys
 * @return boolean all tests
 */
function user_agent($key = 'agent', $compare = null) {
	static $info = array();
	static $user_agent = null;
	
	if (is_null($user_agent)) {
		$user_agent = substr(getenv('http_user_agent'), 0, 150);
		$user_agent = preg_replace('/[^A-z0-9\(\)\/\-\:\.\;_ ]/', '', $user_agent);
		$user_agent or $user_agent = 'unknown';
	}
	
	if ($key == 'agent') {
		return $user_agent;
	}
	
	if (!count($info)) {
		$agents = include('wb-system/configuration/user_agents.php');
		
		foreach ($agents as $type => $data) {
			foreach ($data as $agent => $name) {
				if (stristr($user_agent, $agent) !== false) {
					if ($type == 'browser' && preg_match('|' . preg_quote($agent) . '[^0-9.]*+([0-9.][0-9.a-z]*)|i', $user_agent, $match)) {
						$info['version'] = $match[1];
					}
					
					$info[$type] = $name;
					break;
				}
			}
		}
	}

	if (empty($info[$key])) {
		switch ($key) {
			case 'is_robot':
			case 'is_browser':
			case 'is_mobile':
				$return = !empty($info[substr($key, 3)]);
				break;
			
			case 'languages':
				$return = array();
				if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
					if (preg_match_all('/[-a-z]{2,}/', strtolower(trim($_SERVER['HTTP_ACCEPT_LANGUAGE'])), $matches)) {
						$return = $matches[0];
					}
				}
				break;
			
			case 'charsets':
				$return = array();
				if (!empty($_SERVER['HTTP_ACCEPT_CHARSET'])) {
					if (preg_match_all('/[-a-z0-9]{2,}/', strtolower(trim($_SERVER['HTTP_ACCEPT_CHARSET'])), $matches)) {
						$return = $matches[0];
					}
				}
				break;
			
			case 'referrer':
				if (!empty($_SERVER['HTTP_REFERER'])) {
					$return = trim($_SERVER['HTTP_REFERER']);
				}
				break;
		}
		
		isset($return) and $info[$key] = $return;
	}
	
	if (!is_null($compare)) {
		$compare = strtolower($compare);
		
		switch ($key) {
			case 'accept_lang':
				return in_array($compare, user_agent('languages'));
			
			case 'accept_charset':
				return in_array($compare, user_agent('charsets'));
			
			default:
				return false;
		}
	}
	
	return isset($info[$key]) ? $info[$key] : null;
}
?>