<?php
/**
 * project:
 * WB Engine (Multi User)
 *
 * version:
 * 2.0
 *
 * authors:
 * Egorov Artem
 *
 * last edit:
 * 25/08/2009 22:50
 *
 * GNU General Public License, version 2:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

defined('IN_WBENGINE') or die('Hacking attempt');

/**
 * Получение полномочий пользователя в тематическом блоге
 *
 * @param integer Id блога
 * @param mixed Параметр(ы) для возврата
 * @return mixed
 */
function get_blog_access($blog_id) {
	static $allow_params = array (
		'edit_post',
		'delete_post',
		'approve_user',
		'delete_user',
		'edit_comment',
		'delete_comment'
	);
	
	$params = array_slice(func_get_args(), 1);
	$params = array_unique(isset($params[0]) && is_array($params[0]) ? $params[0] : $params);
	
	if (!count($params)) {
		$params = $allow_params;
	}
	
	foreach ($params as $key => $param) {
		if (!in_array($param, $allow_params)) {
			unset($params[$key]);
		}
		
		$access[$param] = is_admin();
	}
	
	if (is_admin() or !is_logged()) {
		return $access;
	}
	
	
	$sql = 'select * from ' . BLOG_ACCESS_TABLE . ' where user_id = ' . user_id() . ' or 
	group_id in (select group_id from ' . USER_GROUP_TABLE . ' where user_id = ' . user_id() . ')';
	
	$query = mysql_query($sql);
	
	while ($fields = mysql_fetch_assoc($query)) {
		foreach ($params as $param) {
			$fields['allow_' . $param] && $access[$param] = true;
		}
	}
	
	return count($access) > 1 ? $access : array_shift($access);
}

/**
 * Получение полномочий пользователя к личным блогам пользователей
 *
 * @param mixed Параметр(ы) для возврата
 * @return mixed
 */
function get_blog_personal_access() {
	static $allow_params = array (
		'view_post',
		'edit_post',
		'delete_post',
		'edit_comment',
		'delete_comment',
		'comment'
	);
	
	$params = func_get_args();
	$params = array_unique(isset($params[0]) && is_array($params[0]) ? $params[0] : $params);
	
	if (!count($params)) {
		$params = $allow_params;
	}
	
	foreach ($params as $key => $param) {
		if (!in_array($param, $allow_params))
		{
			unset($params[$key]);
		}
		
		$access[$param] = is_admin();
	}
	
	if (is_admin() or !is_logged()) {
		return $access;
	}
	
	$sql = 'select * from ' . BLOG_PERSONAL_ACCESS_TABLE . ' where user_id = ' . user_id() . ' or 
	group_id in (select group_id from ' . USER_GROUP_TABLE . ' where user_id = ' . user_id() . ')';
	
	$query = mysql_query($sql);
	
	while ($fields = mysql_fetch_assoc($query)) {
		foreach ($params as $param) {
			$fields['allow_' . $param] && $access[$param] = true;
		}
	}
	
	return count($access) > 1 ? $access : array_shift($access);
}


/**
 * Возвращает форматированную строку популярных меток (с кешированием)
 *
 * @param integer количество меток
 * @param boolean разбросать
 * @param integer минимальный размер шрифта
 * @param integer максимальный размер шрифта
 * @return array
 */
function get_popular_tags($limit = 20, $shuffle = true, $min_size = 10, $max_size = 17) {
	if (!is_unsigned($limit, true) || !is_unsigned($max_size, true) || !is_unsigned($min_size, true)) {
		return array();
	}
	
	$cache = 'popular_tags/' . $limit . ($shuffle ? '_shuffle' : '');
	
	if (is_null($tags = cache($cache, 300))) {
		$tags = array();
		
		$query = mysql_query('select count(*) as count, post_tag as tag 
		from ' . TAGS_TABLE . ' group by post_tag order by count desc limit ' . $limit);
		
		while ($rows = mysql_fetch_assoc($query)) {
			$tags[] = $rows;
		}
		
		cache_save($cache, $tags, 300);
	}
	
	$min = 10000;
	$max = 0;
	
	foreach ($tags as $tag) {
		$max < $tag['count'] && $max = $tag['count'];
		$min > $tag['count'] && $min = $tag['count'];
	}
	
	$min_count = log($min + 1);
	$max_count = log($max + 1);
	
	$size_range = $max_size - $min_size;
	$count_range = $max_count - $min_count;
	$count_range = $count_range ? $count_range : 1;
	$ratio = $size_range / $count_range;
	
	foreach ($tags as $key => $tag) {
		$tags[$key]['size'] = round($min_size + (log($tag['count'] + 1) - $min_count) * $ratio);
	}
	
	if ($shuffle) {
		shuffle($tags);
	}
	
	return $tags;
}

/**
 * Возвращает метки записи.
 *
 * @param integer Id записи
 * @return array
 */
function get_post_tags($post_id) {
	if (!is_unsigned($post_id, true)) {
		return false;
	}
	
	if (is_null($tags = cache("{tags/{$post_id}", -1))) {
		$tags = array();
		
		$sql = 'select post_tag from ' . TAGS_TABLE . ' where post_id = ' . $post_id;
		$query = mysql_query($sql);
		
		while ($fields = mysql_fetch_assoc($query)) {
			$tags[] = $fields['post_tag'];
		}
		
		cache_save("tags/{$post_id}", $tags, -1);
	}
	
	return $tags;
}

/**
 * Возвращает метки записи.
 *
 * @param integer Id записи
 * @param array Метки
 * @return array
 */
function insert_post_tags($post_id) {
	if (!is_unsigned($post_id, true)) {
		return false;
	}
	
	$tags = array_slice(func_get_args(), 1);
	$tags = isset($tags[0]) && is_array($tags[0]) ? $tags[0]: $tags;
	
	foreach ($tags as $tag) {
		mysql_query('insert into ' . TAGS_TABLE . ' values (' . $post_id . ', "' . $tag . '")');
	}
	
	return true;
}

/**
 * Обновляет метки записи.
 *
 * @param integer Id записи
 * @param array Метки
 * @return array
 */
function update_post_tags($post_id) {
	if (!is_unsigned($post_id, true)) {
		return false;
	}
	
	$tags = array_slice(func_get_args(), 1);
	$tags = isset($tags[0]) && is_array($tags[0]) ? $tags[0]: $tags;
	
	mysql_query('delete from ' . TAGS_TABLE . ' where post_id = ' . $post_id);
	
	cache_save("liked_posts/{$post_id}", null, 1);
	cache_save("tags/{$post_id}", null, 1);
	
	insert_post_tags($post_id, $tags);
	return true;
}

/**
 * Устанавливает, является ли пользователь является читателем блога.
 *
 * @param integer Id блога
 * @param integer Id пользователя
 * @return boolean
 */
function blog_ship($blog_id, $user_id = 0) {
	static $results = array();
	
	if (!isset($results[$blog_id . '_' . $user_id])) {
		if (!is_unsigned($blog_id, true)) {
			return false;
		}
		
		if (!is_unsigned($user_id, true)) {
			if (is_logged()) {
				$user_id = user_id();
			} else {
				return false;
			}
		}
		
		$query = mysql_query('select count(*) 
		from ' . USER_BLOG_TABLE . ' where blog_id = ' . $blog_id . ' and user_id = ' . $user_id);
		
		$results[$blog_id . '_' . $user_id] = (bool) mysql_result($query, 0);
	}
	
	return $results[$blog_id . '_' . $user_id];
}

/**
 * Обновляет счетчик читателей в блоге.
 *
 * @param integer Id блога
 * @return boolean
 */
function update_blog_count_users($blog_id) {
	if (!is_unsigned($blog_id, true)) {
		return false;
	}
	
	$query = mysql_query('select count(*) from ' . USER_BLOG_TABLE . ' where blog_id = ' . $blog_id);
	$count = mysql_result($query, 0);
	
	mysql_query('update ' . BLOGS_TABLE . ' set blog_count_users = ' . $count . ' where blog_id = ' . $blog_id);
	
	return $count;
}

/**
 * Обновляет счетчик комментариев записи
 *
 * @param integer Id записи
 * @param integer Кол-во комментариев
 * @return boolean
 */
function update_post_count_comments($post_id, $count = null) {
	is_null($count) && $count = '(select count(*) from ' . COMMENTS_TABLE . ' where post_id = ' . $post_id . ')';
	mysql_query('update ' . POSTS_TABLE . ' set post_count_comments = ' . $count . ' where post_id = ' . $post_id);
	return (bool) mysql_affected_rows();
}

/**
 * Обновляет Id последнего комментария к записи
 *
 * @param integer Id записи
 * @param integer Id комментария
 * @return boolean
 */
function update_post_last_comment_id($post_id, $comment_id = null) {
	is_null($comment_id) && $comment_id = '(select comment_id from ' . COMMENTS_TABLE . ' where post_id = ' . $post_id . ' order by comment_id desc limit 1)';
	mysql_query('update ' . POSTS_TABLE . ' set post_last_comment_id = ' . $comment_id . '  where post_id = ' . $post_id);
	return (bool) mysql_affected_rows();
}

/**
 * Обновляет счетчик комментариев пользователя.
 *
 * @param integer Id пользователя
 * @return boolean
 */
function update_user_count_comments($user_id) {
	if (!is_unsigned($user_id, true)) {
		if (is_logged()) 	{
			$user_id = user_id();
		} else {
			return false;
		}
	}
	
	mysql_query('update ' . USERS_TABLE . ' set user_count_comments = (
	select count(*) from ' . COMMENTS_TABLE . ' where user_id = ' . $user_id . ') 
	where user_id = ' . $user_id);
	
	return (bool) mysql_affected_rows();
}

/**
 * Обновляет счетчик постов пользователя.
 *
 * @param integer Id пользрователя
 * @return boolean
 */
function update_user_count_posts($user_id) {
	if (!is_unsigned($user_id, true)) {
		if (is_logged()) {
			$user_id = user_id();
		} else {
			return false;
		}
	}
	
	mysql_query('update ' . USERS_TABLE . ' set user_count_posts = (
	select count(*) from ' . POSTS_TABLE . ' where user_id = ' . $user_id . ') 
	where user_id = ' . $user_id);
	
	return (bool) mysql_affected_rows();
}
?>