<?php
/**
 * project:
 * WB Engine (Multi User)
 *
 * version:
 * 2.0
 *
 * authors:
 * Egorov Artem
 *
 * last edit:
 * 18/08/2009 20:00
 *
 * GNU General Public License, version 2:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

defined('IN_WBENGINE') or die('Hacking attempt');

/**
 * Глобальная переменная $ban_data зарезервирована.
 */
$ban_data = false;

function is_banned() {
	if (is_logged()) {
		if (!is_admin()) {
			$sql = 'select * 
			from ' . USER_BAN_TABLE . ' where user_id = ' . user_id();
			
			$query = mysql_query($sql);
			$ban_data = mysql_fetch_assoc($query);
			
			if ($ban_data) {
				if (time() >= $ban_data['time']) {
					mysql_query('delete from ' . USER_BAN_TABLE . ' where user_id = ' . user_id());
				}
				
				$GLOBALS['ban_data'] = $ban_data;
				
				if ($ban_data['deny_site']) {
					return true;
				}
			}
		}
	}
	
	return false;
}

function ban_data($key) {
	return isset($GLOBALS['ban_data'][$key]) ? $GLOBALS['ban_data'][$key] : false;
}

/**
 * Возвращает код ошибки, если за указанного пользователя нельзя голосовать, или true.
 * Коды ошибок:
 * -6 не авторизованы;
 * -5 рейтинг меньше необходимого;
 * -4 установлен запрет на голосование;
 * -3 за себя голосовать нельзя;
 * -2 голос за этого пользователя уже отдан;
 *
 * -1 зарезервированно.
 *
 * @param integer Id пользователя
 * @return mixed
 */
function allow_vote_user($user_id) {
	static $result = null;
	
	
	if (!is_logged()) {
		return -6;
	}
	
	if (!is_admin()) {
		if (user_data('user_rating') < get_option('acl_can_vote_user')) {
			return -5;
		}
		
		if (ban_data('deny_vote_user')) {
			return -4;
		}
	}
	
	if (user_id() == $user_id) {
		return -3;
	}
	
	if (vote_user_already($user_id)) {
		return -2;
	}
	
	return true;
}

/**
 * Возвращает код ошибки, если нельзя публиковать запись, или true.
 * Коды ошибок:
 * -4 не авторизованы;
 * -3 рейтинг меньше необходимого;
 * -2 установлен запрет на голосование;
 *
 * -1 зарезервированно.
 *
 * @return mixed
 */
function allow_add_post() {
	if (!is_logged()) {
		return -4;
	}
	
	if (!is_admin()) {
		if (user_data('user_rating') < get_option('acl_can_add_post')) {
			return -3;
		}
		
		if (ban_data('deny_add_post')) {
			return -2;
		}
	}
	
	return true;
}


function allow_add_comment() {
	if (!is_logged()) {
		return -4;
	}
	
	if (!is_admin()) {
		if (user_data('user_rating') < get_option('acl_can_add_comment')) {
			return -3;
		}
		
		if (ban_data('deny_add_comment')) {
			return -2;
		}
	}
	
	return true;
}

/**
 * Возвращает код ошибки, если нельзя голосовать за указанную запись, или true.
 * Коды ошибок:
 * -6 не авторизованы;
 * -5 рейтинг меньше необходимого;
 * -4 установлен запрет на голосование;
 * -3 срок голосования истек;
 * -2 свой пост;
 * -1 уже голосовали.
 *
 * @param integer Id записи
 * @param integer Время добавления записи
 * @return mixed
 */
function allow_vote_post($post_data) {
	if (!is_logged()) {
		return -6;
	}
	
	if (!is_admin()) {
		if (user_data('user_rating') < get_option('acl_can_vote_post')) {
			return -5;
		}
		
		if (ban_data('deny_vote_post')) {
			return -4;
		}
	}
	
	if (!$post_data || ($post_data['post_add_time'] + get_option('acl_vote_post_time')) < time()) {
		return -3;
	}
	
	if ($post_data['user_id'] == user_id()) {
		return -2;
	}
	
	if (vote_post_already($post_data['post_id'])) {
		return -1;
	}
	
	return true;
}

function allow_vote_blog($blog_id) {
	if (!is_logged()) {
		return -4;
	}
	
	if (!is_admin()) {
		if (user_data('user_rating') < get_option('acl_can_vote_blog')) {
			return -3;
		}
		
		if (ban_data('deny_vote_blog')) {
			return -2;
		}
	}
	
	if (vote_blog_already($blog_id)) {
		return -1;
	}
	
	return true;
}

function allow_vote_comment($comment_data) {
	if (($result = allow_vote_comments()) !== true) {
		return $result;
	}
	
	if ($comment_data['comment_time'] + get_option('acl_vote_comment_time') < time()) {
		return -3;
	}
	
	if ($comment_data['user_id'] == user_id()) {
		return -2;
	}
	
	if (vote_comment_already($comment_data['comment_id'])) {
		return -1;
	}
	
	return true;
}

function allow_vote_comments() {
	if (!is_logged()) {
		return -6;
	}
	
	if (!is_admin()) {
		if (user_data('user_rating') < get_option('acl_can_vote_comment')) {
			return -5;
		}
		
		if (ban_data('deny_vote_comment')) {
			return -4;
		}
	}
	
	return true;
}













/**
 * Устанавливает, изменял рейтинг пользователь указанному блогу
 * 
 * @param integer Id блога
 * @return boolean
 */
function vote_blog_already($blog_id) {
	$sql = 'select count(*) from ' . BLOG_VOTE_TABLE . ' 
	where voter_id = ' . user_id() . ' and blog_id = ' . $blog_id . ' limit 1';
	
	return (bool) mysql_result(mysql_query($sql), 0);
}

/**
 * Устанавливает, изменял рейтинг пользователь указанному комментарию
 * 
 * @param integer Id комментария
 * @return boolean
 */
function vote_comment_already($comment_id) {
	$sql = 'select count(*) from ' . COMMENT_VOTE_TABLE . ' 
	where voter_id = ' . user_id() . ' and comment_id = ' . $comment_id . ' limit 1';
	
	return (bool) mysql_result(mysql_query($sql), 0);
}

/**
 * Устанавливает, изменял рейтинг пользователь указанной записи
 * 
 * @param integer Id записи
 * @return boolean
 */
function vote_post_already($post_id) {
	$sql = 'select count(*) from ' . POST_VOTE_TABLE . ' 
	where voter_id = ' . user_id() . ' and post_id = ' . $post_id . ' limit 1';
	
	return (bool) mysql_result(mysql_query($sql), 0);
}

/**
 * Устанавливает, изменял рейтинг пользователь указанному пользователю
 * 
 * @param integer Id пользователя
 * @return boolean
 */
function vote_user_already($user_id) {
	$sql = 'select count(*) from ' . USER_VOTE_TABLE . ' 
	where voter_id = ' . user_id() . ' and user_id = ' . $user_id . ' limit 1';
	
	return (bool) mysql_result(mysql_query($sql), 0);
}
?>