<?php
/**
 * project:
 * WB Engine (Multi User)
 *
 * version:
 * 2.0
 *
 * authors:
 * Egorov Artem
 *
 * last edit:
 * 29/08/2009 12:00
 *
 * GNU General Public License, version 2:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

defined('IN_WBENGINE') or die('Hacking attempt');

require('wb-system/includes/functions_blogs.php');
require('wb-system/includes/functions_friends.php');

if (get_router_param(0) == 'post' && is_unsigned(get_router_param(1), true)) {
	$sql = 'select p.post_id, p.user_id, p.blog_id, u.user_login, 
	p.post_title, p.privacy_post, p.privacy_comment, p.post_last_comment_id 
	from ' . POSTS_TABLE . ' as p 
	left join ' . USERS_TABLE . ' as u using (user_id) 
	where p.post_id = ' . get_router_param(1);
	
	$query = mysql_query($sql);
	$post_data = mysql_fetch_assoc($query);
	
	if (!$post_data) {
		redirect('/');
	}
	
	/**
	 * Проверка существования блога (если запись сделана в тематическом блоге).
	 */
	if ($post_data['blog_id']) {
		$query = mysql_query('select blog_name, blog_url from ' . BLOGS_TABLE . ' where blog_id = ' . $post_data['blog_id']);
		$blog_data = mysql_fetch_assoc($query);
		
		if ($blog_data) {
			$post_data['blog_url'] = $blog_data['blog_url'];
			$post_data['blog_name'] = $blog_data['blog_name'];
		} else {
			redirect('/');
		}
	}
	
	$post_data['blog_link'] = '/' . ($post_data['blog_id'] ? 'blogs/' . $post_data['blog_url'] : 'personal/' . $post_data['user_id']);
	$post_data['post_link'] = $post_data['blog_link'] . '/' . $post_data['post_id'];
	
	/**
	 * Проверка доступа и полномочий.
	 */
	$access = array (
		'edit_comment' => false,
		'delete_comment' => false
	);
	
	do {
		if (is_admin()) {
			$access['edit_comment'] = true;
			$access['delete_comment'] = true;
			break;
		}
		
		if (is_logged()) {
			if ($post_data['blog_id']) {
				if (array_sum(($access = get_blog_access($post_data['blog_id'])))) {
					break;
				}
				
				if ($post_data['privacy_post'] == PRIVACY_POST_BLOG_USERS && blog_ship($post_data['blog_id'])) {
					break;
				}
			} else {
				if (array_sum(($access = get_blog_personal_access())) && $access['view_post']) {
					break;
				}
				
				if ($post_data['privacy_post'] == PRIVACY_POST_FRIENDS && is_friend(user_id(), $post_data['user_id'])) {
					break;
				}
				
				if (user_id() == $post_data['user_id']) {
					break;
				}
			}
		}
		
		if ($post_data['privacy_post'] == PRIVACY_POST_USERS) {
			break;
		}
		
		view_open('content', 'comments/not_allow');
		view_set_var('content', 'post_data', $post_data);
		view_set_var('main', 'content', view_render('content'));
		return;
	} while (0);
	
	$sql = 'select count(*) 
	from ' . COMMENTS_TABLE . ' where post_id = ' . $post_data['post_id'];
	
	$query = mysql_query($sql);
	$count = mysql_result($query, 0);
	
	if ($count) {
		/**
		 * Расчет нужной страницы с указанным постом
		 */
		if (is_unsigned(get_router_param(2), true)) {
			$sql = 'select count(*) from ' . COMMENTS_TABLE . ' 
			where post_id = ' . $post_data['post_id'] . ' and comment_id <= ' . get_router_param(2);
			
			$query = mysql_query($sql);
			$count_prev = mysql_result($query, 0);
			
			/**
			 * Подмена текущей страницы
			 */
			$current_page = ceil($count_prev / get_nav_comments());
		}
		
		$allow_vote = allow_vote_comments() === true;
		$navigation = get_navigation($count, get_nav_comments(), '/comments/post/' . $post_data['post_id'] . '/page%d', true);
		
		$comments_ids_array = array();
		
		$sql = 'select c.*, u.user_login, u.user_admin_privilege 
		from ' . COMMENTS_TABLE . ' as c 
		left join ' . USERS_TABLE . ' as u using (user_id) 
		where c.post_id = ' . $post_data['post_id'] . ' 
		order by c.comment_id asc 
		limit ' . $navigation['select_limits'];
		
		$query = mysql_query($sql);
		
		while ($fields = mysql_fetch_assoc($query)) {
			$fields['comment_positive'] = $fields['comment_rating'] > 0;
			$fields['comment_negative'] = $fields['comment_rating'] < 0;
			
			$fields['allow_vote'] = false;
			$fields['allow_edit'] = false;
			$fields['allow_delete'] = false;
			
			/**
			 * Разрешения удалять и изменять комментарий.
			 */
			if (is_logged()) {
				// Комментарии других администраторов нельзя удалять
				if ($access['edit_comment'] && (!$fields['user_admin_privilege'] or user_id() == $fields['user_id'])) {
					$fields['allow_edit'] = true;
				}
				
				if ((user_id() == $fields['user_id'] && $post_data['post_last_comment_id'] == $fields['comment_id']) or ($access['delete_comment'] && (!$fields['user_admin_privilege'] or $fields['user_id'] == user_id()))) {
					$fields['allow_delete'] = true;
				}
			}
			
			/**
			 * Составляем массив Id комментариев, которые нужно проверить, голосовал за них пользователь или нет.
			 * Время постинга комментария должно быть в пределах разрешенных голосованием (acl_vote_comment_time).
			 * Также автор комментария не имеет возможность голосовать за свой комментарий.
			 */
			if ($allow_vote && user_id() != $fields['user_id'] && $fields['comment_time'] + get_option('acl_vote_comment_time') > time()) {
				$comments_ids_array[] = $fields['comment_id'];
			}
			
			$comments_array[] = $fields;
		}
		
		/**
		 * Если пользователь может голосовать и 
		 * время постинга выводящихся комментариев в пределах разрешенных голосованием.
		 */
		if ($allow_vote && count($comments_ids_array)) {
			/**
			 * Получение массива комментариев, за которые пользователь отдал голос.
			 */
			$sql = 'select comment_id from ' . COMMENT_VOTE_TABLE . ' 
			where voter_id = ' . user_id() . ' and comment_id in (' . implode(', ', $comments_ids_array) . ')';
			
			$query = mysql_query($sql);
			$comments_ids_allow_vote = array();
			
			while ($fields = mysql_fetch_row($query)) {
				$comments_ids_allow_vote[] = $fields[0];
			}
			
			/**
			 * Проходим по массиву комментариев, и устанавливаем для каждого комментария, 
			 * голосовал за него пользователь или нет.
			 */
			foreach ($comments_array as $key => $fields) {
				$comments_array[$key]['allow_vote'] = in_array($fields['comment_id'], $comments_ids_array) && !in_array($fields['comment_id'], $comments_ids_allow_vote);
			}
		}
		
		view_open('content', 'comments/post/index');
		view_set_var('content', 'post_data', $post_data);
		view_set_var('content', 'comments_array', $comments_array);
		view_set_var('content', 'pagination', $navigation['pagination']);
		view_set_var('main', 'content', view_render('content'));
	} else {
		view_open('content', 'comments/post/empty');
		view_set_var('content', 'post_data', $post_data);
		view_set_var('main', 'content', view_render('content'));
	}
	
} elseif (get_router_param(0) == 'user' && is_unsigned(get_router_param(1), true)) {
	
	$current_user = is_logged() && get_router_param(1) == user_id() ? user_data() : null;
	
	if (is_null($current_user)) {
		$sql = 'select * from ' . USERS_TABLE . ' where user_id = ' . get_router_param(1);
		
		if (($query = mysql_query($sql)) && mysql_num_rows($query)) {
			$current_user = mysql_fetch_assoc($query);
		}
	}
	
	if (is_null($current_user)) {
		redirect('/');
	}
	
	view_set_var('main', 'title', get_lang('comments/comments_by_user'));
	view_set_var('content', 'allow_vote', allow_vote_user($current_user['user_id']) === true);
	view_set_var('content', 'current_user', $current_user);
	
	$sql = 'select count(*) 
	from ' . COMMENTS_TABLE . ' where user_id = ' . $current_user['user_id'];
	
	$query = mysql_query($sql);
	$count = mysql_result($query, 0);
	
	if ($count) {
//		$allow_vote = allow_vote_comments() === true && user_id() != $current_user['user_id'];
//		$comments_ids_array = array();
		
		$navigation = get_navigation($count, get_nav_comments(), '/comments/user/' . $current_user['user_id'] . '/page%d');
		
		
		$sql = 'select c.*, p.post_id, p.user_id, p.post_title, p.post_count_comments, b.blog_url, b.blog_name, u.user_login
		from ' . COMMENTS_TABLE . ' as c 
		inner join ' . POSTS_TABLE . ' as p on (p.post_id = c.post_id) 
		left join ' . BLOGS_TABLE . ' as b on (b.blog_id = p.blog_id) 
		left join ' . USERS_TABLE . ' as u on (u.user_id = p.user_id) 
		where c.user_id = ' . $current_user['user_id'] . ' 
		order by c.comment_id desc 
		limit ' . $navigation['select_limits'];
		
		$query = mysql_query($sql);
		
		while ($fields = mysql_fetch_assoc($query)) {
			$fields['comment_positive'] = $fields['comment_rating'] > 0;
			$fields['comment_negative'] = $fields['comment_rating'] < 0;
			
			/**
			 * Составление ссылок на блог и пост
			 */
			$fields['blog_link'] = '/' . ($fields['blog_url'] ? 'blogs/' . $fields['blog_url'] : 'personal/' . $fields['user_id']);
			$fields['post_link'] = $fields['blog_link'] . '/' . $fields['post_id'];
			
			/**
			 * Запрещаем отображение иконок голосования.
			 * Т.к. нет целостности диалога.
			 */
			$fields['allow_vote'] = false;
			
//			/**
//			 * Составляем массив Id комментариев, которые нужно проверить, голосовал за них пользователь или нет.
//			 * Время постинга комментария должно быть в пределах разрешенных голосованием (acl_vote_comment_time).
//			 */
//			if ($allow_vote && $fields['comment_time'] + get_option('acl_vote_comment_time') > time()) {
//				$comments_ids_array[] = $fields['comment_id'];
//			}
			
			$comments_array[] = $fields;
		}
		
//		/**
//		 * Если пользователь может голосовать и 
//		 * время постинга выводящихся комментариев в пределах разрешенных голосованием.
//		 */
//		if ($allow_vote && count($comments_ids_array)) {
//			/**
//			 * Получение массива комментариев, за которые пользователь отдал голос.
//			 */
//			$sql = 'select comment_id from ' . COMMENT_VOTE_TABLE . ' 
//			where voter_id = ' . user_id() . ' and comment_id in (' . implode(', ', $comments_ids_array) . ')';
//			
//			$query = mysql_query($sql);
//			$comments_ids_allow_vote = array();
//			
//			while ($fields = mysql_fetch_row($query)) {
//				$comments_ids_allow_vote[] = $fields[0];
//			}
//			
//			/**
//			 * Проходим по массиву комментариев, и устанавливаем для каждого комментария, 
//			 * голосовал за него пользователь или нет.
//			 */
//			foreach ($comments_array as $key => $fields) {
//				$comments_array[$key]['allow_vote'] = in_array($fields['comment_id'], $comments_ids_array) && !in_array($fields['comment_id'], $comments_ids_allow_vote);
//			}
//		}
		
		view_open('content', 'comments/user/index');
		view_set_var('content', 'comments_array', $comments_array);
		view_set_var('content', 'pagination', $navigation['pagination']);
		view_set_var('main', 'content', view_render('content'));
	} else {
		view_open('content', 'comments/user/empty');
		view_set_var('main', 'content', view_render('content'));
	}
} else {
	redirect('/');
}
?>