<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/user/settings"><?php echo get_lang('settings') ?></a></div></td>
			<td class="current"><div><a href="/user/profile"><?php echo get_lang('user/profile') ?></a></div></td>
			<td><div><a href="/user/password"><?php echo get_lang('user/password') ?></a></div></td>
			<td><div><a href="/user/avatar"><?php echo get_lang('user/avatar') ?></a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<form action="/user/profile" method="post">
		<div class="card">
			<?php if ($message): ?>
				<dl>
					<dt></dt>
					<dd><?php echo $message ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($error_email): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('user/profile_error_email') ?></dd>
				</dl>
			<?php endif ?>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', 80) ?>"><?php echo get_lang('user/email') ?>:</dt>
				<dd><input type="text" name="email"  value="<?php echo user_data('user_email') ?>" /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_name')) ?>"><?php echo get_lang('user/name') ?>:</dt>
				<dd><input type="text" name="name"  value="<?php echo user_data('user_name') ?>" /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_surname')) ?>"><?php echo get_lang('user/surname') ?>:</dt>
				<dd><input type="text" name="surname"  value="<?php echo user_data('user_surname') ?>" /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_about')) ?>"><?php echo get_lang('user/about') ?>:</dt>
				<dd><textarea name="about"><?php echo user_data('user_about') ?></textarea></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_interests')) ?>"><?php echo get_lang('user/interests') ?>:</dt>
				<dd><textarea name="interests"><?php echo user_data('user_interests') ?></textarea></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_im')) ?>"><?php echo get_lang('user/im') ?>:</dt>
				<dd><input type="text" name="im"  value="<?php echo user_data('user_im') ?>" /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_phone')) ?>"><?php echo get_lang('user/phone') ?>:</dt>
				<dd><input type="text" name="phone"  value="<?php echo $current_user['user_phone'] ?>" /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('maxlength', get_option('length_url')) ?>"><?php echo get_lang('user/url') ?>:</dt>
				<dd><input type="text" name="url"  value="<?php echo user_data('user_url') ?>" /></dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('user/sex') ?>:</dt>
				<dd>
					<input type="radio" name="sex" value="m" <?php user_data('user_sex') == 'm' && print('checked="checked" ') ?>/> <?php echo get_lang('user_sex_man') ?> <?php echo get_lang('user/sex_man') ?><br />
					<input type="radio" name="sex" value="f" <?php user_data('user_sex') == 'f' && print('checked="checked" ') ?>/> <?php echo get_lang('user_sex_woman') ?> <?php echo get_lang('user/sex_woman') ?>
				</dd>
			</dl>
			
			<dl>
				<dt></dt>
				<dd>
					<input type="submit" value="<?php echo get_lang('save') ?>" />
					<input type="submit" name="reset" value="<?php echo get_lang('reset') ?>" /> 
				</dd>
			</dl>
		</div>
	</form>
</div>