<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/user/settings"><?php echo get_lang('settings') ?></a></div></td>
			<td><div><a href="/user/profile"><?php echo get_lang('user/profile') ?></a></div></td>
			<td class="current"><div><a href="/user/password"><?php echo get_lang('user/password') ?></a></div></td>
			<td><div><a href="/user/avatar"><?php echo get_lang('user/avatar') ?></a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<form action="/user/password" method="post">
		<div class="card">
			<?php if ($success): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('user/password_edit_success') ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($password_current_error): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('user/password_current_error') ?></dd>
				</dl>
			<?php endif ?>
			
			<?php if ($password_new_error): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('user/password_new_error') ?></dd>
				</dl>
			<?php endif ?>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('user/password_current_notice') ?>"><?php echo get_lang('user/password_current') ?>:</dt>
				<dd><input type="text" name="password" size="25"  /></dd>
			</dl>
			
			<dl>
				<dt class="help" title="<?php echo get_lang('user/password_new_notice') ?>"><?php echo get_lang('user/password_new') ?>:</dt>
				<dd><input type="text" name="password_new" maxlength="25" size="25" /></dd>
			</dl>
			
			<dl>
				<dt></dt>
				<dd><input type="submit" value="<?php echo get_lang('submit') ?>" /></dd>
			</dl>
		</div>
	</form>
</div>