<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo get_lang('tags/search_success', $tag) ?> &#8595;</h1>
</div>

<div class="content">
	<?php foreach ($posts_array as $fields): ?>
		<div>
			<?php echo fdate($fields['post_add_time'], 'd.m.y') ?> &#8594;
			<?php if ($fields['blog_id']): ?>
				<a href="/blogs/<?php echo $fields['blog_url'] ?>"><?php echo $fields['blog_name'] ?></a>
			<?php else: ?>
				<a href="/personal/<?php echo $fields['user_id'] ?>"><?php echo get_lang('blog_personal', $fields['user_login']) ?></a>
			<?php endif ?> &#8594; 
			<a href="/read/<?php echo $fields['post_id'] ?>"><?php echo $fields['post_title'] ?></a>
		</div>
	<?php endforeach ?>
</div>

<?php view_include('pagination') ?>