<ul class="panel-nav-top">
	<li class="current"><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $current_user['user_login'] ?></h1>
	<div class="skill-rating">
		<div class="skill">
			<div>
				<?php echo get_lang('user/skill') ?><br />
				<span class="number"><?php echo $current_user['user_skill'] ?></span>
			</div>
		</div>
		<div class="rating">
			<?php if ($allow_vote): ?><a href="/vote/user/positive/<?php echo $current_user['user_id'] ?>" class="vote-plus"></a><?php endif ?>
			<div>
				<?php echo get_lang('user/rating') ?><br />
				<span class="number"><?php echo $current_user['user_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $current_user['user_count_vote'], declension($current_user['user_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
			<?php if ($allow_vote): ?><a href="/vote/user/negative/<?php echo $current_user['user_id'] ?>" class="vote-minus"></a><?php endif ?>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/profile/<?php echo $current_user['user_login'] ?>"><?php echo get_lang('profile') ?></a></div></td>
			<td<?php $view_all or print(' class="current"') ?>><div><a href="/personal/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('blog') ?></a></div></td>
			<td<?php $view_all && print(' class="current"') ?>><div><a href="/personal/<?php echo $current_user['user_id'] ?>/all"><?php echo get_lang('posts') ?> (<?php echo $current_user['user_count_posts'] ?>)</a></div></td>
			<td><div><a href="/comments/user/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('comments') ?> (<?php echo $current_user['user_count_comments'] ?>)</a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<?php echo get_lang('posts/empty') ?>
</div>