<ul class="panel-nav-top">
	<li class="current"><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/"><?php echo get_lang('posts/good') ?></a><?php get_new_posts_count('all') && print(' <span class="new">+' . get_new_posts_count('all') . '</span>') ?></div></td>
			<td><div><a href="/blogs"><?php echo get_lang('posts/blogs') ?></a><?php get_new_posts_count('blogs') && print(' <span class="new">+' . get_new_posts_count('blogs') . '</span>') ?></div></td>
			<td class="current"><div><a href="/personal"><?php echo get_lang('posts/personal') ?></a><?php get_new_posts_count('personal') && print(' <span class="new">+' . get_new_posts_count('personal') . '</span>') ?></div></td>
			<?php if (allow_add_post() === true): ?>
				<td><div><a href="/publish"><?php echo get_lang('post/publish') ?></a></div></td>
			<?php endif ?>
		</tr>
	</table>
</div>

<div class="content">
	<?php foreach ($posts_array as $fields): ?>
		<div class="post">
			<h1>
				<?php echo get_lang('blog_personal', '<a href="/personal/' . $fields['user_id'] . '">' . $fields['user_login'] . '</a>') ?> &rarr; 
				<a href="/personal/<?php echo $fields['user_id'] ?>/<?php echo $fields['post_id'] ?>"><?php echo $fields['post_title'] ?></a>
			</h1>
			
			<div class="data">
				<div style="padding-bottom: 10px">
					<?php echo tags($fields['post_text']) ?>
					<?php if ($fields['post_cut_text']): ?>
						 <a href="/personal/<?php echo $fields['user_id'] ?>/<?php echo $fields['post_id'] ?>#cut"><?php echo $fields['post_cut_text'] ?></a>
					<?php endif ?>
				</div>
				
				<div class="bar">
					<div class="corner tl"></div>
					<div class="corner tr"></div>
					<div class="text">
						<div class="rating"><span class="number<?php echo $fields['post_rating'] > 0 ? ' positive' : ($fields['post_rating'] < 0 ? ' negative' : '') ?>"><?php echo ($fields['post_rating'] > 0 ? '+' : '') . $fields['post_rating'] ?></span></div>
						<div><?php echo fdate($fields['post_add_time']) ?></div>
						<div><a class="user" href="/profile/<?php echo $fields['user_login'] ?>"><span><?php echo $fields['user_login'] ?></span></a></div>
						<div><a class="comments" href="/comments/post/<?php echo $fields['post_id'] ?>"><span><?php echo $fields['post_count_comments'] ? $fields['post_count_comments'] : get_lang('post/comment') ?></span></a></div>
					</div>
					<div class="corner bl"></div>
					<div class="corner br"></div>
				</div>
			</div>
		</div>
	<?php endforeach ?>
</div>

<?php view_include('pagination') ?>